<?php

/*Connection Information for the database
$def_coy - the default company that is pre-selected on login

'host' - the computer ip address or name where the database is. The default is 'localhost' assuming that the web server is also the sql server.

'dbuser' - the user name under which the company database should be accessed.
  NB it is not secure to use root as the dbuser with no password - a user with appropriate privileges must be set up.

'dbpassword' - the password required for the dbuser to authorise the above database user.

'dbname' - the name of the database as defined in the RDMS being used. Typically RDMS allow many databases to be maintained under the same server.
'tbpref' - prefix on table names, or '' if not used. Always use non-empty prefixes if multiply company use the same database.
*/

//session_start();

$def_coy = 0;

$tb_pref_counter = 0;

/*Start Changes For Wrkmash*/
$page_name = "accounting";
error_reporting(E_ERROR | E_PARSE);
define('DS', DIRECTORY_SEPARATOR);
define('ZROOT', dirname(dirname(__FILE__)).DS);
define('ROOT', dirname(dirname(__FILE__)).DS."source".DS);

/*Includes Setting Files*/
require_once(ROOT . 'settings' . DS . 'cp-settings.php');
require_once(ROOT . 'settings' . DS . 'config.php');

/*Includes Libraries Files*/
require_once(ROOT . 'lib' . DS . 'Session.php');
require_once(ROOT . 'lib' . DS . 'sql.class.php');
//require_once(ROOT . 'lib' . DS . 'paging.php');
require_once(ROOT . 'lib' . DS . 'Mobile_Detect.php');
require_once(ROOT . 'lib' . DS . 'functions_zentrove.php');
require_once(ROOT . 'lib' . DS . 'functions_contents.php');

/*Includes File For General Variables*/
require_once(ROOT.'includes'.DS.'general_variables_zentrove.php');

/*Includes File For Constant*/
require_once(ROOT.'includes'.DS.'constants_zentrove.php');

define('APP_ABURL',DOMAIN);
define('APP_CPURL',ZBPATH);//echo APP_CPURL;
define('APP_ACCOUNTINGURL',((isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') ? "https"."://".$_SERVER['HTTP_HOST']."/zcp/accounting" :"http"."://".$_SERVER['HTTP_HOST']."/zcp/accounting"));//echo APP_ACCOUNTINGURL;

/*Get Wrkmash  Settings Data*/
function get_cp_mainsettings() {
	// create curl resource
	$ch = curl_init();
	// set url
	curl_setopt($ch, CURLOPT_URL, RDIR."ajax/ajaxMainSettings.php?action=getSettings");
	//return the transfer as a string
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	// $output contains the output string
	$curloutput = curl_exec($ch);
	// close curl resource to free up system resources
	curl_close($ch);      
	//fclose($fp);
	//print_r($curloutput);
	return $mainSettingsData = json_decode($curloutput);
}
$mainSettingsData = get_cp_mainsettings();//print_r($mainSettingsData);echo $mainSettingsData->name;exit();

/*Get Wrkmash  Countries Data*/
function get_cp_countries() {
	// create curl resource
	$ch = curl_init();
	// set url
	curl_setopt($ch, CURLOPT_URL, RDIR."ajax/ajaxMainSettings.php?action=getCPCountries");
	//return the transfer as a string
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	// $output contains the output string
	$curloutput = curl_exec($ch);
	// close curl resource to free up system resources
	curl_close($ch);      
	//fclose($fp);
	//print_r($curloutput);
	return $coutriesData = json_decode($curloutput,true);
}
$countriesArray = get_cp_countries();//print_r($countriesArray);exit();

/*Define Wrkmash Constants*/
define('APPLICATION_NAME', $mainSettingsData->name);//echo APPLICATION_NAME;exit();
define('SUPPORT_EMAIL', $mainSettingsData->support_email);//echo SUPPORT_EMAIL;exit();
define('CONTROL_PANEL', "Control Panel");//echo CONTROL_PANEL;exit();
define('ACCOUNTING_NAME', "Accounting");//echo ACCOUNTING;exit();

define('APP_CPANEL_HOST',DBHOST);
define('APP_CPANEL_USER',DBUSER);
define('APP_CPANEL_PASSWORD',DBPASSWORD);
define('APP_TABLE_PREFIX',TBLPREFIX);
define('APP_CUSTOMERDB_PREFIX',CUSTOMERDB_PREFIX);

$app_name = $page_name;
$app_module_name = str_replace(ZROOT."accounting/","",$_SERVER['SCRIPT_FILENAME']."?".$_SERVER["QUERY_STRING"]);

$body_sidebar_toggle = true;
$is_applications_setup = true;
$hide_control_panel_old_content = true;
$control_panel_landingpage = "dashboard";
$body_additional_class = "layout-top-fixed layout-full-view";
$show_control_panel_left_menus = true;$show_control_panel_top_menus = true;
define('HIDE_CONTROL_PANEL_OLD_CONTENT',$hide_control_panel_old_content);

/*Get CP Html Blocks*/

function cp_html_blocks($company,$block) 
{
	global $sqlMainClass,$modules_helpsection_contents,$page_name,$app_name,$app_module_name,$hide_control_panel_old_content,$show_control_panel_left_menus,$show_control_panel_top_menus,$is_applications_setup;
	
	$customer_user = $sqlMainClass->getRow("*","usermanagement_users"," WHERE username='$company' OR email_address like '".$company."@%' ");
	
	setSession("quick_settings_status",$customer_user['quick_settings_status']);
	setSession("customer_user",$customer_user);
	
	$sqlMainClass->usedatabase(DB);
	
	$customer = $sqlMainClass->getRow("*",TBLPREFIX."customers"," WHERE account_name='$company' ");
	$SESSION_CUSTOMER['customer_type'] = $customer['customer_type'];
	$SESSION_CUSTOMER['customer_id'] = $customer['customer_id'];
	$SESSION_CUSTOMER['account_name'] = $customer['account_name'];
	$SESSION_CUSTOMER['customer_employee']['username'] = $_SESSION['wa_current_user']->username;
	$SESSION_CUSTOMER['customer_employee']['wp_password'] = $customer_user['wp_password'];
	$SESSION_CUSTOMER['is_payable'] = $customer['is_payable'];
	$SESSION_CUSTOMER['payment_status'] = $customer['payment_status'];
	$SESSION_CUSTOMER['type'] = $customer['type'];
	
	setSession("app_module_name",$app_module_name);
	setSession("customer",$customer);
	
	/*Check Customer Applications*/
	$check_customer_applications = checkCustomerApplications($condition=" WHERE customer_id = '".$SESSION_CUSTOMER['customer_id']."' ");
	//print_r($check_customer_applications);
	
	/*Get Applications Data*/
	$application_id = getValue("applications","app_id"," WHERE app_cp_link='$page_name' ");
	$application_title = getValue("applications","app_title"," WHERE app_cp_link='$page_name' ");
	$application_isappsetup = getValue("applications","is_appsetup"," WHERE app_cp_link='$page_name' ");
	$application_is_payable = getValue("applications","is_payable"," WHERE app_cp_link='$page_name' ");
	/*Check Application*/
	$check_application = checkApplication($application_id);//printArray($check_application);
	
	/*Check Customer Single Application*/
	$check_customer_singleapplication = checkCustomerApplications($condition=" WHERE customer_id = '".$SESSION_CUSTOMER['customer_id']."' AND app_id = '$application_id'  ");
	//printArray($check_customer_singleapplication);
	
	/*Check Customer Package Application*/
	$check_customer_package_application = checkPackageApplication($condition=" WHERE pkg_id = '".$customer['payment_plan']."' AND app_id = '$application_id'  ");
	setSession("check_customer_package_application",$check_customer_package_application);
	//printArray($check_customer_package_application); 
	
	/* Get Customer Packages  17-april-2020*/
	$customers_packages = getCustomersPackages("WHERE pkg_status=1");//printArray($customers_packages);
	$customers_packagesArray = array();
	foreach($customers_packages as $key=>$customers_package)
	{
	  $customers_packagesArray[$customers_package['pkg_id']] = $customers_package;
	  $packages_applications = getPackageApplications($customers_package['pkg_id']);
	  $customers_packagesArray[$customers_package['pkg_id']]['applications'] = $packages_applications;
	}
	setSession("customers_packagesArray",$customers_packagesArray);
	
	if($block == "js_includes")
	require_once(ROOT.'includes'.DS.'footer_internal_includes.php');/*Get CP JS Includes*/
	elseif($block == "topright_menu")
	{
		//print_r($customer);

	$is_payable = getsession("is_payable");
	//$customers_packagesArray = getSession("customers_packagesArray");
    
	require_once(ROOT.'includes'.DS.'header_topright_menu.php');/*Get CP Top Right Menu*/
	}
	elseif($block == "left_menu")
	require_once(ROOT.'includes'.DS.'left_menus.php');/*Get CP Left Menu*/
	elseif($block == "left_menus_mobile")
	require_once(ROOT.'includes'.DS.'left_menus_mobile.php');/*Get CP Left Menu*/
	elseif($block == "footer_internal")
	require_once(ROOT.'footer_internal.php');/*Get CP Footer Internal*/
	
	//$sqlMainClass->close_db_conection();
	$db = mysql_connect(APP_CPANEL_HOST, APP_CPANEL_USER, APP_CPANEL_PASSWORD);
	mysql_select_db(CUSTOMERDB.$company, $db);
}

/*Code to Generate DB Configuration Array*/
/*$db_connections = array (
  'nerdsmith' => 
			  array (
				'name' => ACCOUNTING_NAME,
				'host' => APP_CPANEL_HOST,
				'dbuser' => APP_CPANEL_USER,
				'dbpassword' => APP_CPANEL_PASSWORD,
				'dbname' => APP_CUSTOMERDB_PREFIX.'nerdsmith',
				'tbpref' => 'accounting_',
			  ),
);*/
$connect = mysql_connect(APP_CPANEL_HOST, APP_CPANEL_USER, APP_CPANEL_PASSWORD) or die(mysql_error());
mysql_select_db(DB, $connect);
$result_zentrove_customers = mysql_query("SELECT * FROM ".APP_TABLE_PREFIX."customers WHERE is_delete=0 AND status=1 ;",$connect);
$db_connections = array();
while($row_zentrove_customer = mysql_fetch_array($result_zentrove_customers))
{
  $db_connections[$row_zentrove_customer['account_name']]['name'] = $row_zentrove_customer['account_name'];
  $db_connections[$row_zentrove_customer['account_name']]['host'] = APP_CPANEL_HOST;
  $db_connections[$row_zentrove_customer['account_name']]['dbuser'] = APP_CPANEL_USER;
  $db_connections[$row_zentrove_customer['account_name']]['dbpassword'] = APP_CPANEL_PASSWORD;
  $db_connections[$row_zentrove_customer['account_name']]['dbname'] = APP_CUSTOMERDB_PREFIX.$row_zentrove_customer['account_name'];
  $db_connections[$row_zentrove_customer['account_name']]['tbpref'] = 'accounting_';
}
/*echo "<pre>";
print_r($db_connections);*/
mysql_close($connect);

/*End Changes For Wrkmash*/
/*Code to Generate DB Configuration Array*/
?>