<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
/*
	If no context is set current page/menu screen is selected.
*/
function help_url($context=null)
{

	global $help_base_url, $help_context, $old_style_help;

	$country = $_SESSION['language']->code;
	$clean = 0;
	
	if ($context!=null)
	{
		$help_page_url = $context;
	}
	elseif (isset($help_context))
	{
		$help_page_url = $help_context;
	} else // main menu
	{
		$app = $_SESSION['sel_app'];
		$help_page_url = $_SESSION['App']->applications[$app]->help_context;
		$clean = 1;
	}

	if (@$old_style_help)
		$help_page_url = _($help_page_url);

	if ($clean)
		$help_page_url = access_string($help_page_url, true);

	return htmlspecialchars($help_base_url
		.urlencode(strtr(ucwords($help_page_url), array(' '=>'', '/'=>'', '&'=>'And')))
		.'&ctxhelp=1&lang='.$country);
}

function send_scripts()
{
    global $js_static, $js_path, $js_userlib, $path_to_root, $go_debug;

	$js ='';
	foreach($js_static as $jsfile)
	{
	    $fpath = company_path().'/js_cache/'.$jsfile;
	    // compress also static files
	  	if (!file_exists($fpath) || $go_debug)
			cache_js_file($fpath, file_get_contents($js_path.$jsfile));

	  	$js .= '<script language="javascript" type="text/javascript" src="'.
			$fpath . '"></script>';
	}
	foreach($js_userlib as $jsfile)
	{
	  	$js .= '<script language="javascript" type="text/javascript" src="'.
	    	$jsfile . '"></script>';
	}

    echo $js;
}

function page_header($title, $no_menu=false, $is_index=false, $onload="", $js="", $css='')
{
	// titles and screen header
	/*Start Changes For Wrkmash*/
	//global $path_to_root, $def_app, $use_popup_windows, $help_base_url, $db_connections;
	/*global $path_to_root, $def_app, $use_popup_windows, $help_base_url, $db_connections, $modules_helpsection_contents, $check_customer_applications, $countriesArray;*/
	global $path_to_root, $def_app, $use_popup_windows, $help_base_url, $db_connections, $modules_helpsection_contents, $check_customer_applications, $countriesArray,$body_sidebar_toggle,$hide_control_panel_old_content,$control_panel_landingpage,$body_additional_class,$show_control_panel_left_menus,$show_control_panel_top_menus,$is_applications_setup;
	/*End Changes For Wrkmash*/

	if (in_ajax())
		return; // just for speed up

//	$jsext = substr_replace($_SERVER['PHP_SELF'], '.js', -4);

//	if (file_exists($_SERVER['DOCUMENT_ROOT'].$jsext))
//		add_js_ufile($jsext);

	$theme = user_theme();

	if ($help_base_url != null && $use_popup_windows && $js == '')
	{
		if (!function_exists('get_js_open_window'))
		{
			include_once($path_to_root.'/includes/ui/ui_view.inc');
		}
		add_js_source(get_js_open_window(900, 500));
	}
	if ($js!='')
	  add_js_source($js);

	if (!isset($no_menu))
	{
		$no_menu = false;
	}
	if (isset($_SESSION["App"]) && is_object($_SESSION["App"]) && isset($_SESSION["App"]->selected_application) &&
		$_SESSION["App"]->selected_application != "")
		$sel_app = $_SESSION["App"]->selected_application;
	elseif (isset($_SESSION["sel_app"]) && $_SESSION["sel_app"] != "")
		$sel_app = $_SESSION["sel_app"];
	else
		$sel_app = user_startup_tab();
	$_SESSION["sel_app"] = $sel_app;

	// When startup tab for current user was set to already 
	// removed/inactivated extension module select Sales tab as default.
	/*if (isset($_SESSION["App"]) && is_object($_SESSION["App"]))
		$_SESSION["App"]->selected_application = 
			isset($_SESSION["App"]->applications[$sel_app]) ? $sel_app : 'orders';*/
			
	if (isset($_SESSION["App"]) && is_object($_SESSION["App"]))
		$_SESSION["App"]->selected_application = 
			isset($_SESSION["App"]->applications[$sel_app]) ? $sel_app : 'orders';		

	$page_header_args = func_get_args();
	if(isset($db_connections))	// skip before installation
		hook_invoke_all('pre_header', $page_header_args);

	$encoding = $_SESSION['language']->encoding;

	if (!headers_sent()){
		header("Content-type: text/html; charset=$encoding");
	}
	
	/*Start Wrkmash Changes */
	//$body_additional_class = "fixed";
	/*$body_additional_class = "layout-top-fixed";
	if ($no_menu == true)
	{
		$body_additional_class = "layout-top-nav";
	}*/
	if ($no_menu == true)
	{
		$body_additional_class = "layout-top-nav layout-no-menus";
		$show_control_panel_left_menus = false;$show_control_panel_top_menus = false;
	}
	/*End Wrkmash Changes */
	
	/*Start Wrkmash Changes */
	echo "<!DOCTYPE html>\n";
	//echo "<html dir='" . $_SESSION['language']->dir . "' >\n";
	echo "<html dir='" . $_SESSION['language']->dir . "' lang='en'>\n";
	//echo "<head profile=\"http://www.w3.org/2005/10/profile\"><title>".APPLICATION_NAME." :: ".ACCOUNTING_NAME." | $title</title>";//Comment For Bootstrap
	echo "<head>";
	echo "<meta charset='utf-8'>";
	echo "<meta http-equiv='X-UA-Compatible' content='IE=edge'>";
	//echo "<title>".APPLICATION_NAME." :: ".ACCOUNTING_NAME." | $title</title>";
	echo "<meta name='description' content='".APPLICATION_NAME." :: ".ACCOUNTING_NAME."' />";
	echo "<meta name='keywords' content='".APPLICATION_NAME." :: ".ACCOUNTING_NAME."' />";
	
	echo "<!-- Tell the browser to be responsive to screen width -->
		  <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'> ";
	
	echo "<title>".APPLICATION_NAME." :: ".ACCOUNTING_NAME." | $title</title>";
	/*echo "<meta http-equiv='Content-type' content='text/html; charset=$encoding'>";
	echo "<link href='$path_to_root/themes/$theme/default.css' rel='stylesheet' type='text/css'> \n";
	echo "<link rel='stylesheet' href='".APP_CPURL."/source/css/zentrove_inner.css' type='text/css' media='all' />";
 	echo "<link href='$path_to_root/themes/default/images/favicon.ico' rel='icon' type='image/x-icon'> \n";
	echo "<link href='".APP_ABURL."/wp-content/uploads/2015/02/favicon.ico' rel='icon' type='image/x-icon'> \n";
	if ($css)
		echo '<link href="'.$css.'" rel="stylesheet" type="text/css">';*///Comment For Bootstrap
		
	echo "<!-- Bootstrap 3.3.6 -->
		  <!--<link rel='stylesheet' href='".PUBDIR."bootstrap/source/css/bootstrap.css'>-->
		  <link rel='stylesheet' href='".PUBDIR."bootstrap/bootstrap-4-migrate-master/css/bootstrap-4-migrate.min.css' media='all'>
		  <!-- Bootstrap 4.1.0 -->
  		  <link rel='stylesheet' href='".PUBDIR."cooladmin/vendor/bootstrap-4.1/bootstrap.min.css' media='all'>
		  
		  <!-- Fontfaces CSS-->
  		  <link href='".PUBDIR."cooladmin/css/font-face.css' rel='stylesheet' media='all'>
  
		  <!-- Font Awesome -->
		  <link rel='stylesheet' href='https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css'>
		  <link href='".PUBDIR."cooladmin/vendor/font-awesome-4.7/css/font-awesome.min.css' rel='stylesheet' media='all'>
		  <link href='".PUBDIR."cooladmin/vendor/font-awesome-5/css/fontawesome-all.min.css' rel='stylesheet' media='all'>
		  <link href='".PUBDIR."cooladmin/vendor/mdi-font/css/material-design-iconic-font.min.css' rel='stylesheet' media='all'>
		  
		  <!-- Ionicons -->
		  <link rel='stylesheet' href='https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css'>
		  
		  <!-- Theme style -->
		  <!--<link rel='stylesheet' href='".PUBDIR."bootstrap/dist/css/AdminLTE.css'>-->
		  <!-- AdminLTE Skins. Choose a skin from the css/skins folder instead of downloading all of them to reduce the load. -->
		  <!--<link rel='stylesheet' href='".PUBDIR."bootstrap/dist/css/skins/control_panel-skins.css'>-->
		  
		  <!-- iCheck for checkboxes and radio inputs -->
		  <link rel='stylesheet' href='".PUBDIR."bootstrap/plugins/iCheck/all.css'>
		  <!--<link rel='stylesheet' href='".PUBDIR."bootstrap/plugins/iCheck/flat/blue.css'>-->
		  
		  <!-- Morris chart -->
		  <link rel='stylesheet' href='".PUBDIR."bootstrap/plugins/morris/morris.css'>
		  
		  <!-- jvectormap -->
		  <link rel='stylesheet' href='".PUBDIR."bootstrap/plugins/jvectormap/jquery-jvectormap-1.2.2.css'>
		  
		  <!-- Date Picker -->
		  <link rel='stylesheet' href='".PUBDIR."bootstrap/plugins/datepicker/datepicker3.css'>
		  
		  <!-- Daterange picker -->
		  <link rel='stylesheet' href='".PUBDIR."bootstrap/plugins/daterangepicker/daterangepicker.css'>
		  
		  <!-- Date Time Picker -->
		  <link rel='stylesheet' href='".PUBDIR."bootstrap/plugins/bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.css'>
		
		  <!-- bootstrap wysihtml5 - text editor -->
		  <link rel='stylesheet' href='".PUBDIR."bootstrap/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css'>
		  
		  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
		  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
		  <!--[if lt IE 9]>
		  <script src='https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js'></script>
		  <script src='https://oss.maxcdn.com/respond/1.4.2/respond.min.js'></script>
		  <![endif]-->
		  
		  <!-- DataTables -->
		  <link rel='stylesheet' href='".PUBDIR."bootstrap/plugins/datatables/dataTables.bootstrap.css'>
		  
		  <!-- Bootstrap FooTable CSS-->
		  <?php /*?><link rel='stylesheet' href='https://s3-us-west-2.amazonaws.com/s.cdpn.io/123941/footable.core.css'><?php */?>
		  <link rel='stylesheet' href='".PUBDIR."bootstrap/plugins/footable/footable.core.css'>
		  
		  <!-- FancyBox CSS -->
		  <link rel='stylesheet' type='text/css' href='".PUBDIR."bootstrap/plugins/fancybox/source/jquery.fancybox.css?v=2.1.5' media='screen' />
		  
		  <!-- Autocomplete CSS -->
		  <link rel='stylesheet' type='text/css' href='".PUBDIR."bootstrap/plugins/autocomplete/autocomplete.css' media='screen' />
		  
		  <!-- Control Panel Additional CSS-->
		  <!--<link rel='stylesheet' href='".PUBDIR."css/control_panel_main.css?".time()."'>-->
		  <link rel='stylesheet' href='".PUBDIR."css/control_panel_main_b4.css?".time()."'>
		  
		  <!-- Pace style -->
  		  <link rel='stylesheet' href='".PUBDIR."bootstrap/plugins/pace/pace.css?".time()."'>
		  
		  <!-- Cool Admin Vendor CSS-->
		  <link href='".PUBDIR."cooladmin/vendor/animsition/animsition.min.css' rel='stylesheet' media='all'>
		  <link href='".PUBDIR."cooladmin/vendor/bootstrap-progressbar/bootstrap-progressbar-3.3.4.min.css' rel='stylesheet' media='all'>
		  <link href='".PUBDIR."cooladmin/vendor/wow/animate.css' rel='stylesheet' media='all'>
		  <link href='".PUBDIR."cooladmin/vendor/css-hamburgers/hamburgers.min.css' rel='stylesheet' media='all'>
		  <link href='".PUBDIR."cooladmin/vendor/slick/slick.css' rel='stylesheet' media='all'>
		  <link href='".PUBDIR."cooladmin/vendor/select2/select2.min.css' rel='stylesheet' media='all'>
		  <link href='".PUBDIR."cooladmin/vendor/perfect-scrollbar/perfect-scrollbar.css' rel='stylesheet' media='all'>
  
  		  <!-- Cool Admin Main CSS-->
  		  <link href='".PUBDIR."cooladmin/css/theme.css?".time()."' rel='stylesheet' media='all'>
		  <link href='".PUBDIR."cooladmin/css/theme_merge.css?".time()."' rel='stylesheet' media='all'>";	
    
	send_scripts();
	
	/*Get CP JS Includes*/
	//echo cp_html_blocks($_SESSION['wa_current_user']->company,"js_includes");
	
	//echo '<link href="http://fonts.googleapis.com/css?family=PT+Sans:400,700" rel="stylesheet" type="text/css">';//Comment For Bootstrap
	/*echo '<script src="'.APP_CPURL.'/source/js/jquery-1.7.1.min.js" type="text/javascript"></script>';*///Comment For Bootstrap
	echo "</head> \n";
	/*if ($onload == "")
		echo '<body class="hold-transition control_panel sidebar-mini '.$body_additional_class.'">';
	else
		echo '<body class="hold-transition control_panel sidebar-mini '.$body_additional_class.'" onload=\"$onload\">';*/
	if ($onload == "")
		echo '<body class="animsition hold-transition control_panel sidebar-mini '.$body_additional_class.'">';
	else
		echo '<body class="animsition hold-transition control_panel sidebar-mini '.$body_additional_class.'" onload=\"$onload\">';	
		
	//echo '<body>', "\n";
	echo '<div style="width:100%">';
	//echo '<div class="wrapper">';
	echo '<div class="page-wrapper">';
	
	$applications = $_SESSION['App']->applications;
	$application_name = access_string($applications[$_SESSION['App']->selected_application]->name);
	//echo "<pre>";print_r($applications[$_SESSION['App']->selected_application]);echo "</pre>";
	$application_name = strip_tags($application_name[0]);
	
	/*$page_name = "accounting";
	$app_name = $page_name;
	$app_module_name = str_replace(ZROOT."accounting/","",$_SERVER['SCRIPT_FILENAME']."?".$_SERVER["QUERY_STRING"]);
	$body_sidebar_toggle = true;
	$hide_control_panel_old_content = true;
	$control_panel_landingpage = "dashboard";
	$body_additional_class = "layout-top-fixed layout-full-view";
	$show_control_panel_left_menus = true;$show_control_panel_top_menus = true;*/
	include(ROOT.'includes'.DS.'splash.php');
  	include(ROOT.'includes'.DS.'login_form.php');
	include(ROOT.'includes'.DS.'profile_form.php');
  	include(ROOT.'includes'.DS.'login_pos_form.php');
	include(ROOT.'includes'.DS.'contact_support_form.php');
	include(ROOT.'includes'.DS.'customers_payment_plans.php');
    include(ROOT.'includes'.DS.'customers_payment_plans_creditcard.php');
	include(ROOT.'includes'.DS.'customers'.DS.'customer_form.php');
	include(ROOT.'inventorymanagement'.DS.'additems_popup.php');
	include(ROOT.'inventorymanagement'.DS.'categories_form.php');
	include(ROOT.'inventorymanagement'.DS.'supplier_form.php');
	include(ROOT.'appsetup'.DS.'appsetup_confirmation_box.php');
	echo '<input type="hidden" name="app_name" id="app_name" value="'.$app_name.'" />';
	
	if ($no_menu == false)
	{
		/*echo '<div id="top">';
		//echo '<a href="'.APP_CPURL.'/dashboard" id="logout_control_panel"><div class="logo-internal"></div></a>';
		echo '<a href="'.APP_CPURL.'/dashboard" ><div class="logo-internal"></div></a>';
		echo '<div class="header-heading">Accounting&nbsp;-&nbsp;'.$application_name.'</div>';
		echo '<div style="float:right; margin-top:24px;padding-right:20px">';
		//echo '<a href="'.APP_ACCOUNTINGURL.'/access/logout.php?" style="color: #234b5f;font-size:18px;"> Back to Control Panel</a>';
		//echo '<a href="'.APP_ACCOUNTINGURL.'/access/logout.php?"><img src="'.APP_CPURL.'/source/images/gearicon.png" title="Back to Control Panel" /></a>';
		echo '</div>';
		echo '</div>';//End of Top DIV
		echo '<div style="clear:both"></div>';*/
		
		/*Start Hide Old Control Panel Content*/
		if(!$hide_control_panel_old_content)
		{
		echo '<header class="main-header">
				<!-- Logo -->
				<a href="'.ZBPATH.$control_panel_landingpage.'" title="'.APPLICATION_NAME.' :: '.ACCOUNTING_NAME.'" class="logo">
				  <!-- mini logo for sidebar mini 50x50 pixels -->
				  <span class="logo-mini"><!--<b>A</b>LT-->
					<img src="'.RDIR.'images/panel_images/wmlogo-small.png" alt="'.APPLICATION_NAME.' :: '.ACCOUNTING_NAME.'" style="width:50px;">
				  </span>
				  <!-- logo for regular state and mobile devices -->
				  <span class="logo-lg"><!--<b>Admin</b>LTE-->
					<img src="'.RDIR.'images/panel_images/logo-internal.png" alt="'.APPLICATION_NAME.' :: '.ACCOUNTING_NAME.'">
				  </span>
				</a>
				
				<!-- Header Navbar: style can be found in header.less -->
				<nav class="navbar navbar-static-top">';
				  
				  if($body_sidebar_toggle)
				  {
				  
		echo '    <!-- Sidebar toggle button-->
				  <a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
					<span class="sr-only">Toggle navigation</span>
				  </a>';
				  
				  }
				  
		echo '	 <!-- Panel Title -->
      			  <a href="'.ZBPATH.$control_panel_landingpage.'" role="button" class="navbar-panel-title">'.CONTROL_PANEL.'</a>';		  
				  
				  /*Get CP Top Right Menu*/
				  echo cp_html_blocks($_SESSION['wa_current_user']->company,"topright_menu");
				  
		echo '  </nav>
			  </header>';
		}
		/*End Hide Old Control Panel Content*/
	}
	
	/*include(ROOT.'includes'.DS.'splash.php');
  	include(ROOT.'includes'.DS.'login_form.php');
	include(ROOT.'includes'.DS.'profile_form.php');
  	include(ROOT.'includes'.DS.'login_pos_form.php');
	include(ROOT.'appsetup'.DS.'appsetup_confirmation_box.php');
	echo '<input type="hidden" name="app_name" id="app_name" value="'.$app_name.'" />';*/
	
	if ($no_menu == false)
	{
		/*Get CP Left Menu*/
		
		/*Start Hide Old Control Panel Content*/
		if(!$hide_control_panel_old_content)
		{
		echo'<div class="leftpanel hidden">';
		echo'<nav>';
		echo '<ul class="clearfix menu">';
		$applications = $_SESSION['App']->applications;
		//echo "<pre>";print_r($applications);echo "</pre>";
		$local_path_to_root = $path_to_root;
		$sel_app = $_SESSION['sel_app'];
		//echo "<table cellpadding='0' cellspacing='0' width='100%'><tr><td>";
		//echo "<div class='tabs'>";
		/*echo ' <li>';
		echo '	<a href="'.$local_path_to_root.'" >
					<div class="leftmenu_icon"  data-hover_icon="url('.$leftmenu_hovericon.') no-repeat" data-icon="url('.$leftmenu_icon.') no-repeat" style="background:url('.$leftmenu_icon.') no-repeat;font-size:initial;color:#234b5f">' .strip_tags($acc[0]) . '
					</div>
				 </a>';		 
		echo ' </li>';*/
		/*$leftmenu_settings = APP_ACCOUNTINGURL.'/images/leftmenuicons/controlpanel_lefticon.png';
		$leftmenu_settings_hovericon = APP_ACCOUNTINGURL.'/images/leftmenuicons/controlpanel_lefticon_hover.png';
		echo ' <li>'; 
		echo '	<a href="'.APP_CPURL.'" >
					<div class="leftmenu_icon "  data-hover_icon="url('.$leftmenu_settings_hovericon.') no-repeat" data-icon="url('.$leftmenu_settings.') no-repeat" style="background:url('.$leftmenu_icon.') no-repeat;font-size:initial;color:#234b5f">' .strip_tags($acc[0]) . '
					Back to Control Panel
					</div>
				 </a>';		 
		echo ' </li>';*/
		echo ' <li>'; 
		/*echo '	<a href="'.APP_ACCOUNTINGURL.'/access/logout.php?" >
					<!--<img src="'.APP_CPURL.'source/images/back-arrow-white.png" border="0" style="top:6%;width:20px;position:absolute;left:9%;"/>-->
					<input name="back_menu_button" id="back_menu_button" type="button" value="Back to Control Panel" class="back_menu_button" style="width:96.5%;padding-left:10%;margin-left: 1%;margin-top: 6%;float:left;margin-bottom:3%;background-image:url('.APP_CPURL.'/source/images/back-arrow-white.png);background-size:20px; background-repeat:no-repeat;background-position:5% center ">
				 </a>';*/
		echo '	<a href="'.APP_CPURL.'dashboard" >
					<!--<img src="'.APP_CPURL.'source/images/back-arrow-white.png" border="0" style="top:6%;width:20px;position:absolute;left:9%;"/>-->
					<input name="back_menu_button" id="back_menu_button" type="button" value="Back to Control Panel" class="back_menu_button" style="width:96.5%;padding-left:10%;margin-left: 1%;margin-top: 6%;float:left;margin-bottom:3%;background-image:url('.APP_CPURL.'source/images/back-arrow-white.png);background-size:20px; background-repeat:no-repeat;background-position:5% center ">
				 </a>';		 		 
		echo ' </li>';
		foreach($applications as $app)
		{
			//echo "<pre>";print_r($app->id);echo "</pre>";
			if ($_SESSION["wa_current_user"]->check_application_access($app))
			{
				$acc = access_string($app->name);
				$leftmenu_icon = APP_ACCOUNTINGURL.'/images/leftmenuicons/'.$app->id.'menu.png';
				$leftmenu_hovericon = APP_ACCOUNTINGURL.'/images/leftmenuicons/'.$app->id.'menu-hover.png';
				//if($app->id == $sel_app)$selected_application_name = strip_tags($acc[0]);
				echo ' <li>';
				/*echo '	<a href="'.$local_path_to_root.'/index.php?application='.$app->id.'" '.$acc[1].'>
							<div class="leftmenu_icon_'.$array['icon_name'].'" style="background-size: 20px;background-position:5% 7px; margin-top:5px;padding-top:5px;">' .$acc[0] . '
							</div>
						 </a>';*/
				echo '	<a href="'.$local_path_to_root.'/index.php?application='.$app->id.'" '.$acc[1].'>
							<div class="leftmenu_icon"  data-hover_icon="url('.$leftmenu_hovericon.')" data-icon="url('.$leftmenu_icon.')" style="background:url('.$leftmenu_icon.');font-size:17px;color:#234b5f;background-repeat:no-repeat;padding-top:13px;background-position:5px 12px;height:30px;margin-top:0px;">' .strip_tags($acc[0]) . '
							</div>
						 </a>';		 
				echo ' </li>';  	
			}
		}
		//echo "</div>";
		//echo "</td></tr></table>";
		//echo '  <li>';
		//echo '		<a href="'.$array['link'].'" '.$array['params'].'  data-menu="'.$array['icon_name'].'">';
		//echo '  		</a>';
		//echo '  </li>';  
		echo '</ul>';
		echo '<a href="#" id="pull" style="color:#FFFFFF;font-size:17px;text-decoration:none;">Menu</a>';
		echo '</nav>';
		echo '<br style="clear:left" />';
		echo '</div>';
		echo cp_html_blocks($_SESSION['wa_current_user']->company,"left_menu");
		}
		/*End Hide Old Control Panel Content*/
		
		echo '<!-- HEADER MOBILE-->
		  <header class="header-mobile d-block d-lg-none">
			  <div class="header-mobile__bar">
				  <div class="container-fluid">
					  <div class="header-mobile-inner">
						  <!-- Logo -->
						  <a href="'.ZBPATH.$control_panel_landingpage.'" title="'.APPLICATION_NAME.' :: '.ACCOUNTING_NAME.'" class="logo">
							  <img src="'.RDIR.'images/panel_images/logo-internal.png" alt="'.APPLICATION_NAME.' :: '.ACCOUNTING_NAME.'">
						  </a>';
						  
						  if($show_control_panel_left_menus)
						  {
						  echo '<button class="hamburger hamburger--slider" type="button">
							  <span class="hamburger-box">
								  <span class="hamburger-inner"></span>
							  </span>
						  </button>';
						  }
						  
						  if(!$show_control_panel_top_menus)
						  {
						  cp_logout_link();
						  }
					echo '</div>
				  </div>
			  </div>';
			  if($show_control_panel_left_menus)
			  {
			  echo cp_html_blocks($_SESSION['wa_current_user']->company,"left_menus_mobile");
			  }
		echo '</header>
		<!-- END HEADER MOBILE-->';
		
		echo '<!-- MENU SIDEBAR-->';
			  if($show_control_panel_left_menus)
			  {
		echo '<aside class="menu-sidebar d-none d-lg-block">
				  <div class="logo">
					  <!-- Logo -->
					  <a href="'.ZBPATH.$control_panel_landingpage.'" title="'.APPLICATION_NAME.' :: '.ACCOUNTING_NAME.'">
						  <img src="'.RDIR.'images/panel_images/logo-internal.png" alt="'.APPLICATION_NAME.' :: '.ACCOUNTING_NAME.'">
					  </a>
				  </div>';
				  echo cp_html_blocks($_SESSION['wa_current_user']->company,"left_menu");
		echo  '</aside>';
			  }
		echo  '<!-- END MENU SIDEBAR-->';	
	}
	
	echo '<!-- PAGE CONTAINER-->
		  <div class="page-container">';
		  
		  if ($no_menu == false)
		  {
		  echo '<!-- HEADER DESKTOP-->
		  		<header class="header-desktop">
					<div class="section__content section__content--p30">
						<div class="container-fluid">
							<div class="header-wrap">';
								if(!$show_control_panel_left_menus)
								{
								echo '<div class="header__logo d-none d-sm-block">
										<a href="'.ZBPATH.$control_panel_landingpage.'" title="'.APPLICATION_NAME.' :: '.ACCOUNTING_NAME.'">
											<img src="'.RDIR.'images/panel_images/logo-internal.png" alt="'.APPLICATION_NAME.' :: '.ACCOUNTING_NAME.'">
										</a>
									  </div>';
								}
								$show_control_panel_left_menus = false;
								if( $show_control_panel_top_menus )
								{
									  echo cp_html_blocks($_SESSION['wa_current_user']->company,"topright_menu");
								}
								else
								{
								echo '<div class="header-button">';
									 echo '<div class="button-wrap"><div class="button__item">'.cp_logout_link().'</div></div> ';
								echo '</div>';	
								}
		  echo '			 </div>
		  				</div>
		  			</div>
		  		</header>
				<!-- END HEADER DESKTOP-->';
		  }
				
		  echo '<!-- MAIN CONTENT-->
		  	    <div class="main-content">
					<div class="section__content section__content--p30">
						<div class="container-fluid">';				  
	/*End Wrkmash Changes */
		

	include_once($path_to_root . "/themes/$theme/renderer.php");
	$rend = new renderer();
	$rend->menu_header($title, $no_menu, $is_index);
	/*Start Wrkmash Changes */
	//error_box();
	/*End Wrkmash Changes */
}
?>