<?php 
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

include 'AuthorizeNet/AuthorizeNet.php';
use AuthorizeNet\AuthorizeNet;
/*
|	Call it by doing this:
|
|		$this->load->library('my_payment');
|		$params->cc = '1293081309812039812039' ;//etc... you get the idea
|		
|		$result = $this->my_payment->authorize($params);
|		print_r($result); //response codes from authorize.net*/
 
class authroize_payment {
	
	protected $at_login = "";
	protected $at_password = "";
	protected $at_environment= "";
	
	public function __construct()
	{
		$CI =& get_instance();
		$CI->load->model('Gateways'); 
 		//print_r($CI->Gateways->get_default_gateway()->result());exit();
		$data['gateway_info']= $CI->Gateways->get_default_gateway();
  		foreach ($data['gateway_info']->result() as $gateways)
		{
  			   	 
 			 	  $this->at_login = $gateways->MUinfo;
 			      $this->at_password = $gateways->MUkey;
				  $this->at_environment = ($gateways->MUenvironment == "live")?false:true;
 							
 		}
		
	}


    public function AIM($params)
	{
		$x_Login = $this->at_login;     
		$x_Password = $this->at_password;
		$x_environment = $this->at_environment;              // Set to false to test against production
		$METHOD_TO_USE = "AIM";
		// $METHOD_TO_USE = "DIRECT_POST";         // Uncomment this line to test DPM
		
		define("AUTHORIZENET_API_LOGIN_ID",$x_Login);    // Add your API LOGIN ID
		define("AUTHORIZENET_TRANSACTION_KEY",$x_Password); // Add your API transaction key
		define("AUTHORIZENET_SANDBOX",$x_environment); 
		
		//define("AUTHORIZENET_SANDBOX",true);       // Set to false to test against production
		//if($_POST['AUTHORIZENET_SANDBOX'] == 1){define("AUTHORIZENET_SANDBOX",true);}else{define("AUTHORIZENET_SANDBOX",false);}
		
		define("TEST_REQUEST", "FALSE");           // You may want to set to true if testing against production
		
		// You only need to adjust the two variables below if testing DPM
		define("AUTHORIZENET_MD5_SETTING","");                // Add your MD5 Setting.
		
		$transaction = new AuthorizeNetAIM;
		$transaction->setSandbox(AUTHORIZENET_SANDBOX);
		
		$transaction->setFields(
			array(
			
				  "amount"				=> $params->total_amount,
				  "card_num"			=> $params->x_card_num,
				  "exp_date"			=> $params->x_exp_date,
				  "card_code"			=> $params->x_card_code,
				  "first_name"			=> $params->x_first_name,
				  "last_name"			=> $params->x_last_name,
				  "address"				=> $params->x_address,
				  "city"				=> $params->x_city,
				  "state"				=> $params->x_state,
				  "country"				=> $params->x_country,
				  "zip"					=> $params->x_zip,
				  "email"					=> $params->x_email
			)
		);
		
		$transaction->setCustomField("invoice_number", time());
		$transaction->setCustomField("description", $params->description);
		
		$response = $transaction->authorizeAndCapture();
		//return $response->approved;
		$at_error="";
		//print_r($response);
		if ($response->approved) {
			$at_response = ($response);
		} else {
			$at_error = 1;
			$at_response = $response->response_reason_text;
		}
		
		$responseArray = array();
		$responseArray['AT_Error'] = $at_error;
		$responseArray['AT_Response'] = $at_response;
		return $responseArray;
		  
		
	}

	public function Authorize($params)
	{
		
		

		$x_Login = $at_login;     
		$x_Password = $at_password;

		$DEBUGGING					= $CI->config->item('at_debug');
		$TESTING					= $CI->config->item('at_test');	
		$ERROR_RETRIES				= 2;

		$auth_net_url				= $CI->config->item('at_site');

		$authnet_values				= array
		(
			"x_login"				=> $x_Login,
			"x_version"				=> "3.1",
			"x_delim_char"			=> "|",
			"x_delim_data"			=> "TRUE",
			"x_type"				=> "AUTH_CAPTURE",
			"x_method"				=> "CC",
		 	"x_tran_key"			=> $x_Password,
		 	"x_relay_response"		=> "FALSE",
			"x_card_num"			=> $params->cc,
			"x_exp_date"			=> $params->exp,
			"x_description"			=> $params->desc,
			"x_amount"				=> $params->amount,
			"x_first_name"			=> $params->firstName,
			"x_last_name"			=> $params->lastName,
			"x_address"				=> $params->address,
			"x_city"				=> $params->city,
			"x_state"				=> $params->state,
			"x_zip"					=> $params->zip,
			"CustomerBirthMonth"	=> $params->customerMonth,
			"CustomerBirthDay"		=> $params->customerDay,
			"CustomerBirthYear"		=> $params->customerYear,
			"SpecialCode"			=> $params->specialCode,
		);

		$fields = "";
		foreach( $authnet_values as $key => $value ) $fields .= "$key=" . urlencode( $value ) . "&";
		$curl_request = curl_init($auth_net_url);
        curl_setopt($curl_request, CURLOPT_POSTFIELDS,  rtrim( $fields, "& " ));
        curl_setopt($curl_request, CURLOPT_HEADER, 0);
        curl_setopt($curl_request, CURLOPT_TIMEOUT, 45);
        curl_setopt($curl_request, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl_request, CURLOPT_SSL_VERIFYHOST, 2);
       /* if ($this->VERIFY_PEER) {
            curl_setopt($curl_request, CURLOPT_CAINFO, dirname(dirname(__FILE__)) . '/ssl/cert.pem');
        } else {
            curl_setopt($curl_request, CURLOPT_SSL_VERIFYPEER, false);
        }
        */
        if (preg_match('/xml/',$auth_net_url)) {
            curl_setopt($curl_request, CURLOPT_HTTPHEADER, Array("Content-Type: text/xml"));
        }
        
        $response = curl_exec($curl_request);
		
		//die(print_r($response));exit;
  		curl_close ($curl_request);
	
		return $response;

	}
}
 