<?php 
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require_once(dirname(__FILE__) ."/2Checkout/lib/Twocheckout.php");

/*
|	Call it by doing this:
|
|		$this->load->library('my_payment');
|		$params->cc = '1293081309812039812039' ;//etc... you get the idea
|		
|		$result = $this->my_payment->authorize($params);
|		print_r($result); //response codes from authorize.net*/
 
class twocheckout_payment {

	protected $twocheckout_username = "";
	protected $twocheckout_password = "";
	protected $twocheckout_sellerid = "";
	protected $twocheckout_publishablekey = "";
	protected $twocheckout_privatekey = "";
	protected $twocheckout_environment = "";
	
	public function __construct()
	{
		$CI =& get_instance();
		$CI->load->model('Gateways'); 
 		//print_r($CI->Gateways->get_default_gateway()->result());exit();
		$data['gateway_info']= $CI->Gateways->get_default_gateway();
  		foreach ($data['gateway_info']->result() as $gateways){
  			   	 
			  $this->twocheckout_username = $gateways->MUinfo;
			  $this->twocheckout_password = $gateways->MUkey;
			  $this->twocheckout_sellerid = $gateways->MUsellerid;
			  $this->twocheckout_publishablekey = $gateways->MUpublishablekey;
			  $this->twocheckout_privatekey = $gateways->MUprivatekey;
			  $this->twocheckout_environment = ($gateways->MUenvironment == "live")?false:true;
 							
 		}
	}
	
	public function Authorize($params)
	{
		
		
		Twocheckout::username($this->twocheckout_username);
		Twocheckout::password($this->twocheckout_password);
		Twocheckout::privateKey($this->twocheckout_privatekey);
		Twocheckout::sellerId($this->twocheckout_sellerid);
		Twocheckout::sandbox($this->twocheckout_environment);
		Twocheckout::verifySSL(false);  // this is set to true by default
		Twocheckout::format('json');
		
		$orderId = time();
				
		$ck_error = "";
		/*try {
				$charge = Twocheckout_Charge::auth(array(
					"merchantOrderId" => $orderId,
					"token"      => $params->token,
					"currency"   => $params->currency,
					"total"      => $params->total/*,
					"billingAddr" => array(
						"name" => $params->name,
						"addrLine1" => $params->address,
						"city" => $params->city,
						"state" => $params->state,
						"zipCode" => $params->zip,
						"country" => $params->country,
						"email" => $params->email,
						"phoneNumber" => $params->phone_number
					)
				), 'array');*/
		try {
				$charge = Twocheckout_Charge::auth(array(
					"merchantOrderId" => $orderId,
					"token"      => $params->token,
					"currency"   => $params->currency,
					"total"      => $params->total
				), 'array');
				
				$charge = json_decode($charge);
				
				if(!empty($charge->response))
				{
					if ($charge->response->responseCode == 'APPROVED') {
						
						/*echo "Thanks for your Order!";
						echo "<h3>Return Parameters:</h3>";
						echo "<pre>";
						print_r($charge);
						echo "</pre>";*/
						$twocheckout_response = json_encode($charge);
			
					}
				}
				else
				{
					if(!empty($charge->exception))
					{
						$ck_error=1;
						$twocheckout_response = $charge->exception->errorMsg;
					}
				}
				
		} catch (Twocheckout_Error $e) {$twocheckout_response = $e->getMessage();$ck_error=1;} 
		
		$responseArray = array();
		$responseArray['CK_Error'] = $ck_error;
		$responseArray['CK_Response'] = $twocheckout_response;
		return $responseArray;
		
		
		// Check
		/*if($firstData->isError()) {
			// there was an error
			return "First Data Fail";
		} else {
			return "First Data Sucess";
			// transaction passed
		}*/

	}
	
	
}
 