<?php
 class Gateways extends Model {
 
 	function get_all()
	{
		/*$gateway_id = 2;
		$this->db->from('gateways');	
		$this->db->where('gateways.gateway_id',$gateway_id);
		$query = $this->db->get();
				
		return $query;*/		

		$this->db->from('gateways');
 		$gatewayid = $this->db->get();
		foreach($gatewayid->result() as $row)
		{
			$gateway_id=$row->gateway_id;		
 		}
  		
  		return $gatewayid;
  		
	}
	
	function get_default_gateway()
	{
 	 
		$this->db->from('gateways');
 		/*$this->db->where('default',1);*/
		$array = array('default' => 1, 'enable' => 1);
        $this->db->where($array);
  		return $this->db->get();		
	}
	
	function get_gateway_devices($device_gateway)
	{
		$this->db->from('gateways_devices');
 		$this->db->where('device_gateway', $device_gateway);
		$this->db->order_by("device_name", "asc");
  		return $this->db->get();		
	}
	
	function get_info($gateway_id)
	{
		$this->db->from('gateways');	
 		$this->db->where('gateways.gateway_id',$gateway_id);
		$query = $this->db->get();
		
		if($query->num_rows()==1)
		{
			return $query->row();
		}
		else
		{
			//Get empty base parent object, as $customer_id is NOT an customer
	//		$gateway_obj=parent::get_info1(-1);
			
			//Get all the fields from customer table
			$fields = $this->db->list_fields('gateways');
			
			//append those fields to base parent object, we we have a complete empty object
			foreach ($fields as $field)
			{
				$gateway_obj->$field='';
			}
			
			return $gateway_obj;
		}
	}
 		
	function Edit($gateway_id, $gateway_data){
			 
	  $this->db->from('gateways');	
	  $this->db->where('gateway_id', $gateway_id);
	  $result = $this->db->update('gateways', $gateway_data);
 	  if($result){
	    return $gateway_data;
	  } else {
	    return false;
	  }
	} 
	
	/*
	Deletes one gateway
	*/
	function delete($active_gateway)
	{
 		$this->db->where('gateway_id', $active_gateway);
		return $this->db->update('gateways', array('default' => 0));
	}
	
	/*
	Deletes a list of customers
	*/
	function delete_list($customer_ids)
	{
		$this->db->where_in('person_id',$customer_ids);
		return $this->db->update('customers', array('deleted' => 1));
 	}
 	
 	/*
	Get search suggestions to find customers
	*/
	function get_search_suggestions($search,$limit=25)
	{
		$suggestions = array();
		
		$this->db->from('customers');
		$this->db->join('people','customers.person_id=people.person_id');	
		$this->db->where("(first_name LIKE '%".$this->db->escape_like_str($search)."%' or 
		last_name LIKE '%".$this->db->escape_like_str($search)."%' or 
		CONCAT(`first_name`,' ',`last_name`) LIKE '%".$this->db->escape_like_str($search)."%') and deleted=0");
		$this->db->order_by("last_name", "asc");		
		$by_name = $this->db->get();
		foreach($by_name->result() as $row)
		{
			$suggestions[]=$row->first_name.' '.$row->last_name;		
		}
		
		$this->db->from('customers');
		$this->db->join('people','customers.person_id=people.person_id');	
		$this->db->where('deleted',0);		
		$this->db->like("email",$search);
		$this->db->order_by("email", "asc");		
		$by_email = $this->db->get();
		foreach($by_email->result() as $row)
		{
			$suggestions[]=$row->email;		
		}

		$this->db->from('customers');
		$this->db->join('people','customers.person_id=people.person_id');	
		$this->db->where('deleted',0);		
		$this->db->like("phone_number",$search);
		$this->db->order_by("phone_number", "asc");		
		$by_phone = $this->db->get();
		foreach($by_phone->result() as $row)
		{
			$suggestions[]=$row->phone_number;		
		}
		
		$this->db->from('customers');
		$this->db->join('people','customers.person_id=people.person_id');	
		$this->db->where('deleted',0);		
		$this->db->like("account_number",$search);
		$this->db->order_by("account_number", "asc");		
		$by_account_number = $this->db->get();
		foreach($by_account_number->result() as $row)
		{
			$suggestions[]=$row->account_number;		
		}
		
		//only return $limit suggestions
		if(count($suggestions > $limit))
		{
			$suggestions = array_slice($suggestions, 0,$limit);
		}
		return $suggestions;
	
	}
	
	/*
	Get search suggestions to find customers
	*/
	function get_customer_search_suggestions($search,$limit=25)
	{
		$suggestions = array();
		
		$this->db->from('customers');
		$this->db->join('people','customers.person_id=people.person_id');	
		$this->db->where("(first_name LIKE '%".$this->db->escape_like_str($search)."%' or 
		last_name LIKE '%".$this->db->escape_like_str($search)."%' or 
		CONCAT(`first_name`,' ',`last_name`) LIKE '%".$this->db->escape_like_str($search)."%') and deleted=0");
		$this->db->order_by("last_name", "asc");		
		$by_name = $this->db->get();
		foreach($by_name->result() as $row)
		{
			$suggestions[]=$row->person_id.'|'.$row->first_name.' '.$row->last_name;		
		}
		
		$this->db->from('customers');
		$this->db->join('people','customers.person_id=people.person_id');	
		$this->db->where('deleted',0);		
		$this->db->like("account_number",$search);
		$this->db->order_by("account_number", "asc");		
		$by_account_number = $this->db->get();
		foreach($by_account_number->result() as $row)
		{
			$suggestions[]=$row->person_id.'|'.$row->account_number;
		}

		//only return $limit suggestions
		if(count($suggestions > $limit))
		{
			$suggestions = array_slice($suggestions, 0,$limit);
		}
		return $suggestions;

	}
	
	/*
	Preform a search on customers
	*/
	function search($search)
	{
		$this->db->from('customers');
		$this->db->join('people','customers.person_id=people.person_id');		
		$this->db->where("(first_name LIKE '%".$this->db->escape_like_str($search)."%' or 
		last_name LIKE '%".$this->db->escape_like_str($search)."%' or 
		email LIKE '%".$this->db->escape_like_str($search)."%' or 
		phone_number LIKE '%".$this->db->escape_like_str($search)."%' or 
		account_number LIKE '%".$this->db->escape_like_str($search)."%' or 
		CONCAT(`first_name`,' ',`last_name`) LIKE '%".$this->db->escape_like_str($search)."%') and deleted=0");		
		$this->db->order_by("last_name", "asc");
		
		return $this->db->get();	
	}
}
?>
