<?php
require_once("report.php");
class Summary_categories extends Report
{
	function __construct()
	{
		parent::__construct();
	}
	
	public function getDataColumns()
	{
		return array($this->lang->line('reports_category'), $this->lang->line('reports_subtotal'), $this->lang->line('reports_total'), $this->lang->line('reports_tax'), $this->lang->line('reports_profit'));
	}
	
	public function getData(array $inputs)
	{
		$q = $this->db->query("SELECT table_name FROM INFORMATION_SCHEMA.TABLES WHERE table_schema = '".$this->db->database."' and table_name=sales_items_temp");
		/*$exists = array_shift($q->result_array());*/
		if(!empty($q))
		{
		  $this->db->select('category, sum(subtotal) as subtotal, sum(total) as total, sum(tax) as tax, sum(profit) as profit');
		  $this->db->from('sales_items_temp');
		  $this->db->join('items', 'sales_items_temp.item_id = items.item_id');
		  $this->db->where('sale_date BETWEEN "'. $inputs['start_date']. '" and "'. $inputs['end_date'].'"');
		  $this->db->group_by('category');
		  $this->db->order_by('category');
          $data = array();
		  $data = $this->db->get()->result_array();
		  return $data;
		}
		else
		{
		 $data = array();
		 return $data="";	
		}		
	}
	
	public function getSummaryData(array $inputs)
	{
		$q = $this->db->query("SELECT table_name FROM INFORMATION_SCHEMA.TABLES WHERE table_schema = '".$this->db->database."' and table_name=sales_items_temp");
		/*$exists = array_shift($q->result_array());*/
		if(!empty($q))
		{
		$this->db->select('sum(subtotal) as subtotal, sum(total) as total, sum(tax) as tax, sum(profit) as profit');
		$this->db->from('sales_items_temp');
		$this->db->join('items', 'sales_items_temp.item_id = items.item_id');
		$this->db->where('sale_date BETWEEN "'. $inputs['start_date']. '" and "'. $inputs['end_date'].'"');

		return $this->db->get()->row_array();
		}
		else
		{
		 return array("subtotal"=>0,"total"=>0,"tax"=>0,"profit"=>0);	
		}	
	}
}
?>