<?php include("ajax.includes.php");?>
<?php
$sqlClass = new Main();

/*Code for Customer Payment Methods*/
if(isset($_REQUEST['action']) && $_REQUEST['action']=="joinForFree")
{
	$customer_data = $SESSION_CUSTOMER;
	$cancel_subscription_response = [];
	$print_data = ['error'=>1,'msg'=>'Subscription already has been cancelled!'];
	if($customer_data['is_payable'] == 1 && $customer_data['subscription_status'] != 'cancelled')
	{
		$subscription_id = $customer_data['payment_profile_id'];
		$gateway = $customer_data['payment_gateway'];

		if($gateway == "creditcard")
		{
			$authorize_login_id = cleanSQL($settingsData['authorize_login_id']);
			$authorize_transaction_key = cleanSQL($settingsData['authorize_transaction_key']);
			$authorize_environment = cleanSQL($settingsData['authorize_environment']);
			
			define("TEST_REQUEST", false);
			define("AUTHORIZENET_MD5_SETTING","");
			define("AUTHORIZENET_API_LOGIN_ID",$authorize_login_id);
			define("AUTHORIZENET_TRANSACTION_KEY",$authorize_transaction_key);
			define("AUTHORIZENET_SANDBOX",($authorize_environment=="live")?false:true);

			include(ROOT."lib/PaymentsAPI/anet_php_sdk/authorize_payment.inc.php");
			$refId = "ref" . time();		

			// Cancel the subscription.
			$request = new AuthorizeNetARB;
			$request->setRefId($refId);
			$request->setSandbox(AUTHORIZENET_SANDBOX);
			$response = $request->cancelSubscription($subscription_id);


			$cancel_subscription_response = json_decode(json_encode($response->xml),TRUE);
			$cancel_subscription_response['ts'] = date('Y-m-d h:i:s');
			
			// print_r($cancel_subscription_response);

			$print_data = ['error'=>($response->xml->messages->resultCode == "Ok" ? 0 : 1),'msg'=>$response->xml->messages->message->text];

			if ($response->xml->messages->resultCode == "Ok") {

				$print_data = ['error'=>0,'msg'=>'Subscription has been cancelled successfully.'];
			
			// 	// Get Subscription Id
			// 	// $this->assertTrue($response->isOk());
			// 	echo $response->xml->messages->message->text."|";
			// 	exit();
				
			} else {
				$print_data = ['error'=>1,'msg'=>$response->xml->messages->message->text];
			// 	echo $response->xml->messages->message->text."|";
			// 	exit();
			}

			// echo "<pre>";
			// print_r($response);

		}
		else if($gateway == "paypal")
		{
			require(ROOT."lib/functions_payments.php");

			$params = array();
			$params['paypal_environment'] = urlencode($settingsData['paypal_environment']);
			$params['paypal_username'] = urlencode($settingsData['paypal_username']);
			$params['paypal_password'] = urlencode($settingsData['paypal_password']);
			$params['paypal_signature'] = urlencode($settingsData['paypal_signature']);
			$params['nvp_method'] = 'ManageRecurringPaymentsProfileStatus';
			$params['nvp_string'] = '&VERSION=76.0&ACTION=Cancel&PROFILEID='.$subscription_id.'&NOTE='.urlencode( 'Profile cancelled at store' );

			$paypal_result = PayPalHTTPPost($params);
			$cancel_subscription_response = array(
									'error'=>$paypal_result['PP_Error'],
									'response'=>$paypal_result['PP_Response'],
									'ts'=>date('Y-m-d h:i:s')
									);


			if($paypal_result['PP_Error'] == 1)
				$print_data = ['error'=>1,'msg'=>urldecode($paypal_result['PP_Response']['L_LONGMESSAGE0'])];
			else
				$print_data = ['error'=>0,'msg'=>'Subscription has been cancelled successfully.'];
		}
	}

	$table_customers = TBLPREFIX."customers";
	$customer_id = cleanSQL($customer_data['customer_id']);
	$account_name = cleanSQL($customer_data['account_name']);
	$payment_plan = cleanSQL($_REQUEST['payment_plan']);
	$payment_gateway = cleanSQL($_REQUEST['payment_gateway']);

	$payment_profile_uts = TimeStamp();
	$sqlMainClass->updateRow($table_customers," subscription_status='".($print_data['error'] == 0 ? 'cancelled' : '')."', subscription_response = '".json_encode($cancel_subscription_response)."',payment_profile_uts ='$payment_profile_uts',payment_plan ='$payment_plan',payment_gateway ='$payment_gateway',payment_profile_status='canceled',payment_creditcard_expiry_status = 0,is_suspended = 0,sts ='0000-00-00 00:00:00',dts ='0000-00-00 00:00:00' "," WHERE customer_id='$customer_id' AND account_name='$account_name' ");

	$package_data = $sqlClass->getRow("invoice_per_month,domain_based_email_accounts,email_storage_quota",TBLPREFIX."packages", "  WHERE pkg_id = ".$payment_plan." ");

	$customer = $customer_data;
	$customer['package_data'] = $package_data;
	$customer['payment_plan'] = $payment_plan;
	$customer['payment_gateway'] = $payment_gateway;
	$_SESSION["customer"] = $customer;
	setSession("customer",$customer);
}

/*Code for Customer Payment Methods*/
if(isset($_REQUEST['action']) && ($_REQUEST['action']=="payWithPaypal" || $_REQUEST['action']=="payWithCreditCard"))
{
	//printArray($settingsData);
	$current_date = currentDate();
	
	$table_packages = TBLPREFIX."packages";
	$table_customers = TBLPREFIX."customers";
	$table_customers_users = TBLPREFIX."customers_users";
	$table_payments_history = TBLPREFIX_SETTINGS."payments_history";
	
	require ROOT.'lib/functions_payments.php';
	
	//printArray($customer_data);exit();
	$customer_id = cleanSQL($customer_data['customer_id']);
	$account_name = cleanSQL($customer_data['account_name']);
	
	/*Get Main Customer Data*/
	$getMainCustomer = $sqlClass->getRow("*",$table_customers," WHERE customer_id='$customer_id' AND account_name='$account_name' "); 

	$customer_payment_plan = cleanSQL($getMainCustomer['payment_plan']);
	$customer_payment_status = cleanSQL($getMainCustomer['payment_status']);
	$customer_payment_gateway = cleanSQL($getMainCustomer['payment_gateway']);
	$customer_payment_payer_id = cleanSQL($getMainCustomer['payment_payer_id']);
	$customer_payment_profile_id = cleanSQL($getMainCustomer['payment_profile_id']);
	$customer_payment_profile_id = urlDecodeVal($customer_payment_profile_id);
	$customer_payment_profile_status = cleanSQL($getMainCustomer['payment_profile_status']);
	$customer_payment_paid_date = cleanSQL($getMainCustomer['payment_paid_date']);
	$customer_payment_due_date = cleanSQL($getMainCustomer['payment_due_date']);
	$customer_payment_due_amount = cleanSQL($getMainCustomer['payment_due_amount']);
	$customer_payment_creditcard_digits = cleanSQL($getMainCustomer['payment_creditcard_digits']);
	$customer_payment_creditcard_expiry = cleanSQL($getMainCustomer['payment_creditcard_expiry']);
	$customer_payment_trial_duration = cleanSQL($getMainCustomer['payment_trial_duration']);
	
	/*Get Main Customer User Data*/
	$getMainCustomerUser = $sqlClass->getRow("*",$table_customers_users," WHERE customer_id='$customer_id' AND account_name='$account_name' AND type=0 ");	//printArray($getMainCustomerUser);
	$customer_user_firstname = cleanSQL($getMainCustomerUser['firstname']);
	$customer_user_lastname = cleanSQL($getMainCustomerUser['lastname']);
	$customer_user_email_address = cleanSQL($getMainCustomerUser['email_address']);
	
	/*Get Post Data*/
	$payment_plan = cleanSQL($_REQUEST['payment_plan']);
	$payment_gateway = cleanSQL($_REQUEST['payment_gateway']);
	
	/*Get Customer Payment Plan Data*/
	if(!empty($payment_plan))
	{
		$getCustomerPaymentPlan = $sqlClass->getRow("*",$table_packages," WHERE pkg_id='$payment_plan' ");
		//printArray($getCustomerPaymentPlan);	
		$payment_plan_id = $getCustomerPaymentPlan['pkg_id'];
		$payment_plan_name = $getCustomerPaymentPlan['pkg_name'];
		$payment_plan_amount = $getCustomerPaymentPlan['pkg_amount'];
		$payment_plan_period = $getCustomerPaymentPlan['pkg_period'];
		$payment_plan_frequency = $getCustomerPaymentPlan['pkg_frequency'];
		$payment_plan_total_cycles = $getCustomerPaymentPlan['pkg_total_cycles'];
		$payment_plan_offer = $getCustomerPaymentPlan['pkg_offer'];
	}
	
	$payment_profile_subscription_name = "Wrkmash Account Subscription";
	$payment_profile_billing_description = "Wrkmash Account Subscription";
	
	/*Paypal Settings Values and Variables*/
	$country_code = urlEncodeVal($settingsData['cp_paypal_country_code']);
	$currency_code = urlEncodeVal($settingsData['cp_paypal_currency_code']);
	
	$params = array();
	$params['paypal_username'] = urlEncodeVal($settingsData['paypal_username']);
	$params['paypal_password'] = urlEncodeVal($settingsData['paypal_password']);
	$params['paypal_signature'] = urlEncodeVal($settingsData['paypal_signature']);
	$params['paypal_environment'] = urlEncodeVal($settingsData['paypal_environment']);
	
	if ($settingsData['paypal_environment'] == 'live')
	$subenvi = '';
	else
	$subenvi = $settingsData['paypal_environment'].'.';

	$paypal_url = 'https://www.'.$subenvi.'paypal.com';
	$paypal_cancel_url = ZBPATH."dashboard";
	$paypal_return_url = ZBPATH."dashboard/payments/paypal/success";
	$paypal_notify_url = ZBPATH."dashboard/payments/paypal/notify";
	
	/*Credit Card Settings Values and Variables*/
	$authorize_login_id = cleanSQL($settingsData['authorize_login_id']);
	$authorize_transaction_key = cleanSQL($settingsData['authorize_transaction_key']);
	$authorize_environment = cleanSQL($settingsData['authorize_environment']);
	
	define("TEST_REQUEST", false);
	define("AUTHORIZENET_MD5_SETTING","");
	define("AUTHORIZENET_API_LOGIN_ID",$authorize_login_id);
	define("AUTHORIZENET_TRANSACTION_KEY",$authorize_transaction_key);
	define("AUTHORIZENET_SANDBOX",($authorize_environment=="live")?false:true);
	
	if($authorize_environment=="live")
	{
		$authorize_api_url = "https://api.authorize.net/xml/v1/request.api";
	}
	else
	{
		$authorize_api_url = "https://apitest.authorize.net/xml/v1/request.api";
	}
	
	$authorize_cancel_url = ZBPATH."dashboard";
	$authorize_return_url = ZBPATH."dashboard/payments/authorize/success";
	$authorize_notify_url = ZBPATH."dashboard/payments/authorize/notify";
	
	include(ROOT."lib/PaymentsAPI/anet_php_sdk/authorize_payment.inc.php");
	
	if($customer_payment_status !=0)
	{
		/*Get Customer Payment Profile Details*/
		if($customer_payment_gateway == "paypal")
		{
			if(!empty($customer_payment_profile_id))
			{
				//$PROFILEID = urlEncodeVal("I-YDN7PTMD3M57");
				$PROFILEID = urlEncodeVal($customer_payment_profile_id);
				$params['nvp_method'] = "GetRecurringPaymentsProfileDetails";
				$params['nvp_string'] = "&PROFILEID=$PROFILEID";//printArray($params);
				$result = PayPalHTTPPost($params);//printArray($result);
				if(!empty($result['PP_Error']) && $result['PP_Error']==1)
				{
					  $paypal_response['error'] = 1;	
					  $paypal_response['message'] = CheckPayPalHTTPPostError($result);
					  echo json_encode($paypal_response);
					  exit();
				}
				$customer_payment_plan_amount = urlDecodeVal($result['PP_Response']['AMT']);
				$customer_payment_plan_period = urlDecodeVal($result['PP_Response']['BILLINGPERIOD']);
				$customer_payment_plan_period = ConvertPayPalRPPeriodToCPRPPeriod($customer_payment_plan_period);
				$customer_payment_plan_frequency = urlDecodeVal($result['PP_Response']['BILLINGFREQUENCY']);
				$customer_payment_paypal_profile_id = urlDecodeVal($result['PP_Response']['PROFILEID']);
				$customer_payment_paypal_profile_status = urlDecodeVal($result['PP_Response']['STATUS']);
			}
		}
		
		if($customer_payment_gateway == "creditcard")
		{
			if(!empty($customer_payment_profile_id))
			{
				// Get the subscription status.
				$request = new AuthorizeNetARB;
				$request->setSandbox(AUTHORIZENET_SANDBOX);
				$response = $request->getSubscription($customer_payment_profile_id);
				//printArray($response->xml);
				if ($response->xml->messages->resultCode == "Error") {
					$creditcard_response['error'] = 1;
					$creditcard_response['message'] = "".$response->xml->messages->message->text;
					echo json_encode($creditcard_response);
					exit();
				}
				//$response = json_decode(json_encode($response->xml),TRUE);
				$response = $response->xml->subscription;
				$customer_payment_plan_amount = $response->amount;
				$customer_payment_plan_period = $response->paymentSchedule->interval->unit;
				$customer_payment_plan_frequency = $response->paymentSchedule->interval->length;
				$customer_payment_creditcard_profile_id = $customer_payment_profile_id;
				$customer_payment_creditcard_profile_status = $response->status;
			}
		}
		
		/*Calculate Customer Payment Profile Due Amount*/
		$get_customer_payment_due_amount = GetRecurringPaymentDueAmount($current_date,$customer_payment_paid_date,$customer_payment_plan_amount,$customer_payment_plan_period,$customer_payment_plan_frequency);
		$customer_payment_due_amount_days = $get_customer_payment_due_amount['days'];
		$customer_payment_due_amount_periods = $get_customer_payment_due_amount['periods'];
		
		/*if(daysBetweenDates($current_date, $customer_payment_paid_date) > daysBetweenDates($customer_payment_due_date, $customer_payment_paid_date))
		{
			
		}*/
	}
	
	if($_REQUEST['method']=="changeRecurringProfile" || $_REQUEST['method']=="upgradeRecurringProfile")
	{
		if($customer_payment_status !=0)
		//if($customer_payment_status !=0 && $customer_payment_gateway != $payment_gateway)
		{
			if($customer_payment_gateway == "paypal")
			{
				if(!empty($customer_payment_profile_id) && $customer_payment_paypal_profile_status == "Active")
				{
					$params['nvp_method'] = "ManageRecurringPaymentsProfileStatus ";
					$ACTION = urlEncodeVal("Cancel");
					$PROFILEID = urlEncodeVal($customer_payment_profile_id);
					$params['nvp_string'] = "&PROFILEID=$PROFILEID&ACTION=$ACTION";
					//printArray($params);
					$result = PayPalHTTPPost($params);
					if(!empty($result['PP_Error']) && $result['PP_Error']==1)
					{
						  $paypal_response['error'] = 1;	
						  $paypal_response['message'] = CheckPayPalHTTPPostError($result);
						  echo json_encode($paypal_response);
						  exit();
					}
				}
			}
			
			if($customer_payment_gateway == "creditcard")
			{
				if(!empty($customer_payment_profile_id) && $customer_payment_creditcard_profile_status == "active")
				{
					// Cancel the subscription.
					$request = new AuthorizeNetARB;
					$request->setSandbox(AUTHORIZENET_SANDBOX);
					$response = $request->cancelSubscription($customer_payment_profile_id);
					//printArray($response);
					//printArray($response->xml);
					if ($response->xml->messages->resultCode == "Error")
					{
						$creditcard_response['error'] = 1;	
						$creditcard_response['message'] = "".$response->xml->messages->message->text;
						echo json_encode($creditcard_response);
						exit();
					}
				}
			}
		}
	}
	
	/*$METHOD_TO_USE = "AIM";
	$pay_customer_payment_due_amount = new AuthorizeNetAIM;
	$pay_customer_payment_due_amount->setFields(
		array(
	   'amount' => 1,
	   'card_num' => "4111111111111111",
	   'exp_date' => "0919",
	   'card_code' => 123
	   )
	);
	$pay_customer_payment_due_amount_response = $pay_customer_payment_due_amount->authorizeAndCapture();
	printArray($pay_customer_payment_due_amount_response);
	exit();*/
	
	/*$params['nvp_method'] = "UpdateRecurringPaymentsProfile ";
	$PROFILEID = urlEncodeVal($customer_payment_profile_id);
	$OUTSTANDINGBALANCE = urlEncodeVal(cleanSQL(1));
	$params['nvp_string'] = "&PROFILEID=$PROFILEID&OUTSTANDINGBALANCE=$OUTSTANDINGBALANCE";
	printArray($params);
	$result = PayPalHTTPPost($params);printArray($result);*/
	//exit();
}

/*Methods for Paypal for Customer Payment Plan*/
if(isset($_REQUEST['action']) && $_REQUEST['action']=="payWithPaypal")
{
	$paypal_process_modal = $_REQUEST['process_modal'];
	$paypal_return_method = $_REQUEST['return_method'];
	
	/*Set Express Checkout for Customer Payment Recurring Profile*/
	if(isset($_REQUEST['method']) && $_REQUEST['method']=="setExpressCheckout")
	{
		/*Endpoint URL: https://api-3t.sandbox.paypal.com/nvp
		HTTP method: POST
		POST data:
		USER=insert_merchant_user_name_here
		&PWD=insert_merchant_password_here
		&SIGNATURE=insert_merchant_signature_value_here
		&METHOD=SetExpressCheckout
		&VERSION=86
		&L_BILLINGTYPE0=RecurringPayments    #The type of billing agreement
		&L_BILLINGAGREEMENTDESCRIPTION0=FitnessMembership    #The description of the billing agreement
		&cancelUrl=https://example.com/cancel    #For use if the consumer decides not to proceed with payment
		&returnUrl=https://example.com/success   #For use if the consumer proceeds with payment*/
		$params['nvp_method'] = "SetExpressCheckout";
		$L_BILLINGTYPE0 = urlEncodeVal("RecurringPayments");
		$L_BILLINGAGREEMENTDESCRIPTION0 = urlEncodeVal($payment_profile_billing_description);
		$cancelUrl = urlEncodeVal($paypal_cancel_url);
		//$returnUrl = urlEncodeVal($paypal_return_url);
		$paypal_return_data = array();
		$paypal_return_data['payment_plan'] = $payment_plan;
		$paypal_return_data['payment_gateway'] = $payment_gateway;
		$paypal_return_data['paypal_process_modal'] = $paypal_process_modal;
		$paypal_return_data['paypal_return_method'] = $paypal_return_method;
		$returnUrl = urlEncodeVal($paypal_return_url."/".base64_encode(json_encode($paypal_return_data)));
		$notifyUrl = urlEncodeVal($paypal_notify_url);
		$params['nvp_string'] = "&L_BILLINGTYPE0=$L_BILLINGTYPE0&L_BILLINGAGREEMENTDESCRIPTION0=$L_BILLINGAGREEMENTDESCRIPTION0&cancelUrl=$cancelUrl&returnUrl=$returnUrl&NOTIFYURL=$notifyUrl";
		//printArray($params);
		$result = PayPalHTTPPost($params);
		if(!empty($result['PP_Error']) && $result['PP_Error']==1)
		{
			  $paypal_response['error'] = 1;	
			  $paypal_response['message'] = CheckPayPalHTTPPostError($result); 
		}
		else
		{
			  /*Save Data in Main Customer Table*/
			  /*$payment_plan = cleanSQL($_REQUEST['payment_plan']);
			  $sqlMainClass->updateRow($table_customers," payment_plan='$payment_plan' "," WHERE customer_id='$customer_id' AND account_name='$account_name' ");*/	
			  
			  //$data['error_message'] = 'Payment was successfully made';
			  $paypal_response['error'] = 0;
			  $paypal_response['message'] = "Success";
			  $paypal_response["paypal_redirect_url"] = ($paypal_url."/cgi-bin/webscr?cmd=_express-checkout&token=".$result['PP_Response']["TOKEN"]);	
			  
			  
		}
		/*$paypal_response['response'] = $result;
		$paypal_response['method'] = $_REQUEST['method'];
		echo json_encode($paypal_response);*/
	}
	
	/*Get Express Checkout for Customer Payment Recurring Profile*/
	if(isset($_REQUEST['method']) && $_REQUEST['method']=="getExpressCheckout")
	{
		$params['nvp_method'] = "GetExpressCheckoutDetails";
		$TOKEN = urlEncodeVal(cleanSQL($_REQUEST['token']));
		$params['nvp_string'] = "&TOKEN=$TOKEN";
		//printArray($params);
		$result = PayPalHTTPPost($params);
		if(!empty($result['PP_Error']) && $result['PP_Error']==1)
		{
			  $paypal_response['error'] = 1;	
			  $paypal_response['message'] = CheckPayPalHTTPPostError($result);
		}
		else
		{
			  //$data['error_message'] = 'Payment was successfully made';
			  $paypal_response['error'] = 0;
			  $paypal_response['message'] = "Success";
			  $paypal_response["token"] = $result['PP_Response']["TOKEN"];
			  $paypal_response["payer_id"] = $result['PP_Response']["PAYERID"];
			  $paypal_response["payment_status"] = $customer_payment_status;	
			  if($customer_payment_status == 1)
			  {
				  $paypal_response["payment_profile_id"] = $customer_payment_profile_id;
			  }
		}
		/*$paypal_response['response'] = $result;
		$paypal_response['method'] = $_REQUEST['method'];
		echo json_encode($paypal_response);*/
	}
	
	/*Create and Change Customer Payment Recurring Profile*/
	if(isset($_REQUEST['method']) && $_REQUEST['method']=="createRecurringProfile"
	|| isset($_REQUEST['method']) && $_REQUEST['method']=="changeRecurringProfile"
	|| isset($_REQUEST['method']) && $_REQUEST['method']=="upgradeRecurringProfile"
	)
	{
		/*$params['nvp_method'] = "CreateRecurringPaymentsProfile";
		$TOKEN = urlEncodeVal(cleanSQL($_REQUEST['token']));
		$PAYERID = urlEncodeVal(cleanSQL($_REQUEST['payer_id']));
		$PROFILESTARTDATE = urlEncodeVal(TimeStamp());
		$DESC = urlEncodeVal($payment_profile_billing_description);
		//$BILLINGPERIOD = ($payment_plan_period == "months")?urlEncodeVal("Month"):urlEncodeVal("Year");
		if($payment_plan_period == "days"){$BILLINGPERIOD = urlEncodeVal("Day");}
		elseif($payment_plan_period == "months"){$BILLINGPERIOD = urlEncodeVal("Month");}
		elseif($payment_plan_period == "years"){$BILLINGPERIOD = urlEncodeVal("Year");}
		else{$BILLINGPERIOD == $payment_plan_period;}
		$BILLINGFREQUENCY = urlEncodeVal($payment_plan_frequency);
		$AMT = urlEncodeVal($payment_plan_amount);
		$CURRENCYCODE = urlEncodeVal($currency_code);
		$COUNTRYCODE = urlEncodeVal($country_code);
		$MAXFAILEDPAYMENTS = urlEncodeVal(3);
		$params['nvp_string'] = "&TOKEN=$TOKEN&PAYERID=$PAYERID&PROFILESTARTDATE=$PROFILESTARTDATE&DESC=$DESC&BILLINGPERIOD=$BILLINGPERIOD&BILLINGFREQUENCY=$BILLINGFREQUENCY&AMT=$AMT&CURRENCYCODE=$CURRENCYCODE&COUNTRYCODE=$COUNTRYCODE&MAXFAILEDPAYMENTS=$MAXFAILEDPAYMENTS";
		//printArray($params);
		$result = PayPalHTTPPost($params);
		if(!empty($result['PP_Error']) && $result['PP_Error']==1)
		{
			  $paypal_response['error'] = 1;	
			  $paypal_response['message'] = CheckPayPalHTTPPostError($result);
		}
		else
		{
			  //Save Data in Main Customer Table
			  $payment_start_date = $current_date;
			  $payment_paid_date = $current_date;
			  $payment_profile_id = $result['PP_Response']["PROFILEID"];
			  //if($payment_plan_period == "months")
			  //{
				  //$payment_due_date = date("Y-m-d", mktime(date("s"),date("i"),date("H"), date("m")+$payment_plan_frequency, date("d"), date("Y")));
			  //}
			  //else
			  //{
				  //$payment_due_date = date("Y-m-d", mktime(date("s"),date("i"),date("H"), date("m"), date("d"), date("Y")+$payment_plan_frequency));
			  //}
			  $payment_due_date = GetRecurringPaymentDueDate($payment_plan_period,$payment_plan_frequency) ;
			  $sqlMainClass->updateRow($table_customers," payment_status=1,payment_gateway='paypal',payment_profile_id='$payment_profile_id',payment_payer_id='$PAYERID',payment_start_date ='$payment_start_date',payment_paid_date ='$payment_paid_date',payment_due_date ='$payment_due_date' "," WHERE customer_id='$customer_id' AND account_name='$account_name' ");
			  
			  $sqlClass->usedatabase(CUSTOMERDB);
			  $data_payments_history = array();
			  $data_payments_history["amount"] = cleanSQL($payment_plan_amount);
			  $data_payments_history["date"] = $payment_paid_date;
			  $data_payments_history["gateway"] = "paypal";
			  $data_payments_history["ip_address"] = get_ip_address();
			  $data_payments_history["response"] = $result;
			  $data_payments_history = $sqlClass->cleanData($data_payments_history);
			  //print_r($data_payments_history);exit;
			  $sqlClass->addData($data_payments_history,TBLPREFIX_SETTINGS."payments_history");
			  //$sqlClass->usedatabase(DB);
			  
			  //$data['error_message'] = 'Payment was successfully made';
			  $paypal_response['error'] = 0;
			  $paypal_response['message'] = "Success";
			  $paypal_response["profile_id"] = $payment_profile_id;
			  $paypal_response["profile_status"] = $result['PP_Response']["PROFILESTATUS"];
		}
		$paypal_response['response'] = $result;
		$paypal_response['method'] = $_REQUEST['method'];
		echo json_encode($paypal_response);*/
		
		$params['nvp_method'] = "GetExpressCheckoutDetails";
		$TOKEN = urlEncodeVal(cleanSQL($_REQUEST['token']));
		$params['nvp_string'] = "&TOKEN=$TOKEN";
		//printArray($params);
		$result = PayPalHTTPPost($params);
		if(!empty($result['PP_Error']) && $result['PP_Error']==1)
		{
			  $paypal_response['error'] = 1;	
			  $paypal_response['message'] = CheckPayPalHTTPPostError($result);
		}
		else
		{
			  $params['nvp_method'] = "CreateRecurringPaymentsProfile";
			  $TOKEN = urlEncodeVal(cleanSQL($result['PP_Response']["TOKEN"]));
			  $PAYERID = urlEncodeVal(cleanSQL($result['PP_Response']["PAYERID"]));
			  $PROFILESTARTDATE = urlEncodeVal(TimeStamp());
			  $DESC = urlEncodeVal($payment_profile_billing_description);
			  //$BILLINGPERIOD = ($payment_plan_period == "months")?urlEncodeVal("Month"):urlEncodeVal("Year");
			  if(!empty($customer_user_firstname) || !empty($customer_user_lastname))
			  {$SUBSCRIBERNAME = urlEncodeVal($customer_user_firstname." ".$customer_user_lastname);}
			  /*if($payment_plan_period == "days"){$BILLINGPERIOD = urlEncodeVal("Day");}
			  elseif($payment_plan_period == "months"){$BILLINGPERIOD = urlEncodeVal("Month");}
			  elseif($payment_plan_period == "years"){$BILLINGPERIOD = urlEncodeVal("Year");$payment_plan_frequency=1;}
			  else{$BILLINGPERIOD == $payment_plan_period;}*/
			  $payment_plan_period = ConvertCPRPPeriodToPayPalRPPeriod($payment_plan_period);
			  $BILLINGPERIOD = urlEncodeVal($payment_plan_period);
			  if($payment_plan_period == "years"){$payment_plan_frequency=1;}
			  $BILLINGFREQUENCY = urlEncodeVal($payment_plan_frequency);
			  $AMT = urlEncodeVal($payment_plan_amount);
			  $CURRENCYCODE = urlEncodeVal($currency_code);
			  $COUNTRYCODE = urlEncodeVal($country_code);
			  $MAXFAILEDPAYMENTS = urlEncodeVal(3);
			  $PROFILEREFERENCE = urlEncodeVal($customer_id);
			  //$AUTOBILLOUTAMT = urlEncodeVal("AddToNextBilling");
			  if($_REQUEST['method']=="changeRecurringProfile")
			  {
				  if($customer_payment_due_amount_days>0)
				  {
				  	$INITAMT = urlEncodeVal($customer_payment_due_amount_days);
					$FAILEDINITAMTACTION = urlEncodeVal("ContinueOnFailure");
					$AUTOBILLOUTAMT = urlEncodeVal("AddToNextBilling");
				  }
			  }
			  $params['nvp_string'] = "&TOKEN=$TOKEN&PAYERID=$PAYERID&PROFILESTARTDATE=$PROFILESTARTDATE&DESC=$DESC&BILLINGPERIOD=$BILLINGPERIOD&BILLINGFREQUENCY=$BILLINGFREQUENCY&AMT=$AMT&CURRENCYCODE=$CURRENCYCODE&COUNTRYCODE=$COUNTRYCODE&MAXFAILEDPAYMENTS=$MAXFAILEDPAYMENTS&PROFILEREFERENCE=$PROFILEREFERENCE";
			  //printArray($params);
			  $result = PayPalHTTPPost($params);
			  if(!empty($result['PP_Error']) && $result['PP_Error']==1)
			  {
					$paypal_response['error'] = 1;	
					$paypal_response['message'] = CheckPayPalHTTPPostError($result);
			  }
			  else
			  {
					/*Save Data in Main Customer Table*/
					$payment_payer_id = $PAYERID;
					$payment_profile_id = $result['PP_Response']["PROFILEID"];
					$payment_profile_status = ConvertPayPalRPStatusToCPRPStatus($result['PP_Response']["PROFILESTATUS"]);
					$payment_profile_response = serialize($result);
					/*if($payment_plan_period == "months")
					{
						$payment_due_date = date("Y-m-d", mktime(date("s"),date("i"),date("H"), date("m")+$payment_plan_frequency, date("d"), date("Y")));
					}
					else
					{
						$payment_due_date = date("Y-m-d", mktime(date("s"),date("i"),date("H"), date("m"), date("d"), date("Y")+$payment_plan_frequency));
					}*/
					$payment_start_date = $current_date;
					$payment_paid_date = $current_date;
					$payment_due_date = GetRecurringPaymentDueDate($payment_plan_period,$payment_plan_frequency) ;
					/*$sqlMainClass->updateRow($table_customers," payment_plan='$payment_plan',payment_status=1,payment_gateway='paypal',payment_payer_id='$payment_payer_id',payment_profile_id='$payment_profile_id',payment_profile_status='$payment_profile_status',payment_profile_response='$payment_profile_response',payment_start_date ='$payment_start_date',payment_paid_date ='$payment_paid_date',payment_due_date ='$payment_due_date' "," WHERE customer_id='$customer_id' AND account_name='$account_name' ");*/
					
					/*$sqlClass->usedatabase(CUSTOMERDB);
					$data_payments_history = array();
					$data_payments_history["amount"] = cleanSQL($payment_plan_amount);
					$data_payments_history["date"] = $payment_paid_date;
					$data_payments_history["gateway"] = "paypal";
					$data_payments_history["ip_address"] = get_ip_address();
					$data_payments_history["response"] = $result;
					$data_payments_history = $sqlClass->cleanData($data_payments_history);
					//print_r($data_payments_history);exit;
					$sqlClass->addData($data_payments_history,TBLPREFIX_SETTINGS."payments_history");*/
					//$sqlClass->usedatabase(DB);
					
					//$data['error_message'] = 'Payment was successfully made';
					$paypal_response['error'] = 0;
					$paypal_response['message'] = "Success";
					$paypal_response["profile_id"] = $payment_profile_id;
					$paypal_response["profile_status"] = $payment_profile_status;
			  }
		}
		/*$paypal_response['response'] = $result;
		$paypal_response['method'] = $_REQUEST['method'];
		echo json_encode($paypal_response);*/
	}
	
	/*Get Customer Payment Recurring Profile Details*/
	if(isset($_REQUEST['method']) && $_REQUEST['method']=="getRecurringProfileDetails")
	{
		$params['nvp_method'] = "GetRecurringPaymentsProfileDetails";
		$PROFILEID = urlEncodeVal(cleanSQL($_REQUEST['payment_profile_id']));
		$params['nvp_string'] = "&PROFILEID=$PROFILEID";//printArray($params);
		$result = PayPalHTTPPost($params);//printArray($result);
		if(!empty($result['PP_Error']) && $result['PP_Error']==1)
		{
			  $paypal_response['error'] = 1;	
			  $paypal_response['message'] = CheckPayPalHTTPPostError($result);
		}
		else
		{
			  $paypal_response['error'] = 0;
			  $paypal_response['message'] = "Success";
			  $paypal_response["profile_id"] = $result['PP_Response']["PROFILEID"];
			  $paypal_response["profile_status"] = $result['PP_Response']["STATUS"];
		}
		/*$paypal_response['response'] = $result;
		$paypal_response['method'] = $_REQUEST['method'];
		echo json_encode($paypal_response);*/
	}
	
	/*Update Customer Payment Recurring Profile*/
	if(isset($_REQUEST['method']) && $_REQUEST['method']=="updateRecurringProfile")
	{
		$params['nvp_method'] = "UpdateRecurringPaymentsProfile ";
		$PROFILEID = urlEncodeVal(cleanSQL($_REQUEST['profile_id']));
		$PROFILEREFERENCE = urlEncodeVal(cleanSQL($customer_id));
		/*$OUTSTANDINGBALANCE = urlEncodeVal(cleanSQL($payment_plan_amount));
		$params['nvp_string'] = "&PROFILEID=$PROFILEID&OUTSTANDINGBALANCE=$OUTSTANDINGBALANCE";*/
		//$OUTSTANDINGBALANCE = urlEncodeVal(cleanSQL($payment_plan_amount));
		$params['nvp_string'] = "&PROFILEID=$PROFILEID&PROFILEREFERENCE=$PROFILEREFERENCE";
		//printArray($params);
		$result = PayPalHTTPPost($params);//printArray($result);
		if(!empty($result['PP_Error']) && $result['PP_Error']==1)
		{
			  $paypal_response['error'] = 1;	
			  $paypal_response['message'] = CheckPayPalHTTPPostError($result);
		}
		else
		{
			  /*Save Data in Main Customer Table*/
			  $payment_paid_date = $current_date;
			  $payment_profile_id = $result['PP_Response']["PROFILEID"];
			  /*if($payment_plan_period == "months")
			  {
				  $payment_due_date = date("Y-m-d", mktime(date("s"),date("i"),date("H"), date("m")+$payment_plan_frequency, date("d"), date("Y")));
			  }
			  else
			  {
				  $payment_due_date = date("Y-m-d", mktime(date("s"),date("i"),date("H"), date("m"), date("d"), date("Y")+$payment_plan_frequency));
			  }*/
			  /*$payment_due_date = GetRecurringPaymentDueDate($payment_plan_period,$payment_plan_frequency);
			  $sqlMainClass->updateRow($table_customers," payment_status=1,payment_gateway='paypal',payment_profile_id='$payment_profile_id',payment_paid_date ='$payment_paid_date',payment_due_date ='$payment_due_date' "," WHERE customer_id='$customer_id' AND account_name='$account_name' ");*/
			  
			  /*$sqlClass->usedatabase(CUSTOMERDB);
			  $data_payments_history = array();
			  $data_payments_history["amount"] = cleanSQL($payment_plan_amount);
			  $data_payments_history["date"] = $payment_paid_date;
			  $data_payments_history["gateway"] = "paypal";
			  $data_payments_history["ip_address"] = get_ip_address();
			  $data_payments_history["response"] = $result;
			  $data_payments_history = $sqlClass->cleanData($data_payments_history);
			  //print_r($data_payments_history);exit;
			  $sqlClass->addData($data_payments_history,TBLPREFIX_SETTINGS."payments_history");*/
			  //$sqlClass->usedatabase(DB);	
			
			  //$data['error_message'] = 'Payment was successfully made';
			  $paypal_response['error'] = 0;
			  $paypal_response['message'] = "Success";
			  $paypal_response["profile_id"] = $payment_profile_id;
		}
		/*$paypal_response['response'] = $result;
		$paypal_response['method'] = $_REQUEST['method'];
		echo json_encode($paypal_response);*/
	}
	
	/*Change Customer Payment Recurring Profile Status*/
	if(isset($_REQUEST['method']) && $_REQUEST['method']=="changeRecurringProfileStatus")
	{
		$params['nvp_method'] = "ManageRecurringPaymentsProfileStatus ";
		$PROFILEID = urlEncodeVal(cleanSQL($_REQUEST['profile_id']));
		$ACTION = urlEncodeVal(cleanSQL($_REQUEST['profile_action']));
		/*
		Cancel – Only profiles in Active or Suspended state can be canceled.
    	Suspend – Only profiles in Active state can be suspended.
    	Reactivate – Only profiles in a suspended state can be reactivated.
		*/
		$params['nvp_string'] = "&PROFILEID=$PROFILEID&ACTION=$ACTION";
		//printArray($params);
		$result = PayPalHTTPPost($params);//printArray($result);
		if(!empty($result['PP_Error']) && $result['PP_Error']==1)
		{
			  $paypal_response['error'] = 1;	
			  $paypal_response['message'] = CheckPayPalHTTPPostError($result);
		}
		else
		{
			  /*Save Data in Main Customer Table*/
			  $paypal_response['error'] = 0;
			  $paypal_response["profile_id"] = $result['PP_Response']["PROFILEID"];
		}
		/*$paypal_response['response'] = $result;
		$paypal_response['method'] = $_REQUEST['method'];
		echo json_encode($paypal_response);*/
	}
	
	/*Pay Customer Payment Recurring Profile Due Amount*/
	if(isset($_REQUEST['method']) && $_REQUEST['method']=="payRecurringProfileDueAmount")
	{
		/*$params['nvp_method'] = "BillOutstandingAmount";
		$AMT = urlEncodeVal(cleanSQL($_REQUEST['amount']));
		$PROFILEID = urlEncodeVal(cleanSQL($_REQUEST['profile_id']));
		//$NOTE = urlEncodeVal(cleanSQL($_REQUEST['note']));
		//$params['nvp_string'] = "&PROFILEID=$PROFILEID&AMT=$AMT&NOTE=$NOTE";
		$params['nvp_string'] = "&PROFILEID=$PROFILEID&AMT=$AMT";
		//printArray($params);
		$result = PayPalHTTPPost($params);//printArray($result);
		if(!empty($result['PP_Error']) && $result['PP_Error']==1)
		{
			  $paypal_response['error'] = 1;	
			  $paypal_response['message'] = CheckPayPalHTTPPostError($result);
		}
		else
		{
			  $paypal_response['error'] = 0;
			  $paypal_response["profile_id"] = $result['PP_Response']["PROFILEID"];
		}*/
		if(!empty($customer_payment_profile_id))
		{	
			$params['nvp_method'] = "BillOutstandingAmount";
			$AMT = urlEncodeVal($customer_payment_due_amount);
			$PROFILEID = urlEncodeVal($customer_payment_profile_id);
			//$NOTE = urlEncodeVal(cleanSQL($_REQUEST['note']));
			//$params['nvp_string'] = "&PROFILEID=$PROFILEID&AMT=$AMT&NOTE=$NOTE";
			$params['nvp_string'] = "&PROFILEID=$PROFILEID&AMT=$AMT";
			//printArray($params);
			$result = PayPalHTTPPost($params);//printArray($result);
			if(!empty($result['PP_Error']) && $result['PP_Error']==1)
			{
				  $paypal_response['error'] = 1;	
				  $paypal_response['message'] = CheckPayPalHTTPPostError($result);
			}
			else
			{
				  if($customer_payment_creditcard_profile_status == "Suspend")
				  {
					  $params['nvp_method'] = "ManageRecurringPaymentsProfileStatus ";
					  $ACTION = urlEncodeVal('Reactivate');
					  $PROFILEID = urlEncodeVal($customer_payment_profile_id);
					  /*
					  Cancel – Only profiles in Active or Suspended state can be canceled.
					  Suspend – Only profiles in Active state can be suspended.
					  Reactivate – Only profiles in a suspended state can be reactivated.
					  */
					  $params['nvp_string'] = "&PROFILEID=$PROFILEID&ACTION=$ACTION";
					  //printArray($params);
					  $result = PayPalHTTPPost($params);//printArray($result);
					  if(!empty($result['PP_Error']) && $result['PP_Error']==1)
					  {
							$paypal_response['error'] = 1;	
							$paypal_response['message'] = CheckPayPalHTTPPostError($result);
					  }
				  }
				  
				  $paypal_response['error'] = 0;
				  $paypal_response["profile_id"] = $customer_payment_profile_id;
				  
				  if($customer_payment_plan_period == "days")
				  {
					  $customer_payment_overdue_frequency = daysBetweenDates($current_date, $customer_payment_paid_date);
				  }
				  elseif($customer_payment_plan_period == "months")
				  {
					  $customer_payment_overdue_frequency = monthsBetweenDates($current_date, $customer_payment_paid_date);
				  }
				  elseif($customer_payment_plan_period == "years")
				  {
					  $customer_payment_overdue_frequency = yearsBetweenDates($current_date, $customer_payment_paid_date);
				  }
				  else
				  {
					  $customer_payment_overdue_frequency = daysBetweenDates($current_date, $customer_payment_paid_date);
				  }
				  $payment_paid_date = $current_date;
				  $payment_due_date = GetRecurringPaymentDueDate($customer_payment_plan_period,$customer_payment_overdue_frequency) ;
			}
		}
		else
		{
			$paypal_response['error'] = 1;	
			$paypal_response['message'] = "Payment profile does not exists";
		}
		/*$paypal_response['response'] = $result;
		$paypal_response['method'] = $_REQUEST['method'];
		echo json_encode($paypal_response);*/
	}
	 
	/*Notify Customer Payment Recurring Profile Activity*/
	/*if(isset($_REQUEST['method']) && $_REQUEST['method']=="notifyRecurringProfile")
	{
		require ROOT.'lib/PaymentsAPI/paypal_php_sdk/ipn-code-samples/php/PaypalIPN.php';
		$ipn = new PaypalIPN();
		// Use the sandbox endpoint during testing.
		if ($settingsData['paypal_environment'] != 'live')
		{
			$ipn->useSandbox();
		}
		mail("waseeansari@gmail.com","Test Paypal Notification Subject","Test Paypal Notification Message");
		$verified = $ipn->verifyIPN();
		if ($verified) {
			 mail("waseeansari@gmail.com","Test Paypal Notification Subject","Test Paypal Notification Message");
		}
		
		// Reply with an empty 200 response to indicate to paypal the IPN was received correctly.
		header("HTTP/1.1 200 OK");
		exit();
	}*/
	
	/*Save Customer Payment Recurring Profile*/
	if(isset($_REQUEST['method']) && ($_REQUEST['method']=="createRecurringProfile" || $_REQUEST['method']=="changeRecurringProfile" || $_REQUEST['method']=="upgradeRecurringProfile" || $_REQUEST['method']=="payRecurringProfileDueAmount"))
	{
		$payment_profile_uts = TimeStamp();
		if($paypal_response['error'] == 0)
		{
			if($_REQUEST['method']=="payRecurringProfileDueAmount")
			{
				$sqlMainClass->updateRow($table_customers,"payment_status=1,payment_profile_uts='$payment_profile_uts',payment_profile_status='active',payment_paid_date ='$payment_paid_date',payment_due_date ='$payment_due_date',payment_due_amount =0,is_paid =1 "," WHERE customer_id='$customer_id' AND account_name='$account_name' ");
			}
			
			if($_REQUEST['method']=="createRecurringProfile" || $_REQUEST['method']=="changeRecurringProfile" || $_REQUEST['method']=="upgradeRecurringProfile")
			{
				$sqlMainClass->updateRow($table_customers," payment_plan='$payment_plan',payment_status=1,payment_gateway='$payment_gateway',payment_payer_id='$payment_payer_id',payment_profile_id='$payment_profile_id',payment_profile_uts='$payment_profile_uts',payment_profile_status='$payment_profile_status',payment_profile_response='$payment_profile_response',payment_start_date ='$payment_start_date',payment_paid_date ='$payment_paid_date',payment_due_date ='$payment_due_date',payment_creditcard_digits ='',payment_creditcard_expiry ='' "," WHERE customer_id='$customer_id' AND account_name='$account_name' ");
	
				$package_data = $sqlClass->getRow("invoice_per_month,domain_based_email_accounts,email_storage_quota",TBLPREFIX."packages", "  WHERE pkg_id = ".$payment_plan." ");

				$customer = $SESSION_CUSTOMER;
				$customer['package_data'] = $package_data;
				$customer['payment_plan'] = $payment_plan;
				$customer['payment_gateway'] = $payment_gateway;
				$_SESSION["customer"] = $customer;
				setSession("customer",$customer);
			}
		}
	}
	
	$paypal_response['response'] = $result;
	$paypal_response['method'] = $_REQUEST['method'];
	echo json_encode($paypal_response);
	exit();
}

/*Methods for Credit Card for Customer Payment Plan*/
if(isset($_REQUEST['action']) && $_REQUEST['action']=="payWithCreditCard")
{
	$METHOD_TO_USE = "ARB";
	
	/*Get and Validate Credit Card POST Data*/
	if(isset($_REQUEST['method']) && $_REQUEST['method']=="createRecurringProfile"
	|| isset($_REQUEST['method']) && $_REQUEST['method']=="changeRecurringProfile"
	|| isset($_REQUEST['method']) && $_REQUEST['method']=="updateRecurringProfile"
	|| isset($_REQUEST['method']) && $_REQUEST['method']=="upgradeRecurringProfile"
	|| isset($_REQUEST['method']) && $_REQUEST['method']=="payRecurringProfileDueAmount"
	)
	{
		$creditcard_firstname = cleanSQL($_REQUEST['customer_payment_plans_creditcard_firstname']);
		if(empty($creditcard_firstname))
		{
			$creditcard_response['error'] = 1;
			$creditcard_response['message'] = "Card First Name is required.";
			echo json_encode($creditcard_response);
			exit();
		}
		
		$creditcard_lastname = cleanSQL($_REQUEST['customer_payment_plans_creditcard_lastname']);
		if(empty($creditcard_lastname))
		{
			$creditcard_response['error'] = 1;
			$creditcard_response['message'] = "Card Last Name is required.";
			echo json_encode($creditcard_response);
			exit();
		}
		
		$creditcard_number = cleanSQL($_REQUEST['customer_payment_plans_creditcard_number']);
		if(empty($creditcard_number))
		{
			$creditcard_response['error'] = 1;
			$creditcard_response['message'] = "Card Number is required.";
			echo json_encode($creditcard_response);
			exit();
		}
		
		$creditcard_expiry_month = cleanSQL($_REQUEST['customer_payment_plans_creditcard_expiry_month']);
		if(empty($creditcard_expiry_month))
		{
			$creditcard_response['error'] = 1;
			$creditcard_response['message'] = "Card Expiry Month is required.";
			echo json_encode($creditcard_response);
			exit();
		}
		
		$creditcard_expiry_year = cleanSQL($_REQUEST['customer_payment_plans_creditcard_expiry_year']);
		if(empty($creditcard_expiry_year))
		{
			$creditcard_response['error'] = 1;
			$creditcard_response['message'] = "Card Expiry Year is required.";
			echo json_encode($creditcard_response);
			exit();
		}
		
		$creditcard_cvv = cleanSQL($_REQUEST['customer_payment_plans_creditcard_cvv']);
		if(empty($creditcard_cvv))
		{
			$creditcard_response['error'] = 1;
			$creditcard_response['message'] = "Card CVV code is required.";
			echo json_encode($creditcard_response);
			exit();
		}
	}
	/*Create and Change Customer Payment Recurring Profile*/
	if(isset($_REQUEST['method']) && $_REQUEST['method']=="createRecurringProfile"
	|| isset($_REQUEST['method']) && $_REQUEST['method']=="changeRecurringProfile"
	|| isset($_REQUEST['method']) && $_REQUEST['method']=="upgradeRecurringProfile"
	) 
	{
		/*$METHOD_TO_USE = "ARB";
		echo "<br>AUTHORIZENET_SANDBOX = ".$x_environment = AUTHORIZENET_SANDBOX;
		echo "<br>AUTHORIZENET_API_LOGIN_ID = ".$x_Login = AUTHORIZENET_API_LOGIN_ID;     
		echo "<br>AUTHORIZENET_TRANSACTION_KEY = ".$x_Password = AUTHORIZENET_TRANSACTION_KEY;*/

		//require ROOT.'lib/functions_payments.php';

		$stripe_publishable_key = ($settingsData['stripe_environment_is_live'] == 1 ? $settingsData['stripe_live_publishable_key'] : $settingsData['stripe_test_publishable_key']);
		$stripe_secret_key = ($settingsData['stripe_environment_is_live'] == 1 ? $settingsData['stripe_live_secret_key'] : $settingsData['stripe_test_secret_key']);
		$stripe_product_id = ($settingsData['stripe_environment_is_live'] == 1 ? $settingsData['stripe_live_product_id'] : $settingsData['stripe_test_product_id']);

		//new code for stripe start here
		$payment_profile_id = subscribeWithStripe($stripe_publishable_key,$stripe_secret_key,$stripe_product_id,$_REQUEST['stripeToken'],$_REQUEST['customer_payment_plans_creditcard_firstname']." ".$_REQUEST['customer_payment_plans_creditcard_lastname'],$getMainCustomerUser['email_address'],$payment_plan_amount);

		if(strpos($payment_profile_id, 'ErrorMessage')!== false)
		{
			$errorMessage = str_replace("ErrorMessage: ", "", $payment_profile_id);
		
			$creditcard_response['error'] = 1;
			$creditcard_response['message'] = $errorMessage;
		}
		else
		{
			$payment_start_date = $current_date;
			$payment_paid_date = $current_date;
			$payment_due_date = GetRecurringPaymentDueDate($payment_plan_period,$payment_plan_frequency) ;
			
			$creditcard_response['error'] = 0;
			$creditcard_response['message'] = "Success";
			$creditcard_response["profile_id"] = $payment_profile_id;
			$creditcard_response["profile_status"] = "active";			
		}
		// code for stripe end here

		// echo 1;
		// echo $payment_plan_amount."<br>";
		// echo $payment_profile_id;
		// exit;
		
		// Set the subscription fields.
		$subscription = new AuthorizeNet_Subscription;
		$subscription->name = $payment_profile_subscription_name;
		$subscription->startDate = $current_date;
		if($payment_plan_period == "years"){$payment_plan_period = "months";$payment_plan_frequency=12;}
		$subscription->intervalUnit = $payment_plan_period;
		$subscription->intervalLength = $payment_plan_frequency;
		$subscription->totalOccurrences = ($payment_plan_total_cycles == 0)?"9999":$payment_plan_total_cycles;
		$subscription->amount = $payment_plan_amount;
		$subscription->creditCardCardNumber = $creditcard_number;
		$subscription->creditCardExpirationDate = $creditcard_expiry_year."-".$creditcard_expiry_month;
		$subscription->creditCardCardCode = $creditcard_cvv;
		$subscription->customerEmail =  $email_address;
		$subscription->billToFirstName = $creditcard_firstname;
		$subscription->billToLastName = $creditcard_lastname;
		//printArray($subscription);
		$refId = "ref" . time();
		
		// below code commented for stripe
		// Create the subscription.
		// $request = new AuthorizeNetARB;
		// $request->setRefId($refId);
		// $request->setSandbox(AUTHORIZENET_SANDBOX);
		// $response = $request->createSubscription($subscription);
		// //printArray($response);
		// //printArray($response->xml);
		// if ($response->xml->messages->resultCode == "Ok") {
		// 	// Get Subscription Id
		// 	// $this->assertTrue($response->isOk());
		// 	$payment_profile_id = $response->getSubscriptionId();
			
		// 	if(!empty($payment_profile_id))
		// 	{
		// 		$request = new AuthorizeNetARB;
		// 		$request->setSandbox(AUTHORIZENET_SANDBOX);
		// 		$payment_profile_status_response = $request->getSubscriptionStatus($payment_profile_id);//printArray($payment_profile_status_response);
		// 		if ($payment_profile_status_response->xml->messages->resultCode == "Ok") {
		// 			/*$payment_profile_status = json_decode(json_encode($payment_profile_status_response->xml->status),TRUE);
		// 			$payment_profile_status = $payment_profile_status[0];*/
		// 			$payment_profile_status = $payment_profile_status_response->getSubscriptionStatus();
		// 		} 
				
		// 		/*Pay Customer Payment Due Amount*/
		// 		if($_REQUEST['method']=="changeRecurringProfile" || $_REQUEST['method']=="upgradeRecurringProfile")
		// 		{
		// 			if($customer_payment_due_amount_days>0)
		// 			{
		// 			  $METHOD_TO_USE = "AIM";
		// 			  $pay_customer_payment_due_amount = new AuthorizeNetAIM;
		// 			  $pay_customer_payment_due_amount->setFields(
		// 				  array(
		// 				 'amount' => $customer_payment_due_amount_days,
		// 				 'card_num' => $creditcard_number,
		// 				 'exp_date' => $creditcard_expiry_month."".date("y",strtotime("01-01-".$creditcard_expiry_year)),
		// 				 'card_code' => $creditcard_cvv
		// 				 )
		// 			  );
		// 			  $pay_customer_payment_due_amount_response = $pay_customer_payment_due_amount->authorizeAndCapture();
		// 			  //printArray($pay_customer_payment_due_amount_response);
		// 			  $customer_payment_due_amount = $customer_payment_due_amount_days;
		// 			}
		// 		}
		// 	}
		// 	$payment_profile_response = json_decode(json_encode($response->xml),TRUE);
			
		// 	$payment_start_date = $current_date;
		// 	$payment_paid_date = $current_date;
		// 	$payment_due_date = GetRecurringPaymentDueDate($payment_plan_period,$payment_plan_frequency) ;
			
		// 	$creditcard_response['error'] = 0;
		// 	$creditcard_response['message'] = "Success";
		// 	$creditcard_response["profile_id"] = $payment_profile_id;
		// 	$creditcard_response["profile_status"] = $payment_profile_status;
		// } else {
		// 	$creditcard_response['error'] = 1;
		// 	$creditcard_response['message'] = "".$response->xml->messages->message->text;
		// }
		// $response = $response->xml;
		//printArray($creditcard_profile_response);
		/*$creditcard_response['response'] = $payment_profile_response;
		$creditcard_response['method'] = $_REQUEST['method'];
		echo json_encode($creditcard_response);*/
	}
	
	/*Get Customer Payment Recurring Profile Details*/
	if(isset($_REQUEST['method']) && $_REQUEST['method']=="getRecurringProfileDetails")
	{
		$payment_profile_id = cleanSQL($_REQUEST['payment_profile_id']);
		if(!empty($payment_profile_id))
		{
			// Get the subscription status.
			$request = new AuthorizeNetARB;
			$request->setSandbox(AUTHORIZENET_SANDBOX);
			$response = $request->getSubscription($payment_profile_id);
			//printArray($response->xml);
			if ($response->xml->messages->resultCode == "Ok") {
				$creditcard_response['error'] = 0;
				$creditcard_response['message'] = "Success";
				$creditcard_response["profile_id"] = $payment_profile_id;
			}else {
				$creditcard_response['error'] = 1;
				$creditcard_response['message'] = "".$response->xml->messages->message->text;
			}
			$response = $response->xml; 
			/*$response = json_decode(json_encode($response->xml),TRUE);
			$creditcard_response['response'] = $response;
			$creditcard_response['method'] = $_REQUEST['method'];
			echo json_encode($creditcard_response);*/
		}
	}
	
	/*Update Customer Payment Recurring Profile*/
	if(isset($_REQUEST['method']) && $_REQUEST['method']=="updateRecurringProfile")
	{
		if(!empty($customer_payment_profile_id))
		{
			$subscription = new AuthorizeNet_Subscription;
			//$subscription->name = "Update subscription";
			//$subscription->intervalLength = "1";    // cnnot be update 
			//$subscription->intervalUnit = "months"; // cnnot be update
			//$subscription->startDate = "2018-09-01";
			//$subscription->totalOccurrences = "8";
			//$subscription->amount = rand(1,200);
			$subscription->creditCardCardNumber = $creditcard_number;
			$subscription->creditCardExpirationDate = $creditcard_expiry_year."-".$creditcard_expiry_month;
			$subscription->creditCardCardCode = $creditcard_cvv;
			$subscription->billToFirstName = $creditcard_firstname;
			$subscription->billToLastName = $creditcard_lastname;
			$refId = "ref" . time();
			// Update the subscription.
			$request = new AuthorizeNetARB;
			$request->setRefId($refId);
			$request->setSandbox(AUTHORIZENET_SANDBOX);
			$response = $request->updateSubscription($customer_payment_profile_id,$subscription);
			//printArray($response->xml);
			if ($response->xml->messages->resultCode == "Ok") {
				$creditcard_response['error'] = 0;
				$creditcard_response['message'] = "Success";
				$creditcard_response["profile_id"] = $customer_payment_profile_id;
			}else {
				$creditcard_response['error'] = 1;
				$creditcard_response['message'] = "".$response->xml->messages->message->text;
			} 
			$response = $response->xml;
			/*$response = json_decode(json_encode($response->xml),TRUE);
			$creditcard_response['response'] = $response;
			$creditcard_response['method'] = $_REQUEST['method'];
			echo json_encode($creditcard_response);*/
		}
		else
		{
			$creditcard_response['error'] = 1;
			$creditcard_response['message'] = "Payment profile does not exists";
		}
	}
	
	/*Get Customer Payment Recurring Profile Details*/
	if(isset($_REQUEST['method']) && $_REQUEST['method']=="getRecurringProfileStatus")
	{
		$payment_profile_id = cleanSQL($_REQUEST['payment_profile_id']);
		if(!empty($payment_profile_id))
		{
			// Get the subscription status.
			$request = new AuthorizeNetARB;
			$request->setSandbox(AUTHORIZENET_SANDBOX);
			$response = $request->getSubscriptionStatus($payment_profile_id);
			//printArray($response->xml);
			if ($response->xml->messages->resultCode == "Ok") {
				/*$payment_profile_status = json_decode(json_encode($response->xml->status),TRUE);
				$payment_profile_status = $payment_profile_status[0];*/
				$payment_profile_status = $response->getSubscriptionStatus();
				$creditcard_response['error'] = 0;
				$creditcard_response['message'] = "Success";
				$creditcard_response["profile_id"] = $payment_profile_id;
				$creditcard_response["profile_status"] = $payment_profile_status;
			}else {
				$creditcard_response['error'] = 1;
				$creditcard_response['message'] = "".$response->xml->messages->message->text;
			} 
			$response = $response->xml;
			/*$response = json_decode(json_encode($response->xml),TRUE);
			$creditcard_response['response'] = $response;
			$creditcard_response['method'] = $_REQUEST['method'];
			echo json_encode($creditcard_response);*/
		}
	}
	
	/*Cancel Customer Payment Recurring Profile*/
	if(isset($_REQUEST['method']) && $_REQUEST['method']=="cancelRecurringProfile")
	{
		$payment_profile_id = cleanSQL($_REQUEST['payment_profile_id']);
		// Cancel the subscription.
		$request = new AuthorizeNetARB;
		$request->setSandbox(AUTHORIZENET_SANDBOX);
		$response = $request->cancelSubscription($subscriptionId);
		//printArray($response->xml);
		if ($response->xml->messages->resultCode == "Ok") {
			$creditcard_response['error'] = 0;
			$creditcard_response['message'] = "Success";
			$creditcard_response["profile_id"] = $payment_profile_id;
		}else {
			$creditcard_response['error'] = 1;
			$creditcard_response['message'] = "".$response->xml->messages->message->text;
		} 
		$response = $response->xml;
		/*$response = json_decode(json_encode($response->xml),TRUE);
		$creditcard_response['response'] = $response;
		$creditcard_response['method'] = $_REQUEST['method'];
		echo json_encode($creditcard_response);*/
	}
	
	/*Pay Customer Recurring Profile Due Amount*/
	if(isset($_REQUEST['method']) && $_REQUEST['method']=="payRecurringProfileDueAmount")
	{
		if($customer_payment_due_amount > 0)
		{
			$METHOD_TO_USE = "AIM";
			$request = new AuthorizeNetAIM;
			$request->setFields(
				array(
			   'amount' => $customer_payment_due_amount,
			   'card_num' => $creditcard_number,
			   'exp_date' => $creditcard_expiry_month."".date("y",strtotime("01-01-".$creditcard_expiry_year)),
			   'card_code' => $creditcard_cvv,
			   'first_name' => $creditcard_firstname,
			   'last_name' => $creditcard_lastname
			   )
			);
			$response = $request->authorizeAndCapture();
			//printArray($response);
			if ($response->approved) {
				$creditcard_response['error'] = 0;
				$creditcard_response['message'] = "Success";
				
				if($customer_payment_plan_period == "days")
				{
					$customer_payment_overdue_frequency = daysBetweenDates($current_date, $customer_payment_paid_date);
				}
				elseif($customer_payment_plan_period == "months")
				{
					$customer_payment_overdue_frequency = monthsBetweenDates($current_date, $customer_payment_paid_date);
				}
				elseif($customer_payment_plan_period == "years")
				{
					$customer_payment_overdue_frequency = yearsBetweenDates($current_date, $customer_payment_paid_date);
				}
				else
				{
					$customer_payment_overdue_frequency = daysBetweenDates($current_date, $customer_payment_paid_date);
				}
				$payment_paid_date = $current_date;
				$payment_due_date = GetRecurringPaymentDueDate($customer_payment_plan_period,$customer_payment_overdue_frequency) ;
				$pay_customer_payment_due_amount_response = $response;
			}
			else
			{
				$creditcard_response['error'] = 1;
				$creditcard_response['message'] = "".$response->response_reason_text;
			}
		}
		else
		{
			$creditcard_response['error'] = 1;
			$creditcard_response['message'] = "Pricing plan due amount must be greater than zero";
		}
		/*$response = json_decode(json_encode($response),TRUE);
		$creditcard_response['response'] = $response;
		$creditcard_response['method'] = $_REQUEST['method'];
		echo json_encode($creditcard_response);*/
	}
	
	/*Save Customer Payment Recurring Profile*/
	if(isset($_REQUEST['method']) && ($_REQUEST['method']=="createRecurringProfile" || $_REQUEST['method']=="changeRecurringProfile" || $_REQUEST['method']=="upgradeRecurringProfile" || $_REQUEST['method']=="payRecurringProfileDueAmount" || $_REQUEST['method']=="updateRecurringProfile"))
	{
		$payment_profile_uts = TimeStamp();
		if($creditcard_response['error'] == 0)
		{
			if($_REQUEST['method']=="updateRecurringProfile")
			{
				$payment_creditcard_digits = substr($creditcard_number, -4);
				$creditcard_expiry_day = getNumberDaysOfMonth($creditcard_expiry_month,$creditcard_expiry_year);
				$payment_creditcard_expiry = $creditcard_expiry_year."-".$creditcard_expiry_month."-".$creditcard_expiry_day;
				$sqlMainClass->updateRow($table_customers,"payment_profile_uts ='$payment_profile_uts',payment_creditcard_digits ='$payment_creditcard_digits',payment_creditcard_expiry ='$payment_creditcard_expiry',payment_creditcard_expiry_status = 0,is_suspended = 0,sts ='0000-00-00 00:00:00',dts ='0000-00-00 00:00:00' "," WHERE customer_id='$customer_id' AND account_name='$account_name' ");
			}
			
			if($_REQUEST['method']=="payRecurringProfileDueAmount")
			{
				$sqlMainClass->updateRow($table_customers,"payment_status=1,payment_profile_uts ='$payment_profile_uts',payment_profile_status='active',payment_paid_date ='$payment_paid_date',payment_due_date ='$payment_due_date',payment_due_amount =0,is_paid =1 "," WHERE customer_id='$customer_id' AND account_name='$account_name' ");
			}
			
			if($_REQUEST['method']=="createRecurringProfile" || $_REQUEST['method']=="changeRecurringProfile" || $_REQUEST['method']=="upgradeRecurringProfile")
			{
				$payment_profile_response = serialize($payment_profile_response);
				$payment_creditcard_digits = substr($creditcard_number, -4);
				$creditcard_expiry_day = getNumberDaysOfMonth($creditcard_expiry_month,$creditcard_expiry_year);
				$payment_creditcard_expiry = $creditcard_expiry_year."-".$creditcard_expiry_month."-".$creditcard_expiry_day;
				$sqlMainClass->updateRow($table_customers," payment_plan='$payment_plan',payment_status=1,payment_gateway='$payment_gateway',payment_payer_id='',payment_profile_id='$payment_profile_id',payment_profile_uts ='$payment_profile_uts',payment_profile_status='$payment_profile_status',payment_profile_response='$payment_profile_response',payment_start_date ='$payment_start_date',payment_paid_date ='$payment_paid_date',payment_due_date ='$payment_due_date',payment_creditcard_digits ='$payment_creditcard_digits',payment_creditcard_expiry ='$payment_creditcard_expiry' "," WHERE customer_id='$customer_id' AND account_name='$account_name' ");

				$package_data = $sqlClass->getRow("invoice_per_month,domain_based_email_accounts,email_storage_quota",TBLPREFIX."packages", "  WHERE pkg_id = ".$payment_plan." ");

				$customer = $SESSION_CUSTOMER;
				$customer['package_data'] = $package_data;
				$customer['payment_plan'] = $payment_plan;
				$customer['payment_gateway'] = $payment_gateway;
				$_SESSION["customer"] = $customer;
				setSession("customer",$customer);
			}
			
			if(($_REQUEST['method']=="changeRecurringProfile" || $_REQUEST['method']=="upgradeRecurringProfile" || $_REQUEST['method']=="payRecurringProfileDueAmount") && !empty($pay_customer_payment_due_amount_response))
			{
				if ($pay_customer_payment_due_amount_response->approved) {
					$transaction_id = $pay_customer_payment_due_amount_response->transaction_id;
					if(!empty($transaction_id))
					{
						/*Save Data into Payment History Table */
						$data_payments_history = array();
						$data_payments_history["transaction_id"] = $transaction_id;
						$data_payments_history["transaction_type"] = "recurring_payment";
						$data_payments_history["profile_id"] = $payment_profile_id;
						$data_payments_history["amount"] = $customer_payment_due_amount;
						$data_payments_history["date"] = $current_date;
						$data_payments_history["status"] = "Completed";
						$data_payments_history["is_paid"] = 1;
						$data_payments_history["gateway"] = $payment_gateway;
						$data_payments_history["ip_address"] = get_ip_address();
						$response = json_decode(json_encode($pay_customer_payment_due_amount_response),TRUE);
						$data_payments_history["response"] = serialize($response);
						$data_payments_history["summary"] = "Pricing plan due payment has been paid";
						$data_payments_history = $sqlClass->cleanData($data_payments_history);
						//print_r($data_payments_history);exit;
						$sqlClass->usedatabase(CUSTOMERDB);
						$sqlClass->addData($data_payments_history,$table_payments_history);
						$sqlClass->usedatabase(DB);
					}		  
				}
				else
				{
					//$creditcard_response['error'] = 1;
					//$creditcard_response['message'] = "".$pay_customer_payment_due_amount_response->response_reason_text;
					$payment_due_amount = $customer_payment_due_amount_days;
					$sqlMainClass->updateRow($table_customers," payment_status = 2,payment_profile_uts ='$payment_profile_uts',payment_due_amount ='$payment_due_amount' "," WHERE customer_id='$customer_id' AND account_name='$account_name' ");
				}
			}
		}
	}
	
	$response = json_decode(json_encode($response),TRUE);
	$creditcard_response['response'] = $response;
	$creditcard_response['method'] = $_REQUEST['method'];
	echo json_encode($creditcard_response);
	exit();
}

/*Method to Check Customer Payments*/
if(isset($_REQUEST['action']) && $_REQUEST['action']=="checkCustomerPayments")
{
	if(!empty($SESSION_CUSTOMER))
	{
		//printArray($customer_data);
		/*$current_date = cleanSQL(currentDate());
		$account_name = cleanSQL($customer_data['account_name']);
		$account_is_payable = cleanSQL($customer_data['is_payable']);
		$account_create_date = date_create($customer_data['ts']);
		$account_create_date = date_format($account_create_date,"Y-m-d");
		$payment_plan = cleanSQL($customer_data['payment_plan']);
		$payment_status = cleanSQL($customer_data['payment_status']);
		$payment_start_date = cleanSQL($customer_data['payment_start_date']);
		$payment_paid_date = cleanSQL($customer_data['payment_paid_date']);
		$payment_due_date = cleanSQL($customer_data['payment_due_date']);
		
		$customer_data['check_customer_session'] = 1;
		if($account_is_payable == 1)
		{
			if($payment_status == 0)
			{
				//if(daysBetweenDates($current_date, $account_create_date) > 30)
				if(daysBetweenDates($current_date, $account_create_date) >= 35)
				{
					$customer_data['check_customer_payment'] = 0;
				}
				else
				{
					$customer_data['check_customer_payment'] = 1;
				}
				$customer_data['check_customer_payment_plan'] = 0;
				$customer_data['check_customer_payment_status'] = 0;
				$customer_data['check_customer_payment_overdue_days'] = daysBetweenDates($current_date, $account_create_date);
			}
			else 
			{
				//printArray($customers_packagesArray[$payment_plan]);
				if(daysBetweenDates($current_date, $payment_paid_date) > daysBetweenDates($payment_due_date, $payment_paid_date))
				{
					$customer_data['check_customer_payment'] = 0;
				}
				else
				{
					$customer_data['check_customer_payment'] = 1;
				}
				$customer_data['check_customer_payment_plan'] = $payment_plan;
				$customer_data['check_customer_payment_status'] = 1;
				$customer_data['check_customer_payment_overdue_days'] = daysBetweenDates($current_date, $payment_paid_date);
			}
		}
		else
		{
			$customer_data['check_customer_session'] = 1;
			$customer_data['check_customer_payment'] = 1;
			$customer_data['check_customer_payment_status'] = 1;
		}*/
		
		$customer_data['check_customer_session'] = 1;
		$customer_payment_status = checkCustomerPaymentStatus($customer_data);
		$customer_data['check_customer_payment'] = $customer_payment_status['check_customer_payment'];
		$customer_data['check_customer_payment_plan'] = $customer_payment_status['check_customer_payment_plan'];
		$customer_data['check_customer_payment_status'] = $customer_payment_status['check_customer_payment_status'];
		$customer_data['check_customer_payment_overdue_days'] = $customer_payment_status['check_customer_payment_overdue_days'];
		$customer_data['check_customer_payment_trial_duration'] = $customer_payment_status['check_customer_payment_trial_duration'];
		$customer_data['check_customer_payment_free_trial_warning_days'] = $customer_payment_status['check_customer_payment_free_trial_warning_days'];
	}
	else
	{
		$customer_data['check_customer_session'] = 0;
		$customer_data['check_customer_payment'] = 0;
		$customer_data['check_customer_payment_plan'] = 0;
		$customer_data['check_customer_payment_status'] = 0;
		$customer_data['check_customer_payment_overdue_days'] = 0;
		$customer_data['check_customer_payment_trial_duration'] = 0;
		$customer_data['check_customer_payment_free_trial_warning_days'] = 0;
	}
	echo json_encode($customer_data);
}
?>