<?php
include(CLASSES."Report.class.php");
class  EcommerceReports extends Report{
	
private $conn;
public $tableprefix;
	
public function  __construct()
		{
		 $this->conn = $this->connect(DBHOST, DBUSER, DBPASSWORD);
		 $this->usedatabase(CUSTOMERDB);
		 $this->create_sales_items_temp_table(); 
		}

public function getSale($where="",$orderby="",$limit="")
	{
		$fields =  " * ";
		$sales =  $this->getRows($fields,"opos_sales",  "  ".$where." ".$orderby." ".$limit);	
		return $sales;
	}
public function getSummaryData_bk($where="",$orderby="",$limit="")
{
	    $fields='date(sale_time)sale_date,sum(totalSV) as totalSV,sum(totalCP) as totalCP,sum(profit) as profit';
		$sales =  $this->getRows($fields,"opos_sales",  "  ".$where." ".$orderby." ".$limit);
		/*$this->db->from('sales_items_temp');
		$this->db->group_by('sale_date');
		$this->db->having('sale_date BETWEEN "'. $inputs['start_date']. '" and "'. $inputs['end_date'].'"');
		$this->db->order_by('sale_date');*/
		return $sales;
	
}
public function getSummaryData($where="",$orderby="",$limit="")
{
	   
		$tble_tempSale = TBLPREFIX_OPOS."sales_items_temp";
		$exists = $this->dbqueryexe("SELECT table_name FROM INFORMATION_SCHEMA.TABLES WHERE table_schema = '".CUSTOMERDB."' and table_name='$tble_tempSale'");
		if(!empty($exists))
		{
		   //DO SOMETHING! IT EXISTS!
		   $fields='sale_date, sum(subtotal) as subtotal, sum(total) as total, sum(tax) as tax,sum(profit) as profit';
		   $sales =  $this->getRows($fields,$tble_tempSale,$where." ".$orderby." ".$limit);
		}
		else
		{
			//I can't find it...
			$sales =  "";
		}
		return $sales;
	
}

public function getCurrentSummaryData($where="",$orderby="",$limit="")
{
	    $tble_tempSale = TBLPREFIX_OPOS."sales_items_temp";
		$exists = $this->dbqueryexe("SELECT table_name FROM INFORMATION_SCHEMA.TABLES WHERE table_schema = '".CUSTOMERDB."' and table_name='$tble_tempSale'");
		if(!empty($exists))
		{
		$fields='sale_date, sum(subtotal) as subtotal, sum(total) as total, sum(tax) as tax,sum(profit) as profit';
		$sales =  $this->getRow($fields,$tble_tempSale,$where." ".$orderby." ".$limit);
		}
		else
		{
			//I can't find it...
			$sales =  "";
		}
		return $sales;
	
}

public function getDetailData_bk($where="",$orderby="",$limit="")
{
	    $fields='date(sale_time)sale_date,totalSV,totalCP,profit';
		$sales =  $this->getRows($fields,"opos_sales",  "  ".$where." ".$orderby." ".$limit);
		return $sales;
	
}
public function getDetailData($where="",$orderby="",$limit="")
{       
       $tblemployee = TBLPREFIX_OPOS."people";
	   $tblcustomer = TBLPREFIX_OPOS."people";
	   $tble_tempSale = TBLPREFIX_OPOS."sales_items_temp";
	   $items = TBLPREFIX_OPOS."items";	
	   $exists = $this->dbqueryexe("SELECT table_name FROM INFORMATION_SCHEMA.TABLES WHERE table_schema = '".CUSTOMERDB."' and table_name='$tble_tempSale'");
		 if(!empty($exists))
		 {
		   $fields='sale_id, sale_date, sum(quantity_purchased) as items_purchased,
					 CONCAT(employee.first_name," ",employee.last_name) as employee_name,
					 CONCAT(customer.first_name," ",customer.last_name) as customer_name,
					 sum(subtotal) as subtotal, sum(total) as total, sum(tax) as tax,
					 sum(profit) as profit, payment_type, comment';
			$join_salecustomers = " left JOIN $tblcustomer as customer ON $tble_tempSale.customer_id = customer.person_id  ";
			$join_saleemployees = " left JOIN $tblemployee as employee ON $tble_tempSale.employee_id = employee.person_id  ";
			$sales =  $this->getRows($fields,$tble_tempSale," ".$join_salecustomers." ".$join_saleemployees." " .$where." GROUP BY sale_id ".$orderby." ".$limit);
			$data = array();
			$data['summary'] = $sales;
			$data['details'] = array();
			
			foreach($data['summary'] as $key=>$value)
			{
				$detail_feilds = "name, category,item_cost_price,item_unit_price,discount_amount,quantity_purchased, serialnumber, $tble_tempSale.description, subtotal,total, tax, profit, discount_percent";
				$join_items = "JOIN  $items ON $tble_tempSale.item_id  = $items.item_id  ";
				$data['details'][$value['sale_id']] =  $this->getRows($detail_feilds,$tble_tempSale," ".$join_items." " ."WHERE $tble_tempSale.sale_id = ".$value['sale_id']." ".$orderby." ".$limit);
			
			}
		  }
		 else
		 {
			//I can't find it...
			$data =  "";
		 }
		/*$sales =  $this->getRows($fields,$tble_tempSale,$join_salecustomers." ".$where." ".$orderby." ".$limit);*/		
		return $data;
	
}
	
public function getTotalSale($where="",$orderby="",$limit="")
	{
		$tbl_opos_sales="opos_sales";
		
		$fields =  "sum(totalCP) as total_costprice,
		            sum(totalSV) as total_sale,
					sum(profit) as total_profit";
		
		
		$sales =  $this->getRows($fields,$tbl_opos_sales,  "  ".$where." ".$orderby." ".$limit);	
		return $sales;	
	}

public function getTotalSaleTax($where="",$orderby="",$limit="")
	{
		
		$tbl_opos_salesTax="opos_sales_items_taxes";
		$fields =  "sum(percent) as tax";
		
		
		$salestax =  $this->getRows($fields,$tbl_opos_salesTax,  "  ".$where." ".$orderby." ".$limit);	
		return $salestax;	
	}
public function getSaleCustomer($where="",$orderby="")
	{
		
		$tbl_sales = "opos_sales";
	    $tbl_ecomerce_user = "ecommerce_billing";
	    $fields = "count($tbl_sales.sale_id) as sale,
		           $tbl_sales.customer_id,
			       sum($tbl_sales.totalSV) as totalsale,
			       sum($tbl_sales.profit) as totalprofit,
				   $tbl_ecomerce_user.id,
				   $tbl_ecomerce_user.billing_first_name,
				   $tbl_ecomerce_user.billing_last_name,
				   $tbl_ecomerce_user.user_type
			   
			   ";
		   
	$join_salecustomers = " left JOIN $tbl_ecomerce_user ON $tbl_ecomerce_user.id = $tbl_sales.customer_id  ";
	//return "SELECT ".$fields." FROM ".$tbl_customers_applications. " ".$join_applications." ".$condition." ".$limits;	   
	$selling_customers = $this->getRows($fields,$tbl_sales, " ".$join_salecustomers." ".$condition." ".$orderby."GROUP By $tbl_sales.customer_id DESC LIMIT 0 , 5");
	
		return $selling_customers;	
	}
	
public function getSaleItem($where="",$orderby="")
	{
		
		$tbl_opos_items = "opos_items";
	    $tbl_opos_sales_items = "opos_sales_items";
	    $fields = "$tbl_opos_items.name,
				   $tbl_opos_sales_items.item_id,
				   $tbl_opos_sales_items.item_cost_price";
		   
	$join_saleitems = " left JOIN $tbl_opos_items ON $tbl_opos_items.item_id = $tbl_opos_sales_items.item_id  ";
	//return "SELECT ".$fields." FROM ".$tbl_customers_applications. " ".$join_applications." ".$condition." ".$limits;	   
	$selling_items = $this->getRows($fields,$tbl_opos_sales_items, " ".$join_saleitems." ".$condition." ".$orderby."GROUP By $tbl_opos_sales_items.item_id DESC LIMIT 0 , 5");
	
		return $selling_items;	
	}	


public function getSummaryInventory($where="",$orderby="",$limit="")
	{
		$fields =  " name, item_number, quantity, reorder_level, description";
		$summaryinventories = $this->getRows($fields,TBLPREFIX_OPOS."items",  "  ".$where." ".$orderby." ".$limit);	
		return $summaryinventories;
	}
	
////////////////////////////////////////////////////////////////
////////// Function for Save Frequent Report /////////////
public function saveFrequentReports($report_id_input)
{
	$report_id_input = cleanSQL($report_id_input);
	$tbl_app_config = TBLPREFIX_OPOS."app_config";
	$fields = '`value`';
	$value =  $this->getRow($fields,$tbl_app_config,"WHERE `key`='freports' ");
	$report_ids = substr($value['value'] ,0,-1);
	$report_ids = explode(",",$report_ids);
	$trim_report_ids = array();
	foreach($report_ids as $key=>$report_id) 
	  { 
		if($report_id!="")
		{
		  $trim_report_ids[$key] = trim($report_id);
		}
	  }
	  //print_r($trim_report_ids);
	if(in_array($report_id_input,$trim_report_ids))
	  {
		  $value['value'] = $value['value'];
		  //return "Already exists".$value['value'];
	  }
	else
	  {
		  $value['value'] = $value['value'].$report_id_input.",";
		  $this->updateData('freports',$value,$tbl_app_config,'`key`');	
		 // return "Updated sucessfully".$value['value'];
	  }
}

////////////////////////////////////////////////////////////////
////////// Function for Ecommerce Customers Report  /////////////
public function getEcommerceCustomers($where="",$orderby="",$limits="")
	{
		$tbl_customer = TBLPREFIX_OPOS."customers";
	    $tbl_people = TBLPREFIX_OPOS."people";
	    $fields = "$tbl_customer.person_id,
				   $tbl_people.first_name,
				   $tbl_people.last_name,
				   $tbl_people.phone_number,
				   $tbl_people.email,
				   $tbl_people.address_1,
				   $tbl_people.address_2,
				   $tbl_people.city,
				   $tbl_people.state,
				   $tbl_people.zip,
				   $tbl_people.country,
				   $tbl_people.m_name";
		$join_salecustomers = " LEFT JOIN $tbl_people ON $tbl_customer.person_id = $tbl_people.person_id ";
		//return "SELECT ".$fields." FROM ".$tbl_customers_applications. " ".$join_applications." ".$condition." ".$limits;	   
		$pos_customers = $this->getRows($fields,$tbl_customer, " ".$join_salecustomers." WHERE plateform != 2 && deleted= 0 ".$where." ".$orderby." ".$limits." ");
		return $pos_customers;	}
		
////////////////////////////////////////////////////////////////
////////// Function for Ecommerce Single Customer Report  /////////////
public function getEcommerceCustomer($customer_id)
	{

		$tbl_customer = TBLPREFIX_OPOS."customers";
	    $tbl_people = TBLPREFIX_OPOS."people";
	    $fields = "$tbl_customer.person_id,
				   $tbl_people.first_name,
				   $tbl_people.last_name,
				   $tbl_people.phone_number,
				   $tbl_people.email,
				   $tbl_people.address_1,
				   $tbl_people.address_2,
				   $tbl_people.city,
				   $tbl_people.state,
				   $tbl_people.zip,
				   $tbl_people.country,
				   $tbl_people.m_name";
		$join_salecustomers = " LEFT JOIN $tbl_people ON $tbl_customer.person_id = $tbl_people.person_id ";
		$ecommerce_customer = $this->getRow($fields,$tbl_customer, " ".$join_salecustomers." WHERE $tbl_customer.person_id = $customer_id && deleted= 0 ".$where." ".$orderby." ".$limits." ");
		return $ecommerce_customer;	
	}	

////////////////////////////////////////////////////////////////
////////// Function for Employee Customer Report  /////////////
public function getEmployeeCustomers($where="",$orderby="",$limits="")
	{
		$tbl_employees = TBLPREFIX_OPOS."employees";
	    $tbl_people = TBLPREFIX_OPOS."people";
	    $fields = "$tbl_employees.person_id,
				   $tbl_people.first_name,
				   $tbl_people.last_name,
				   $tbl_people.phone_number,
				   $tbl_people.email,
				   $tbl_people.address_1,
				   $tbl_people.address_2,
				   $tbl_people.city,
				   $tbl_people.state,
				   $tbl_people.zip,
				   $tbl_people.country,
				   $tbl_people.m_name";
		$join_salecustomers = " LEFT JOIN $tbl_people ON $tbl_employees.person_id = $tbl_people.person_id ";
		//return "SELECT ".$fields." FROM ".$tbl_customers_applications. " ".$join_applications." ".$condition." ".$limits;	   
		$pos_tbl_employees = $this->getRows($fields,$tbl_employees, " ".$join_salecustomers." WHERE  deleted= 0 ".$where." ".$orderby." ".$limits." ");
		return $pos_tbl_employees;	
	}	
			
public function close()
	{
		$this->close_db($this->conn);
	}
	
}
?>