<?php
include(CLASSES."Report.class.php");
class  POSReports extends Report{
private $conn;
public function  __construct()
{
	 $this->conn = $this->connect(DBHOST, DBUSER, DBPASSWORD);
	 $this->usedatabase(CUSTOMERDB);
	 $this->create_sales_items_temp_table(); 
	 $this->create_receivings_items_temp_table(); 
}
	
////////////////////////////////////////////////////////////////
////////// Function for Get Frequent Report /////////////
public function getFrequentReports($where="",$orderby="",$limit="")
{
	$tbl_app_config = TBLPREFIX_OPOS."app_config";
	$fields = '`key`,value';
	$frequent_reports =  $this->getRow($fields,$tbl_app_config,"WHERE `key`='freports' ");
	return $frequent_reports;	
}

////////////////////////////////////////////////////////////////
////////// Function for Save Frequent Report /////////////
public function saveFrequentReports($report_id_input)
{
	$report_id_input = cleanSQL($report_id_input);
	$tbl_app_config = TBLPREFIX_OPOS."app_config";
	$fields = '`value`';
	$value =  $this->getRow($fields,$tbl_app_config,"WHERE `key`='freports' ");
	$report_ids = substr($value['value'] ,0,-1);
	$report_ids = explode(",",$report_ids);
	$trim_report_ids = array();
	foreach($report_ids as $key=>$report_id) 
	  { 
		if($report_id!="")
		{
		  $trim_report_ids[$key] = trim($report_id);
		}
	  }
	  //print_r($trim_report_ids);
	if(in_array($report_id_input,$trim_report_ids))
	  {
		  $value['value'] = $value['value'];
		  //return "Already exists".$value['value'];
	  }
	else
	  {
		  $value['value'] = $value['value'].$report_id_input.",";
		  $this->updateData('freports',$value,$tbl_app_config,'`key`');	
		 // return "Updated sucessfully".$value['value'];
	  }
}
////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////
////////// Function for Customer Report Data  /////////////
public function getCustomerReportData($where="",$orderby="",$limit="")
{
	$tbl_sales_items = TBLPREFIX_OPOS."sales_items_temp";
	$tbl_customers = TBLPREFIX_OPOS."customers";
	$tbl_people = TBLPREFIX_OPOS."people";

    $q=  $this->dbqueryexe("SELECT table_name FROM INFORMATION_SCHEMA.TABLES WHERE table_schema = '".CUSTOMERDB."' and table_name='$tbl_sales_items'");
		/*$exists = array_shift($q->result_array());*/
		if(!empty($q))
		{
		  $fields = 'sale_id, sale_date, sum(quantity_purchased) as items_purchased, CONCAT(first_name," ",last_name) as employee_name, sum(subtotal) as subtotal, sum(total) as total, sum(tax) as tax, sum(profit) as profit, payment_type, comment';
		  $join_customers  = "JOIN  $tbl_people ON $tbl_sales_items.employee_id = $tbl_people.person_id ";
		 // $join_people  = "JOIN $tbl_people  ON $tbl_customers.person_id = $tbl_people.person_id";
		  $customers =  $this->getRows($fields,$tbl_sales_items," ".$join_customers." ".$where." ".$orderby."  ".$limit);

		  return $customers;	
		}

		else
		{
		  $customers = array();
		  return $customers="";	
		}	
}

////////////////////////////////////////////////////////////////
////////// Function for POS Customers  /////////////
public function getPOSCustomersBackup($where="",$orderby="",$limits="")
	{
		
	    $tbl_people = TBLPREFIX_OPOS."people";
		$tbl_customer = TBLPREFIX_OPOS."customers";
	    $fields = "$tbl_customer.person_id,
				   $tbl_people.first_name,
				   $tbl_people.last_name,
				   $tbl_people.phone_number,
				   $tbl_people.email,
				   $tbl_people.address_1,
				   $tbl_people.address_2,
				   $tbl_people.city,
				   $tbl_people.state,
				   $tbl_people.zip,
				   $tbl_people.country,
				   $tbl_people.m_name";
		$join_salecustomers = " LEFT JOIN $tbl_people ON $tbl_customer.person_id = $tbl_people.person_id ";
		//return "SELECT ".$fields." FROM ".$tbl_customer. " ".$join_salecustomers." WHERE deleted=0 ".$condition." ".$limits;	   
		//$pos_customers = $this->getRows($fields,$tbl_customer, " ".$join_salecustomers." WHERE plateform = 2 && deleted=0 ".$where." ".$orderby." ".$limits." ");
		$pos_customers = $this->getRows($fields,$tbl_customer, " ".$join_salecustomers." WHERE plateform = 2 && deleted=0 ".$where." ".$orderby." ".$limits." "); 
		return $pos_customers;	
	}

public function getPOSCustomers($where="",$orderby="",$limits="")
	{
		$tbl_sales = TBLPREFIX_OPOS."sales";
	    $tbl_people = TBLPREFIX_OPOS."people";
		$fields = "$tbl_sales.sale_id,
				   $tbl_sales.customer_id,
				   $tbl_sales.employee_id,
				   $tbl_sales.plateform,
				   $tbl_people.person_id,
				   $tbl_people.first_name as first_name,
				   $tbl_people.m_name as middle_name,
				   $tbl_people.last_name as last_name,
				   $tbl_people.email as pos_email";
		$join_salecustomers = " INNER JOIN $tbl_people ON $tbl_people.person_id = $tbl_sales.customer_id AND $tbl_people.first_name IS NOT NULL ";
		$selling_customers = $this->getRows($fields,$tbl_sales, " ".$join_salecustomers." ".$where." WHERE $tbl_sales.customer_id IS NOT NULL AND $tbl_sales.customer_id!=0 AND $tbl_sales.plateform=1 ".$orderby." GROUP BY $tbl_sales.customer_id".$limit);
		return $selling_customers;
	}

////////////////////////////////////////////////////////////////
////////// Function for POS Employees  /////////////
public function getPOSEmployees($where="",$orderby="",$limits="")
	{
		
	    $tbl_people = TBLPREFIX_OPOS."people";
		$tbl_employees = TBLPREFIX_OPOS."employees";
	    $fields = "$tbl_employees.person_id,
				   $tbl_employees.username,
				   $tbl_people.first_name,
				   $tbl_people.last_name,
				   $tbl_people.phone_number,
				   $tbl_people.email,
				   $tbl_people.address_1,
				   $tbl_people.address_2,
				   $tbl_people.city,
				   $tbl_people.state,
				   $tbl_people.zip,
				   $tbl_people.country,
				   $tbl_people.m_name";
		$join_salecustomers = " LEFT JOIN $tbl_people ON $tbl_employees.person_id = $tbl_people.person_id ";
		//return "SELECT ".$fields." FROM ".$tbl_customers_applications. " ".$join_applications." ".$condition." ".$limits;	   
		$pos_tbl_employees = $this->getRows($fields,$tbl_employees, " ".$join_salecustomers." WHERE  deleted= 0 ".$where." ".$orderby." ".$limits." ");
		return $pos_tbl_employees;	
	}	

///////////////////////////////////////////////////////////////
////////// Function for Specific Customer Report  /////////////
public function getSpecificCustomer($where="",$orderby="",$limits="")
	{
		$tbl_sales_items = TBLPREFIX_OPOS."sales_items_temp";
	    $tbl_items = TBLPREFIX_OPOS."items";
	    $tbl_people = TBLPREFIX_OPOS."people";
		$category = TBLPREFIX_OPOS."category";

		$categories = [];
		$categories_data =  $this->getRows("id,title",$category," ");
		foreach ($categories_data as $key => $value) 
		{
				$categories[$value['id']] = $value['title'];
		}

        $q=  $this->dbqueryexe("SELECT table_name FROM INFORMATION_SCHEMA.TABLES WHERE table_schema = '".CUSTOMERDB."' and table_name='$tbl_sales_items'");
		/*$exists = array_shift($q->result_array());*/
		if(!empty($q))
		{
		  $fields = 'sale_id, sale_date, sum(quantity_purchased) as items_purchased, CONCAT(first_name," ",last_name) as employee_name, sum(subtotal) as subtotal, sum(total) as total, sum(tax) as tax, sum(profit) as profit, payment_type, comment';
		  $join_customers  = "JOIN  $tbl_people ON $tbl_sales_items.employee_id = $tbl_people.person_id ";
		 // $join_people  = "JOIN $tbl_people  ON $tbl_customers.person_id = $tbl_people.person_id";
		  $customers =  $this->getRows($fields,$tbl_sales_items," ".$join_customers." ".$where." ".$orderby."  ".$limit);
		  $data = array();
		  $data['summary'] =  $customers ;
		  $data['details'] = array();
		  foreach($data['summary'] as $key=>$value)
		  {
			  $fields = 'sale_id, name, category_id, serialnumber, quantity_purchased, subtotal,total, tax, profit, discount_percent';
			  $join_items  = "INNER JOIN  $tbl_items ON $tbl_sales_items.item_id = $tbl_items.item_id ";
		      $details =  $this->getRows($fields,$tbl_sales_items," ".$join_items." WHERE sale_id = ".$value['sale_id']);
              // print_r($details);
			 /* $this->db->select('name, category, serialnumber, sales_items_temp.description, quantity_purchased, subtotal,total, tax, profit, discount_percent');
			  $this->db->from('sales_items_temp');
			  $this->db->join('items', 'sales_items_temp.item_id = items.item_id');
			  $this->db->where('sale_id = '.$value['sale_id']);*/
			 // $data['details'][$key] = $details;
			  $data['details'][$value['sale_id']] = $details;

			  foreach ($data['details'][$value['sale_id']] as $sale_detail_key => $sale_detail_val) 
				{
					$category_val = "";
					if($sale_detail_val['category_id'] != "" && array_key_exists($sale_detail_val['category_id'], $categories))
					{
						$category_val = $categories[$sale_detail_val['category_id']];
					}
					$data['details'][$value['sale_id']][$sale_detail_key]['category'] = $category_val;
				}
		  }
		}
		return $data;
	}

////////////////////////////////////////////////////


public function getPOSCustomer($customer_id="")
	{

		$tbl_customer = TBLPREFIX_OPOS."customers";
	    $tbl_people = TBLPREFIX_OPOS."people";
	    $fields = "$tbl_customer.person_id,
				   $tbl_people.first_name,
				   $tbl_people.last_name,
				   $tbl_people.phone_number,
				   $tbl_people.email,
				   $tbl_people.address_1,
				   $tbl_people.address_2,
				   $tbl_people.city,
				   $tbl_people.state,
				   $tbl_people.zip,
				   $tbl_people.country,
				   $tbl_people.m_name";
		$join_salecustomers = " LEFT JOIN $tbl_people ON $tbl_customer.person_id = $tbl_people.person_id ";
		//return "SELECT ".$fields." FROM ".$tbl_customers_applications. " ".$join_applications." ".$condition." ".$limits;	   
		$pos_customers = $this->getRow($fields,$tbl_customer, " ".$join_salecustomers." WHERE plateform = 2 && deleted= 0 ".$where." ".$orderby." ".$limits." ");
		return $pos_customers;	
	}
	
		



function cogs_report($start_date, $end_date, $export_excel=0)
	{
		
		//Cost of existing inventory at the beginning of the report period
		$sql_xcost = mysql_query("SELECT SUM(cost_price) as xcost FROM phppos_inventory as ppiv,phppos_items as ppit WHERE ppit.item_id = ppiv.trans_items AND DATE(trans_date) = '$start_date'");
		$result_xcost = mysql_fetch_assoc($sql_xcost);
		$xcost = $result_xcost['xcost'];
		
		//Cost of inventory purchased during the report period
		$sql_ycost = mysql_query("SELECT SUM(item_cost_price) as ycost FROM phppos_inventory as ppiv,phppos_receivings_items as pprit WHERE pprit.item_id = ppiv.trans_items AND (DATE(trans_date) >= '$start_date' AND DATE(trans_date) <= '$end_date')");
		$result_ycost = mysql_fetch_assoc($sql_ycost);
		$ycost = $result_ycost['ycost'];
		
		//Cost of inventory on hand at the end of the report period
		$sql_zcost = mysql_query("SELECT SUM(cost_price) as zcost FROM phppos_inventory as ppiv,phppos_items as ppit WHERE ppit.item_id = ppiv.trans_items AND DATE(trans_date) = '$end_date' AND quantity>0");
		$result_zcost = mysql_fetch_assoc($sql_zcost);
		$zcost = $result_zcost['zcost'];
		
		$data = array(
			"title" => 'COGS Report',
			"subtitle" => date('m/d/Y', strtotime($start_date)) .'-'.date('m/d/Y', strtotime($end_date)),
			"xcost" => $xcost,
			"ycost" => $ycost,
			"zcost" => $zcost,
			"export_excel" => $export_excel
		);
		
		$this->load->view("reports/cogs_report_detail.php",$data);	
	}


////////////////////////////////////////////////////
////////////   Function for Close   //////////
public function close()
	{
		$this->close_db($this->conn);
	}

}
?>