<?php
  require ROOT.'lib/PaymentsAPI/anet_php_sdk/sample-code-php/vendor/autoload.php';
  require_once  ROOT.'lib/PaymentsAPI/anet_php_sdk/sample-code-php/constants/SampleCodeConstants.php';
  use net\authorize\api\contract\v1 as AnetAPI;
  use net\authorize\api\controller as AnetController;

  define("AUTHORIZENET_LOG_FILE", "phplog");


function chargeCreditCard($merchantLoginId, $merchantTransactionKey,$environment,$payment_data)
{
    // echo $merchantTransactionKey;
    // uncomment below lines for sandbox
   /* $merchantLoginId = '66eksL6LXb';
    $merchantTransactionKey = '5bU49ds99Bxc9FdN';
    $environment = 'sandbox'; */

    /* Create a merchantAuthenticationType object with authentication details
       retrieved from the constants file */
    $merchantAuthentication = new AnetAPI\MerchantAuthenticationType();
    // $merchantAuthentication->setName(\SampleCodeConstants::MERCHANT_LOGIN_ID);
    // $merchantAuthentication->setTransactionKey(\SampleCodeConstants::MERCHANT_TRANSACTION_KEY);
    $merchantAuthentication->setName($merchantLoginId);
    $merchantAuthentication->setTransactionKey($merchantTransactionKey);
    
    // Set the transaction's refId
    $refId = 'ref' . time();

    // Create the payment data for a credit card
    $creditCard = new AnetAPI\CreditCardType();
    $creditCard->setCardNumber($payment_data['card_no']);
    $creditCard->setExpirationDate($payment_data['year'].'-'.$payment_data['month']);
    $creditCard->setCardCode($payment_data['cvv']);


    // Add the payment data to a paymentType object
    $paymentOne = new AnetAPI\PaymentType();
    $paymentOne->setCreditCard($creditCard);

    // Create order information
    $order = new AnetAPI\OrderType();

    $invoice_num = rand().time();
    $order->setInvoiceNumber($invoice_num);

    $description = "Purchasing Domain!";
    if(array_key_exists("description", $payment_data))
        $description = $payment_data['description'];
    $order->setDescription($description);

    $company = "Wrkmash";
    if(array_key_exists("company", $payment_data))
        $company = $payment_data['company'];

    // Set the customer's Bill To address
    $customerAddress = new AnetAPI\CustomerAddressType();
    $customerAddress->setFirstName($payment_data['first_name']);
    $customerAddress->setLastName($payment_data['last_name']);
    $customerAddress->setCompany($company);
    // $customerAddress->setAddress("");
    // $customerAddress->setCity("");
    // $customerAddress->setState("");
    // $customerAddress->setZip("44628");
    $customerAddress->setCountry("USA");

    // Set the customer's identifying information
    $customerData = new AnetAPI\CustomerDataType();
    $customerData->setType("individual");

    $customer_id = rand().time();
    $customerData->setId($customer_id);
    $customerData->setEmail($payment_data['email_address']);

    // Add values for transaction settings
    // $duplicateWindowSetting = new AnetAPI\SettingType();
    // $duplicateWindowSetting->setSettingName("duplicateWindow");
    // $duplicateWindowSetting->setSettingValue("60");

    // Add some merchant defined fields. These fields won't be stored with the transaction,
    // but will be echoed back in the response.
    $merchantDefinedField1 = new AnetAPI\UserFieldType();
    $merchantDefinedField1->setName("customerLoyaltyNum");
    $merchantDefinedField1->setValue(rand());

    $merchantDefinedField2 = new AnetAPI\UserFieldType();
    $merchantDefinedField2->setName("favoriteColor");
    $merchantDefinedField2->setValue("blue");




    // Create a TransactionRequestType object and add the previous objects to it
    $transactionRequestType = new AnetAPI\TransactionRequestType();
    $transactionRequestType->setTransactionType("authCaptureTransaction");
    $transactionRequestType->setAmount($payment_data['amount']);
    $transactionRequestType->setOrder($order);
    $transactionRequestType->setPayment($paymentOne);
    $transactionRequestType->setBillTo($customerAddress);
    $transactionRequestType->setCustomer($customerData);
    // $transactionRequestType->addToTransactionSettings($duplicateWindowSetting);
   
    $transactionRequestType->addToUserFields($merchantDefinedField1);
    $transactionRequestType->addToUserFields($merchantDefinedField2);

    // Assemble the complete transaction request
    $request = new AnetAPI\CreateTransactionRequest();
    $request->setMerchantAuthentication($merchantAuthentication);
    $request->setRefId($refId);
    $request->setTransactionRequest($transactionRequestType);

    // Create the controller and get the response
    $controller = new AnetController\CreateTransactionController($request);
    // $response = $controller->executeWithApiResponse(\net\authorize\api\constants\ANetEnvironment::SANDBOX);
    if($environment == 'live')
    {
      $response = $controller->executeWithApiResponse( \net\authorize\api\constants\ANetEnvironment::PRODUCTION);
    }
    else
    {
      $response = $controller->executeWithApiResponse( \net\authorize\api\constants\ANetEnvironment::SANDBOX);      
    }
    
    $result = [];
    if ($response != null) {
        // Check to see if the API request was successfully received and acted upon
        if ($response->getMessages()->getResultCode() == "Ok") {
            // Since the API request was successful, look for a transaction response
            // and parse it to display the results of authorizing the card
            $tresponse = $response->getTransactionResponse();
        
            if ($tresponse != null && $tresponse->getMessages() != null) {
                // echo " Successfully created transaction with Transaction ID: " . $tresponse->getTransId() . "\n";
                // echo " Transaction Response Code: " . $tresponse->getResponseCode() . "\n";
                // echo " Message Code: " . $tresponse->getMessages()[0]->getCode() . "\n";
                // echo " Auth Code: " . $tresponse->getAuthCode() . "\n";
                // echo " Description: " . $tresponse->getMessages()[0]->getDescription() . "\n";

                $result['error'] = 0;
                $result['api_response'] = json_encode(['Transaction ID'=>$tresponse->getTransId(),'Transaction Response Code'=>$tresponse->getResponseCode(),'Message Code'=>$tresponse->getMessages()[0]->getCode(),'Auth Code'=>$tresponse->getAuthCode(),'Description'=>$tresponse->getMessages()[0]->getDescription()]);
            } else {
                // echo "Transaction Failed \n";
                $result['error'] = 1;
                $result['message'] = 'Transaction Failed.';
                if ($tresponse->getErrors() != null) 
                {
                    $result['message'] = $tresponse->getErrors()[0]->getErrorText();
                    /*echo " Error Code  : " . $tresponse->getErrors()[0]->getErrorCode() . "\n";
                    echo " Error Message : " . $tresponse->getErrors()[0]->getErrorText() . "\n";*/
                }
            }
            // Or, print errors if the API request wasn't successful
        } else {
            // echo "Transaction Failed \n";
            $result['error'] = 1;
            $result['message'] = 'Transaction Failed.';

            $tresponse = $response->getTransactionResponse();
        
            if ($tresponse != null && $tresponse->getErrors() != null) {
                $result['message'] = $tresponse->getErrors()[0]->getErrorText();
                /*echo " Error Code  : " . $tresponse->getErrors()[0]->getErrorCode() . "\n";
                echo " Error Message : " . $tresponse->getErrors()[0]->getErrorText() . "\n";*/
            } else {
                $result['message'] = $response->getMessages()->getMessage()[0]->getText();
                /*echo " Error Code  : " . $response->getMessages()->getMessage()[0]->getCode() . "\n";
                echo " Error Message : " . $response->getMessages()->getMessage()[0]->getText() . "\n";*/
            }
        }
    } else {
        $result['error'] = 1;
        $result['message'] = 'Transaction Failed.';
        // echo  "No response returned \n";
    }

    return $result;
}

// if (!defined('DONT_RUN_SAMPLES')) {
//     chargeCreditCard("2.23");
// }
