<?php 
require_once(dirname(__FILE__) ."/CPanelAPI/xmlapi.php");
require_once(dirname(__FILE__) ."/CPanelAPI/tldextract.php");

class CPanelAPI {

	protected $CPanel_HOST = "";
	protected $CPanel_USER = "";
	protected $CPanel_PASSWORD = "";
	protected $CPanel_ACCOUNT = "";
	
	public function __construct($cpanel_hots,$cpanel_user,$cpanel_password)
	{
		$this->CPanel_HOST = $cpanel_hots;
		$this->CPanel_USER = $cpanel_user;
		$this->CPanel_PASSWORD = $cpanel_password;
		$this->CPanel_ACCOUNT = $cpanel_user;
	}
	
	/*Create XML API Object*/
	public function objXMLApi()
	{
		$xmlapi = new xmlapi($this->CPanel_HOST);
		$xmlapi->set_output("json");
		$xmlapi->set_debug(1);
		return $xmlapi;
	}
	
	/*************************/
	/*Add on Domain Functions*/
	/*************************/
	
	/*Get All Add on Domains*/
	public function getAllAddonDomains()
	{
		$xmlapi = $this->objXMLApi();
		$xmlapi->password_auth($this->CPanel_USER,$this->CPanel_PASSWORD); //trying to go not root, but reseller
		
		$result = $xmlapi->listaddondomains($this->CPanel_ACCOUNT, $domain = null);
		$result = jsonDecode($result);
		$result = $result->cpanelresult;
		/*printArray($result);exit();*/
		
		$responseArray = array();
		$responseArray['CP_Error'] = $result->error;
		$responseArray['CP_Response'] = $result;
		return $responseArray;
	}

	public function removeControlpanelTextFromDomain($domain)
	{
		return str_replace("controlpanel.wrkmash", "wrkmash", $domain);
	}
	
	/*Check All Add on Domain*/
	public function checkAddonDomain($domain)
	{
		$domain = $this->removeControlpanelTextFromDomain($domain);
		$xmlapi = $this->objXMLApi();
		$xmlapi->password_auth($this->CPanel_USER,$this->CPanel_PASSWORD); //trying to go not root, but reseller
		
		$result = $xmlapi->listaddondomains($this->CPanel_ACCOUNT, $domain);
		$result = jsonDecode($result);
		$result = $result->cpanelresult;
		if(empty($result->error))
		{
			$data = jsonDecode(jsonEncode($result->data), true);
			$exists = array_search($domain, array_column($data, 'domain'));
			if($result->data[$exists]->domain == $domain)
			{
				$result = $result->data[$exists];
			}
			else
			{
				$result = array();
			}
		}
		/*printArray($result);exit();*/
		
		$responseArray = array();
		$responseArray['CP_Error'] = $result->error;
		$responseArray['CP_Response'] = $result;
		return $responseArray;
	}
	
	/*Add New Add on Domain*/
	public function addAddonDomain($dir,$newdomain,$subdomain)
	{
		$newdomain = $this->removeControlpanelTextFromDomain($newdomain);
		$subdomain = $this->removeControlpanelTextFromDomain($subdomain);
		$xmlapi = $this->objXMLApi();
		$xmlapi->password_auth($this->CPanel_USER,$this->CPanel_PASSWORD); //trying to go not root, but reseller
		
		/*$directory = "public_html/zcp/eidivapoke/sitebuilder/";
		$domain = "pokemon.science";
		$subdomain = "pokemon";*/
		
		$result = $xmlapi->api2_query($this->CPanel_ACCOUNT, "AddonDomain", "addaddondomain", array(dir=>$dir,newdomain=>$newdomain, subdomain=>$subdomain));
		$result = jsonDecode($result);
		$result = $result->cpanelresult;
		/*printArray($result);exit();*/
				
		$responseArray = array();
		$responseArray['CP_Error'] = $result->error;
		$responseArray['CP_Response'] = $result;
		return $responseArray;
	}

	/*Add New Add on Domain*/
	public function activeAddonDomain($dir,$newdomain,$subdomain)
	{
		$subdomain = $this->removeControlpanelTextFromDomain($subdomain);
		$newdomain = $this->removeControlpanelTextFromDomain($newdomain);
		$xmlapi = $this->objXMLApi();
		$xmlapi->password_auth($this->CPanel_USER,$this->CPanel_PASSWORD); //trying to go not root, but reseller
		
		/*$directory = "public_html/zcp/eidivapoke/sitebuilder/";
		$domain = "pokemon.science";
		$subdomain = "pokemon";*/
		
		// $result = $xmlapi->api2_query($this->CPanel_ACCOUNT, "SSL", "installssl", array(dir=>$dir,newdomain=>$newdomain, subdomain=>$subdomain));
		// $result = jsonDecode($result);
		// $result = $result->cpanelresult;
		/*printArray($result);exit();*/
		
		$result = $xmlapi->api2_query($this->CPanel_ACCOUNT, 'SSL', 'gencrt', array(
			'city'            => 'Houston',
			'company'          => 'wrkmash',
			'companydivision' => 'Documentation',
			'country'         => 'US',
			'email'           => 'sumera@yopmail.com',
			'host'            => 'example.com',
			'state'           => 'TX',
		));
		
		//$result = $xmlapi->api2_query($this->CPanel_ACCOUNT, "SSL", "installssl", array(dir=>$dir,newdomain=>$newdomain, subdomain=>$subdomain));
		$result = jsonDecode($result);
		$result = $result->cpanelresult;

		
		$responseArray = array();
		$responseArray['CP_Error'] = $result->error;
		$responseArray['CP_Response'] = $result;
		return $responseArray;
	}
	
	/*Delete New Add on Domain*/
	public function deleteAddonDomain($domain,$subdomain)
	{		
		$domain = $this->removeControlpanelTextFromDomain($domain);
		$subdomain = $this->removeControlpanelTextFromDomain($subdomain);
		
		$xmlapi = $this->objXMLApi();
		$xmlapi->password_auth($this->CPanel_USER,$this->CPanel_PASSWORD); //trying to go not root, but reseller
		
		$result = $xmlapi->api2_query($this->CPanel_ACCOUNT, "AddonDomain", "deladdondomain", array(domain=>$domain, subdomain=>$subdomain));
		$result = jsonDecode($result);
		$result = $result->cpanelresult;
		/*printArray($result);exit();*/
				
		$responseArray = array();
		$responseArray['CP_Error'] = $result->error;
		$responseArray['CP_Response'] = $result;
		return $responseArray;
	}
	
	/***************************/
	/*CPanel Accounts Functions*/
	/***************************/
	
	/*Check CPanel Account*/
	public function checkCPAccount($username)
	{
		$xmlapi = $this->objXMLApi();
		$xmlapi->password_auth($this->CPanel_USER,$this->CPanel_PASSWORD); //trying to go not root, but reseller
		
		//$result = $xmlapi->accountsummary($username);
		$result = $xmlapi->listaccts();
		$result = jsonDecode($result);
		if(!empty($result->cpanelresult))$result = $result->cpanelresult;
		if(empty($result->error))
		{
			$accts = jsonDecode(jsonEncode($result->acct), true);
			$exists = array_search($username, array_column($accts, 'user'));
			if($result->acct[$exists]->user == $username)
			{
				$result = $result->acct[$exists];
			}
			else
			{
				$result = array();
			}
		}
		/*printArray($result);exit();*/
				
		$responseArray = array();
		$responseArray['CP_Error'] = $result->error;
		$responseArray['CP_Response'] = $result;
		return $responseArray;
	}
	
	/*Create CPanel Account*/
	public function createCPAccount($acctconf)
	{
		$xmlapi = $this->objXMLApi();
		$xmlapi->password_auth($this->CPanel_USER,$this->CPanel_PASSWORD); //trying to go not root, but reseller
		
		$result = $xmlapi->createacct($acctconf);
		$result = jsonDecode($result);
		if(!empty($result->cpanelresult))$result = $result->cpanelresult;
		/*printArray($result);exit();*/
				
		$responseArray = array();
		$responseArray['CP_Error'] = $result->error;
		$responseArray['CP_Response'] = $result;
		return $responseArray;
	}
	
	/*Remove CPanel Account*/
	public function removeCPAccount($username)
	{
		$xmlapi = $this->objXMLApi();
		$xmlapi->password_auth($this->CPanel_USER,$this->CPanel_PASSWORD); //trying to go not root, but reseller
		
		$result = $xmlapi->removeacct($username);
		$result = jsonDecode($result);
		if(!empty($result->cpanelresult))$result = $result->cpanelresult;
		/*printArray($result);exit();*/
				
		$responseArray = array();
		$responseArray['CP_Error'] = $result->error;
		$responseArray['CP_Response'] = $result;
		return $responseArray;
	}
	
	/*Get Domain User Data*/
	public function getDomainUserData($domain)
	{
		$domain = $this->removeControlpanelTextFromDomain($domain);
		$xmlapi = $this->objXMLApi();
		$xmlapi->password_auth($this->CPanel_USER,$this->CPanel_PASSWORD); //trying to go not root, but reseller
		
		$result = $xmlapi->domainuserdata($domain);
		$result = jsonDecode($result);
		if(!empty($result->cpanelresult))$result = $result->cpanelresult;
		/*printArray($result);exit();*/
				
		$responseArray = array();
		$responseArray['CP_Error'] = $result->error;
		$responseArray['CP_Response'] = $result;
		return $responseArray;
	}
	
	/****************/
	/*DNS  Functions*/
	/****************/
	
	/*Check DNS Entry*/
	public function checkDNSEntry($dns)
	{
		$xmlapi = $this->objXMLApi();
		$xmlapi->password_auth($this->CPanel_USER,$this->CPanel_PASSWORD); //trying to go not root, but reseller
		
		$result = $xmlapi->listzones();
		$result = jsonDecode($result);
		if(!empty($result->cpanelresult))$result = $result->cpanelresult;
		if(empty($result->error))
		{
			$zones = jsonDecode(jsonEncode($result->zone), true);
			$exists = array_search($dns, array_column($zones, 'domain'));
			if($result->zone[$exists]->domain == $dns)
			{
				$result = $result->zone[$exists];
			}
			else
			{
				$result = array();
			}
		}
		/*printArray($result);exit();*/
				
		$responseArray = array();
		$responseArray['CP_Error'] = $result->error;
		$responseArray['CP_Response'] = $result;
		return $responseArray;
	}
	
	/*Add DNS Entry*/
	public function addDNSEntry($domain)
	{
		$domain = $this->removeControlpanelTextFromDomain($domain);
		$xmlapi = $this->objXMLApi();
		$xmlapi->password_auth($this->CPanel_USER,$this->CPanel_PASSWORD); //trying to go not root, but reseller
		
		$ip = $_SERVER['SERVER_ADDR'];
		$result = $xmlapi->adddns($domain, $ip);
		$result = jsonDecode($result);
		if(!empty($result->cpanelresult))$result = $result->cpanelresult;
		/*printArray($result);exit();*/
				
		$responseArray = array();
		$responseArray['CP_Error'] = $result->error;
		$responseArray['CP_Response'] = $result;
		return $responseArray;
	}
	
	/*Kill DNS Entry*/
	public function killDNSEntry($domain)
	{
		$domain = $this->removeControlpanelTextFromDomain($domain);
		$xmlapi = $this->objXMLApi();
		$xmlapi->password_auth($this->CPanel_USER,$this->CPanel_PASSWORD); //trying to go not root, but reseller
		
		$result = $xmlapi->killdns($domain);
		$result = jsonDecode($result);
		if(!empty($result->cpanelresult))$result = $result->cpanelresult;
		/*printArray($result);exit();*/
				
		$responseArray = array();
		$responseArray['CP_Error'] = $result->error;
		$responseArray['CP_Response'] = $result;
		return $responseArray;
	}
	
	/*Add DNS Record*/
	public function addDNSRecord($domain,$args)
	{
		$domain = $this->removeControlpanelTextFromDomain($domain);
		$xmlapi = $this->objXMLApi();
		$xmlapi->password_auth($this->CPanel_USER,$this->CPanel_PASSWORD); //trying to go not root, but reseller
		$result = $xmlapi->addzonerecord( $domain, $args );
		$result = jsonDecode($result);
		if(!empty($result->cpanelresult))$result = $result->cpanelresult;
		/*printArray($result);exit();*/
		$responseArray = array();
		$responseArray['CP_Error'] = $result->error;
		$responseArray['CP_Response'] = $result;
		return $responseArray;
	}
	
	/*Get All Record of DNS*/
	public function getDNSRecords($domain,$name=NULL)
	{
		$domain = $this->removeControlpanelTextFromDomain($domain);
		$xmlapi = $this->objXMLApi();
		$xmlapi->password_auth($this->CPanel_USER,$this->CPanel_PASSWORD); //trying to go not root, but reseller
		
		$result = $xmlapi->dumpzone($domain);
		$result = jsonDecode($result);
		if(!empty($result->cpanelresult))$result = $result->cpanelresult;
		if(empty($result->error))
		{
			foreach($result->result as $key=>$result)
			{
				if($name != NULL)
				{
					foreach($result->record as $key=>$record)
					{
						//$result = array();
						if($record->name == $name)$exists = $key;
					}
					
					$result = $result->record[$exists];
				}
			}
		}
		/*printArray($result);exit();*/
		$responseArray = array();
		$responseArray['CP_Error'] = $result->error;
		$responseArray['CP_Response'] = $result;
		return $responseArray;
	}
	
	/*Edit DNS Record*/
	public function editDNSRecord($domain,$args)
	{
		//$xmlapi = $this->objXMLApi();
		//$xmlapi->password_auth($this->CPanel_USER,$this->CPanel_PASSWORD); //trying to go not root, but reseller
		$domain = $this->removeControlpanelTextFromDomain($domain);
		$get_record_line = $this->getDNSRecords($domain,$args['name']);
		$line = $get_record_line['CP_Response']->Line;
		$result = $xmlapi->editzonerecord( $domain, $line, $args );
		$result = jsonDecode($result);
		if(!empty($result->cpanelresult))$result = $result->cpanelresult;
		/*printArray($result);exit();*/
		$responseArray = array();
		$responseArray['CP_Error'] = $result->error;
		$responseArray['CP_Response'] = $result;
		return $responseArray;
	}
	
	/*****************/
	/*Email Functions*/
	/*****************/
	
	/*Check Email Account*/
	public function checkEmailAccount($username,$emailaccount)
	{
		return $this->getAllEmailAccounts($username,$emailaccount);
	}
	
	/*Get Email Account*/
	public function getEmailAccount($username,$emailaccount)
	{
		return $this->getAllEmailAccounts($username,$emailaccount);
	}
	
/*Get Email Account*/
	public function acctcounts($username)
	{
		return "sam".$this->acctcounts($username);
		//return $this->acctcounts($username,$emailaccount);
	}

	/*Get Email Accounts*/
	public function getAllEmailAccounts($username,$emailaccount=NULL)
	{
		$xmlapi = $this->objXMLApi();
		$xmlapi->password_auth($this->CPanel_USER,$this->CPanel_PASSWORD); //trying to go not root, but reseller
		
		$result = $xmlapi->api2_query($username, 'Email', 'listpops', $args = array());
		//$result = $xmlapi->api2_query($username, 'Email', 'listpops', $args = array(regex=>"sumera.naz"));
		$result = jsonDecode($result);
		if(!empty($result->cpanelresult))$result = $result->cpanelresult;
		if(empty($result->error))
		{
			$emailaccouns = jsonDecode(jsonEncode($result->data), true);
			if($emailaccount != NULL)
			{
				//$emailaccouns = jsonDecode(jsonEncode($result->data), true);
				$exists = array_search($emailaccount, array_column($emailaccouns, 'email'));
				if($result->data[$exists]->email == $emailaccount)
				{
					$result = $result->data[$exists];
				}
				else
				{
					$result = array();
				}
			}
			else
			{
				$exists = array_search($username, array_column($emailaccouns, 'email'));
				if($result->data[$exists]->email == $username)
				{
					unset($result->data[$exists]);
				}
			}
		}
		/*printArray($result);exit();*/
				
		$responseArray = array();
		$responseArray['CP_Error'] = $result->error;
		$responseArray['CP_Response'] = $result;
		return $responseArray;
	}
	
	/*Get Specific Domain Email Accounts*/
	public function getDomainEmailAccounts($username,$domain)
	{
		$domain = $this->removeControlpanelTextFromDomain($domain);
		$xmlapi = $this->objXMLApi();
		$xmlapi->password_auth($this->CPanel_USER,$this->CPanel_PASSWORD); //trying to go not root, but reseller
		
		//$result = $xmlapi->api2_query($username, 'Email', 'listpops', $args = array());
		//$result = $xmlapi->api2_query($username, 'Email', 'listpops', $args = array(regex=>"user"));
		$result = $xmlapi->api2_query($username, 'Email', 'listpops', $args = array(regex=>$domain));
		$result = jsonDecode($result);
		if(!empty($result->cpanelresult))$result = $result->cpanelresult;
		/*printArray($result);exit();*/
				
		$responseArray = array();
		$responseArray['CP_Error'] = $result->error;
		$responseArray['CP_Response'] = $result;
		return $responseArray;
	}
	
	/*Add Email Account*/
	public function addEmailAccount($username,$args)
	{
		$xmlapi = $this->objXMLApi();
		$xmlapi->password_auth($this->CPanel_USER,$this->CPanel_PASSWORD); //trying to go not root, but reseller
		
		//$result = $xmlapi->addpop($username, $args);
		/*$args = array(
			'domain'          => 'example.com', 
			'email'           => 'user', 
			'password'        => '12345luggage',
			'quota'           => '500',//0 For Unlimited
		);*/
		$result = $xmlapi->api2_query($username, 'Email', 'addpop', $args);
		$result = jsonDecode($result);
		if(!empty($result->cpanelresult))$result = $result->cpanelresult;
		/*printArray($result);exit();*/
				
		$responseArray = array();
		$responseArray['CP_Error'] = $result->error;
		$responseArray['CP_Response'] = $result;
		return $responseArray;
	}
	
	/*Edit Email Account*/
	/*public function editEmailAccount($username,$args)
	{
		$xmlapi = $this->objXMLApi();
		$xmlapi->password_auth($this->CPanel_USER,$this->CPanel_PASSWORD); //trying to go not root, but reseller
		
		$result = $xmlapi->api2_query($username, 'Email', 'editpop', $args);
		$result = jsonDecode($result);
		if(!empty($result->cpanelresult))$result = $result->cpanelresult;
		//printArray($result);exit();
				
		$responseArray = array();
		$responseArray['CP_Error'] = $result->error;
		$responseArray['CP_Response'] = $result;
		return $responseArray;
	}*/
	
	/*Delete Email Account*/
	public function deleteEmailAccount($username,$args)
	{
		$xmlapi = $this->objXMLApi();
		$xmlapi->password_auth($this->CPanel_USER,$this->CPanel_PASSWORD); //trying to go not root, but reseller
		
		$result = $xmlapi->api2_query($username, 'Email', 'delpop', $args);
		$result = jsonDecode($result);
		if(!empty($result->cpanelresult))$result = $result->cpanelresult;
		/*printArray($result);exit();*/
				
		$responseArray = array();
		$responseArray['CP_Error'] = $result->error;
		$responseArray['CP_Response'] = $result;
		return $responseArray;
	}
	
	/*Change Email Account Password*/
	public function changeEmailAccountPassword($username,$args)
	{
		$xmlapi = $this->objXMLApi();
		$xmlapi->password_auth($this->CPanel_USER,$this->CPanel_PASSWORD); //trying to go not root, but reseller
		
		$result = $xmlapi->api2_query($username, 'Email', 'passwdpop', $args);
		$result = jsonDecode($result);
		if(!empty($result->cpanelresult))$result = $result->cpanelresult;
		/*printArray($result);exit();*/
				
		$responseArray = array();
		$responseArray['CP_Error'] = $result->error;
		$responseArray['CP_Response'] = $result;
		return $responseArray;
	}
	
	/*Change Email Account Quota*/
	public function editEmailAccountQuota($username,$args)
	{
		$xmlapi = $this->objXMLApi();
		$xmlapi->password_auth($this->CPanel_USER,$this->CPanel_PASSWORD); //trying to go not root, but reseller
		
		$result = $xmlapi->api2_query($username, 'Email', 'editquota', $args);
		$result = jsonDecode($result);
		if(!empty($result->cpanelresult))$result = $result->cpanelresult;
		/*printArray($result);exit();*/
				
		$responseArray = array();
		$responseArray['CP_Error'] = $result->error;
		$responseArray['CP_Response'] = $result;
		return $responseArray;
	}
	
	/*******************/
	/*SSL Functions*/
	/*******************/
	
	/*Check CPanel Account*/
	public function checkDomainSSL($domain)
	{
		$domain = $this->removeControlpanelTextFromDomain($domain);
		$xmlapi = $this->objXMLApi();
		$xmlapi->password_auth($this->CPanel_USER,$this->CPanel_PASSWORD); //trying to go not root, but reseller
		
		$result = $xmlapi->fetchsslinfo(array("domain"=>$domain));
		$result = jsonDecode($result);
		if(!empty($result->cpanelresult))$result = $result->cpanelresult;
		if(empty($result->error))
		{
			$sslinfos = jsonDecode(jsonEncode($result->sslinfo), true);
			if(!empty($domain))
			{
				//$emailaccouns = jsonDecode(jsonEncode($result->data), true);
				$exists = array_search($domain, array_column($sslinfos, 'domain'));
				if($result->sslinfo[$exists]->domain == $domain)
				{
					$result = $result->sslinfo[$exists];
				}
				else
				{
					$result = array();
				}
			}
			else
			{
				/*$exists = array_search($domain, array_column($sslinfos, 'domain'));
				if($result->sslinfo[$exists]->email == $domain)
				{
					unset($result->sslinfo[$exists]);
				}*/
			}
		}
		/*printArray($result);exit();*/
				
		$responseArray = array();
		$responseArray['CP_Error'] = $result->error;
		$responseArray['CP_Response'] = $sslinfos;
		return $responseArray;
	}
	
	/*******************/
	/*General Functions*/
	/*******************/
	
	/*Extract Domain*/
	public function extractDomain($domain)
	{
		$domain = $this->removeControlpanelTextFromDomain($domain);
		return tldextract($domain);
	}
	
	/*Generate Sub Domain from Domain*/
	public function generateSubDomain($domain)
	{
		$domain = $this->removeControlpanelTextFromDomain($domain);
		$components = tldextract($domain);
		return str_replace(".".$components->tld,'',$domain);
	}
	
	/*Generate CPanel Account Username*/
	public function generateDomainUsername($domain)
	{
		$domain = $this->removeControlpanelTextFromDomain($domain);
		/*$components = tldextract($domain);
		$username = str_replace(array('-', '.'),'',$components->domain) ;
		return $this->random_username($username);*/
		return $this->random_username("user");
	}
	
	/*Generate CPanel Account Password*/
	public function generateDomainPassword($length)
	{
		return generateStrongPassword($length);
	}
	
	/*Generate Random Username*/
	public function random_username($username)
	{
		//$new_username = $username.mt_rand(0,10);
		$new_username = $username.mt_rand(0,10000);
		return $this->check_username($new_username,$username);
	}
	
	/*Check Username*/
	public function check_username($new_username,$username)
	{
		$result = $this->checkCPAccount($new_username);
		if(!empty($result['CP_Response']->acct[0]) && ($result['CP_Response']->acct[0]->user == $new_username))
		{
			$this->random_username($username);
		}
		else
		{
			return $new_username;
		}
	}
	
	/*Get Result Error Reason*/
	public function getResultErrorReason($result)
	{
		$result = jsonDecode(jsonEncode($result), true);
		//return getArrayValueByKey($result, 'reason');
		//$exists = array_search($domain, array_column($result, 'reason'));
		if(isArrayMultidimensional($result))
		{
			return $result[0]['reason'];
		}
		else
		{
			return $result['reason'];
		}
		
	}
}
?> 