# FacebookResponse for the Facebook SDK for PHP

Represents a response from the Graph API.

## Facebook\FacebookResponse

After sending a request to the Graph API, the response will be returned in the form of a `Facebook\FacebookResponse` entity.

Usage:

```php
$fb = new Facebook\Facebook(/* . . . */);

// Send the request to Graph
try {
  $response = $fb->get('/me');
} catch(Facebook\Exceptions\FacebookResponseException $e) {
  // When Graph returns an error
  echo 'Graph returned an error: ' . $e->getMessage();
  exit;
} catch(Facebook\Exceptions\FacebookSDKException $e) {
  // When validation fails or other local issues
  echo 'Facebook SDK returned an error: ' . $e->getMessage();
  exit;
}

var_dump($response);
// class Facebook\FacebookResponse . . .
```

## Instance Methods

### getRequest()
```php
public Facebook\FacebookRequest getRequest()
```
Returns the original [`Facebook\FacebookRequest`](FacebookRequest.md) entity that was used to solicit this response.

### getAccessToken()
```php
public string getAccessToken()
```
Returns the access token that was used for the original request in the form of a string.

### getApp()
```php
public Facebook\FacebookApp getApp()
```
Returns the [`Facebook\FacebookApp`](FacebookApp.md) entity that was used with the original request.

### getHttpStatusCode()
```php
public int getHttpStatusCode()
```
Returns the HTTP response code for this response.

### getHeaders()
```php
public array getHeaders()
```
Returns the response headers that were returned.

### getBody()
```php
public string getBody()
```
Returns the raw, unparsed body of the response as a string.

### getDecodedBody()
```php
public array getDecodedBody()
```
Returns the parsed body of the response as an array.

### getAppSecretProof()
```php
public string getAppSecretProof()
```
Returns the original [app secret proof](https://developers.facebook.com/docs/graph-api/securing-requests/#appsecret_proof) that was used with the original request.

### getETag()
```php
public string getETag()
```
Returns the `ETag` response header if it exists. If the header does not exist in the response headers, `null` will be returned instead.

### getGraphVersion()
```php
public string getGraphVersion()
```
Returns the Graph version that was used by returning the value from the `Facebook-API-Version` response header if it exists. If the header does not exist in the response headers, `null` will be returned instead.

### isError()
```php
public boolean isError()
```
If the Graph API returned an error response `isError()` will return `true`. If a successful response was returned, `isError()` will return `false`.

### throwException()
```php
public throwException()
```
Throws the [`Facebook\Exceptions\FacebookResponseException`](FacebookResponseException.md) that was generated by an error response from Graph.

### getThrownException()
```php
public Facebook\Exceptions\FacebookResponseException getThrownException()
```
Returns the [`Facebook\Exceptions\FacebookResponseException`](FacebookResponseException.md) that was generated by an error response from Graph. This is mainly useful for dealing with [responses to batch requests](FacebookBatchResponse.md).

### getGraphNode()
```php
public Facebook\GraphNodes\GraphNode getGraphNode()
```
Returns the response data in the form of a [`Facebook\GraphNodes\GraphNode`](GraphNode.md) collection.

### getGraphAlbum()
```php
public Facebook\GraphNodes\GraphAlbum getGraphAlbum()
```
Returns the response data in the form of a [`Facebook\GraphNodes\GraphAlbum`](GraphNode.md#graphalbum-instance-methods) collection.

### getGraphPage()
```php
public Facebook\GraphNodes\GraphPage getGraphPage()
```
Returns the response data in the form of a [`Facebook\GraphNodes\GraphPage`](GraphNode.md#graphpage-instance-methods) collection.

### getGraphSessionInfo()
```php
public Facebook\GraphNodes\GraphSessionInfo getGraphSessionInfo()
```
Returns the response data in the form of a [`Facebook\GraphNodes\GraphSessionInfo`](GraphNode.md) collection.

### getGraphUser()
```php
public Facebook\GraphNodes\GraphUser getGraphUser()
```
Returns the response data in the form of a [`Facebook\GraphNodes\GraphUser`](GraphNode.md#graphuser-instance-methods) collection.

### getGraphEdge()
```php
public Facebook\GraphNodes\GraphEdge getGraphEdge(
	string|null $subclassName,
	boolean $auto_prefix)
```
Returns the response data in the form of a [`Facebook\GraphNodes\GraphEdge`](GraphEdge.md) collection.

`$subclassName`
The `Facebook\GraphNodes\GraphNode` subclass to cast list items to. If none is provided, default is `Facebook\GraphNodes\GraphNode`.

`$auto_prefix`
Toggle to auto-prefix the subclass name. If none is provided, default is `true`.

```php
$res = $fb->get('/{facebook-page}/events', '{access-token}');
$events = $res->getGraphEdge("GraphEvent");
foreach ($events as $event) {
	// . . .
}
```
