<?php
// Include the autoloader provided in the SDK
require_once __DIR__ . '/vendor/autoload.php'; // change path as needed

// Include required libraries
use Abraham\TwitterOAuth\TwitterOAuth;

/*
 * Configuration and setup Twitter SDK
 */
$is_socialboard_twitter_error = 0;
$consumer_api_key = $socialboard_twitter_consumer_api_key; //Twitter Consumer Key
$consumer_api_secret_key = $socialboard_twitter_consumer_api_secret_key; //Twitter Consumer Secret Key
$api_access_token = $socialboard_twitter_api_access_token; //Twitter App Access Token
$api_access_token_secret = $socialboard_twitter_api_access_token_secret; //Twitter App Access Token Secret
$socialboard_twitter_url = "https://twitter.com";
$socialboard_twitter_callback_module = getSession("app_module_name");
$socialboard_twitter_callback_url = ZBPATH."socialboard/$socialboard_twitter_callback_module/twitter/callback"; //Twitter Callback URL

/*Check Twitter Object*/
$socialboard_twitter_object = new TwitterOAuth($consumer_api_key, $consumer_api_secret_key);
$socialboard_twitter_object_exists = false;
if ( isset( $socialboard_twitter_object ) and ! is_null( $socialboard_twitter_object ) ){$socialboard_twitter_object_exists = true;}

if($socialboard_twitter_object_exists)
{ 
	// Try to get access token
	try {
		if(!empty($socialboard_twitter_access_token_saved_value)){
			$socialboard_twitter_access_token = unserialize($socialboard_twitter_access_token_saved_value);//printArray($socialboard_twitter_access_token);
		}else{
			if(!empty($socialboard_twitter_oauth_token) && !empty($socialboard_twitter_oauth_verifier) && ($socialboard_twitter_oauth_token == getSession('socialboard_twitter_request_oauth_token')))
			{
				/*Connect Twitter with application token*/
				$connection = new TwitterOAuth($consumer_api_key,$consumer_api_secret_key,getSession('socialboard_twitter_request_oauth_token'),getSession('socialboard_twitter_request_oauth_token_secret'));
				
				/*Get Twitter access token*/
				try {
					$socialboard_twitter_access_token = $connection->oauth("oauth/access_token", array("oauth_verifier" => $socialboard_twitter_oauth_verifier));
				} catch(Exception  $e) {
					$is_socialboard_twitter_error = 1;
					$socialboard_twitter_error = 'Twitter returned an error: ' . $e->getMessage();
				}
			}
		}
		
		if(empty($socialboard_twitter_access_token))
		{
			/*Create Twitter OAuth Object*/
			$twitteroauth = $socialboard_twitter_object;//printArray($twitteroauth);
			
			try {
				/*Get Twitter request token of application*/
				$request_token = $twitteroauth->oauth('oauth/request_token', array('oauth_callback' => $socialboard_twitter_callback_url));

				/*Throw Twitter exception if something gone wrong*/
				try {
					if($twitteroauth->getLastHttpCode() != 200) {
						throw new \Exception('Please try again if you can not connect with Twitter <br>OR<br> '.$verbiage_contact_to_support);
					}
				} catch(Exception  $e) {
					$is_socialboard_twitter_error = 1;
					$socialboard_twitter_error = 'Twitter returned an error: ' . $e->getMessage();
				}
				 
				/*Save Twitter request token of application to session*/
				setSession('socialboard_twitter_request_oauth_token',$request_token['oauth_token']);
				setSession('socialboard_twitter_request_oauth_token_secret',$request_token['oauth_token_secret']);
				
				try {
					/*Generate the Twitter URL to make request to authorize our application*/
					$socialboard_twitter_login_url = $twitteroauth->url('oauth/authorize', array('oauth_token' => $request_token['oauth_token']));
				} catch(Exception  $e) {
					$is_socialboard_twitter_error = 1;
					$socialboard_twitter_error = 'Twitter returned an error: ' . $e->getMessage();
				}
			} catch(Exception  $e) {
				$is_socialboard_twitter_error = 1;
				$socialboard_twitter_error = 'Twitter returned an error: ' . $e->getMessage();
			}
		}
		else
		{
			/*Create Twitter Object*/
			$twitter = new TwitterOAuth($consumer_api_key,$consumer_api_secret_key,$socialboard_twitter_access_token['oauth_token'],$socialboard_twitter_access_token['oauth_token_secret']);
			/*$twitter_user_profile = $twitter->get('account/verify_credentials', array('tweet_mode' => 'extended', 'include_entities' => 'true', 'include_email' => 'true'));
			$twitter_user_profile = convertStdObjtoArray($twitter_user_profile);
			printArray($twitter_user_profile);*/
		}
	} catch(Exception  $e) {
		$is_socialboard_twitter_error = 1;
		$socialboard_twitter_error = 'Twitter returned an error: ' . $e->getMessage();
	} 
}
else
{
	$is_socialboard_twitter_error = 1;
	$socialboard_twitter_error = 'Please try again if you can not connect with Twitter <br>OR<br> '.$verbiage_contact_to_support;
}
?>