<?php
/*Function to Paypal HTTP Post*/
function PayPalHTTPPost($params) 
{
	/*Merchant Credentials*/
	$paypal_environment = $params['paypal_environment'];  //live or sandbox 
	$paypal_username = $params['paypal_username'];			//paypal api username
	$paypal_password = $params['paypal_password']; 			//paypal api password
	$paypal_signature = $params['paypal_signature'];	      //paypal api signature
	
	$nvp_string = $params['nvp_string'];
	$nvp_method = $params['nvp_method'];

	if ($paypal_environment == 'live')
	$subenvi = '';
	else
	$subenvi = $paypal_environment.'.';

	$API_Endpoint = 'https://api-3t.'.$subenvi.'paypal.com/nvp';
	$version = urlencode('86.0'); 								//paypal version

	// Set the curl parameters.
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $API_Endpoint);
	curl_setopt($ch, CURLOPT_VERBOSE, 1);

	// Turn off the server and peer verification (TrustManager Concept).
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);

	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);

	// Set the API operation, version, and API signature in the request.
	$nvpreq = "METHOD=$nvp_method&VERSION=$version&USER=$paypal_username&PWD=$paypal_password&SIGNATURE=$paypal_signature$nvp_string";

	// Set the request as a POST FIELD for curl.
	curl_setopt($ch, CURLOPT_POSTFIELDS, $nvpreq);

	// Get response from the server.
	$httpResponse = curl_exec($ch);

	$paypal_error = 0;
	if(!$httpResponse) {
		//exit("$methodName_ failed: ".curl_error($ch).'('.curl_errno($ch).')');
		$paypal_error = 1;
		$paypal_response = "$methodName_ failed: ".curl_error($ch).'('.curl_errno($ch).')';
	}

	//Extract the response details.
	$httpResponseAr = explode("&", $httpResponse);

	$httpParsedResponseAr = array();
	foreach ($httpResponseAr as $i => $value) {
		$tmpAr = explode("=", $value);
		if(sizeof($tmpAr) > 1) {
			$httpParsedResponseAr[$tmpAr[0]] = $tmpAr[1];
		}
	}
	
	$paypal_response = $httpParsedResponseAr;

	if((0 == sizeof($httpParsedResponseAr)) || !array_key_exists('ACK', $httpParsedResponseAr)) {
		$paypal_error = 1;
		//exit("Invalid HTTP Response for POST request($nvpreq) to $API_Endpoint.");
		$paypal_response = "Invalid HTTP Response for POST request($nvpreq) to $API_Endpoint";
	}
	//print_r($httpParsedResponseAr);exit();
	//return $httpParsedResponseAr;
	if($httpParsedResponseAr["ACK"] == 'Failure'){$paypal_error = 1;}
	
	
	$responseArray = array();
	$responseArray['PP_Error'] = $paypal_error;
	$responseArray['PP_Response'] = $paypal_response;
	
	return $responseArray;

} // end function

/*Function to Paypal HTTP Post*/
function CheckPayPalHTTPPostError($result) 
{
	if($result['PP_Response']["L_SEVERITYCODE0"] == 'Error')
	$result_message = "".urldecode($result['PP_Response']["L_LONGMESSAGE0"]);
	elseif($result['PP_Response']["L_SEVERITYCODE1"] == 'Error')
	$result_message = "".urldecode($result['PP_Response']["L_LONGMESSAGE1"]);
	elseif($result['PP_Response']["L_SEVERITYCODE2"] == 'Error')
	$result_message = "".urldecode($result['PP_Response']["L_LONGMESSAGE2"]);
	
	if($result['PP_Response']["L_ERRORCODE0"]==10002)
	$result_message = "".urldecode("Unable to process your request because your API credentials are invalid");
	
	return $result_message;
}

/*Function to Convert CP Recurring Profile Period to Paypal Recurring Profile Period*/
function ConvertCPRPPeriodToPayPalRPPeriod($cp_recurring_profile_period) 
{
	if($cp_recurring_profile_period == 'days')
	$paypal_recurring_profile_converted_period = "Day";
	elseif($cp_recurring_profile_period == 'months')
	$paypal_recurring_profile_converted_period = "Month";
	elseif($cp_recurring_profile_period == 'years')
	$paypal_recurring_profile_converted_period = "Year";
	else
	$paypal_recurring_profile_converted_period = $cp_recurring_profile_period;
	
	return $paypal_recurring_profile_converted_period;
}

/*Function to Convert Paypal Recurring Profile Period to CP Recurring Profile Period*/
function ConvertPayPalRPPeriodToCPRPPeriod($paypal_recurring_profile_period) 
{
	if($paypal_recurring_profile_period == 'Day')
	$cp_recurring_profile_converted_period = "days";
	elseif($paypal_recurring_profile_period == 'Month')
	$cp_recurring_profile_converted_period = "months";
	elseif($paypal_recurring_profile_period == 'Year')
	$cp_recurring_profile_converted_period = "years";
	else
	$cp_recurring_profile_converted_period = $paypal_recurring_profile_period;
	
	return $cp_recurring_profile_converted_period;
}

/*Function to Convert Paypal Recurring Profile Status to CP Recurring Profile Status*/
function ConvertPayPalRPStatusToCPRPStatus($paypal_recurring_profile_status) 
{
	if($paypal_recurring_profile_status == 'Active' || $paypal_recurring_profile_status == 'ActiveProfile')
	$paypal_recurring_profile_converted_status = "active";
	elseif($paypal_recurring_profile_status == 'Pending' || $paypal_recurring_profile_status == 'PendingProfile')
	$paypal_recurring_profile_converted_status = "pending";
	elseif($paypal_recurring_profile_status == 'Expired' || $paypal_recurring_profile_status == 'ExpiredProfile')
	$paypal_recurring_profile_converted_status = "expired";
	elseif($paypal_recurring_profile_status == 'Suspended' || $paypal_recurring_profile_status == 'SuspendedProfile')
	$paypal_recurring_profile_converted_status = "suspended";
	elseif($paypal_recurring_profile_status == 'Cancelled' || $paypal_recurring_profile_status == 'CancelledProfile')
	$paypal_recurring_profile_converted_status = "canceled";
	else
	$paypal_recurring_profile_converted_status = $paypal_recurring_profile_status;
	
	return $paypal_recurring_profile_converted_status;
}
 
/*Function to Get Recurring Payment Due Date*/
function GetRecurringPaymentDueDate($payment_plan_period,$payment_plan_frequency) 
{
	/*if($payment_plan_period == "days")
	{
		$payment_due_date = formatedTimeStamp("Y-m-d", generateTimeStamp(formatedDateTime("s"),formatedDateTime("i"),formatedDateTime("H"), formatedDateTime("m"), formatedDateTime("d")+$payment_plan_frequency, formatedDateTime("Y")));
	}
	elseif($payment_plan_period == "months")
	{
		$payment_due_date = formatedTimeStamp("Y-m-d", generateTimeStamp(formatedDateTime("s"),formatedDateTime("i"),formatedDateTime("H"), formatedDateTime("m")+$payment_plan_frequency, formatedDateTime("d"), formatedDateTime("Y")));
	}
	elseif($payment_plan_period == "years")
	{
		$payment_due_date = formatedTimeStamp("Y-m-d", generateTimeStamp(formatedDateTime("s"),formatedDateTime("i"),formatedDateTime("H"), formatedDateTime("m"), formatedDateTime("d"), formatedDateTime("Y")+$payment_plan_frequency));
	}
	else
	{
		$payment_due_date = formatedTimeStamp("Y-m-d", generateTimeStamp(formatedDateTime("s"),formatedDateTime("i"),formatedDateTime("H"), formatedDateTime("m"), formatedDateTime("d"), formatedDateTime("Y")));
	}*/
	/*if($payment_plan_period == "days")
	{
		$payment_due_date = formatedTimeStamp("Y-m-d", stringToTimeStamp(currentDate()."+$payment_plan_frequency day"));
	}
	elseif($payment_plan_period == "months")
	{
		$payment_due_date = formatedTimeStamp("Y-m-d", stringToTimeStamp(currentDate()."+$payment_plan_frequency month"));
	}
	elseif($payment_plan_period == "years")
	{
		$payment_due_date = formatedTimeStamp("Y-m-d", stringToTimeStamp(currentDate()."+$payment_plan_frequency year"));
	}
	else
	{
		$payment_due_date = formatedTimeStamp("Y-m-d", stringToTimeStamp(currentDate()));
	}*/
	/*$date = currentDate();
	if($payment_plan_period == "days")
	{
		$date_string = $date."+$payment_plan_frequency day";
	}
	elseif($payment_plan_period == "months")
	{
		$date_string = $date."+$payment_plan_frequency month";
	}
	elseif($payment_plan_period == "years")
	{
		$date_string = $date."+$payment_plan_frequency year";
	}
	else
	{
		$date_string = $date;
	}*/
	//$date_string = currentDate()."+$payment_plan_frequency $payment_plan_period";
	// echo "payment_plan_frequency  ".$payment_plan_frequency;
	// echo "payment_plan_period  ".$payment_plan_period;
	// echo changeDateTime("Y-m-d",currentDate()."+$payment_plan_frequency $payment_plan_period");
	// echo "currentDate   ".currentDate()."<br>";

	return changeDateTime("Y-m-d",currentDate()."+$payment_plan_frequency $payment_plan_period");
}

/*Function to Get Recurring Payment Due Amount*/
function GetRecurringPaymentDueAmount($to,$from,$payment_plan_amount,$payment_plan_period,$payment_plan_frequency) 
{
	$payment_due_amount = array();
	$payment_overdue_days = daysBetweenDates($to, $from);
	if($payment_plan_period == "days")
	{
		$payment_plan_period_days = 1;
		$payment_due_amount_periods = ($payment_plan_amount*($payment_overdue_days/$payment_plan_frequency));
	}
	elseif($payment_plan_period == "months")
	{
		$payment_plan_period_days = 30;
		$payment_overdue_months = monthsBetweenDates($to, $from);
		$payment_due_amount_periods = ($payment_plan_amount*($payment_overdue_months/$payment_plan_frequency));
	}
	elseif($payment_plan_period == "years")
	{
		$payment_plan_period_days = 365;
		$payment_overdue_years = yearsBetweenDates($to, $from);
		$payment_due_amount_periods = ($payment_plan_amount*($payment_overdue_years/$payment_plan_frequency));
	}
	else
	{
		$payment_plan_period_days = 1;
		$payment_due_amount_periods = ($payment_plan_amount*($payment_overdue_days/$payment_plan_frequency));
	}
	$payment_due_amount_days = ($payment_plan_amount/($payment_plan_period_days*$payment_plan_frequency))*$payment_overdue_days;
	$payment_due_amount['days'] = $payment_due_amount_days;
	$payment_due_amount['periods'] = $payment_due_amount_periods;
	return $payment_due_amount;
}

/*Process Customer Paywall Payment Email*/
function processCustomerPaywallPaymentEmail($email_subject,$email_message_html,$customer)
{
	$customer_email = $customer['user']['email_address'];  
	$customer_name = $customer['user']['firstname']."&nbsp;".$customer['user']['firstname'];
	$emaildataArray = array();
	$emaildataArray["is_smtp"] = true;
	$emaildataArray["from_email"] = FROM_EMAIL;
	$emaildataArray["from_name"] = FROM_NAME;
	$emaildataArray["to_email"] = $customer_email;
	$emaildataArray["to_name"] = $customer_name;
	$emaildataArray["email_subject"] = $email_subject;
	$emaildataArray["email_message_html"] = $email_message_html;
	$email_status = ZentroveEmail($emaildataArray);
	return $email_status;
}

/*Customer Paywall Payment Declined Email Content*/
function customerPaywallPaymentDeclinedEmail($customer)
{
	$email_subject = "Payment Declined Email";
	$customer_name = $customer['user']['firstname'];  
	$customer_email = $customer['user']['email_address'];  
	
	$email_message_html='<table width="800" border="0" style="font-family:Arial, Helvetica, sans-serif;font-size:12px;font-weight:normal">';
	if(!empty($customer_name))
	{
	$email_message_html.='
	  <tr>
		<td height="20" style="font-family:Arial, Helvetica, sans-serif;font-size:14px;font-weight:normal">Dear&nbsp;'.$customer_name.',</td>
	  </tr>
	  <tr><td height="10" ></td></tr>';
	}
	$email_message_html.='
	  <tr>
		<td>This is to notify you that the card on file (or PayPal, whichever is being used) was declined. Please update the payment information in your account as soon as you can.</td>
	  </tr>
	  <tr><td height="5" ></td></tr>
	  <tr>
		<td>To update your payment information simply log in to your Wrkmash account and go to settings (top right corner of your account Dashboard). From there go to the profile tab and update the payment information.</td>
	  </tr>
	  <tr><td height="5" ></td></tr>
	  <tr>
		<td>Sincerely,</td>
	  </tr>
	</table>';
	
	$email_message_html.='<br>&nbsp;'.APPLICATION_NAME.' Account Team<br>&nbsp;<a href="mailto:'.SUPPORT_EMAIL.'">'.SUPPORT_EMAIL.'</a><br>&nbsp;<a href="'.DOMAIN.'">'.APPLICATION_DOMAIN.'</a><br>';
	
	return processCustomerPaywallPaymentEmail($email_subject,$email_message_html,$customer);
}

/*Customer Paywall Payment Card About to Expiry Email Content*/
function customerPaywallPaymentCardAboutExpireEmail_bk($customer)
{
	$email_subject = "Card about to expire";
	$customer_name = $customer['user']['firstname'];  
	$customer_email = $customer['user']['email_address'];    
	
	$email_message_html='<table width="800" border="0" style="font-family:Arial, Helvetica, sans-serif;font-size:12px;font-weight:normal">';
	if(!empty($customer_name))
	{
	$email_message_html.='
	  <tr>
		<td height="20" style="font-family:Arial, Helvetica, sans-serif;font-size:14px;font-weight:normal">Dear&nbsp;'.$customer_name.',</td>
	  </tr>
	  <tr><td height="10" ></td></tr>';
	}
	$email_message_html.='
	  <tr>
		<td>We are contacting to let you know that the Credit Card saved on your Wrkmash account is about to expire. Please update the information with a new payment source to avoid any interruption in your Wrkmash service.</td>
	  </tr>
	  <tr><td height="5" ></td></tr>
	  <tr>
		<td>To update your payment information simply log in to your Wrkmash account and go to settings (top right corner of your account Dashboard). From there go to the profile tab and update the payment information.</td>
	  </tr>
	  <tr><td height="5" ></td></tr>
	  <tr>
		<td>Thank you for using Wrkmash for your business.</td>
	  </tr>
	</table>';
	
	$email_message_html.='<br>&nbsp;'.APPLICATION_NAME.' Account Team<br>&nbsp;<a href="mailto:'.SUPPORT_EMAIL.'">'.SUPPORT_EMAIL.'</a><br>&nbsp;<a href="'.DOMAIN.'">'.APPLICATION_DOMAIN.'</a><br>';
	
	return processCustomerPaywallPaymentEmail($email_subject,$email_message_html,$customer);
}

/*Customer Paywall Payment Card About to Expiry Email Content*/
function customerPaywallPaymentCardAboutExpireEmail($customer)
{
	$email_subject = "Card about to expire";
	$customer_name = $customer['user']['firstname'];  
	$customer_email = $customer['user']['email_address'];    
	
	$email_message_html='<table width="800" border="0" style="font-family:Arial, Helvetica, sans-serif;font-size:12px;font-weight:normal">';
	if(!empty($customer_name))
	{
	$email_message_html.='
	  <tr>
		<td height="20" style="font-family:Arial, Helvetica, sans-serif;font-size:14px;font-weight:normal">Dear&nbsp;'.$customer_name.',</td>
	  </tr>
	  <tr><td height="10" ></td></tr>';
	}
	$email_message_html.='
	  <tr>
		<td>Your credit card on file with us is expiring on '.date('D, d F Y',strtotime($customer['payment_creditcard_expiry'])).'. To avoid any interruption in service please update your payment information before '.date('D, d F Y',strtotime($customer['payment_creditcard_expiry'])).'.</td>
	  </tr>
	  <tr><td height="5" ></td></tr>
	  <tr>
		<td>To do so, please log in to your Wrkmash account and go to settings (top right corner of your account Dashboard). From there go to the profile tab and update the payment information.</td>
	  </tr>
	  <tr><td height="5" ></td></tr>
	  <tr>
		<td>Please feel free to contact us with any questions you may have.</td>
	  </tr>
	</table>';
	
	$email_message_html.='<br>&nbsp;'.APPLICATION_NAME.' Support<br>&nbsp;<a href="mailto:'.SUPPORT_EMAIL.'">'.SUPPORT_EMAIL.'</a><br>&nbsp;<a href="'.DOMAIN.'">'.APPLICATION_DOMAIN.'</a><br>';
	
	return processCustomerPaywallPaymentEmail($email_subject,$email_message_html,$customer);
}


/*Customer Paywall Payment Card After Expired Email Content*/
function customerPaywallPaymentCardExpiredEmail_bk($customer)
{
	$email_subject = "Card Expired";
	$customer_name = $customer['user']['firstname'];  
	$customer_email = $customer['user']['email_address'];  
	
	$email_message_html='<table width="800" border="0" style="font-family:Arial, Helvetica, sans-serif;font-size:12px;font-weight:normal">';
	if(!empty($customer_name))
	{
	$email_message_html.='
	  <tr>
		<td height="20" style="font-family:Arial, Helvetica, sans-serif;font-size:14px;font-weight:normal">Dear&nbsp;'.$customer_name.',</td>
	  </tr>
	  <tr><td height="10" ></td></tr>';
	}
	$email_message_html.='
	  <tr>
		<td>Your credit card on file for your Wrkmash account has expired. This means that we cannot charge it for your Wrkmash account. Please update the payment information as soon as possible to avoid interruption in service.</td>
	  </tr>
	  <tr><td height="5" ></td></tr>
	  <tr>
		<td>To update your payment information simply log in to your Wrkmash account and go to settings (top right corner of your account Dashboard). From there go to the profile tab and update the payment information.</td>
	  </tr>
	  <tr><td height="5" ></td></tr>
	  <tr>
		<td>Thank you for using Wrkmash for your business.</td>
	  </tr>
	</table>';
	
	$email_message_html.='<br>&nbsp;'.APPLICATION_NAME.' Account Team<br>&nbsp;<a href="mailto:'.SUPPORT_EMAIL.'">'.SUPPORT_EMAIL.'</a><br>&nbsp;<a href="'.DOMAIN.'">'.APPLICATION_DOMAIN.'</a><br>';
	
	return processCustomerPaywallPaymentEmail($email_subject,$email_message_html,$customer);
}


/*Customer Paywall Payment Card After Expired Email Content*/
function customerPaywallPaymentCardExpiredEmail($customer)
{
	$email_subject = "Card Expired";
	$customer_name = $customer['user']['firstname'];  
	$customer_email = $customer['user']['email_address'];  
	
	$email_message_html='<table width="800" border="0" style="font-family:Arial, Helvetica, sans-serif;font-size:12px;font-weight:normal">';
	if(!empty($customer_name))
	{
	$email_message_html.='
	  <tr>
		<td height="20" style="font-family:Arial, Helvetica, sans-serif;font-size:14px;font-weight:normal">Dear&nbsp;'.$customer_name.',</td>
	  </tr>
	  <tr><td height="10" ></td></tr>';
	}
	$email_message_html.='
	  <tr>
		<td>Your credit card on file with us has expired on '.date('D, d F Y',strtotime($customer['payment_creditcard_expiry'])).'. To avoid any interruption in service please update your payment information before '.$customer['payment_due_date'].'.</td>
	  </tr>
	  <tr><td height="5" ></td></tr>
	  <tr>
		<td>To do so, please log in to your Wrkmash account and go to settings (top right corner of your account Dashboard). From there go to the profile tab and update the payment information.</td>
	  </tr>
	  <tr><td height="5" ></td></tr>
	  <tr>
		<td>Please feel free to contact us with any questions you may have.</td>
	  </tr>
	</table>';
	
	$email_message_html.='<br>&nbsp;'.APPLICATION_NAME.' Account Support<br>&nbsp;<a href="mailto:'.SUPPORT_EMAIL.'">'.SUPPORT_EMAIL.'</a><br>&nbsp;<a href="'.DOMAIN.'">'.APPLICATION_DOMAIN.'</a><br>';
	
	return processCustomerPaywallPaymentEmail($email_subject,$email_message_html,$customer);
}

/*Customer Paywall Payment Service Suspension Warning Email Content*/
function customerPaywallPaymentServiceSuspensionWarningEmail($customer)
{
	$email_subject = "Service Suspension Warning";
	$customer_name = $customer['user']['firstname'];  
	$customer_email = $customer['user']['email_address'];  
	
	$email_message_html='<table width="800" border="0" style="font-family:Arial, Helvetica, sans-serif;font-size:12px;font-weight:normal">';
	if(!empty($customer_name))
	{
	$email_message_html.='
	  <tr>
		<td height="20" style="font-family:Arial, Helvetica, sans-serif;font-size:14px;font-weight:normal">Dear&nbsp;'.$customer_name.',</td>
	  </tr>
	  <tr><td height="10" ></td></tr>';
	}
	$email_message_html.='
	  <tr>
		<td>Your credit card on file for your Wrkmash account has been expired and because of that we are unable to process your payment. Since we have not been able to receive a payment on this account, we will have to suspend the account if a payment is not received in the next five days.</td>
	  </tr>
	  <tr><td height="5" ></td></tr>
	  <tr>
		<td>To update your payment information simply log in to your Wrkmash account and go to settings (top right corner of your account Dashboard). From there go to the profile tab and update the payment information.</td>
	  </tr>
	  <tr><td height="5" ></td></tr>
	  <tr>
		<td>Thank you for using Wrkmash for your business.</td>
	  </tr>
	</table>';
	
	$email_message_html.='<br>&nbsp;'.APPLICATION_NAME.' Account Team<br>&nbsp;<a href="mailto:'.SUPPORT_EMAIL.'">'.SUPPORT_EMAIL.'</a><br>&nbsp;<a href="'.DOMAIN.'">'.APPLICATION_DOMAIN.'</a><br>';
	
	return processCustomerPaywallPaymentEmail($email_subject,$email_message_html,$customer);
}

/*Customer Paywall Payment Service Suspension Email Content*/
function customerPaywallPaymentServiceSuspensionEmail($customer)
{
	$email_subject = "Service Suspension";
	$customer_name = $customer['user']['firstname'];  
	$customer_email = $customer['user']['email_address'];  
	
	$email_message_html='<table width="800" border="0" style="font-family:Arial, Helvetica, sans-serif;font-size:12px;font-weight:normal">';
	if(!empty($customer_name))
	{
	$email_message_html.='
	  <tr>
		<td height="20" style="font-family:Arial, Helvetica, sans-serif;font-size:14px;font-weight:normal">Dear&nbsp;'.$customer_name.',</td>
	  </tr>
	  <tr><td height="10" ></td></tr>';
	}
	$email_message_html.='
	  <tr>
		<td>This is to notify you that your Wkrmash account has been suspended due to non payment. We&rsquo;ve tried to contact you a few times about it, but the payment information has not been updated, so we have no choice but to suspend the account.</td>
	  </tr>
	  <tr><td height="5" ></td></tr>
	  <tr>
		<td>To update your payment information simply log in to your Wrkmash account, and you will be taken to the profile section where you can enter payment information.</td>
	  </tr>
	  <tr><td height="5" ></td></tr>
	  <tr>
		<td>We hope to continue to be your partner in the success of your business. Please update the payment information as soon as you can so as not to lose any of your business data.</td>
	  </tr>
	</table>';
	
	$email_message_html.='<br>&nbsp;'.APPLICATION_NAME.' Account Team<br>&nbsp;<a href="mailto:'.SUPPORT_EMAIL.'">'.SUPPORT_EMAIL.'</a><br>&nbsp;<a href="'.DOMAIN.'">'.APPLICATION_DOMAIN.'</a><br>';
	
	return processCustomerPaywallPaymentEmail($email_subject,$email_message_html,$customer);
}

/*Customer Paywall Payment Account Deletion Notice Email Content*/
function customerPaywallPaymentAccountDeletionNoticeEmail($customer)
{
	$email_subject = "Account Deletion Notice";
	$customer_name = $customer['user']['firstname'];  
	$customer_email = $customer['user']['email_address'];    
	
	$email_message_html='<table width="800" border="0" style="font-family:Arial, Helvetica, sans-serif;font-size:12px;font-weight:normal">';
	if(!empty($customer_name))
	{
	$email_message_html.='
	  <tr>
		<td height="20" style="font-family:Arial, Helvetica, sans-serif;font-size:14px;font-weight:normal">Dear&nbsp;'.$customer_name.',</td>
	  </tr>
	  <tr><td height="10" ></td></tr>';
	}
	$email_message_html.='
	  <tr>
		<td>This is to notify you that your Wkrmash account has been suspended due to non payment for 45 days. Any account that is not paid for 60 days is deleted from our servers. Please make a payment on your account as soon as possible so you can retain your valuable business data. You have 15 days to do so.</td>
	  </tr>
	  <tr><td height="5" ></td></tr>
	  <tr>
		<td>To update your payment information simply log in to your Wrkmash account, and you will be taken to the profile section where you can enter payment information.</td>
	  </tr>
	  <tr><td height="5" ></td></tr>
	  <tr>
		<td>We hope to continue to be your partner in the success of your business. Please update the payment information as soon as you can so as not to lose any of your business data.</td>
	  </tr>
	</table>';
	
	$email_message_html.='<br>&nbsp;'.APPLICATION_NAME.' Account Team<br>&nbsp;<a href="mailto:'.SUPPORT_EMAIL.'">'.SUPPORT_EMAIL.'</a><br>&nbsp;<a href="'.DOMAIN.'">'.APPLICATION_DOMAIN.'</a><br>';
	
	return processCustomerPaywallPaymentEmail($email_subject,$email_message_html,$customer);
}

/*Customer Paywall Payment Final Account Deletion Notice Email Content*/
function customerPaywallPaymentFinalAccountDeletionNoticeEmail($customer)
{
	setTimeZone("EST");
	$email_subject = "Final Account Deletion Notice";
	$customer_suspension_time = $customer['sts'];  
	$customer_name = $customer['user']['firstname'];  
	$customer_email = $customer['user']['email_address'];  
	$customer_account_deletion_date = changeDateTime("l, F jS, Y",$customer_suspension_time."+60 days");
	$customer_account_deletion_date_and_time = changeDateTime("Y-m-d H:i:s",$customer_suspension_time."+60 days");
	
	$email_message_html='<table width="800" border="0" style="font-family:Arial, Helvetica, sans-serif;font-size:12px;font-weight:normal">';
	if(!empty($customer_name))
	{
	$email_message_html.='
	  <tr>
		<td height="20" style="font-family:Arial, Helvetica, sans-serif;font-size:14px;font-weight:normal">Dear&nbsp;'.$customer_name.',</td>
	  </tr>
	  <tr><td height="10" ></td></tr>';
	}
	$email_message_html.='
	  <tr>
		<td>This is to notify you that your Wkrmash account will be deleted from our servers on '.$customer_account_deletion_date.'. If you&rsquo;d like to activate your account and retain your valuable business data, please make a payment on your account before '.$customer_account_deletion_date_and_time.'.</td>
	  </tr>
	  <tr><td height="5" ></td></tr>
	  <tr>
		<td>To update your payment information simply log in to your Wrkmash account, and you will be taken to the profile section where you can enter payment information.</td>
	  </tr>
	  <tr><td height="5" ></td></tr>
	  <tr>
		<td>We hope to continue to be your partner in the success of your business. Please update the payment information as soon as you can so as not to lose any of your business data.</td>
	  </tr>
	  <tr><td height="5" ></td></tr>
	  <tr>
		<td>This is your final notice before your account gets deleted on '.$customer_account_deletion_date_and_time.'.</td>
	  </tr>
	</table>';
	
	$email_message_html.='<br>&nbsp;'.APPLICATION_NAME.' Account Team<br>&nbsp;<a href="mailto:'.SUPPORT_EMAIL.'">'.SUPPORT_EMAIL.'</a><br>&nbsp;<a href="'.DOMAIN.'">'.APPLICATION_DOMAIN.'</a><br>';
	
	return processCustomerPaywallPaymentEmail($email_subject,$email_message_html,$customer);
}

/*Customer Paywall Payment Failure Notice Email Content*/
function customerPaywallPaymentFailureNoticeEmail($customer,$payment)
{
	setTimeZone("EST");
	$email_subject = "Payment Failure Notice";
	$customer_name = $customer['user']['firstname'];  
	$customer_email = $customer['user']['email_address'];  
	
	$email_message_html='<table width="800" border="0" style="font-family:Arial, Helvetica, sans-serif;font-size:12px;font-weight:normal">';
	if(!empty($customer_name))
	{
	$email_message_html.='
	  <tr>
		<td height="20" style="font-family:Arial, Helvetica, sans-serif;font-size:14px;font-weight:normal">Dear&nbsp;'.$customer_name.',</td>
	  </tr>
	  <tr><td height="10" ></td></tr>';
	}
	$email_message_html.='
	  <tr>
		<td>This is to notify you that your payment on file with us is failed on '.date('D, d F Y',strtotime($payment['date'])).', due to <strong style="color:red;"> "'.$payment['summary'].'"</strong>.  Please update your payment information to avoid account suspension.</td>
	  </tr>
	  <tr><td height="5" ></td></tr>
	  <tr>
		<td>To do so, simply log in to your Wrkmash account, and you will be taken to the profile section where you can enter payment information.</td>
	  </tr>
	  <tr><td height="5" ></td></tr>
	  <tr>
		<td>Please feel free to contact us with any questions you may have.</td>
	  </tr>
	  <tr><td height="5" ></td></tr>
	</table>';
	
	$email_message_html.='<br>&nbsp;'.APPLICATION_NAME.' Support<br>&nbsp;<a href="mailto:'.SUPPORT_EMAIL.'">'.SUPPORT_EMAIL.'</a><br>&nbsp;<a href="'.DOMAIN.'">'.APPLICATION_DOMAIN.'</a><br>';
	
	return processCustomerPaywallPaymentEmail($email_subject,$email_message_html,$customer);
}

require ROOT.'lib/PaymentsAPI/stripe_php_sdk/init.php';
function subscribeWithStripe($stripe_publishable_key,$stripe_secret_key,$stripe_product_id,$stripeToken,$name,$email,$amount)
{
	// $stripe = array(
    //   "secret_key"      => "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",
    //   "publishable_key" => "pk_live_51MzAVvHN5knCLl33L4gB0VoRPTrfMVmQlUj20rIDfef5GBMUz8cM8ElO32xlI2vl3TM8CCzQmNdrZWbTZNIHlMbk00lz44ePRi"
    // );  
	$stripe = array(
		"secret_key"      => $stripe_secret_key,
		"publishable_key" => $stripe_publishable_key
	  );
	      
	 try {

    \Stripe\Stripe::setApiKey($stripe['secret_key']);    
    
	//add customer to stripe
    $customer = \Stripe\Customer::create(array(
		'name' => $name,
		//'description' => 'test description',
        'email' => $email,
        'source'  => $stripeToken,
		// "address" => ["city" => $customerCity, "country" => $customerCountry, "line1" => $customerAddress, "line2" => "", "postal_code" => $customerZipcode, "state" => $customerState]
    ));  

   

    	$subs = \Stripe\Subscription::create(array(
	     'customer' => $customer->id,
		  
		  'items' => [[
		    'price_data' => [
		      'unit_amount' => calculateRealNumber((int)$amount),
		      'currency' => 'usd',
		      'product' => $stripe_product_id,
			  //'product' => 'prod_NrRHWSI2Ucd9yL',
		      'recurring' => [
		        'interval' => 'month',
		      ],
		    ],
		  ]],
		));

		return $subs->id;

	}
	//catch exception
	catch(Exception $e) {
	  return 'ErrorMessage: ' .$e->getMessage();
	}


	
}

function createCustomerWithCreditCardOnStripeForFutureUse($stripe_publishable_key,$stripe_secret_key,$name,$email,$stripeToken)
{
	$stripe = array(
		"secret_key"      => $stripe_secret_key,
		"publishable_key" => $stripe_publishable_key
	  );
	      
	 try {

	    \Stripe\Stripe::setApiKey($stripe['secret_key']);    
	    
		//add customer to stripe
	    $customer = \Stripe\Customer::create(array(
			'name' => $name,
			//'description' => 'test description',
	        'email' => $email,
	        'source'  => $stripeToken,
			// "address" => ["city" => $customerCity, "country" => $customerCountry, "line1" => $customerAddress, "line2" => "", "postal_code" => $customerZipcode, "state" => $customerState]
	    ));  

	    return $customer->id;
    }
	//catch exception
	catch(Exception $e) {
	  return 'ErrorMessage: ' .$e->getMessage();
	}

}

function payWithStripe($stripe_publishable_key,$stripe_secret_key,$stripeToken,$name,$email,$amount,$itemName,$orderNumber)
{
	// echo $amount;
	// exit;
	//live keys
	// $stripe = array(
    //   "secret_key"      => "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",
    //   "publishable_key" => "pk_live_51MzAVvHN5knCLl33L4gB0VoRPTrfMVmQlUj20rIDfef5GBMUz8cM8ElO32xlI2vl3TM8CCzQmNdrZWbTZNIHlMbk00lz44ePRi"
    // );  
	$stripe = array(
		"secret_key"      => $stripe_secret_key,
		"publishable_key" => $stripe_publishable_key
	  );  
	
    \Stripe\Stripe::setApiKey($stripe['secret_key']);    
    
	//add customer to stripe
    $customer = \Stripe\Customer::create(array(
		'name' => $name,
		//'description' => 'test description',
        'email' => $email,
        'source'  => $stripeToken,
		// "address" => ["city" => $customerCity, "country" => $customerCountry, "line1" => $customerAddress, "line2" => "", "postal_code" => $customerZipcode, "state" => $customerState]
    ));  


    $payDetails = \Stripe\Charge::create(array(
        'customer' => $customer->id,
        'amount'   => calculateRealNumber((int)$amount),
        'currency' => 'USD',
        'description' => $itemName,
        'metadata' => array(
            'order_id' => $orderNumber
        )
    ));  

    return $payDetails;
    // ['status']

	// return $subs->id;
}

function calculateRealNumber($amount) {
    return (($amount)*100);
}

function stripe_generate_device_token($token)
{
	require ROOT.'lib/PaymentsAPI/stripe_php_sdk/generate_device_token/vendor/autoload.php';

	\Stripe\Stripe::setApiKey($token);

	$connectionToken = \Stripe\Terminal\ConnectionToken::create();
	// token = # ... Create or retrieve the ConnectionToken
	// print_r($connectionToken);
	// echo json_encode(array('secret' => $connectionToken->secret));
	return $connectionToken->secret;
}

?>