<?php 
$limit = "";
$export_type = $page_array[4];

$today = date("d-m-Y");
$filename = "Summary_Discounts_Report_($today)";
if($export_type=="excel")
{
	$filename = $filename.".xls";
	header('Content-type: application/ms-excel');
	header('Content-Disposition: attachment; filename='.$filename);
}
elseif($export_type=="pdf")
{
	$filename = $filename.".pdf";
	header("Content-type: application/pdf");
	header("Content-Disposition: attachment; filename=".$filename);
	/*header("Pragma: no-cache");
	header("Expires: 0");*/
}
else
{
	include(ZBROOT."pos/pos_reports_summary.php");
}
include(ZBROOT."includes.inc.php"); 
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>

<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<?php /*?><link rel="stylesheet" type="text/css" href="<?php echo PUBDIR?>css/main.css" />
<?php */?>
<?php
$select_duration = $page_array[5];
//echo $date;
$currency_code = $currency_symbol;
include(CLASSES .'POSReports.class.php');
$reportClass = new POSReports();
$tbl_sales_items_temp = TBLPREFIX_OPOS."sales_items_temp";

if($select_duration==1)
{
	$date_title="Today";
	$pos_summary_discount = $reportClass->getDiscountData($condition=" WHERE sale_date = CURDATE() and plateform = 1 GROUP BY $tbl_sales_items_temp.discount_percent ",$orderby=" ORDER BY discount_percent",$limit);
	$sumgraphSales = $reportClass->getSummaryTaxesData($condition=" WHERE sale_date = CURDATE() and plateform = 1 ");
}
elseif($select_duration==2)
{
	$date_title="Yesterday";
	$pos_summary_discount = $reportClass->getDiscountData($condition=" WHERE sale_date = CURDATE() - INTERVAL 1 DAY and plateform = 1 GROUP BY $tbl_sales_items_temp.discount_percent ",$orderby=" ORDER BY discount_percent",$limit);
	$pos_summary_tax_sum = $reportClass->getSummaryTaxesData($condition=" WHERE sale_date = CURDATE() - INTERVAL 1 DAY  and plateform = 1");

}
elseif($select_duration==3)
{

	$date_title="Last Week";
	$pos_summary_discount = $reportClass->getDiscountData($condition=" WHERE sale_date >= CURDATE() - INTERVAL 6 DAY AND sale_date <= CURDATE() and plateform = 1 GROUP BY $tbl_sales_items_temp.discount_percent",$orderby=" ORDER BY discount_percent",$limit);
	$pos_summary_tax_sum = $reportClass->getSummaryTaxesData($condition=" WHERE sale_date >= CURDATE() - INTERVAL 6 DAY AND sale_date <= CURDATE() and plateform = 1 ");

}
elseif($select_duration==4)
{
	$date_title="Last Month";
	$pos_summary_discount = $reportClass->getDiscountData($condition=" WHERE sale_date >= CURDATE() - INTERVAL 30 DAY AND sale_date <= CURDATE() and plateform = 1 GROUP BY $tbl_sales_items_temp.discount_percent",$orderby=" ORDER BY discount_percent",$limit);
	$pos_summary_tax_sum = $reportClass->getSummaryTaxesData($condition=" WHERE sale_date >= CURDATE() - INTERVAL 30 DAY AND sale_date <= CURDATE() and plateform = 1 ");}

elseif($select_duration==5)
{
	$date_title="All Time";	
	$display_chart="block";
	$pos_summary_discount = $reportClass->getDiscountData($condition = " where plateform = 1 ",$orderby="GROUP BY $tbl_sales_items_temp.discount_percent ",$limit);
	$pos_summary_tax_sum = $reportClass->getSummaryTaxesData($condition = " where plateform = 1 ");
}

elseif($select_duration==6)
{
	 
	$report_from_date = $page_array[6];
	$report_to_date = $page_array[7];
	$date_title= $report_from_date."/".$report_to_date;
	$date = $report_from_date."/".$report_to_date;
	$report_from_date = explode("-",$report_from_date);
	$from_date = $report_from_date[2]."-".$report_from_date[1]."-".$report_from_date[0];
	$report_to_date = explode("-",$report_to_date);
	$to_date = $report_to_date[2]."-".$report_to_date[1]."-".$report_to_date[0];
	$where = " WHERE sale_date >= '$from_date' AND sale_date <= '$to_date' and plateform = 1 GROUP BY $tbl_sales_items_temp.discount_percent";
	$sumwhere = " WHERE sale_date >= '$from_date' AND sale_date <= '$to_date' and plateform = 1 ";
	$pos_summary_discount = $reportClass->getDiscountData($where,$orderby=" ORDER BY discount_percent",$limit);
	$pos_summary_tax_sum = $reportClass->getSummaryTaxesData($sumwhere);
	 
}
elseif($select_duration==7)
{
	 $date_title = "This Year ";
	 $pos_summary_discount = $reportClass->getDiscountData($condition=" WHERE YEAR(sale_date) = YEAR(CURDATE())  GROUP BY $tbl_sales_items_temp.discount_percent and plateform = 1",$orderby="ORDER BY discount_percent ",$limit);
     $pos_summary_tax_sum = $reportClass->getSummaryTaxesData($condition=" WHERE YEAR(sale_date) = YEAR(CURDATE()) and plateform = 1 ");
}
elseif($select_duration==8)
{
	 $date_title = "Last Year";
	 $pos_summary_discount = $reportClass->getDiscountData($condition=" WHERE YEAR(sale_date) = YEAR(CURDATE())-1 and plateform = 1  GROUP BY $tbl_sales_items_temp.discount_percent",$orderby="ORDER BY discount_percent ",$limit);
	 $pos_summary_tax_sum = $reportClass->getSummaryTaxesData($condition=" WHERE YEAR(sale_date) = YEAR(CURDATE())-1 and plateform = 1 ");
}
else
{
	$date_title="Today";
	$pos_summary_discount = $reportClass->getDiscountData($condition=" WHERE sale_date = CURDATE() and plateform = 1 GROUP BY $tbl_sales_items_temp.discount_percent ",$orderby=" ORDER BY discount_percent",$limit);
	$pos_summary_tax_sum = $reportClass->getSummaryTaxesData($condition=" WHERE sale_date = CURDATE() and plateform = 1 ");
}

?>
<style>
html,body{margin:0;}
@page {
/*size:9.00in 11.00in;*/
size:3.4in 4.13in;
size:portrait; 
margin:0in; 
mso-header-margin:0in; 
mso-footer-margin:0in; 
mso-paper-source:0;
}
@media print 
{
    .noPrint { display:none;}
    /*a[href]:after {
	  content: none !important;
    }*/
    /*a[href]::after {
	  content: " (" attr(href) ")"
    } 
    .page_break{page-break-before:always; }*/
    /*table { page-break-inside : avoid; }*/
}
.sales_table tr td
{
	color:#000;border-bottom:solid 1px #000000;
	border-left:solid 1px #000000;
	vertical-align:top;
	padding-top:6px;
	vertical-align:middle;
}
#report_summary {
    margin: 0 auto;
    text-align: center;
}
</style>
</head>
<body>
<div style="background-color:#FFF;width:1040px;font-family:calibri;margin-left:auto;margin-right:auto;margin-top:40px;">

  <div style="font-size:36px;text-align:center;text-transform:capitalize;font-family:Arial, Helvetica, sans-serif;">Discounts Summary Report</div>
  <br />
  <div style="font-size:20px;text-align:center;border-bottom:2px solid dashed;"><?=$date_title?></div>
  <br />
          
  <table width="100%" border="0" style="font-size:12px;border:solid 1px #000000;margin:0 auto;" cellpadding="0" cellspacing="0" class="sales_table"> 		
        <thead>
            <tr style="text-transform:uppercase; background-color:#f1f1f1;font-weight:bold;border:solid 1px #cccccc;">
                <td align="center"  colspan="2" width="20%" style="height:40px;color:#000000;border-top:solid 1px #000000;font-size: 18px;">Discount Percent</td>
                <td align="center" colspan="2" width="20%" style="color:#000000;border-top:solid 1px #000000;font-size: 18px;">Count</td>
            </tr>
        </thead>
        <tbody>
         <?php
		 foreach($pos_summary_discount as $summarySale)
		 {
			 
		 ?>
         <tr >
                <td align="center"colspan="2" style="height:40px;font-size: 16px;"><?=numberFormatDsiplay($summarySale['discount_percent'])?></td>
                <td align="center" colspan="2" style="font-size: 16px;"><?=numberFormatDsiplay($summarySale['count'])?></td>
          </tr>
          <?php
		  } 
		  ?>
        </tbody>
  </table>
  <br />
  <div id="report_summary">
    <div style="font-size: 16px;"><strong>Subtotal: </strong><?=$currency_code.numberFormatDsiplay($pos_summary_tax_sum[0]['subtotal'])?></div>
    <div style="font-size: 16px;"><strong>Total: </strong><?=$currency_code.numberFormatDsiplay($pos_summary_tax_sum[0]['total'])?></div>
    <div style="font-size: 16px;"><strong>Tax: </strong><?=numberFormatDsiplay($pos_summary_tax_sum[0]['tax'])?>&nbsp;%</div>
    <div style="font-size: 16px;"><strong>Profit: </strong><?=$currency_code.numberFormatDsiplay($pos_summary_tax_sum[0]['profit'])?></div>
  </div>          
  
         
 <?php /*?><span class="noPrint">
      <div style="clear:both; height:10px"></div>
      <div class="submit"  style="float:left;margin-top:30px; margin-left:auto;margin-right:auto;width:100%;text-align:center" id="submit_button_div">
          <input type="button" onclick="window.print();" name="print_button" id="print_button" value="Print" class="bluebutton" />
      </div>
      <div style="clear:both; height:50px"></div>
 </span><?php */?>
  
  </div>     

</body>
</html>  