<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
/*
	Retrieve value of POST variable(s).
	For $name passed as array $dflt is not used, 
	default values can be passed as values with non-numeric keys instead.
	If some field have user formatted numeric value, pass float default value to
	convert automatically to POSIX.
*/
function get_post($name, $dflt='')
{
	if (is_array($name)) {
		$ret = array();
		foreach($name as $key => $dflt)
			if (!is_numeric($key)) {
				$ret[$key] = is_float($dflt) ? input_num($key, $dflt) : get_post($key, $dflt);
			} else {
				$ret[$dflt] = get_post($dflt, null);
			}
		return $ret;
	} else
		return is_float($dflt) ? input_num($name, $dflt) : 
				((!isset($_POST[$name]) || $_POST[$name] === '') ? $dflt : $_POST[$name]);
}
//---------------------------------------------------------------------------------

function start_form($multi=false, $dummy=false, $action="", $name="")
{
	// $dummy - leaved for compatibility with 2.0 API

	if ($name != "")
		$name = "name='$name'";
	if ($action == "")
		$action = $_SERVER['PHP_SELF'];

	if ($multi)
		echo "<form enctype='multipart/form-data' method='post' action='$action' $name role='form'>\n";
	else
		echo "<form method='post' action='$action' $name role='form'>\n";

}

/*
	Flush hidden fields buffer.
*/
function output_hidden()
{
	global $hidden_fields;

	echo implode('', $hidden_fields);
	$hidden_fields = array();
}
//---------------------------------------------------------------------------------

function end_form($breaks=0)
{
	global $Ajax, $hidden_fields;

	$_SESSION['csrf_token'] = hash('sha256', uniqid(mt_rand(), true));
	if ($breaks)
		br($breaks);
	hidden('_focus');
	hidden('_modified', get_post('_modified', 0));
	hidden('_token', $_SESSION['csrf_token']);
	
	output_hidden();
	echo "</form>\n";
	$Ajax->activate('_token');
}

function check_csrf_token()
{
	if ($_SESSION['csrf_token'] != @$_POST['_token'])
	{
		display_error(_("Request from outside of this page is forbidden."));
		error_log(_("CSRF attack detected from: ").@$_SERVER['HTTP_HOST'].' ('.@$_SERVER['HTTP_REFERER'].')');
		return false;
	}
	return true;
}

function start_table($class=false, $extra="", $padding='2', $spacing='0')
{
	/*Start Wrkmash Changes */
	/*echo "<center><table";
	if ($class == TABLESTYLE_NOBORDER)
		echo " class='tablestyle_noborder'";
	elseif ($class == TABLESTYLE2)
		echo " class='tablestyle2'";
	elseif ($class == TABLESTYLE)
		echo " class='tablestyle'";
	if ($extra != "")
		echo " $extra";
	echo " cellpadding='$padding' cellspacing='$spacing'>\n";*/
	//echo "<div class='row'><div class='col-md-12'>";
	echo "<table";
	if ($class == TABLESTYLE_NOBORDER)
		echo " class='tablestyle_noborder table responsive'";
	elseif ($class == TABLESTYLE2)
		echo " class='tablestyle2 table responsive'";
	elseif ($class == TABLESTYLE)
		echo " class='tablestyle table table-bordered table-striped table-hover footable responsive'";
	/*if ($extra != "")
		echo " $extra";*/
	echo ">\n";
	/*End Wrkmash Changes */
}

function end_table($breaks=0)
{
	/*Start Wrkmash Changes */
	//echo "</table></center>\n";
	echo "</table>";
	//echo "</div></div>\n";
	/*Start Wrkmash Changes */
	output_hidden();
	if ($breaks)
		br($breaks);
}

function start_outer_table($class=false, $extra="", $padding='2', $spacing='0', $br=false)
{
	if ($br)
		br();
	start_table($class, $extra, $padding, $spacing);
	echo "<tr valign=top><td class='valign-center'>\n"; // outer table
}

/*Start Wrkmash Changes */
function start_row_div($extra="")
{
	echo "<div class='row' $extra >\n";
}
/*End Wrkmash Changes */

function table_section($number=1, $width=false)
{
	if ($number > 1)
	{
		echo "</table>\n";
		$width = ($width ? "width='$width'" : "");
		//echo "</td><td class='tableseparator' $width>\n"; // outer table
		echo "</td><td style='border-left:1px solid #cccccc;' $width>\n"; // outer table
	}
	echo "<table class='tablestyle_inner table responsive'>\n";
}

/*Start Wrkmash Changes */
function row_col_div($cols=12,$number=1,$extra="")
{
	if ($number > 1)
	{
		echo 	"</table>\n";
		echo "</div>\n";
		$style = "style='border-left:1px solid #cccccc;'";
	}
	echo "<div class='col-md-$cols col_table_inner' $extra>\n";
	echo 	"<table class='tablestyle_inner table responsive form-horizontal'>\n";
	
}
/*End Wrkmash Changes */	

function end_outer_table($breaks=0, $close_table=true)
{
	if ($close_table)
		echo "</table>\n";
	echo "</td></tr>\n";
	end_table($breaks);
}

/*Start Wrkmash Changes */
function end_row_div()
{
	echo 		"</table>\n";
	echo 	"</div>\n";
	echo "</div>\n";
}
/*End Wrkmash Changes */

/*Start Wrkmash Changes */
function row_div_start()
{
	echo "<div class='row'>";
}

function row_div_end()
{
	echo "</div>";
}
/*End Wrkmash Changes */

/*Start Wrkmash Changes */
function row_col_div_start($col)
{
	echo "<div class='col-md-$col'>";
}

function row_col_div_end()
{
	echo "</div>";
}
/*End Wrkmash Changes */

/*Start Wrkmash Changes */
function form_group_div_start()
{
	echo "<div class='form-group'>";
}

function form_group_div_end()
{
	echo "</div>";
}
/*End Wrkmash Changes */
//
//  outer table spacer
//
function vertical_space($params='')
{
	echo "</td></tr><tr><td valign=center $params class='valign-center'>";
}

function meta_forward($forward_to, $params="")
{
    global $Ajax;
	echo "<meta http-equiv='Refresh' content='0; url=$forward_to?$params'>\n";
	echo "<center><br>" . _("You should automatically be forwarded.");
	echo " " . _("If this does not happen") . " " . "<a href='$forward_to?$params'>" . _("click here") . "</a> " . _("to continue") . ".<br><br></center>\n";
	if ($params !='') $params = '?'.$params;
	$Ajax->redirect($forward_to.$params);
	exit;
}

//-----------------------------------------------------------------------------------
// Find and replace hotkey marker.
// if $clean == true marker is removed and clean label is returned 
// (for use in wiki help system), otherwise result is array of label 
// with underlined hotkey letter and access property string.
//
function access_string($label, $clean=false)
{
	$access = '';
	$slices = array();

	if (preg_match('/(.*)&([a-zA-Z0-9])(.*)/', $label, $slices))	
	{
		$label = $clean ? $slices[1].$slices[2].$slices[3] :
			$slices[1].'<u>'.$slices[2].'</u>'.$slices[3];
		$access = " accesskey='".strtoupper($slices[2])."'";
	}
	
	$label = str_replace( '&&', '&', $label);

	return $clean ? $label : array($label, $access);
}

function hyperlink_back($center=true, $no_menu=true, $type_no=0, $trans_no=0, $final=false)
{
	global $path_to_root;

	/*Start Wrkmash Changes */
	/*if ($center)
		echo "<center>";
	$id = 0;	
	if ($no_menu && $trans_no != 0)
	{
		include_once($path_to_root."/admin/db/attachments_db.inc");
		$id = has_attachment($type_no, $trans_no);
		$attach = get_attachment_string($type_no, $trans_no);
    	echo $attach;	
    }
	$width = ($id != 0 ? "30%" : "20%");	
	start_table(false, "width='$width'");
	start_row();
	if ($no_menu)
	{
		echo "<td align=center><a href='javascript:window.print();'>"._("Print")."</a></td>\n";
	}
	echo "<td align=center><a href='javascript:goBack(".($final ? '-2' : '').");'>".($no_menu ? _("Close") : _("Back"))."</a></td>\n";
	end_row();
	end_table();
	if ($center)
		echo "</center>";
	echo "<br>";*/
	

	$id = 0;	
	/*if ($no_menu && $trans_no != 0)
	{
		include_once($path_to_root."/admin/db/attachments_db.inc");
		$id = has_attachment($type_no, $trans_no);
		//$attach = get_attachment_string($type_no, $trans_no);
		$attach = get_attachment_string(30, 4);
    	echo $attach;	
    }*/
	if ($no_menu)
	{
		echo "<a href='javascript:window.print();'><button type='button' class='btn btn-sm btn-print'><i class='fa fa-print'></i>&nbsp; "._("Print")."</button></a>\n";
	}
	echo "<a href='javascript:goBack(".($final ? '-2' : '').");'><button type='button' class='btn btn-sm btn-back'><i class='fa fa-chevron-circle-left'></i>&nbsp; ".($no_menu ? _("Close") : _("Back"))."</button></a>\n";

	/*End Wrkmash Changes */
}

/*Start Wrkmash Changes */
function attachment_files_list($center=true, $no_menu=true, $type_no=0, $trans_no=0, $final=false)
{
	global $path_to_root;

	$id = 0;	
	if ($no_menu && $trans_no != 0)
	{
		include_once($path_to_root."/admin/db/attachments_db.inc");
		$id = has_attachment($type_no, $trans_no);
		$attach = get_attachment_string($type_no, $trans_no);
		
    	echo $attach;	
    }
}
/*End Wrkmash Changes */

function hyperlink_no_params($target, $label, $center=true)
{
	$id = default_focus();
	$pars = access_string($label);
	if ($target == '')
		$target = $_SERVER['PHP_SELF'];
	if ($center)
		echo "<br><center>";
	echo "<a href='$target' id='$id' $pars[1]>$pars[0]</a>\n";
	if ($center)
		echo "</center>";
}

function hyperlink_no_params_td($target, $label)
{
	echo "<td class='valign-center'>";
	hyperlink_no_params($target, $label);
	echo "</td>\n";
}

function viewer_link($label, $url='', $class='', $id='',  $icon=null)
{
	global $path_to_root;
	
	if ($class != '')
		$class = " class='$class'";

	if ($id != '')
		$class = " id='$id'";

	if ($url != "")
	{
		$pars = access_string($label);
		if (user_graphic_links() && $icon)
			$pars[0] = set_icon($icon, $pars[0]);
		$preview_str = "<a target='_blank' $class $id href='$path_to_root/$url' onclick=\"javascript:openWindow(this.href,this.target); return false;\"$pars[1]>$pars[0]</a>";
	}
	else
		$preview_str = $label;
 return $preview_str;
}

function menu_link($url, $label, $id=null)
{

	$id = default_focus($id);
	$pars = access_string($label);
	return "<a href='$url' class='menu_option' id='$id' $pars[1]>$pars[0]</a>";
}

function submenu_option($title, $url, $id=null)
{
	global $path_to_root;
	display_note(menu_link($path_to_root . $url, $title, $id), 0, 1);
}

function submenu_view($title, $type, $number, $id=null)
{
	display_note(get_trans_view_str($type, $number, $title, false, 'viewlink', $id), 0, 1);
}

function submenu_print($title, $type, $number, $id=null, $email=0, $extra=0)
{
	display_note(print_document_link($number, $title, true, $type, false, 'printlink', $id, $email, $extra), 0, 1);
}
//-----------------------------------------------------------------------------------

function hyperlink_params($target, $label, $params, $center=true)
{
	$id = default_focus();
	
	$pars = access_string($label);
	if ($target == '')
		$target = $_SERVER['PHP_SELF'];
	if ($center)
		echo "<br><center>";
	echo "<a id='$id' href='$target?$params'$pars[1]>$pars[0]</a>\n";
	if ($center)
		echo "</center>";
}

function hyperlink_params_td($target, $label, $params)
{
	echo "<td class='valign-center'>";
	hyperlink_params($target, $label, $params, false);
	echo "</td>\n";
}

//-----------------------------------------------------------------------------------

function hyperlink_params_separate($target, $label, $params, $center=false)
{
	$id = default_focus();

	$pars = access_string($label);
	if ($center)
		echo "<br><center>";
	echo "<a target='_blank' id='$id' href='$target?$params' $pars[1]>$pars[0]</a>\n";
	if ($center)
		echo "</center>";
}

function hyperlink_params_separate_td($target, $label, $params)
{
	echo "<td class='valign-center'>";
	hyperlink_params_separate($target, $label, $params);
	echo "</td>\n";
}

//--------------------------------------------------------------------------------------------------

function alt_table_row_color(&$k, $extra_class=null)
{
	$classes = $extra_class ? array($extra_class) : array();
	if ($k == 1)
	{
		array_push($classes, 'oddrow');
		$k = 0;
	}
	else
	{
		array_push($classes, 'evenrow');
		$k++;
	}
	echo "<tr class='".implode(' ', $classes)." '>\n";
}

function table_section_title($msg, $colspan=2)
{
	/*Start Chnages for Wrkmash*/
	//echo "<tr><td colspan=$colspan class='tableheader'>$msg</td></tr>\n";
	echo "<tr><td colspan=$colspan class='tableheader valign-center'><div class='row'><div class='col-md-12'><h4>$msg</h4></div></div></td></tr>\n";
	/*End Chnages for Wrkmash*/
}

function table_header($labels, $params='')
{
	start_row();
	foreach ($labels as $label)
		labelheader_cell($label, $params);
	end_row();
}
//-----------------------------------------------------------------------------------

function start_row($param="")
{
	if ($param != "")
		echo "<tr $param>\n";
	else
		echo "<tr>\n";
}

function end_row()
{
	echo "</tr>\n";
}

function br($num=1)
{
	for ($i = 0; $i < $num; $i++)
		echo "<br>";
}

$ajax_divs = array();

function div_start($id='', $trigger=null, $non_ajax=false)
{
    global $ajax_divs;

	if ($non_ajax) { // div for non-ajax elements
   		array_push($ajax_divs, array($id, null));
   		echo "<div style='display:none' class='js_only' ".($id !='' ? "id='$id'" : '').">";
	} else { // ajax ready div
   		array_push($ajax_divs, array($id, $trigger===null ? $id : $trigger));
   		echo "<div ". ($id !='' ? "id='$id'" : '').">";
   		ob_start();
	}
}

function div_end()
{
    global $ajax_divs, $Ajax;
	/*Start Wrkmash Changes*/
	output_hidden();
	/*Start Wrkmash Changes*/
    if (count($ajax_divs))
    {
		$div = array_pop($ajax_divs);
		if ($div[1] !== null)
			$Ajax->addUpdate($div[1], $div[0], ob_get_flush());
		echo "</div>";
    }
}

//-----------------------------------------------------------------------------
//	Tabbed area:
// 	$name - prefix for widget internal elements:
//		Nth tab submit name:  {$name}_N
//		div id:	_{$name}_div
//		sel (hidden) name: _{$name}_sel
// $tabs - array of tabs; string: tab title or array(tab_title, enabled_status)

function tabbed_content_start($name, $tabs, $dft='') {
    global $Ajax;

    $selname = '_'.$name.'_sel';
	$div = '_'.$name.'_div';

	$sel = find_submit($name.'_', false);
	if($sel==null)
		$sel = get_post($selname, (string)($dft==='' ? key($tabs) : $dft));

	if ($sel!==@$_POST[$selname])
		$Ajax->activate($name);

	$_POST[$selname] = $sel;

	div_start($name);
	/*Start Wrkmash Changes */
	echo "<div class='row'><div class='col-md-12'>";
	echo "<div class='nav-tabs-custom'>\n";
	/*End Wrkmash Changes */
	/*Start Wrkmash Changes */
	//$str = "<ul class='ajaxtabs' rel='$div'>\n";
	$str = "<ul class='ajaxtabs nav nav-tabs' rel='$div' style='border-top:1px solid #f4f4f4'>\n";
	/*End Wrkmash Changes */
	foreach($tabs as $tab_no => $tab) {
		
		$acc = access_string(is_array($tab) ? $tab[0] : $tab);
		$disabled = (is_array($tab) && !$tab[1])  ? 'disabled ' : '';
		/*Start Wrkmash Changes */
		/*$str .= ( "<li>"
			."<button type='submit' name='{$name}_".$tab_no
			."' class='".((string)$tab_no===$sel ? 'current':'ajaxbutton')."' $acc[1] $disabled>"
			."<span>$acc[0]</span>"
			."</button>\n"
			."</li>\n" );*/
		$str .= "<li class='".((string)$tab_no===$sel ? 'active':'')."'><button type='submit' name='{$name}_".$tab_no
			."' class='".((string)$tab_no===$sel ? 'current':'ajaxbutton')."' $acc[1] $disabled>"
			."<span>$acc[0]</span>"
			."</button>\n</li>";	
		/*End Wrkmash Changes */
	}

	$str .= "</ul>\n";
	/*Start Wrkmash Changes */
	//$str .= "<div class='spaceBox'></div>\n";
	/*End Wrkmash Changes */
	$str .= "<input type='hidden' name='$selname' value='$sel'>\n";
	$str .= "<div class='contentBox tab-content' id='$div'>\n";
	echo $str;
}

function tabbed_content_end() {
	echo "</div>"; // content box (don't change to div_end() unless div_start() is used above)
	/*Start Wrkmash Changes */
	echo "</div>";
	echo "</div>";
	echo "</div>";
	/*End Wrkmash Changes */
	div_end(); // tabs widget
}

function tab_changed($name)
{
	$to = find_submit("{$name}_", false);
	if (!$to) return null;

	return array('from' => $from = get_post("_{$name}_sel"),
		'to' => $to);
}

/* Table editor interfaces. Key is editor type
	0 => url of editor page
	1 => hotkey code
	2 => context help
*/
$popup_editors = array(
	'customer' => array('/sales/manage/customers.php?debtor_no=', 
		113,	_("Customers"), 900, 500),
	'branch' => array('/sales/manage/customer_branches.php?SelectedBranch=', 
		114, _("Branches"), 900, 700),
	'supplier' => array('/purchasing/manage/suppliers.php?supplier_id=', 
		113, _("Suppliers"), 900, 700),
	'item' => array('/inventory/manage/items.php?stock_id=', 
		115, _("Items"), 800, 600)
);
/*
	Bind editors for various selectors.
	$type - type of editor
	$input - name of related input field
	$caller - optional function key code (available values F1-F12: 112-123,
		true: default)
*/
function set_editor($type, $input, $caller=true)
{
	global $path_to_root, $Editors, $popup_editors, $Pagehelp;

	$key = $caller===true ? $popup_editors[$type][1] : $caller;

	$Editors[$key] = array( $path_to_root . $popup_editors[$type][0], $input, 
		$popup_editors[$type][3], $popup_editors[$type][4]);
	
	$help = 'F' . ($key - 111) . ' - ';
	$help .= $popup_editors[$type][2];
	$Pagehelp[] = $help;
}
//------------------------------------------------------------------------------
// Procedures below are now obsolete. Preserved for eventual future use.

/*
	External page call with saving current context.
	$call - url of external page
	$ctx - optional. name of SESSION context object or array of names of POST 
		variables saved on call
*/
function context_call($call, $ctx='')
{
	if (is_array($ctx)) 
	{
		foreach($ctx as $postname)
		{
		 	$context[$postname] = get_post($postname);
		}
	} else 
		$context = isset($_SESSION[$ctx]) ? $_SESSION[$ctx] : null;

	array_unshift($_SESSION['Context'], array('name' => $ctx, 
		'ctx' => $context,
		'caller' => $_SERVER['PHP_SELF'],
		'ret' => array()));
	meta_forward($call);
}
/*
	Restores context after external page call and
	returns array of data passed by external page.
*/
function context_restore()
{
	if ( count($_SESSION['Context'])) {
		if ($_SERVER['PHP_SELF'] == $_SESSION['Context'][0]['caller']) {
			$ctx = array_shift($_SESSION['Context']);
			if ($ctx) {
				if (is_array($ctx['ctx'])) {
					foreach($ctx['ctx'] as $name => $val) 
					{
						$_POST[$name] = $val;
					}
				} else
					if ($ctx['name']!='')
						$_SESSION[$ctx['name']] = $ctx['ctx'];
				return $ctx['ret'];
			}
		}
	}
	return false;
}

/*
	Return to caller page if the page was called from external context.
*/
function context_return($ret)
{
	if ( count($_SESSION['Context'])) {
		$ctx = &$_SESSION['Context'][0];
		$ctx['ret'] = $ret;
		meta_forward( $ctx['caller'] );
	}
}
/*
	Clearing context stack after page cancel.
*/
function context_reset()
{
	$_SESSION['Context'] = array();
}
/*
	Context stack initialization
*/
if (!isset($_SESSION['Context'])) {
		context_reset();
}
/*
	Redirector for selector F4 calls.
	$sel_editors is array of selname=>editor_page
*/
function editor_redirect($sel_editors, $save_fun='') {
	foreach ($sel_editors as $selname=>$editor)
		if (isset($_POST['_'.$selname.'_editor'])) {
			if (function_exists($save_fun))
				$save_fun();
			unset($_POST['_'.$selname.'_editor']);
			context_call($editor, array_keys($_POST));
		}
}
/*
	Return procedure for selector F4 calls
*/
function editor_return($vars, $restore_fun='') {
	if (function_exists($restore_fun))
		$restore_fun();

	if ($ret = context_restore()) {
		foreach ($vars as $postname=>$retname)
			if (isset($ret[$retname])) {
				$_POST[$postname] = $ret[$retname];
				set_focus($postname);
			}
	}
}

function confirm_dialog($submit, $msg) {
	if (find_post($submit)) {
		display_warning($msg);
		br();
		submit_center_first('DialogConfirm', _("Proceed"), '', true);
		submit_center_last('DialogCancel', _("Cancel"), '', 'cancel');
		return 0;
	} else
		return get_post('DialogConfirm', 0);
}

/*
	Block menu/shortcut links during transaction procesing.
*/
function page_processing($msg = false)
{
	global $Ajax;

	if ($msg === true)
		$msg = _('Entered data has not been saved yet.\nDo you want to abandon changes?');

	$js = "_validate._processing=" . (
		$msg ? '\''.strtr($msg, array("\n"=>'\\n')) . '\';' : 'null;');
	if (in_ajax()) {
		$Ajax->addScript(true, $js);
	} else
		add_js_source($js);
}

function page_modified($status = true)
{
	global $Ajax;

	$js = "_validate._modified=" . ($status ? 1:0).';';
	if (in_ajax()) {
		$Ajax->addScript(true, $js);
	} else
		add_js_source($js);
}

?>