<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/

function add_supplier($supp_name, $supp_ref, $address, $supp_address, $gst_no,
	$website, $supp_account_no, $bank_account, $credit_limit, $dimension_id, $dimension2_id, 
	$curr_code, $payment_terms, $payable_account, $purchase_account, $payment_discount_account, 
	$notes, $tax_group_id, $tax_included)
{
	$sql = "INSERT INTO ".TB_PREF."suppliers (supp_name, supp_ref, address, supp_address, gst_no, website,
		supp_account_no, bank_account, credit_limit, dimension_id, dimension2_id, curr_code,
		payment_terms, payable_account, purchase_account, payment_discount_account, notes, 
		tax_group_id, tax_included)
		VALUES (".db_escape($supp_name). ", "
		.db_escape($supp_ref). ", "
		.db_escape($address) . ", "
		.db_escape($supp_address) . ", "
		.db_escape($gst_no). ", "
		.db_escape($website). ", "
		.db_escape($supp_account_no). ", "
		.db_escape($bank_account). ", "
		.db_escape($credit_limit). ", "
		.db_escape($dimension_id). ", "
		.db_escape($dimension2_id). ", "
		.db_escape($curr_code). ", "
		.db_escape($payment_terms). ", "
		.db_escape($payable_account). ", "
		.db_escape($purchase_account). ", "
		.db_escape($payment_discount_account). ", "
		.db_escape($notes). ", "
		.db_escape($tax_group_id). ", "
		.db_escape($tax_included). ")";

	db_query($sql,"The supplier could not be added");
}

function update_supplier($supplier_id, $supp_name, $supp_ref, $address, $supp_address, $gst_no, 
	$website, $supp_account_no, $bank_account, $credit_limit, $dimension_id, $dimension2_id, 
	$curr_code, $payment_terms, $payable_account, $purchase_account, $payment_discount_account, 
	$notes, $tax_group_id, $tax_included)
{
	$sql = "UPDATE ".TB_PREF."suppliers SET supp_name=".db_escape($supp_name) . ",
		supp_ref=".db_escape($supp_ref) . ",
		address=".db_escape($address) . ",
		supp_address=".db_escape($supp_address) . ",
		gst_no=".db_escape($gst_no) . ",
		website=".db_escape($website) . ",
		supp_account_no=".db_escape($supp_account_no) . ",
		bank_account=".db_escape($bank_account) . ",
		credit_limit=".$credit_limit . ",
		dimension_id=".db_escape($dimension_id) . ",
		dimension2_id=".db_escape($dimension2_id) . ",
		curr_code=".db_escape($curr_code).",
		payment_terms=".db_escape($payment_terms) . ",
		payable_account=".db_escape($payable_account) . ",
		purchase_account=".db_escape($purchase_account) . ",
		payment_discount_account=".db_escape($payment_discount_account) . ",
		notes=".db_escape($notes) . ",
		tax_group_id=".db_escape($tax_group_id). ",
		tax_included=".db_escape($tax_included)
		." WHERE supplier_id = ".db_escape($supplier_id);

	db_query($sql,"The supplier could not be updated");
}

function delete_supplier($supplier_id)
{
	$sql="DELETE FROM ".TB_PREF."suppliers WHERE supplier_id=".db_escape($supplier_id);
	db_query($sql,"check failed");
}

function get_supplier_details($supplier_id, $to=null, $all=true)
{

	if ($to == null)
		$todate = date("Y-m-d");
	else
		$todate = date2sql($to);
	$past1 = get_company_pref('past_due_days');
	$past2 = 2 * $past1;
	// removed - supp_trans.alloc from all summations

	if ($all)
    	$value = "(trans.ov_amount + trans.ov_gst + trans.ov_discount)";
    else	
    	$value = "IF (trans.type=".ST_SUPPINVOICE." OR trans.type=".ST_BANKDEPOSIT.",
    		(trans.ov_amount + trans.ov_gst + trans.ov_discount - trans.alloc),
    		(trans.ov_amount + trans.ov_gst + trans.ov_discount + trans.alloc))";
	$due = "IF (trans.type=".ST_SUPPINVOICE." OR trans.type=".ST_SUPPCREDIT.",trans.due_date,trans.tran_date)";
    $sql = "SELECT supp.supp_name, supp.curr_code, ".TB_PREF."payment_terms.terms,

		Sum(IFNULL($value,0)) AS Balance,

		Sum(IF ((TO_DAYS('$todate') - TO_DAYS($due)) > 0,$value,0)) AS Due,
		Sum(IF ((TO_DAYS('$todate') - TO_DAYS($due)) > $past1,$value,0)) AS Overdue1,
		Sum(IF ((TO_DAYS('$todate') - TO_DAYS($due)) > $past2,$value,0)) AS Overdue2,
		supp.credit_limit - Sum(IFNULL(IF(trans.type=".ST_SUPPCREDIT.", -1, 1) 
			* (ov_amount + ov_gst + ov_discount),0)) as cur_credit,
		supp.tax_group_id

		FROM ".TB_PREF."suppliers supp
			 LEFT JOIN ".TB_PREF."supp_trans trans ON supp.supplier_id = trans.supplier_id AND trans.tran_date <= '$todate',
			 ".TB_PREF."payment_terms

		WHERE
			 supp.payment_terms = ".TB_PREF."payment_terms.terms_indicator
			 AND supp.supplier_id = $supplier_id ";
	if (!$all)
		$sql .= "AND ABS(trans.ov_amount + trans.ov_gst + trans.ov_discount) - trans.alloc > ".FLOAT_COMP_DELTA." ";  
	$sql .= "GROUP BY
			  supp.supp_name,
			  ".TB_PREF."payment_terms.terms,
			  ".TB_PREF."payment_terms.days_before_due,
			  ".TB_PREF."payment_terms.day_in_following_month";

    $result = db_query($sql,"The customer details could not be retrieved");
    $supp = db_fetch($result);

    return $supp;
}

function get_supplier($supplier_id)
{
	$sql = "SELECT * FROM ".TB_PREF."suppliers WHERE supplier_id=".db_escape($supplier_id);

	$result = db_query($sql, "could not get supplier");

	return db_fetch($result);
}

function get_supplier_name($supplier_id)
{
	$sql = "SELECT supp_name AS name FROM ".TB_PREF."suppliers WHERE supplier_id=".db_escape($supplier_id);

	$result = db_query($sql, "could not get supplier");

	$row = db_fetch_row($result);

	return $row[0];
}

function get_supplier_accounts($supplier_id)
{
	$sql = "SELECT payable_account,purchase_account,payment_discount_account FROM ".TB_PREF."suppliers WHERE supplier_id=".db_escape($supplier_id);

	$result = db_query($sql, "could not get supplier");

	return db_fetch($result);
}

function get_supplier_contacts($supplier_id, $action=null)
{
	$results = array();
	$res = get_crm_persons('supplier', $action, $supplier_id);
	while($contact = db_fetch($res))
		$results[] = $contact;

	return $results;
}

function get_current_supp_credit($supplier_id)
{
	$suppdet = get_supplier_details($supplier_id);
	return $suppdet['cur_credit'];

}

function is_new_supplier($id)
{
	$tables = array('supp_trans', 'grn_batch', 'purch_orders', 'purch_data');

	return !key_in_foreign_table($id, $tables, 'supplier_id');
}

/*Start Changes for Wrkmash*/
/*Check Supplier Account Number*/
function check_pos_supplier_accountnumber($supplier_id,$account_number)
{
	$sql = "SELECT account_number FROM opos_suppliers WHERE account_number=".db_escape($account_number);
	if(!empty($supplier_id))$sql .= " AND accounting_supplier_id!=".db_escape($supplier_id);
	$result = db_query($sql, "could not get supplier");
	return db_fetch($result);
}
/*Save Data in POS Suppliers and Peoples*/
function add_pos_supplier($accounting_supplier_id,$crm_person_id,$company_name, $account_number,$contact_person,$phone_number,$email,$address_1, $address_2, $comments )
{
	$active = 1;
	if(!empty($contact_person))
	{
		$contact_personArray = explode(" ",$contact_person);
		$first_name = $contact_personArray[0];
		$last_name = ltrim(str_replace($first_name," ",$contact_person));
	}
	else
	{
		$first_name = "";
		$last_name = "";
	}
	
	$sql = "INSERT INTO opos_people (first_name, last_name, phone_number, email, address_1, address_2,active,comments)
		VALUES (".db_escape($first_name). ", "
		.db_escape($last_name) . ", "
		.db_escape($phone_number) . ", "
		.db_escape($email). ", "
		.db_escape($address_1). ", "
		.db_escape($address_2). ", "
		.db_escape($active). ", "
		.db_escape($comments).  ")";
	db_query($sql,"The supplier could not be added");
	$person_id = db_insert_id();
	
	$sql = "UPDATE ".TB_PREF."suppliers SET cp_supplier_id=".db_escape($person_id) . " WHERE supplier_id = ".db_escape($accounting_supplier_id);
	db_query($sql,"The supplier could not be updated");
	
	$sql = "UPDATE ".TB_PREF."crm_persons SET pos_supplier_id=".db_escape($person_id) . " WHERE id = ".db_escape($crm_person_id);
	db_query($sql,"The supplier could not be updated");
	
	if(!empty($account_number))
	{
		$sql = "INSERT INTO opos_suppliers (person_id, accounting_supplier_id, company_name, account_number)
			VALUES (".db_escape($person_id). ", ".db_escape($accounting_supplier_id). ", ".db_escape($company_name). ", ".db_escape($account_number) .  ")";
	}
	else
	{
		$sql = "INSERT INTO opos_suppliers (person_id, accounting_supplier_id, company_name)
			VALUES (".db_escape($person_id). ", ".db_escape($accounting_supplier_id). ", ".db_escape($company_name). ")";
	}
	db_query($sql,"The supplier could not be added");
	
}

/*Update Data in POS Suppliers and Peoples*/
function update_pos_supplier($accounting_supplier_id,$company_name, $account_number,$phone_number,$email,$address_1, $address_2, $comments, $status )
{
	
	$sql = "SELECT person_id,accounting_supplier_id FROM opos_suppliers WHERE accounting_supplier_id=".db_escape($accounting_supplier_id);
	$result = db_query($sql, "could not get supplier");
	$row = db_fetch($result);
	
	if($status==1){$active=0;}else{$active=1;}	
	$sql = "UPDATE opos_people SET address_1=".db_escape($address_1) . ",address_2=".db_escape($address_2) . ",comments=".db_escape($comments) .",active=".db_escape($active) 
		." WHERE person_id = ".db_escape($row['person_id']);	
	db_query($sql,"The supplier could not be updated");
	
	if(!empty($account_number))
	{
		$sql = "UPDATE opos_suppliers SET company_name=".db_escape($company_name) . ", account_number=".db_escape($account_number). ", status=".db_escape($active) . " WHERE accounting_supplier_id = ".db_escape($row['accounting_supplier_id']);
	}
	else
	{
		$sql = "UPDATE opos_suppliers SET company_name=".db_escape($company_name) . ", status=".db_escape($active) . " WHERE accounting_supplier_id = ".db_escape($row['accounting_supplier_id']);
	}
	db_query($sql,"The supplier could not be updated");
}
/*Delete Data from POS Suppliers and Peoples*/
function delete_pos_supplier($accounting_supplier_id)
{
	$sql = "SELECT person_id,accounting_supplier_id FROM opos_suppliers WHERE accounting_supplier_id=".db_escape($accounting_supplier_id);
	$result = db_query($sql, "could not get supplier");
	$row = db_fetch($result);
	if(!empty($row))
	{
		$sql_people = "DELETE FROM opos_people  WHERE person_id=".$row['person_id'];
		db_query($sql_people,"cannot delete supplier");
		
		$sql_supplier = "DELETE FROM opos_suppliers  WHERE accounting_supplier_id=".db_escape($accounting_supplier_id);;
		db_query($sql_supplier,"cannot delete supplier");
	}
}
/*End Changes for Wrkmash*/
?>