<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/

function add_customer($CustName, $cust_ref, $address, $tax_id, $curr_code,
	$dimension_id, $dimension2_id, $credit_status, $payment_terms, $discount, $pymt_discount, 
	$credit_limit, $sales_type, $notes)
{
	$sql = "INSERT INTO ".TB_PREF."debtors_master (name, debtor_ref, address, tax_id,
		dimension_id, dimension2_id, curr_code, credit_status, payment_terms, discount, 
		pymt_discount,credit_limit, sales_type, notes) VALUES ("
		.db_escape($CustName) .", " .db_escape($cust_ref) .", "
		.db_escape($address) . ", " . db_escape($tax_id) . ","
		.db_escape($dimension_id) . ", " 
		.db_escape($dimension2_id) . ", ".db_escape($curr_code) . ", 
		" . db_escape($credit_status) . ", ".db_escape($payment_terms) . ", " . $discount . ", 
		" . $pymt_discount . ", " . $credit_limit 
		 .", ".db_escape($sales_type).", ".db_escape($notes) . ")";

	db_query($sql,"The customer could not be added");
}

function update_customer($customer_id, $CustName, $cust_ref, $address, $tax_id, $curr_code,
	$dimension_id, $dimension2_id, $credit_status, $payment_terms, $discount, $pymt_discount,
	$credit_limit, $sales_type, $notes)
{
	$sql = "UPDATE ".TB_PREF."debtors_master SET name=" . db_escape($CustName) . ", 
		debtor_ref=" . db_escape($cust_ref) . ",
		address=".db_escape($address) . ", 
		tax_id=".db_escape($tax_id) . ", 
		curr_code=".db_escape($curr_code) . ", 
		dimension_id=".db_escape($dimension_id) . ", 
		dimension2_id=".db_escape($dimension2_id) . ", 
		credit_status=".db_escape($credit_status) . ", 
		payment_terms=".db_escape($payment_terms) . ", 
		discount=" . $discount . ", 
		pymt_discount=" . $pymt_discount . ", 
		credit_limit=" . $credit_limit . ", 
		sales_type = ".db_escape($sales_type) . ", 
		notes=".db_escape($notes) ."
		WHERE debtor_no = ".db_escape($customer_id);

	db_query($sql,"The customer could not be updated");
}

function delete_customer($customer_id)
{
	begin_transaction();
	delete_entity_contacts('customer', $customer_id);
	
	/*Start Changes for Wrkmash*/
    delete_posc5_customer($customer_id);
	/*End Changes for Wrkmash*/

	$sql = "DELETE FROM ".TB_PREF."debtors_master WHERE debtor_no=".db_escape($customer_id);;
	db_query($sql,"cannot delete customer");
	commit_transaction();
}

function get_customer_details($customer_id, $to=null, $all=true)
{

	if ($to == null)
		$todate = date("Y-m-d");
	else
		$todate = date2sql($to);
	/*Start Changes By Wrkmash*/
	//$past1 = get_company_pref('past_due_days');
	$past1 = !empty(get_company_pref('past_due_days'))?get_company_pref('past_due_days'):0;
	/*End Changes By Wrkmash*/
	$past2 = 2 * $past1;
	// removed - debtor_trans.alloc from all summations
	if ($all)
    	$value = "IFNULL(IF(trans.type=11 OR trans.type=12 OR trans.type=2, -1, 1) 
    		* (trans.ov_amount + trans.ov_gst + trans.ov_freight + trans.ov_freight_tax + trans.ov_discount),0)";
    else		
    	$value = "IFNULL(IF(trans.type=11 OR trans.type=12 OR trans.type=2, -1, 1) 
    		* (trans.ov_amount + trans.ov_gst + trans.ov_freight + trans.ov_freight_tax + trans.ov_discount - 
    		trans.alloc),0)";
	$due = "IF (trans.type=10, trans.due_date, trans.tran_date)";
    $sql = "SELECT ".TB_PREF."debtors_master.name, ".TB_PREF."debtors_master.curr_code, ".TB_PREF."payment_terms.terms,
		".TB_PREF."debtors_master.credit_limit, ".TB_PREF."credit_status.dissallow_invoices, ".TB_PREF."credit_status.reason_description,

		Sum(IFNULL($value,0)) AS Balance,
		Sum(IF ((TO_DAYS('$todate') - TO_DAYS($due)) > 0,$value,0)) AS Due,
		Sum(IF ((TO_DAYS('$todate') - TO_DAYS($due)) > $past1,$value,0)) AS Overdue1,
		Sum(IF ((TO_DAYS('$todate') - TO_DAYS($due)) > $past2,$value,0)) AS Overdue2

		FROM ".TB_PREF."debtors_master
			 LEFT JOIN ".TB_PREF."debtor_trans trans ON 
			 trans.tran_date <= '$todate' AND ".TB_PREF."debtors_master.debtor_no = trans.debtor_no AND trans.type <> 13
,
			 ".TB_PREF."payment_terms,
			 ".TB_PREF."credit_status

		WHERE
			 ".TB_PREF."debtors_master.payment_terms = ".TB_PREF."payment_terms.terms_indicator
 			 AND ".TB_PREF."debtors_master.credit_status = ".TB_PREF."credit_status.id
			 AND ".TB_PREF."debtors_master.debtor_no = ".db_escape($customer_id)." ";
	if (!$all)
		$sql .= "AND ABS(trans.ov_amount + trans.ov_gst + trans.ov_freight + trans.ov_freight_tax + trans.ov_discount - trans.alloc) > ".FLOAT_COMP_DELTA." ";  
	$sql .= "GROUP BY
			  ".TB_PREF."debtors_master.name,
			  ".TB_PREF."payment_terms.terms,
			  ".TB_PREF."payment_terms.days_before_due,
			  ".TB_PREF."payment_terms.day_in_following_month,
			  ".TB_PREF."debtors_master.credit_limit,
			  ".TB_PREF."credit_status.dissallow_invoices,
			  ".TB_PREF."credit_status.reason_description";
    $result = db_query($sql,"The customer details could not be retrieved");

    $customer_record = db_fetch($result);

    return $customer_record;

}


function get_customer($customer_id)
{
	$sql = "SELECT * FROM ".TB_PREF."debtors_master WHERE debtor_no=".db_escape($customer_id);

	$result = db_query($sql, "could not get customer");

	return db_fetch($result);
}

function get_customer_name($customer_id)
{
	$sql = "SELECT name FROM ".TB_PREF."debtors_master WHERE debtor_no=".db_escape($customer_id);

	$result = db_query($sql, "could not get customer");

	$row = db_fetch_row($result);

	return $row[0];
}

function get_customer_habit($customer_id)
{
	$sql = "SELECT ".TB_PREF."debtors_master.pymt_discount,
		".TB_PREF."credit_status.dissallow_invoices
		FROM ".TB_PREF."debtors_master, ".TB_PREF."credit_status
		WHERE ".TB_PREF."debtors_master.credit_status = ".TB_PREF."credit_status.id
			AND ".TB_PREF."debtors_master.debtor_no = ".db_escape($customer_id);

	$result = db_query($sql, "could not query customers");

	return db_fetch($result);
}

function get_customer_contacts($customer_id, $action=null)
{
	$results = array();
	$res = get_crm_persons('customer', $action, $customer_id);
	while($contact = db_fetch($res))
	{
		if ($contact['lang'] == 'C') // Fix for improper lang in demo sql files.
			$contact['lang'] = '';
		$results[] = $contact;
	}	
	return $results;
}

function get_current_cust_credit($customer_id)
{
	$custdet = get_customer_details($customer_id);

	return $custdet['credit_limit']-$custdet['Balance'];

}

function is_new_customer($id)
{
	$tables = array('cust_branch', 'debtor_trans', 'recurrent_invoices', 'sales_orders');

	return !key_in_foreign_table($id, $tables, 'debtor_no');
}

function get_customer_by_ref($reference)
{
	$sql = "SELECT * FROM ".TB_PREF."debtors_master WHERE debtor_ref=".db_escape($reference);

	$result = db_query($sql, "could not get customer");

	return db_fetch($result);
}

/*Start Changes for Wrkmash*/
/*Save Data in POS Customer and Peoples*/
function add_pos_customer($accounting_customer_id,$crm_person_id,$customer_name,$address,$phone_number,$email,$comments )
{
	$active = 1;
	$plateform = 4;
	if(!empty($customer_name))
	{
		$customer_nameArray = explode(" ",$customer_name);
		$first_name = $customer_nameArray[0];
		$last_name = ltrim(str_replace($first_name," ",$customer_name));
	}
	else
	{
		$first_name = "";
		$last_name = "";
	}
	
	$sql = "INSERT INTO opos_people (first_name,last_name,address_1,address_2,phone_number,email,/*active,*/comments)
		VALUES (".db_escape($first_name). ", "
		.db_escape($last_name) . ", "
		.db_escape($address). ", "
		.db_escape($address). ", "
		.db_escape($phone_number) . ", "
		.db_escape($email) . ", "
		/*.db_escape($active) . ", "*/
		.db_escape($comments) .")";
	db_query($sql,"The customer could not be added");
	$person_id = db_insert_id();
	
	$sql = "INSERT INTO opos_customers (person_id,accounting_customer_id, plateform)
		    VALUES (".db_escape($person_id). ", ".db_escape($accounting_customer_id). ", ".db_escape($plateform).")";
	db_query($sql,"The customer could not be added");
	
	$sql = "UPDATE ".TB_PREF."debtors_master SET pos_customer_id=".db_escape($person_id) . " WHERE debtor_no = ".db_escape($accounting_customer_id);
	db_query($sql,"The customer could not be updated");
	
	$sql = "UPDATE ".TB_PREF."cust_branch SET pos_customer_id=".db_escape($person_id) . " WHERE debtor_no = ".db_escape($accounting_customer_id);
	db_query($sql,"The customer could not be updated");
	
	$sql = "UPDATE ".TB_PREF."crm_persons SET pos_customer_id=".db_escape($person_id) . " WHERE id = ".db_escape($crm_person_id);
	db_query($sql,"The customer could not be updated");
}

/*Update Data in POS Customer and Peoples and C5 UserSearchIndexAttributes*/
function update_posc5_customer($accounting_customer_id,$customer_name,$address,$comments,$inactive )
{
	if($inactive==1){$active=0;} else{$active=1;}
	if(!empty($customer_name))
	{
		$customer_nameArray = explode(" ",$customer_name);
		$first_name = $customer_nameArray[0];
		$last_name = ltrim(str_replace($first_name," ",$customer_name));
	}
	else
	{
		$first_name = "";
		$last_name = "";
	}
	$addressArray = explode("<br />", nl2br($address));
	if(count($addressArray)>1)
	{
		$address_1 = $addressArray[0];
		$address_2 = ltrim($addressArray[1]);
	}
	else
	{
		$address_1 = $address;
		$address_2 = $address;
	}
	$sql = "SELECT person_id,accounting_customer_id,c5_uID FROM opos_customers WHERE accounting_customer_id=".db_escape($accounting_customer_id);
	$result = db_query($sql, "could not get customer");
	$row = db_fetch($result);
	
	/*$sql = "UPDATE opos_people SET first_name=".db_escape($first_name) . ",
		m_name=".db_escape($m_name) . ",
		last_name=".db_escape($last_name) . ",
		phone_number=".db_escape($phone_number) . ",
		email=".db_escape($email) . ",
		address_1=".db_escape($address_1) . ",
		address_2=".db_escape($address_2) . ",
		comments=".db_escape($comments) 
		." WHERE person_id = ".db_escape($row['person_id']);*/
	if(!empty($row))
	{	
		if(!empty($row['person_id']))
		{
			/*Update POS Peoples*/
			$sql = "UPDATE opos_people SET first_name=".db_escape($first_name) .
				   ",last_name=".db_escape($last_name) . 
				   ",address_1=".db_escape($address_1) . 
				   ",address_2=".db_escape($address_2) . 
				   ",comments=".db_escape($comments) . 
				   ",active=".db_escape($active).
				   " WHERE person_id = ".db_escape($row['person_id']);	
			db_query($sql,"The customer could not be updated");
		}
		
		if(!empty($row['c5_uID']))
		{
			/*Update C5 UserSearchIndexAttributes*/
			$sql = "UPDATE UserSearchIndexAttributes SET ak_billing_first_name=".db_escape($first_name) .
				   ",ak_billing_last_name=".db_escape($last_name) . 
				   ",ak_billing_address_address1=".db_escape($address_1) . 
				   ",ak_billing_address_address2=".db_escape($address_2) .
				   " WHERE uID = ".db_escape($row['c5_uID']);	
			db_query($sql,"The customer could not be updated");
		}
		
	}
	/*$sql = "UPDATE opos_customers SET plateform=".db_escape($plateform) . " WHERE accounting_customer_id = ".db_escape($row['accounting_customer_id']);
	db_query($sql,"The customer could not be updated");*/
}

/* Delete Customer from POS and C5 */
function delete_posc5_customer($accounting_customer_id)
{
	$sql = "SELECT person_id,accounting_customer_id,c5_uID FROM opos_customers WHERE accounting_customer_id=".db_escape($accounting_customer_id);
	$result = db_query($sql, "could not get customer");
	$row = db_fetch($result);
	if(!empty($row))
	{
		/*Delete From C5 Users and UserSearchIndexAttributes*/
		if(!empty($row['c5_uID']))
		{
			$sql = "DELETE FROM UserSearchIndexAttributes  WHERE uID=".$row['c5_uID'];
			db_query($sql,"cannot delete customer");
			
			$sql = "DELETE FROM Users  WHERE uID=".$row['c5_uID'];
			db_query($sql,"cannot delete customer");
		}
		
		/*Delete From POS Customers and Peoples*/
		if(!empty($row['person_id']))
		{
			$sql = "DELETE FROM opos_people  WHERE person_id=".$row['person_id'];
			db_query($sql,"cannot delete customer");
		}
		
		$sql = "DELETE FROM opos_customers  WHERE accounting_customer_id=".db_escape($accounting_customer_id);;
		db_query($sql,"cannot delete customer");
	}
}

/*End Changes for Wrkmash*/

?>