<?php
/*
Gets the html table to manage people.
*/
function get_people_manage_table($people,$controller)
{
	$CI =& get_instance();
	
	$table='<table class="tablesorter" id="sortable_table" style="border:solid 1px #cccccc; border-spacing:0px; width:100%;">';
	
	$headers = array('<input type="checkbox" id="select_all" />', 
	$CI->lang->line('common_first_name'),
	$CI->lang->line('common_last_name'),
	
	$CI->lang->line('common_email'),
	$CI->lang->line('common_phone_number'),
	$CI->lang->line('common_action')
	);
	
	
	
	$table.='<thead><tr style="height:40px; font-size:14px; text-transform:uppercase; background-color:#f1f1f1; font-weight:bold">';
	foreach($headers as $header)
	{
		//if($options->num_rows()= 0)
		$table.="<th style='color: #234B5F; width: 25% text-align: left;'>$header</th>";
	}
	$table.='</tr></thead><tbody>';
	$table.=get_people_manage_table_data_rows($people,$controller);
	$table.='</tbody></table>';
	return $table;
}

/*
Gets the html data rows for the people.
*/
function get_people_manage_table_data_rows($people,$controller)
{
	$CI =& get_instance();
	$table_data_rows='';
	
	foreach($people->result() as $person)
	{
		$table_data_rows.=get_person_data_row($person,$controller);
	}
	
	if($people->num_rows()==0)
	{
		$table_data_rows.="<tr style='height:40px; font-size:14px; text-transform:uppercase; background-color:#f1f1f1; font-weight:bold'><td colspan='6'><div class='warning_message' style='padding:7px;'>".$CI->lang->line('common_no_persons_to_display')."</div></tr></tr>";
	}
	
	return $table_data_rows;
}

function get_person_data_row($person,$controller)
{
	$CI =& get_instance();
	$controller_name=$CI->uri->segment(1);
	$width = $controller->get_form_width();

	$table_data_row='<tr>';
	$table_data_row.="<td width='5%'><input type='checkbox' id='person_$person->person_id' value='".$person->person_id."'/></td>";
	$table_data_row.='<td width="20%">'.character_limiter($person->first_name,13).'</td>';
	$table_data_row.='<td width="20%">'.character_limiter($person->last_name,13).'</td>';
	$table_data_row.='<td width="30%">'.mailto($person->email,character_limiter($person->email,22)).'</td>';
	$table_data_row.='<td width="20%">'.character_limiter($person->phone_number,13).'</td>';
			
	//$table_data_row.='<td width="5%">'.anchor($controller_name."/view/$person->person_id/width:$width", $CI->lang->line('common_edit'),array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_update'))).'</td>';		
	//echo ZCPPATH;
	$table_data_row.='<td width="5%"><a href="http://zentrove.net/dev-ali/zcp/ecommerce/customer/posaddcustomer/'.$person->person_id.'" class="thickbox none addedit" >
	 <img src="http://zentrove.net/dev-ali/zcp/source/images/panel_icons/edit_icon.png" data-person_id="'.$person->person_id.'"></td>';
	
	
	$table_data_row.='<td width="5%">
	
	
	<img src="http://zentrove.net/dev-ali/zcp/source/images/panel_icons/delete_icon.png" data-person_id="'.$person->person_id.'"></td>';
	
	$table_data_row.='</tr>';
	return $table_data_row;
}

/*
Gets the html table to manage suppliers.
*/
function get_supplier_manage_table($suppliers,$controller)
{
	$CI =& get_instance();
	$table='<table class="tablesorter" id="sortable_table">';
	
	$headers = array('<input type="checkbox" id="select_all" />',
	$CI->lang->line('suppliers_company_name'),
	$CI->lang->line('common_last_name'),
	$CI->lang->line('common_first_name'),
	$CI->lang->line('common_email'),
	$CI->lang->line('common_phone_number'),
	'&nbsp');
	
	$table.='<thead><tr>';
	foreach($headers as $header)
	{
		$table.="<th>$header</th>";
	}
	$table.='</tr></thead><tbody>';
	$table.=get_supplier_manage_table_data_rows($suppliers,$controller);
	$table.='</tbody></table>';
	return $table;
}

/*
Gets the html data rows for the supplier.
*/
function get_supplier_manage_table_data_rows($suppliers,$controller)
{
	$CI =& get_instance();
	$table_data_rows='';
	
	foreach($suppliers->result() as $supplier)
	{
		$table_data_rows.=get_supplier_data_row($supplier,$controller);
	}
	
	if($suppliers->num_rows()==0)
	{
		$table_data_rows.="<tr><td colspan='7'><div class='warning_message' style='padding:7px;'>".$CI->lang->line('common_no_persons_to_display')."</div></tr></tr>";
	}
	
	return $table_data_rows;
}

function get_supplier_data_row($supplier,$controller)
{
	$CI =& get_instance();
	$controller_name=$CI->uri->segment(1);
	$width = $controller->get_form_width();

	$table_data_row='<tr>';
	$table_data_row.="<td width='5%'><input type='checkbox' id='person_$supplier->person_id' value='".$supplier->person_id."'/></td>";
	$table_data_row.='<td width="17%">'.character_limiter($supplier->company_name,13).'</td>';
	$table_data_row.='<td width="17%">'.character_limiter($supplier->last_name,13).'</td>';
	$table_data_row.='<td width="17%">'.character_limiter($supplier->first_name,13).'</td>';
	$table_data_row.='<td width="22%">'.mailto($supplier->email,character_limiter($supplier->email,22)).'</td>';
	$table_data_row.='<td width="17%">'.character_limiter($supplier->phone_number,13).'</td>';		
	$table_data_row.='<td width="5%">'.anchor($controller_name."/view/$supplier->person_id/width:$width", $CI->lang->line('common_edit'),array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_update'))).'</td>';		
	$table_data_row.='</tr>';
	
	return $table_data_row;
}

/*
Gets the html table to manage items.
*/
function get_items_manage_table($items,$controller,$source_store="")
{
	$CI =& get_instance();
	$table='<table class="tablesorter" style = "cursor:pointer" id="sortable_table" >';
	
	$headers = array('<input type="checkbox" id="select_all" />', 
	$CI->lang->line('items_item_number'),
	$CI->lang->line('items_name'),
	$CI->lang->line('items_category'),
	$CI->lang->line('items_cost_price'),
	//$CI->lang->line('items_unit_price'),
	$CI->lang->line('items_retail_price'),
	$CI->lang->line('items_tax_percents'),
	$CI->lang->line('items_quantity'),
	$CI->lang->line('items_listing_actions')
	//'&nbsp', 
	//'Images',
	
	//'&nbsp', 
	//'View History'//Ramel Inventory Tracking
	);
	

	$table.='<thead><tr>';
	foreach($headers as $header)
	{
		$table.="<th>$header</th>";
	}
	$table.='</tr></thead><tbody>';
	$table.=get_items_manage_table_data_rows($items,$controller,$source_store);
	$table.='</tbody></table>';
	return $table;
}


/*
Gets the html data rows for the items.
*/
function get_items_manage_table_data_rows($items,$controller,$source_store="")
{
	$CI =& get_instance();
	$table_data_rows='';
	if($items)
	{
	foreach($items->result() as $item)
	{
		$table_data_rows.=get_item_data_row($item,$controller,$source_store);
	}
	
	if($items->num_rows()==0)
	{
		$table_data_rows.="<tr><td colspan='11'><div class='warning_message' style='padding:7px;'>".$CI->lang->line('items_no_items_to_display')."</div></tr></tr>";
	}
	}
	else
	{
		$table_data_rows.="<tr><td colspan='11'><div class='warning_message' style='padding:7px;'>".$CI->lang->line('items_no_items_to_display')."</div></tr></tr>";
	}
	
	return $table_data_rows;
}

function get_item_data_row($item,$controller,$source_store="")
{
	$CI =& get_instance();
	$item_tax_info=$CI->Item_taxes->get_info($item->item_id);
	$tax_percents = '';
	foreach($item_tax_info as $tax_info)
	{
		$tax_percents.=$tax_info['percent']. '%, ';
	}
	$tax_percents=substr($tax_percents, 0, -2);
	$controller_name=$CI->uri->segment(1);
	
	$width = $controller->get_form_width();

	$table_data_row='<tr>';
	$table_data_row.="<td width='3%'><input type='checkbox' style = 'cursor:pointer' id='item_$item->item_id' value='".$item->item_id."'/></td>";
	$table_data_row.='<td width="15%">'.$item->item_number.'</td>';
	$table_data_row.='<td width="20%">'.$item->name.'</td>';
	$table_data_row.='<td width="14%">'.$item->category.'</td>';
	$table_data_row.='<td width="14%">'.to_currency($item->cost_price).'</td>';
	$table_data_row.='<td width="14%">'.to_currency($item->unit_price).'</td>';
	$table_data_row.='<td width="14%">'.$tax_percents.'</td>';	
	$table_data_row.='<td width="14%">'.$item->quantity.'</td>';
	
	if($source_store!="")
	{
	
	$table_data_row.='<td width="15%">'.anchor($controller_name."/view/$item->item_id/width:$width/$source_store", $CI->lang->line('common_edit'),array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_update'))).'    '.anchor($controller_name."/view_img/$item->item_id", 'image',array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_update'))).'&nbsp;|&nbsp;';
	
	$table_data_row.=anchor($controller_name."/view_img/$item->item_id", 'image',array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_update'))).'&nbsp;|&nbsp;';
	
	//Ramel Inventory Tracking
	$table_data_row.=anchor($controller_name."/count_details/$item->item_id/width:$width/$source_store", $CI->lang->line('common_det'),array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_details_count'))).'</td>';//inventory details	
	
	}
	else
	{
	
	$table_data_row.='<td width="15%">'.anchor($controller_name."/view/$item->item_id/width:$width/None", $CI->lang->line('common_edit'),array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_update'))).'&nbsp;|&nbsp;';
	
	$table_data_row.=anchor($controller_name."/view_img/$item->item_id",$CI->lang->line($controller_name.'_listing_actions_image'),array('class'=>'thickbox','title'=>$item->name."&nbsp;".$CI->lang->line($controller_name.'_listing_actions_image'))).'&nbsp;|&nbsp;';
	
	//Ramel Inventory Tracking
	/*$table_data_row.=''.anchor('', '-',array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_count'))).'&nbsp;&nbsp;&nbsp;&nbsp;'.anchor($controller_name."/count_details/$item->item_id/width:$width/None", $CI->lang->line('common_det'),array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_details_count'))).'</td>';*/
	$table_data_row.=anchor($controller_name."/count_details/$item->item_id/width:$width/None", $CI->lang->line('common_det'),array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_details_count'))).'</td>';
	//inventory details	
			
	}
	
	$table_data_row.='</tr>';
	return $table_data_row;
}




/*
Gets the html table to manage categories.
*/
function get_category_manage_table($category,$controller)
{
	$CI =& get_instance();
	$table='<table class="tablesorter" id="sortable_table" style="width:80% !important;margin-left:auto;margin-right:auto">';
	
	$headers = array('<input type="checkbox" id="select_all" />', 
	$CI->lang->line('items_categoryname'),
	$CI->lang->line('common_action'),	
	
	);
	
	$table.='<thead><tr>';
	/*foreach($headers as $header)
	{
		$table.="<th>$header</th>";
	}
	*/
	$table.="<th height='35'>".$headers[0]."</th>";
	$table.="<th height='35'>".$headers[1]."</th>";
	$table.="<th height='35' align='center' style='text-align:center'>".$headers[2]."</th>";
	
	$table.='</tr></thead><tbody>';
	$table.=get_category_manage_table_data_rows($category,$controller);
	$table.='</tbody></table>';
	return $table;


	//$table.='<thead><tr>';
	/*foreach($headers as $header)
	{
		$table.="<th height='35'>$header</th>";
	}*/
	/*$table.="<th height='35'>".$headers[0]."</th>";
	$table.="<th height='35'>".$headers[1]."</th>";
	$table.="<th height='35' align='center' style='text-align:center'>".$headers[2]."</th>";
	$table.='</tr></thead><tbody>';
	$table.=get_category_manage_table_data_rows($category,$controller);
	$table.='</tbody></table>';
	return $table;*/
}


/*
Gets the html data rows for the categories.
*/
function get_category_manage_table_data_rows($category,$controller,$source_store="")
{
	$CI =& get_instance();
	$table_data_rows='';
	
	//print_r($category->result());
	if($category->result())
	{
		foreach($category->result() as $eachcategory)
		{
			//print_r($eachcategory);
			$table_data_rows.=get_category_data_row($eachcategory,$controller,$source_store);
		}
		
		if($category->num_rows()==0)
		{
			$table_data_rows.="<tr><td colspan='11' height='30'><div class='warning_message' style='padding:7px;'>".$CI->lang->line('items_no_category_to_display')."</div></tr></tr>";
		}
	}
	else
	{
		$table_data_rows.="<tr><td colspan='11'><div class='warning_message' style='padding:7px;'>".$CI->lang->line('items_no_category_to_display')."</div></tr></tr>";
	}
	
	return $table_data_rows;
}

function get_category_data_row($eachcategory,$controller,$source_store="")
{
	//print_r($eachcategory);
	
	//exit;
	//$eachcategory=$CI->Item_taxes->get_info($item->item_id);
		
		
	
	$CI =&get_instance();
	//$controller_name=$CI->uri->segment(1);
	$width = $controller->get_form_width();
	$date = date("Y-m-d");
    $controller_name=$CI->uri->segment(1);
	
	//$eachcategory= $CI->Items->eachcategory();

	$table_data_row='<tr height="40px">';
	$table_data_row.="<td width='5%' style='vertical-align:middle'><input type='checkbox' id='item_$eachcategory->id' value='".$eachcategory->id."'/></td>";
	$table_data_row.='<td width="35%" style="vertical-align:middle">';
	$category_id = $eachcategory->id;
	
	$subcategories = $CI->Item->get_subcategory($eachcategory->id);
	
	if($subcategories->num_rows()!= 0)
	{
	$table_data_row.='<a id="imageDivLink" href="javascript:show_hide_subcategory('.$category_id.');" style="outline:none;position:relative;"><img src="'.base_url().'images/plus.png" style="border:0;outline:none;padding:0px;margin:0px;position:absolute;top:-7px;left:-35px"></a>';
	}
	$table_data_row.="<input type='text' style='outline:none; border:none; border-style: none;' cate_id = '$eachcategory->id'  class='cate_edit' id='cate_$eachcategory->id' value='".$eachcategory->title."'/>"; 
	
	
	
	
	$table_data_row.="</td>";
	
	$table_data_row.='<td width="10%" align="center" style="vertical-align:middle">
	'. form_submit(array(
	'name'=>'submit',
	'id'=>$eachcategory->id,
	'value'=>'Edit',
	'style'=>'float:none',
		'class'=>'submit_button float_right  edit')
	).'
	
	'. form_submit(array(
	'name'=>'submit',
	'id'=>$eachcategory->id,
	'value'=>'Delete',
	'style'=>'float:none',
	'class'=>'submit_button float_right  del')
	).'
	</td>';

	$table_data_row.='</tr>';
	
	if($subcategories->num_rows()!= 0)
	{
	
	$table_data_row.="<tr id='subcategory_div".$eachcategory->id."' style='display:none'>";
	$table_data_row.='<td colspan="3" width="100%" style="padding:10px;">';	
	$table_data_row.='<table class="tablesorter" id="sortable_table" style="width:88% !important;margin-left:auto;margin-right:auto">';
	$table_data_row.='<thead><tr>';
	//$table_data_row.='<th height="30" ><input type="checkbox" id="select_sub_all" /></th>';
	$table_data_row.="<th height='30' width='80%' >Title</th>";
	$table_data_row.="<th height='30' width='20%'  align='center' style='text-align:center'>Actions</th>";
	$table_data_row.='</tr></thead><tbody>';
	
		foreach($subcategories->result() as $subcategory)
		{
		  
		  
		 $table_data_row.='<tr height="40px">
			
			<td width="35%" style="vertical-align:middle">&nbsp;<input type="text" style="outline:none; border:none; border-style: none;" subcate_id = "'.$subcategory->id.'"  cate = '.$eachcategory->id.'   class="subcate_edit" id="subcate_'.$subcategory->id.'" value="'.$subcategory->title.'"/></td>
			<td width="35%" style="vertical-align:middle" align="center">'. form_submit(array(
			'name'=>'submit',
			'id'=>$subcategory->id,
			'value'=>'Edit',
			'style'=>'float:none',
			'class'=>'submit_button float_right  edit_subcate')
			).'
			
			'. form_submit(array(
			'name'=>'submit',
			'id'=>$subcategory->id,
			'value'=>'Delete',
			'style'=>'float:none',
			'class'=>'submit_button float_right  del_subcate')
			).'</td>
		  </tr>';
		
		}
	
	
	$table_data_row.='</tbody></table>';
	$table_data_row.='</td>';
	$table_data_row.="</tr>";
	

	}
	
	
	return $table_data_row;
}






function get_attributes_manage_table($category,$controller)
{
	$CI =& get_instance();
	$table='<table class="tablesorter" id="sortable_table" style="width:80% !important;margin-left:auto;margin-right:auto">';
	
	$headers = array('<input type="checkbox" id="select_all" />', 
	$CI->lang->line('items_attributesname'),
	'Action'
	
	);
	

	$table.='<thead><tr>';
	/*foreach($headers as $header)
	{
		$table.="<th height='35'>$header</th>";
	}*/
	$table.="<th height='35'>".$headers[0]."</th>";
	$table.="<th height='35'>".$headers[1]."</th>";
	$table.="<th height='35' align='center' style='text-align:center'>".$headers[2]."</th>";
	$table.='</tr></thead><tbody>';
	$table.=get_attributes_manage_table_data_rows($category,$controller);
	$table.='</tbody></table>';
	return $table;
}


/*
Gets the html data rows for the items.
*/
function get_attributes_manage_table_data_rows($category,$controller,$source_store="")
{
	$CI =& get_instance();
	$table_data_rows='';
	
//	print_r($category->result());
	if($category)
	{
		foreach($category->result() as $eachcategory)
		{
			$table_data_rows.=get_attributes_data_row($eachcategory,$controller,$source_store);
		}
		
		if($category->num_rows()==0)
		{
			$table_data_rows.="<tr><td colspan='11' height='30'><div class='warning_message' style='padding:7px;'>".$CI->lang->line('items_no_attributes_to_display')."</div></tr></tr>";
		}
	}
	else
	{
		$table_data_rows.="<tr><td colspan='11'><div class='warning_message' style='padding:7px;'>".$CI->lang->line('items_no_attributes_to_display')."</div></tr></tr>";
	}
	
	return $table_data_rows;
}

function get_attributes_data_row($eachattributes,$controller,$source_store="")
{


	$CI =&get_instance();
	$width = $controller->get_form_width();
	$date = date("Y-m-d");
    $controller_name=$CI->uri->segment(1);
	
	$options = $CI->Item->get_option($eachattributes->id);
	
	$table_data_row='<tr height="40px">';
	$table_data_row.="<td width='5%' style='vertical-align:middle'><input type='checkbox' id='item_$eachattributes->id' value='".$eachattributes->id."'/></td>";
	$table_data_row.='<td width="35%" style="vertical-align:middle">';
	$category_id = $eachattributes->id;
	
	$options = $CI->Item->get_option($eachattributes->id);
	
	if($options->num_rows()!= 0)
	{
	$table_data_row.='<a id="imageDivLink" href="javascript:show_hide_option('.$category_id.');" style="outline:none;position:relative;"><img src="'.base_url().'images/plus.png" style="border:0;outline:none;padding:0px;margin:0px;position:absolute;top:-7px;left:-35px"></a>';
	}
	$table_data_row.="<input type='text' style='outline:none; border:none; border-style: none;' cate_id = '$eachattributes->id'  class='cate_edit' id='cate_$eachattributes->id' value='".$eachattributes->title."'/>"; 
	
	
	
	
	$table_data_row.="</td>";
	
	$table_data_row.='<td width="10%" align="center" style="vertical-align:middle">
	'. form_submit(array(
	'name'=>'submit',
	'id'=>$eachattributes->id,
	'value'=>'Edit',
	'style'=>'float:none',
		'class'=>'submit_button float_right  edit')
	).'
	
	'. form_submit(array(
	'name'=>'submit',
	'id'=>$eachattributes->id,
	'value'=>'Delete',
	'style'=>'float:none',
	'class'=>'submit_button float_right  del')
	).'
	</td>';

	$table_data_row.='</tr>';
	
	if($options->num_rows()!= 0)
	{
	
	$table_data_row.="<tr id='option_div".$eachattributes->id."' style='display:none'>";
	$table_data_row.='<td colspan="3" width="100%" style="padding:10px;">';	
	$table_data_row.='<table class="tablesorter" id="sortable_table" style="width:88% !important;margin-left:auto;margin-right:auto">';
	$table_data_row.='<thead><tr>';
	//$table_data_row.='<th height="30" ><input type="checkbox" id="select_sub_all" /></th>';
	$table_data_row.="<th height='30' width='80%' >Title</th>";
	$table_data_row.="<th height='30' width='20%'  align='center' style='text-align:center'>Actions</th>";
	$table_data_row.='</tr></thead><tbody>';
	
		foreach($options->result() as $option)
		{
		  
		  
		 $table_data_row.='<tr height="40px">
			
			<td width="35%" style="vertical-align:middle">&nbsp;<input type="text" style="outline:none; border:none; border-style: none;" option_id = "'.$option->id.'"  attri = '.$eachattributes->id.'   class="option_edit" id="option_'.$option->id.'" value="'.$option->title.'"/></td>
			<td width="35%" style="vertical-align:middle" align="center">'. form_submit(array(
			'name'=>'submit',
			'id'=>$option->id,
			'value'=>'Edit',
			'style'=>'float:none',
			'class'=>'submit_button float_right  edit_option')
			).'
			
			'. form_submit(array(
			'name'=>'submit',
			'id'=>$option->id,
			'value'=>'Delete',
			'style'=>'float:none',
			'class'=>'submit_button float_right  del_option')
			).'</td>
		  </tr>';
		
		}
	
	
	$table_data_row.='</tbody></table>';
	$table_data_row.='</td>';
	$table_data_row.="</tr>";
	

	}
	
	
	return $table_data_row;
}


/*
Gets the html table to manage print labels items.
*/
function get_printlabelsitems_manage_table($items,$controller,$source_store="")
{
	$CI =& get_instance();
	$table='<table class="tablesorter" id="sortable_table">';
	
	$headers = array('<input type="checkbox" id="select_all" />', 
	$CI->lang->line('items_item_number'),
	$CI->lang->line('items_name'),
	$CI->lang->line('items_category'),
	//$CI->lang->line('items_cost_price'),
	
	//$CI->lang->line('items_unit_price'),
	//$CI->lang->line('items_retail_price'),
	//$CI->lang->line('items_tax_percents'),
	$CI->lang->line('items_quantity'),
	'Number of labels printed'//Ramel Inventory Tracking
	);
	

	$table.='<thead><tr>';
	foreach($headers as $header)
	{
		$table.="<th>$header</th>";
	}
	$table.='</tr></thead><tbody>';
	$table.=get_printlabelsitems_manage_table_data_rows($items,$controller,$source_store);
	$table.='</tbody></table>';
	return $table;
}


/*
Gets the html data rows for the items.
*/
function get_printlabelsitems_manage_table_data_rows($items,$controller,$source_store="")
{
	$CI =& get_instance();
	$table_data_rows='';
	if($items)
	{
	foreach($items->result() as $item)
	{
		$table_data_rows.=get_printlabelsitem_data_row($item,$controller,$source_store);
	}
	
	if($items->num_rows()==0)
	{
		$table_data_rows.="<tr><td colspan='11'><div class='warning_message' style='padding:7px;'>".$CI->lang->line('items_no_items_to_display')."</div></tr></tr>";
	}
	}
	else
	{
		$table_data_rows.="<tr><td colspan='11'><div class='warning_message' style='padding:7px;'>".$CI->lang->line('items_no_items_to_display')."</div></tr></tr>";
	}
	
	return $table_data_rows;
}

function get_printlabelsitem_data_row($item,$controller,$source_store="")
{
	$CI =& get_instance();
	$item_tax_info=$CI->Item_taxes->get_info($item->item_id);
	$tax_percents = '';
	foreach($item_tax_info as $tax_info)
	{
		$tax_percents.=$tax_info['percent']. '%, ';
	}
	$tax_percents=substr($tax_percents, 0, -2);
	$controller_name=$CI->uri->segment(1);
	
	$width = $controller->get_form_width();

	$table_data_row='<tr>';
	$table_data_row.="<td width='3%'><input type='checkbox' class='item_checkbox' id='item_$item->item_id' value='".$item->item_id."'/></td>";
	$table_data_row.='<td width="15%">'.$item->item_number.'</td>';
	$table_data_row.='<td width="25%">'.$item->name.'</td>';
	$table_data_row.='<td width="14%">'.$item->category.'</td>';
	//$table_data_row.='<td width="14%">'.to_currency($item->cost_price).'</td>';
	//$table_data_row.='<td width="14%">'.to_currency($item->unit_price).'</td>';
	//$table_data_row.='<td width="14%">'.$tax_percents.'</td>';	
	$table_data_row.='<td width="14%">'.$item->quantity.'</td>';
	$table_data_row.='<td width="20%" align="center"><div id="span_printlabels_number_error'.$item->item_id.'" class="span_printlabels_number_error" style="position:relative"></div>'.form_input(array('name'=>'printlabels_number'.$item->item_id,'id'=>'printlabels_number'.$item->item_id,'value'=>"",'size'=>'5','item_id'=>$item->item_id,'class'=>'printlabels_number','div'=>'printlabels_number','title'=>'Press up and down key to increase or decrease number.')).'</td>';
	
	
	$table_data_row.='</tr>';
	return $table_data_row;
}

/*
Gets the html table to manage giftcards.
*/
function get_giftcards_manage_table( $giftcards, $controller )
{
	$CI =& get_instance();
	
	$table='<table class="tablesorter" id="sortable_table">';
	
	$headers = array('<input type="checkbox" id="select_all" />', 
	$CI->lang->line('giftcards_giftcard_number'),
	$CI->lang->line('giftcards_card_value'),
	'&nbsp', 
	);
	
	$table.='<thead><tr>';
	foreach($headers as $header)
	{
		$table.="<th>$header</th>";
	}
	$table.='</tr></thead><tbody>';
	$table.=get_giftcards_manage_table_data_rows( $giftcards, $controller );
	$table.='</tbody></table>';
	return $table;
}

/*
Gets the html data rows for the giftcard.
*/
function get_giftcards_manage_table_data_rows( $giftcards, $controller )
{
	$CI =& get_instance();
	$table_data_rows='';
	
	foreach($giftcards->result() as $giftcard)
	{
		$table_data_rows.=get_giftcard_data_row( $giftcard, $controller );
	}
	
	if($giftcards->num_rows()==0)
	{
		$table_data_rows.="<tr><td colspan='11'><div class='warning_message' style='padding:7px;'>".$CI->lang->line('giftcards_no_giftcards_to_display')."</div></tr></tr>";
	}
	
	return $table_data_rows;
}

function get_giftcard_data_row($giftcard,$controller)
{
	$CI =& get_instance();
	$controller_name=$CI->uri->segment(1);
	$width = $controller->get_form_width();

	$table_data_row='<tr>';
	$table_data_row.="<td width='3%'><input type='checkbox' id='giftcard_$giftcard->giftcard_id' value='".$giftcard->giftcard_id."'/></td>";
	$table_data_row.='<td width="15%">'.$giftcard->giftcard_number.'</td>';
	$table_data_row.='<td width="20%">'.to_currency($giftcard->value).'</td>';
	$table_data_row.='<td width="5%">'.anchor($controller_name."/view/$giftcard->giftcard_id/width:$width", $CI->lang->line('common_edit'),array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_update'))).'</td>';		
	
	$table_data_row.='</tr>';
	return $table_data_row;
}
function get_gateway_data_row($gateways,$controller)
{
	$CI =& get_instance();
	$controller_name=$CI->uri->segment(1);
	  $table = $controller->get_form_width();

//	$table_data_row='<tr>';
//	$table_data_row.="<td width='5%'><input type='checkbox' id='person_$person->person_id' value='".$person->person_id."'/></td>";
//	$table_data_row.='<td width="20%">'.character_limiter($person->last_name,13).'</td>';
//	$table_data_row.='<td width="20%">'.character_limiter($person->first_name,13).'</td>';
//	$table_data_row.='<td width="30%">'.mailto($person->email,character_limiter($person->email,22)).'</td>';
//	$table_data_row.='<td width="20%">'.character_limiter($person->phone_number,13).'</td>';		
//	$table_data_row.='<td width="5%">'.anchor($controller_name."/view/$person->person_id/width:$width", $CI->lang->line('common_edit'),array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_update'))).'</td>';		
//	$table_data_row.='</tr>';
	
	return $table;
}

/*
Gets the html table to manage stores.
*/
function get_stores_manage_table( $stores, $controller )
{
	$CI =& get_instance();
	
	$table='<table class="tablesorter" id="sortable_table">';
	
	/*$headers = array('<input type="checkbox" id="select_all" />', 
	$CI->lang->line('giftcards_giftcard_number'),
	$CI->lang->line('giftcards_card_value'),
	$CI->lang->line('giftcards_card_value'),
	$CI->lang->line('giftcards_card_value'),
	'&nbsp', 
	);*/
	
	$headers = array('<input type="checkbox" id="select_all" />', 
	$CI->lang->line('config_accounts_settings_id'),
	$CI->lang->line('config_accounts_settings_name'),
	$CI->lang->line('config_accounts_settings_email'),
	$CI->lang->line('config_accounts_settings_phone_number'),
	$CI->lang->line('config_accounts_settings_Address'),
	$CI->lang->line('common_action'), 
	);
	
	$table.='<thead><tr>';
	foreach($headers as $header)
	{
		$table.="<th class=\"header\" height=\"25\">$header</th>";
	}
	$table.='</tr></thead><tbody>';
	$table.=get_stores_manage_table_data_rows( $stores, $controller );
	$table.='</tbody></table>';
	return $table;
}


/*
Gets the html data rows for the stores.
*/
function get_stores_manage_table_data_rows($stores,$controller)
{
	$CI =& get_instance();
	$table_data_rows='';
	
	foreach($stores->result() as $store)
	{
		$table_data_rows.=get_store_data_row($store,$controller);
	}
	
	if($stores->num_rows()==0)
	{
		//$table_data_rows.="<tr><td colspan='6'><div class='warning_message' style='padding:7px;'>".$CI->lang->line('common_no_persons_to_display')."</div></tr></tr>";
		$table_data_rows.="<tr><td colspan='6'><div class='warning_message' style='padding:7px;'>No result found</div></tr></tr>";
	}
	
	return $table_data_rows;
}

function get_store_data_row($store,$controller)
{
	$CI =& get_instance();
	$controller_name=$CI->uri->segment(1);
	$width = "400";
	
    if($store->status=="0"){$status_text="Active";$status_value=1;}else{$status_text="Deactive";$status_value=0;}
	$table_data_row='<tr>';
	$table_data_row.="<td width='5%'><input type='checkbox' id='person_$store->id' value='".$store->id."'/></td>";
	$table_data_row.='<td width="5%">'.character_limiter($store->id,13).'</td>';
	$table_data_row.='<td width="20%">'.character_limiter($store->name,13).'</td>';
	$table_data_row.='<td width="30%">'.mailto($store->email,character_limiter($store->email,22)).'</td>';
	$table_data_row.='<td width="20%">'.character_limiter($store->phonenumber,13).'</td>';
	$table_data_row.='<td width="20%">'.character_limiter($store->address,13).'</td>';		
	$table_data_row.='<td width="5%">'.anchor($controller_name."/view/$store->id/width:$width", $CI->lang->line('common_edit'),array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_update'))).'&nbsp;&nbsp;|&nbsp;&nbsp;<a href="javascript:void(0);" style="cursor:pointer"  store_id="'.$store->id.'" status_value="'.$status_value.'" class="change_status">'.$status_text.'</a></td>';		
	$table_data_row.='</tr>';
	
	return $table_data_row;
}


/*
Gets the html table to manage items.
*/
function get_assign_items_manage_table($items,$controller,$source_store,$des_store_one,$des_store_two)
{
	$CI =& get_instance();
	
	$table='<table class="tablesorter" id="item_sortable_table">';
	
	$headers = array('<input type="checkbox" id="select_all" />', 
	$CI->lang->line('items_item_number'),
	$CI->lang->line('items_name'),
	$CI->lang->line('items_category'),
	//$CI->lang->line('items_cost_price'),
	
	//$CI->lang->line('items_unit_price'),
	//$CI->lang->line('items_retail_price'),
	//$CI->lang->line('items_tax_percents'),
	$CI->lang->line('items_quantity'),
	'Store 1 '.$CI->lang->line('items_quantity'),
	'Store 2 '.$CI->lang->line('items_quantity'),
	//'&nbsp', 
	//'View History'//Ramel Inventory Tracking
	);
	

	$table.='<thead><tr>';
	foreach($headers as $header)
	{
		$table.="<th>$header</th>";
	}
	$table.='</tr></thead><tbody>';
	$table.=get_assign_items_manage_table_data_rows($items,$controller,$source_store,$des_store_one,$des_store_two);
	$table.='</tbody></table>';
	return $table;
}


/*
Gets the html data rows for the items.
*/
function get_assign_items_manage_table_data_rows($items,$controller,$source_store,$des_store_one,$des_store_two)
{
	$CI =& get_instance();
	$table_data_rows='';
	if($source_store!="")
	{// exit;
		if($items)
		{
			foreach($items->result() as $item)
			{
				$table_data_rows.=get_assign_item_data_row($item,$controller,$source_store,$des_store_one,$des_store_two);
			}
			
			if($items->num_rows()==0)
			{
				$table_data_rows.="<tr ><td colspan='11'><div class='warning_message' style='padding:7px;'>".$CI->lang->line('items_no_items_to_display')."</div></tr></tr>";
			}
		}
		else
		{
				$table_data_rows.="<tr ><td colspan='11'><div class='warning_message' style='padding:7px;'>".$CI->lang->line('items_no_items_to_display')."</div></tr></tr>";
		}
	}
	else
	{
		$table_data_rows.="<tr ><td colspan='11'><div class='warning_message' style='padding:7px;'>".$CI->lang->line('items_no_items_to_display')."</div></tr></tr>";
	}
	return $table_data_rows;
}

function get_assign_item_data_row($item,$controller,$source_store,$des_store_one,$des_store_two)
{
	$CI =& get_instance();
	$item_tax_info=$CI->Item_taxes->get_info($item->item_id);
	$tax_percents = '';
	foreach($item_tax_info as $tax_info)
	{
		$tax_percents.=$tax_info['percent']. '%, ';
	}
	$tax_percents=substr($tax_percents, 0, -2);
	$controller_name=$CI->uri->segment(1);
	$width = $controller->get_form_width();
	
	if($des_store_one!="")
	{
		$des_store_one_Array = $CI->Item->get_Store_Item($des_store_one,$item->item_id);//print_r($des_store_one_Array);
		if(sizeof($des_store_one_Array)>0) $des_store_one_quantity = $des_store_one_Array[0]['quantity'];else $des_store_one_quantity = "0";
		$disabled = "";
	}
	else
	{
		$des_store_one_quantity = "0";
		$disabled = ",'disabled'=>'disabled'";
	}
	
	if($des_store_two!="")
	{
		$des_store_two_Array = $CI->Item->get_Store_Item($des_store_two,$item->item_id);
		if(sizeof($des_store_two_Array)>0) $des_store_two_quantity = $des_store_two_Array[0]['quantity'];else $des_store_two_quantity = "0";
		$disabled = "";
	}
	else
	{
		$des_store_two_quantity = "0";
		$disabled = ",'disabled'=>'disabled'";
	}
	//print_r($des_store_one_Array);
	
	$table_data_row='<tr onmouseover=this.className="over" onmouseout=this.className="">';
	$table_data_row.="<td width='3%'><input type='checkbox' id='item_$item->item_id' value='".$item->item_id."' class='checkbox'/></td>";
	$table_data_row.='<td width="15%">'.$item->item_number.'</td>';
	$table_data_row.='<td width="20%">'.$item->name.'</td>';
	$table_data_row.='<td width="14%">'.$item->category.'</td>';
	//$table_data_row.='<td width="14%">'.to_currency($item->cost_price).'</td>';
	//$table_data_row.='<td width="14%">'.to_currency($item->unit_price).'</td>';
	//$table_data_row.='<td width="14%">'.$tax_percents.'</td>';	
	$table_data_row.='<td width="10%" class="source_store_quantity" id="source_store_quantity'.$item->item_id.'">'.$item->quantity.'</td>';
	if($des_store_one!="")
	{
	$table_data_row.='<td width="15%" align="center" ><div id="span_store_one_error'.$item->item_id.'" class="span_store_one_error" style="position:relative"></div><div id="span_quantity_store_one'.$item->item_id.'" style="width:40%;float:left;" class="span_quantity_store_one">'.$des_store_one_quantity.'</div>&nbsp;&nbsp;&nbsp;'.form_input(array('name'=>'quantity_store_one'.$item->item_id,'id'=>'quantity_store_one'.$item->item_id,'value'=>"",'size'=>'5','item_id'=>$item->item_id,'class'=>'store_quantity','div'=>'span_quantity_store_one','style'=>'float:left','title'=>'Press enter to add quantity in existing quantity.','old_quantity'=>$des_store_one_quantity,'new_quantity'=>'0')).'</td>';
	}
	else
	{
	$table_data_row.='<td width="15%" align="center"><div id="span_store_one_error'.$item->item_id.'" class="span_store_one_error" style="position:relative"></div><div id="span_quantity_store_one'.$item->item_id.'" style="width:40%;float:left;" class="span_quantity_store_one">'.$des_store_one_quantity.'</div>&nbsp;&nbsp;&nbsp;'.form_input(array('name'=>'quantity_store_one'.$item->item_id,'id'=>'quantity_store_one'.$item->item_id,'value'=>"",'size'=>'5','item_id'=>$item->item_id,'class'=>'store_quantity','div'=>'span_quantity_store_one','style'=>'float:left','title'=>'Press enter to add quantity in existing quantity.','old_quantity'=>$des_store_one_quantity,'new_quantity'=>'0','disabled'=>'disabled')).'</td>';	
	}
	if($des_store_two!="")
	{
	$table_data_row.='<td width="15%" align="center"><div id="span_store_two_error'.$item->item_id.'" class="span_store_two_error" style="position:relative"></div><div id="span_quantity_store_two'.$item->item_id.'" style="width:40%;float:left;" class="span_quantity_store_two">'.$des_store_two_quantity.'</div>&nbsp;&nbsp;&nbsp;'.form_input(array('name'=>'quantity_store_two'.$item->item_id,'id'=>'quantity_store_two'.$item->item_id,'value'=>"",'size'=>'5','item_id'=>$item->item_id,'class'=>'store_quantity','div'=>'span_quantity_store_two','style'=>'float:left','title'=>'Press enter to add quantity in existing quantity.','old_quantity'=>$des_store_two_quantity,'new_quantity'=>'0')).'</td>';
	}
	else
	{
	$table_data_row.='<td width="15%" align="center"><div id="span_store_two_error'.$item->item_id.'" class="span_store_two_error" style="position:relative"></div><div id="span_quantity_store_two'.$item->item_id.'" style="width:40%;float:left;" class="span_quantity_store_two">'.$des_store_two_quantity.'</div>&nbsp;&nbsp;&nbsp;'.form_input(array('name'=>'quantity_store_two'.$item->item_id,'id'=>'quantity_store_two'.$item->item_id,'value'=>"",'size'=>'5','item_id'=>$item->item_id,'class'=>'store_quantity','div'=>'span_quantity_store_two','style'=>'float:left','title'=>'Press enter to add quantity in existing quantity.','old_quantity'=>$des_store_two_quantity,'new_quantity'=>'0','disabled'=>'disabled')).'</td>';	
	}
	//$table_data_row.='<td width="5%">'.anchor($controller_name."/view/$item->item_id/width:$width", $CI->lang->line('common_edit'),array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_update'))).'</td>';		
	
	//Ramel Inventory Tracking
	
	//$table_data_row.='<td width="10%">'.anchor('', '-',array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_count')))./*'</td>';//inventory count	
	//$table_data_row.='<td width="5%">'*/'&nbsp;&nbsp;&nbsp;&nbsp;'.anchor($controller_name."/count_details/$item->item_id/width:$width", $CI->lang->line('common_det'),array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_details_count'))).'</td>';//inventory details	
	
	$table_data_row.='</tr>';
	return $table_data_row;
}


?>
