<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class chargeitpro_lib {

	protected $cip_oid = "";
	protected $cip_auth_token = "";
	protected $cip_environment = "";
	
	public function __construct()
	{
		$CI =& get_instance();
		//$CI->load->model('Appconfig'); 
		//print_r($CI->Appconfig->get_payment_device());exit();
		//$payment_device = $CI->Appconfig->get_payment_device();
		$CI->load->model('Gateways'); 
 		//print_r($CI->Gateways->get_default_gateway()->result());exit();
		$gateway_info= $CI->Gateways->get_default_gateway();
  		foreach ($gateway_info->result() as $gateways){
			  $device_oid = $gateways->MUinfo;
			  $device_auth_token = $gateways->MUkey;
			  $device_environment = $gateways->MUenvironment;
 		}
		
		//if(!empty($payment_device))
		if(!empty($gateway_info))
		{
			/*$this->cip_oid = $payment_device->device_oid;
			$this->cip_auth_token = $payment_device->device_auth_token;
			$this->cip_environment = $payment_device->device_environment;*/
			$this->cip_oid = $device_oid;
			$this->cip_auth_token = $device_auth_token;
			$this->cip_environment = $device_environment;
		}
		else
		{
			$this->cip_oid = "1822352550";
			$this->cip_auth_token = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJ0aWQiOjEwNSwib2lkIjoxODIyMzUyNTUwLCJ0b2tlbl91c2UiOiJvcnQiLCJybmQiOjE0NTcxNDA3NjIuOTg2NDI3LCJncm91cHMiOlsiT3JnQVBJVXNlcnMiXSwiaWF0IjoxNTUzMTAyMDYyfQ.hZ25fCZlWCNpNTv5EAvDyyv0C6osgmzx5M5lYevSwH4";
			$this->cip_environment = "sandbox";
		}
		/*$this->cip_oid = '1394243001';
		$this->cip_auth_token = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJ0aWQiOjEyLCJmcW9pZCI6IjEtMTM5NDI0MzAwMSIsInRva2VuX3VzZSI6Im9ydCIsInJuZCI6MTI2MTI5MzY4Ni45MDc4MTc4LCJncm91cHMiOlsiT3JnQVBJVXNlcnMiXSwiaWF0IjoxNTIzOTk2OTQ5fQ.SpHIMHvvpg83oXLQPDoy8c5Z3k6fAXuSudZ9s2aaA9c';
		$this->cip_environment = "sandbox";*/
	}

	/*Start CIP Transactions*/
	public function StartTransaction($params)
	{
		$cip_oid = $this->cip_oid;
		$cip_auth_token = $this->cip_auth_token;
		$cip_environment = $this->cip_environment;  //live or sandbox 

		$cip_transaction_type = $params->transaction_type;
		$cip_transaction_method = $params->transaction_method;
		$cip_transaction_fields = $params->transaction_fields;
	
		if ($cip_environment == 'live')
		$cip_environment = '';
		else
		$cip_environment = '-'.$cip_environment;

		$cip_url = 'https://api.emergepay'.$cip_environment;
		$cip_url.= '.chargeitpro.com/virtualterminal/v1'; 
		$cip_url.= '/orgs/' . $cip_oid . '/transactions/start'; 
	
		// Set the CIP post fields.
		//base_amount and external_tran_id are required in the fields array. 
		$cip_post_fields = array(
		  'transactionData' => array(
			'transactionType' => $cip_transaction_type,
			'method' => $cip_transaction_method,
			'fields' => $cip_transaction_fields
		  )
		);//print_r($cip_post_fields);
		
		$cip_curl_request->cip_curl_url = $cip_url;
		$cip_curl_request->cip_curl_auth_token = $cip_auth_token;
		$cip_curl_request->cip_curl_post_fields = $cip_post_fields;
		
		$cip_curl_response = $this->CIPHttpPost($cip_curl_request);

		if(!empty($cip_curl_response->transactionToken)) 
		{
		    $cip_error = 0;
		    $cip_response = $cip_curl_response->transactionToken;
        }
		else 
		{
		    $cip_error = 1;
		    $cip_response = $cip_curl_response->message;
        }

		$responseArray = array();
		$responseArray['CIP_Error'] = $cip_error;
		$responseArray['CIP_Response'] = $cip_response;
		
		return $responseArray;
	}
	
	/*Initiate CIP Device For Card*/
	//public function CallDevice($params)
	public function InitiateDevice($params)
	{
		$cip_oid = $this->cip_oid;
		$cip_auth_token = $this->cip_auth_token;
		$cip_environment = $this->cip_environment;  //live or sandbox 

		if ($cip_environment == 'live')
		$cip_environment = '';
		else
		$cip_environment = '-'.$cip_environment;

		$cip_transaction_token = $params->transaction_token;
		
		$cip_url = 'https://api.emergepay'.$cip_environment;
		$cip_url.= '.chargeitpro.com/device/v1/deviceTransactions/'.$cip_transaction_token; 
	
		$cip_curl_request->cip_curl_url = $cip_url;
		
		$cip_curl_response = $this->CIPHttpPut($cip_curl_request);

		if(!empty($cip_curl_response->status)) 
		{
		  if($cip_curl_response->status == 200)
		  {
		      $cip_error = 0;
		      $cip_response = "Your transaction start to your device";
		  }
		  else 
		  {
			  $cip_error = 1;
			  $cip_response = $cip_curl_response->message;
		  }
        }
		else 
		{
		    $cip_error = 1;
		    $cip_response = $cip_curl_response->message;
        }

		$responseArray = array();
		$responseArray['CIP_Error'] = $cip_error;
		$responseArray['CIP_Response'] = $cip_response;
		
		return $responseArray;
	}
	
	/*Retrieve/Pull CIP Results*/
	public function RetrieveResults($params)
	{
		$cip_oid = $this->cip_oid;
		$cip_auth_token = $this->cip_auth_token;
		$cip_environment = $this->cip_environment;  //live or sandbox 

		$cip_external_tran_id = $params->cip_external_tran_id;
	
		if ($cip_environment == 'live')
		$cip_environment = '';
		else
		$cip_environment = '-'.$cip_environment;

		$cip_url = 'https://api.emergepay'.$cip_environment;
		$cip_url.= '.chargeitpro.com/virtualterminal/v1'; 
		$cip_url.= '/orgs/' . $cip_oid . '/transactions/'.$cip_external_tran_id; 
		
		$cip_curl_request->cip_curl_url = $cip_url;
		$cip_curl_request->cip_curl_auth_token = $cip_auth_token;
		
		$cip_curl_response = $this->CIPHttpGet($cip_curl_request);

		if(!empty($cip_curl_response->transactionResponse)) 
		{
		  $result_message = $cip_curl_response->transactionResponse->resultMessage;
		  if($result_message == "Approved")
		  {
		      $cip_error = 0;
		      $cip_response = $cip_curl_response->transactionResponse;
		  }
		  else
		  {
			  $cip_error = 1;
		  	  $cip_response = $cip_curl_response->transactionResponse->resultMessage;
		  }
        }
		else 
		{
		    $cip_error = 1;
		    $cip_response = $cip_curl_response->message;
        }

		$responseArray = array();
		$responseArray['CIP_Error'] = $cip_error;
		$responseArray['CIP_Response'] = $cip_response;
		
		return $responseArray;
	}
	
	/*Adjusting a CIP Transactions*/
	public function AdjustTransaction($params)
	{
		$cip_oid = $this->cip_oid;
		$cip_auth_token = $this->cip_auth_token;
		$cip_environment = $this->cip_environment;  //live or sandbox 

		$cip_tip_amount = $params->cip_tip_amount;
		$cip_unique_transaction_id = $params->cip_unique_transaction_id;
		$cip_external_transaction_id = $params->cip_external_transaction_id;
	
		if ($cip_environment == 'live')
		$cip_environment = '';
		else
		$cip_environment = '-'.$cip_environment;

		$cip_url = 'https://api.emergepay'.$cip_environment;
		$cip_url.= '.chargeitpro.com/virtualterminal/v1'; 
		$cip_url.= '/orgs/' . $cip_oid . '/transactions/adjust'; 
	
		// Set the CIP post fields.
		//tipAmount and external_tran_id are required in the fields array. 
		$cip_post_fields = array(
		  'transactionData' => array(
			'uniqueTransId' => $cip_unique_transaction_id,
			'externalTransactionId' => $cip_external_transaction_id, 
			'adjustmentType' => 'SaleAdjust',
			'tipAmount' => $cip_tip_amount
		  )
		);//print_r($cip_post_fields);
		
		$cip_curl_request->cip_curl_url = $cip_url;
		$cip_curl_request->cip_curl_auth_token = $cip_auth_token;
		$cip_curl_request->cip_curl_post_fields = $cip_post_fields;
		
		$cip_curl_response = $this->CIPHttpPut($cip_curl_request);
		if(!empty($cip_curl_response->data->transactionResponse)) 
		{
		  $result_message = $cip_curl_response->data->transactionResponse->resultMessage;
		  if($result_message == "Approved")
		  {
		      $cip_error = 0;
		      $cip_response = $cip_curl_response->data->transactionResponse;
		  }
		  else
		  {
			  $cip_error = 1;
		  	  $cip_response = $cip_curl_response->data->transactionResponse->resultMessage;
		  }
        }
		else 
		{
		    $cip_error = 1;
		    $cip_response = $cip_curl_response->message;
        }
		
		$responseArray = array();
		$responseArray['CIP_Error'] = $cip_error;
		$responseArray['CIP_Response'] = $cip_response;
		
		return $responseArray;
	}
	
	/*Delete a CIP Transactions*/
	public function DeleteTransaction($params)
	{
		$cip_oid = $this->cip_oid;
		$cip_auth_token = $this->cip_auth_token;
		$cip_environment = $this->cip_environment;  //live or sandbox 

		if ($cip_environment == 'live')
		$cip_environment = '';
		else
		$cip_environment = '-'.$cip_environment;

		$cip_transaction_token = $params->transaction_token;
		
		$cip_url = 'https://api.emergepay'.$cip_environment;
		$cip_url.= '.chargeitpro.com/device/v1/deviceTransactions/'.$cip_transaction_token; 
	
		$cip_curl_request->cip_curl_url = $cip_url;
		
		$cip_curl_response = $this->CIPHttpDelete($cip_curl_request);

		if(!empty($cip_curl_response->status)) 
		{
		  if($cip_curl_response->status == 200)
		  {
		      $cip_error = 0;
		      $cip_response = "Your transaction deleted from device";
		  }
		  else 
		  {
			  $cip_error = 1;
			  $cip_response = $cip_curl_response->message;
		  }
        }
		else 
		{
		    $cip_error = 1;
		    $cip_response = $cip_curl_response->message;
        }

		$responseArray = array();
		$responseArray['CIP_Error'] = $cip_error;
		$responseArray['CIP_Response'] = $cip_response;
		
		return $responseArray;
	}
	
	/*Patch a CIP Transactions*/
	public function PatchTransaction($params)
	{
		$cip_oid = $this->cip_oid;
		$cip_auth_token = $this->cip_auth_token;
		$cip_environment = $this->cip_environment;  //live or sandbox 

		if ($cip_environment == 'live')
		$cip_environment = '';
		else
		$cip_environment = '-'.$cip_environment;

		$cip_transaction_token = $params->transaction_token;
		
		$cip_url = 'https://api.emergepay'.$cip_environment;
		$cip_url.= '.chargeitpro.com/device/v1/deviceTransactions/'.$cip_transaction_token; 
	
		$cip_curl_request->cip_curl_url = $cip_url;
		
		$cip_curl_response = $this->CIPHttpPatch($cip_curl_request);

		if(!empty($cip_curl_response->status)) 
		{
		  if($cip_curl_response->status == 200)
		  {
		      $cip_error = 0;
		      $cip_response = "Your transaction patched from device";
		  }
		  else 
		  {
			  $cip_error = 1;
			  $cip_response = $cip_curl_response->message;
		  }
        }
		else 
		{
		    $cip_error = 1;
		    $cip_response = $cip_curl_response->message;
        }

		$responseArray = array();
		$responseArray['CIP_Error'] = $cip_error;
		$responseArray['CIP_Response'] = $cip_response;
		
		return $responseArray;
	}
	
	/**
	 * Send HTTP POST Request
	 *
	 * @param	string	The API method name
	 * @param	string	The POST Message fields in &name=value pair format
	 * @return	array	Parsed HTTP Response body
	 */
	public function CIPHttpPost($request) {	
		
		//print_r($request);
		$cip_curl_url = $request->cip_curl_url;
		$cip_curl_auth_token = $request->cip_curl_auth_token;
		$cip_curl_post_fields = $request->cip_curl_post_fields;
		
		// Set the curl parameters.
		$cip_curl_request = curl_init();
		curl_setopt($cip_curl_request, CURLOPT_HEADER, false);
		//curl_setopt($cip_curl_request, CURLOPT_VERBOSE, true);
	
		// Turn off the server and peer verification (TrustManager Concept).
		//curl_setopt($cip_curl_request, CURLOPT_SSL_VERIFYPEER, false);
		//curl_setopt($cip_curl_request, CURLOPT_SSL_VERIFYHOST, false);
	
		curl_setopt($cip_curl_request, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($cip_curl_request, CURLOPT_HTTPHEADER, array("Content-Type: application/json", "Authorization: Bearer " . $cip_curl_auth_token));
		curl_setopt($cip_curl_request, CURLOPT_POST, true);
		
		// Set the request as a Url for curl.
		curl_setopt($cip_curl_request, CURLOPT_URL, $cip_curl_url);
		
		// Set the request as a POST FIELD for curl.
		curl_setopt($cip_curl_request, CURLOPT_POSTFIELDS, json_encode($cip_curl_post_fields));
	
		// Get response from the server.
		$cip_curl_response = curl_exec($cip_curl_request);
		curl_close($cip_curl_request);
				
		$cip_curl_response = json_decode($cip_curl_response);

		return $cip_curl_response;
	}
	
	/**
	 * Send HTTP Get Request
	 *
	 * @param	string	The API method name
	 * @param	string	The GET Message fields in &name=value pair format
	 * @return	array	Parsed HTTP Response body
	 */
	public function CIPHttpGet($request) {	
		
		//print_r($request);
		$cip_curl_url = $request->cip_curl_url;
		$cip_curl_auth_token = $request->cip_curl_auth_token;
		
		// Set the curl parameters.
		$cip_curl_request = curl_init($cip_curl_url);
		curl_setopt($cip_curl_request, CURLOPT_HEADER, false);
		curl_setopt($cip_curl_request, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($cip_curl_request, CURLOPT_HTTPHEADER, array("Content-Type: application/json", "Authorization: Bearer " . $cip_curl_auth_token));
		
		// Get response from the server.
		$cip_curl_response = curl_exec($cip_curl_request);
		curl_close($cip_curl_request);
				
		$cip_curl_response = json_decode($cip_curl_response);

		return $cip_curl_response;
	}
	
	/**
	 * Send HTTP PUT Request
	 *
	 * @param	string	The API method name
	 * @param	string	The PUT Message fields in &name=value pair format
	 * @return	array	Parsed HTTP Response body
	 */
	public function CIPHttpPut($request) {	
		
		$cip_curl_url = $request->cip_curl_url;
		$cip_curl_auth_token = $request->cip_curl_auth_token;
		$cip_curl_post_fields = $request->cip_curl_post_fields;
		
		// Set the curl parameters.
		$cip_curl_request = curl_init();
		curl_setopt($cip_curl_request, CURLOPT_HEADER, false);
		curl_setopt($cip_curl_request, CURLOPT_RETURNTRANSFER, true);
		
		if(!empty($cip_curl_auth_token))
		curl_setopt($cip_curl_request, CURLOPT_HTTPHEADER, array("Content-Type: application/json", "Content-Length: " . strlen(json_encode($cip_curl_post_fields)), "Authorization: Bearer " . $cip_curl_auth_token));
		
		//curl_setopt($cip_curl_request, CURLOPT_PUT, true);
		curl_setopt($cip_curl_request, CURLOPT_CUSTOMREQUEST, "PUT");
		
		// Set the request as a Url for curl.
		curl_setopt($cip_curl_request, CURLOPT_URL, $cip_curl_url);
		
		// Set the request as a POST FIELD for curl.
		if(!empty($cip_curl_post_fields))
		curl_setopt($cip_curl_request, CURLOPT_POSTFIELDS, json_encode($cip_curl_post_fields));
		
		// Get response from the server.
		$cip_curl_response = curl_exec($cip_curl_request);
		$cip_curl_response_status = curl_getinfo($cip_curl_request, CURLINFO_HTTP_CODE);
		curl_close($cip_curl_request);
		
		$cip_curl_response = json_decode($cip_curl_response);
		$cip_curl_response_array = array();
		$cip_curl_response_array['data'] = $cip_curl_response;
		$cip_curl_response_array['status'] = $cip_curl_response_status;
		$cip_curl_response_array['message'] = $cip_curl_response->message;
		$cip_curl_response = (object)$cip_curl_response_array;

		return $cip_curl_response;
	}
	
	/**
	 * Send HTTP DELETE Request
	 *
	 * @param	string	The API method name
	 * @return	array	Parsed HTTP Response body
	 */
	public function CIPHttpDelete($request) {	
		
		$cip_curl_url = $request->cip_curl_url;
		
		// Set the curl parameters.
		$cip_curl_request = curl_init();
		curl_setopt($cip_curl_request, CURLOPT_HEADER, false);
		curl_setopt($cip_curl_request, CURLOPT_RETURNTRANSFER, true);
		//curl_setopt($cip_curl_request, CURLOPT_DELETE, true);
		curl_setopt($cip_curl_request, CURLOPT_CUSTOMREQUEST, "DELETE");
		
		// Set the request as a Url for curl.
		curl_setopt($cip_curl_request, CURLOPT_URL, $cip_curl_url);
		
		// Get response from the server.
		$cip_curl_response = curl_exec($cip_curl_request);
		$cip_curl_response_status = curl_getinfo($cip_curl_request, CURLINFO_HTTP_CODE);
		curl_close($cip_curl_request);
		
		$cip_curl_response = json_decode($cip_curl_response);
		$cip_curl_response_array = array();
		$cip_curl_response_array['data'] = $cip_curl_response;
		$cip_curl_response_array['status'] = $cip_curl_response_status;
		$cip_curl_response_array['message'] = $cip_curl_response->message;
		$cip_curl_response = (object)$cip_curl_response_array;

		return $cip_curl_response;
	}
	
	/**
	 * Send HTTP PATCH Request
	 *
	 * @param	string	The API method name
	 * @return	array	Parsed HTTP Response body
	 */
	public function CIPHttpPatch($request) {	
		
		$cip_curl_url = $request->cip_curl_url;
		
		// Set the curl parameters.
		$cip_curl_request = curl_init();
		curl_setopt($cip_curl_request, CURLOPT_HEADER, false);
		curl_setopt($cip_curl_request, CURLOPT_RETURNTRANSFER, true);
		//curl_setopt($cip_curl_request, CURLOPT_PATCH, true);
		curl_setopt($cip_curl_request, CURLOPT_CUSTOMREQUEST, "PATCH");
		
		// Set the request as a Url for curl.
		curl_setopt($cip_curl_request, CURLOPT_URL, $cip_curl_url);
		
		// Get response from the server.
		$cip_curl_response = curl_exec($cip_curl_request);
		$cip_curl_response_status = curl_getinfo($cip_curl_request, CURLINFO_HTTP_CODE);
		curl_close($cip_curl_request);
		
		$cip_curl_response = json_decode($cip_curl_response);
		$cip_curl_response_array = array();
		$cip_curl_response_array['data'] = $cip_curl_response;
		$cip_curl_response_array['status'] = $cip_curl_response_status;
		$cip_curl_response_array['message'] = $cip_curl_response->message;
		$cip_curl_response = (object)$cip_curl_response_array;

		return $cip_curl_response;
	}

	/**
	 Generate Unique ID
	 */
	public function GUID()
	{
		if (function_exists('com_create_guid') === true)
		{
			return trim(com_create_guid(), '{}');
		}
	
		return sprintf('%04X%04X-%04X-%04X-%04X-%04X%04X%04X', mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(16384, 20479), mt_rand(32768, 49151), mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(0, 65535));
	}
	
	/**
	 * Send a POST request without using PHP's curl functions.
	 *
	 * @param string $url The URL you are sending the POST request to.
	 * @param array $postVars Associative array containing POST values.
	 * @return string The output response.
	 * @throws Exception If the request fails.
	 */
	public function CIPHttpPostWithoutCurl($url, $postVars = array()){
		//Transform our POST array into a URL-encoded query string.
		$postStr = http_build_query($postVars);
		//Create an $options array that can be passed into stream_context_create.
		$options = array(
			'http' =>
				array(
					'method'  => 'POST', //We are using the POST HTTP method.
					'header'  => 'Content-type: application/x-www-form-urlencoded',
					'content' => $postStr //Our URL-encoded query string.
				)
		);
		//Pass our $options array into stream_context_create.
		//This will return a stream context resource.
		$streamContext  = stream_context_create($options);
		//Use PHP's file_get_contents function to carry out the request.
		//We pass the $streamContext variable in as a third parameter.
		$result = file_get_contents($url, false, $streamContext);
		//If $result is FALSE, then the request has failed.
		if($result === false){
			//If the request failed, throw an Exception containing
			//the error.
			$error = error_get_last();
			throw new Exception('POST request failed: ' . $error['message']);
		}
		//If everything went OK, return the response.
		return $result;
	}

	/*
	* Refund Payment with transaction id
	* ref: https://dev.gravitypayments.com/docs/emergepay/tokenized-transactions/tokenized-refund/
	*/ 
	public function RefundTransaction($uniqueTransId,$amount)
	{
		//Configure your oid and authToken. These are supplied by ChargeItPro.
		$oid = $this->cip_oid;
		$authToken = $this->cip_auth_token;
		$cip_environment = $this->cip_environment;

		if ($cip_environment == 'live')
			$cip_environment = '';
		else
			$cip_environment = '-'.$cip_environment;

		$environmentUrl = 'https://api.emergepay'.$cip_environment;
		$environmentUrl.= '.chargeitpro.com/virtualterminal/v1'; 
	
		$url = $environmentUrl . '/orgs/' . $oid . '/transactions/tokenizedRefund';
		//Set the uniqueTransId you want to use to run the tokenized refund.
		// $uniqueTransId = "adc5fdd644d4488e8e31b8d235061809-0d0eb5f5ec604849aed1d8fdd1611338";
		//Configure the request body.
		//uniqueTransId, externalTransactionId, and amount are all required.
		$body = array(
		  'transactionData' => array(
		    'uniqueTransId' => $uniqueTransId,
		    'externalTransactionId' => $this->GUID(),
		    'amount'=>$amount
		     //optional values
		    /*'cashierId' => '',
		    'billingName' => '',
		    'billingAddress' => '',
		    'billingPostalCode' => '',
		    'transactionReference' => ''*/
		  )
		);

		// if($amount != 'full')
		// 	$body['transactionData']['amount'] = $amount;

		$payload = json_encode($body);

		//Configure the request
		$request = curl_init($url);
		curl_setopt($request, CURLOPT_HEADER, false);
		curl_setopt($request, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($request, CURLOPT_HTTPHEADER, array('Content-Type: application/json', 'Content-Length: ' . strlen($payload), 'Authorization: Bearer ' . $authToken));
		curl_setopt($request, CURLOPT_CUSTOMREQUEST, "PUT");
		curl_setopt($request, CURLOPT_POSTFIELDS, $payload);

		//Issue the request and get the result
		$response = curl_exec($request);
		curl_close($request);

		//Helper function used to generate a GUID/UUID
		//source: http://php.net/manual/en/function.com-create-guid.php#99425
		// echo $response;
		$cip_curl_response['data'] = json_decode($response,true);

		if(!empty($cip_curl_response['data']['transactionResponse'])) 
		{
		  $result_message = $cip_curl_response['data']['transactionResponse']['resultMessage'];
		  // echo "<pre>";
		  // print_r($result_message);
		  if($result_message == "Approved")
		  {
		      $cip_error = 0;
		      $cip_response = $cip_curl_response['data']['transactionResponse'];
		  }
		  else
		  {
			  $cip_error = 1;
		  	  $cip_response = $cip_curl_response['data']['transactionResponse']['resultMessage'];
		  }
        }
		else 
		{
		    $cip_error = 1;
		    $cip_response = $cip_curl_response['data']['message'];
        }
		
		$responseArray = array();
		$responseArray['CIP_Error'] = $cip_error;
		$responseArray['CIP_Response'] = $cip_response;
		
		return $responseArray;
	}
	
}
?>