<?php
class Sale extends Model
{
	
	/*
	Set Store Table
	*/
	public $store;
	function setStore($store)
	{
		$this->store==$store;
	}
	
	public function get_info($sale_id)
	{
		$this->db->from('sales');
		$this->db->where('sale_id',$sale_id);
		return $this->db->get();
	}

	function exists($sale_id)
	{
		$this->db->from('sales');
		$this->db->where('sale_id',$sale_id);
		$query = $this->db->get();

		return ($query->num_rows()==1);
	}
	
	function update($sale_data, $sale_id)
	{
		$this->db->where('sale_id', $sale_id);
		$success = $this->db->update('sales',$sale_data);
		
		return $success;
	}
	
	/*function save ($items,$customer_id,$employee_id,$comment,$payments,$sale_id=false)*/
	function save ($items,$customer_id,$employee_id,$comment,$payments,$sale_id=false,$tax_comment="",$total_sale_amount="",$return_payment_response="",$return_gateway_id=0,$mode="",$return_sale_id="",$account_name="")
	{
		if(count($items)==0)
			return -1;

		//Alain Multiple payments
		//Build payment types string
		$payment_types='';
		foreach($payments as $payment_id=>$payment)
		{
			$payment_types=$payment_types.$payment['payment_type'].': '.to_currency($payment['payment_amount']).'<br />';
		}

		$CP=0;
		$sv=0;
		$profit=0;
		foreach($items as $line=>$item)
		{
			$cur_item_info = $this->Item->get_info($item['item_id']);

			$CP=($cur_item_info->cost_price+$CP);
			$sv=($cur_item_info->retailprice*$item['quantity'])+$sv;
			$profit=(($cur_item_info->retailprice-$cur_item_info->cost_price)*$item['quantity'])+$profit;
		}
		
		$sales_data = array(
			'sale_time' => date('Y-m-d H:i:s'),
			'customer_id'=> $this->Customer->exists($customer_id) ? $customer_id : null,
			'employee_id'=>$employee_id,
			'payment_type'=>$payment_types,
			'totalCP'=>$CP,
			'totalSV'=>$sv,
			'profit'=>$profit,
			'comment'=>$comment,
			'tax_comment'=>$tax_comment,
			'total_sale_amount'=>$total_sale_amount,
			'return_gateway_response_data'=>$return_payment_response,
			'return_gateway_id'=>$return_gateway_id
		);


		//Run these queries as a transaction, we want to make sure we do all or nothing
		$this->db->trans_start();

		$this->db->insert('sales',$sales_data);
		$sale_id = $this->db->insert_id();
		
		foreach($payments as $payment_id=>$payment)
		{
			if ( substr( $payment['payment_type'], 0, strlen( $this->lang->line('sales_giftcard') ) ) == $this->lang->line('sales_giftcard') )
			{
				/* We have a gift card and we have to deduct the used value from the total value of the card. */
				$splitpayment = explode( ':', $payment['payment_type'] );
				$cur_giftcard_value = $this->Giftcard->get_giftcard_value( $splitpayment[1] );
				$this->Giftcard->update_giftcard_value( $splitpayment[1], $cur_giftcard_value - $payment['payment_amount'] );
			}

			$sales_payments_data = array
			(
				'sale_id'=>$sale_id,
				'payment_type'=>$payment['payment_type'],
				'payment_amount'=>$payment['payment_amount']
			);
			$this->db->insert('sales_payments',$sales_payments_data);
		}
		$wp_data=array();
		foreach($items as $line=>$item)
		{
			if($mode == "return" && $return_sale_id != "")
			{
				$this->db->where(['sale_id'=>$return_sale_id,'item_id'=>$item['item_id']]);
				$this->db->set('returned_qty', 'returned_qty+'.($item['quantity']), FALSE);
				$this->db->update('sales_items');
			}

			$return_reason = "";
			if($mode == "return")
			{
				if(empty($item['select_reason']))
				{
					$return_reason = "Changed Mind";
				}
				else
				{
					$return_reason = $item['select_reason'];
				}				
			}

			$cur_item_info = $this->Item->get_info($item['item_id']);

			$sales_items_data = array
			(
				'sale_id'=>$sale_id,
				'item_id'=>$item['item_id'],
				'line'=>$item['line'],
				'description'=>$item['description'],
				'serialnumber'=>$item['serialnumber'],
				'quantity_purchased'=>$item['quantity'],
				'discount_percent'=>$item['discount'],
				//'discount_amount'=>$item['discount_amount'],
				'discount_amount'=>$item['discount_amount']!=null ? $item['discount_amount']: 0,
				'item_cost_price' => $cur_item_info->cost_price,
				'item_retailprice'=>$cur_item_info->retailprice,
				'item_unit_price'=>$item['price'],
				'return_reason'=>$return_reason,
			);

			$this->db->insert('sales_items',$sales_items_data);
				
			if($mode != "return" || ($mode == "return" && $return_reason != 'Defective item'))
			{
				//Update stock quantity
				$item_data = array('quantity'=>$cur_item_info->quantity - $item['quantity']);
				//$this->Item->save($item_data,$item['item_id']);
				$this->Item->save_sale_item($item_data,$item['item_id']);				
				
				//return print_r($this->session->userdata);
				$wp_data['quantity']=$item_data['quantity'];
				$wp_data['wp_pid']=$cur_item_info->wp_pid;
				 //print_r($wp_data);
				$this->load->library('sale_lib');
			    $wp_result = $this->sale_lib->runWPSitebuilderCurl($account_name,'wrkmash_update_product_quantity',$wp_data);			
			}
		
			//Ramel Inventory Tracking
			//Inventory Count Details
			$qty_buy = -$item['quantity'];
			//$sale_remarks ='POS '.$sale_id;
			$sale_remarks ='Item Sold';
			$inv_data = array
			(
				'trans_date'=>date('Y-m-d H:i:s'),
				'trans_items'=>$item['item_id'],
				'trans_user'=>$employee_id,
				'trans_comment'=>$sale_remarks,
				'trans_inventory'=>$qty_buy
			);
			
			$this->Inventory->insert($inv_data);
			//------------------------------------Ramel
			$customer = $this->Customer->get_info($customer_id);
 			
			if ($customer_id == -1 or $customer->taxable)
 			{
				foreach($this->Item_taxes->get_info($item['item_id']) as $row)
				{
					 
					$this->db->insert('sales_items_taxes', array(
						'sale_id' 	=>$sale_id,
						'item_id' 	=>$item['item_id'],
						'line'      =>$item['line'],
						'name'		=>$row['name'],
						'percent' 	=>$row['percent']
					));
				}
			}
		}
		
		$this->db->trans_complete();
		
		/*if ($this->db->trans_status() === FALSE)
		{
			return -1;
		}*/
		
		return $sale_id;
	}
	
	function delete($sale_id)
	{
		//Run these queries as a transaction, we want to make sure we do all or nothing
		$this->db->trans_start();
		
		$this->db->delete('sales_payments', array('sale_id' => $sale_id)); 
		$this->db->delete('sales_items_taxes', array('sale_id' => $sale_id)); 
		$this->db->delete('sales_items', array('sale_id' => $sale_id)); 
		$this->db->delete('sales', array('sale_id' => $sale_id)); 
		
		$this->db->trans_complete();
				
		return $this->db->trans_status();
	}

	function get_sale_items($sale_id)
	{
		$this->db->from('sales_items');
		$this->db->where('sale_id',$sale_id);
		return $this->db->get();
	}

	function get_sale_payments($sale_id)
	{
		$this->db->from('sales_payments');
		$this->db->where('sale_id',$sale_id);
		return $this->db->get();
	}

	function get_customer($sale_id)
	{
		$this->db->from('sales');
		$this->db->where('sale_id',$sale_id);
		return $this->Customer->get_info($this->db->get()->row()->customer_id);
	}

	//We create a temp table that allows us to do easy report/sales queries
	public function create_sales_items_temp_table()
	{
		$this->db->query("CREATE TEMPORARY TABLE ".$this->db->dbprefix('sales_items_temp')."
		(SELECT date(sale_time) as sale_date, ".$this->db->dbprefix('sales_items').".sale_id, comment,payment_type, customer_id, employee_id, 
		".$this->db->dbprefix('items').".item_id, supplier_id, quantity_purchased, item_cost_price, item_unit_price, SUM(percent) as item_tax_percent,
		discount_percent,discount_amount, (item_unit_price*quantity_purchased-(item_unit_price*quantity_purchased*discount_percent/100)-discount_amount) as subtotal,
		".$this->db->dbprefix('sales_items').".line as line, serialnumber, ".$this->db->dbprefix('sales_items').".description as description,
		ROUND((item_unit_price*quantity_purchased-(item_unit_price*quantity_purchased*discount_percent/100)-discount_amount)*(1+(SUM(percent)/100)),2) as total,
		ROUND((item_unit_price*quantity_purchased-(item_unit_price*quantity_purchased*discount_percent/100)-discount_amount)*(SUM(percent)/100),2) as tax,
		(item_unit_price*quantity_purchased-(item_unit_price*quantity_purchased*discount_percent/100)-discount_amount) - (item_cost_price*quantity_purchased) as profit
		FROM ".$this->db->dbprefix('sales_items')."
		INNER JOIN ".$this->db->dbprefix('sales')." ON  ".$this->db->dbprefix('sales_items').'.sale_id='.$this->db->dbprefix('sales').'.sale_id'."
		INNER JOIN ".$this->db->dbprefix('items')." ON  ".$this->db->dbprefix('sales_items').'.item_id='.$this->db->dbprefix('items').'.item_id'."
		LEFT OUTER JOIN ".$this->db->dbprefix('suppliers')." ON  ".$this->db->dbprefix('items').'.supplier_id='.$this->db->dbprefix('suppliers').'.person_id'."
		LEFT OUTER JOIN ".$this->db->dbprefix('sales_items_taxes')." ON  "
		.$this->db->dbprefix('sales_items').'.sale_id='.$this->db->dbprefix('sales_items_taxes').'.sale_id'." and "
		.$this->db->dbprefix('sales_items').'.item_id='.$this->db->dbprefix('sales_items_taxes').'.item_id'." and "
		.$this->db->dbprefix('sales_items').'.line='.$this->db->dbprefix('sales_items_taxes').'.line'."
		GROUP BY sale_id, item_id, line)");

		//Update null item_tax_percents to be 0 instead of null
		$this->db->where('item_tax_percent IS NULL');
		$this->db->update('sales_items_temp', array('item_tax_percent' => 0));

		//Update null tax to be 0 instead of null
		$this->db->where('tax IS NULL');
		$this->db->update('sales_items_temp', array('tax' => 0));

		//Update null subtotals to be equal to the total as these don't have tax
		$this->db->query('UPDATE '.$this->db->dbprefix('sales_items_temp'). ' SET total=subtotal WHERE total IS NULL');
	}
	
	public function get_giftcard_value( $giftcardNumber )
	{
		if ( !$this->Giftcard->exists( $this->Giftcard->get_giftcard_id($giftcardNumber)))
			return 0;
		
		$this->db->from('giftcards');
		$this->db->where('giftcard_number',$giftcardNumber);
		return $this->db->get()->row()->value;
	}
	
	function get_tips()
	{
		$this->db->from('tips');
		$this->db->where('status',1);
		$this->db->order_by("value", "asc");
		return $this->db->get();
	}
	
	function get_customer_email($email)
	{
		$this->db->from('people');
		$this->db->where('email',$email);
		return $this->db->get()->row()->person_id;
	}

	function addCustomerData(&$person_data)
	{
		$success=false;
		$this->db->trans_start();
		if(!empty($person_data))
		{
			if(empty($person_data['person_id']))
			{
			  /*Save Customers Data in Pos*/
			  $customer_data = array();
			  //$this->db->dbprefix = "opos_";
			  $this->db->insert('people',$person_data);
			  $person_id = $this->db->insert_id();
			  $customer_data['person_id'] = $person_id;
			  $success = $this->db->insert('customers',$customer_data);
			  
			  /*Save Customers Data in Accounting Debtor*/
			  $this->db->dbprefix = "accounting_";
			  $data_debtors_master = array();
			  $data_debtors_master['application'] = 2;
			  $data_debtors_master['pos_customer_id'] = $person_id;
			  $data_debtors_master['name'] = $person_data['first_name']." ".$person_data['last_name'];
			  $data_debtors_master['debtor_ref'] = $person_data['first_name']." ".$person_data['last_name'];
			  $data_debtors_master['sales_type'] = 1;
			  $data_debtors_master['dimension_id'] = 0;
			  $data_debtors_master['credit_status'] = 1;
			  $data_debtors_master['payment_terms'] = 4;
			  $data_debtors_master['inactive'] = 0;
			  $this->db->insert('debtors_master',$data_debtors_master);
			  $debtor_no = $this->db->insert_id();
			  
			  /*Update Customers Data in Pos*/
			  $this->db->dbprefix = "opos_";
			  $data_debtors_customer = array();
			  $data_debtors_customer['accounting_customer_id'] = $debtor_no;
			  $this->db->where('person_id', $person_id);
			  $this->db->update('customers',$data_debtors_customer);
			  
			  /*Save Customers Data in Accounting Customer Branch*/
			  $this->db->dbprefix = "accounting_";
			  $data_cust_branch = array();
			  $data_cust_branch['application'] = 2;
			  $data_cust_branch['pos_customer_id'] = $person_id;
			  $data_cust_branch['debtor_no'] = $debtor_no;
			  $data_cust_branch['br_name'] = $person_data['first_name']." ".$person_data['last_name'];
			  $data_cust_branch['branch_ref'] = $person_data['first_name']." ".$person_data['last_name'];
			  $data_cust_branch['area'] = 1;
			  $data_cust_branch['salesman'] = 1;
			  $data_cust_branch['contact_name'] = "Main Branch";
			  $data_cust_branch['default_location'] = "DEF";
			  $data_cust_branch['tax_group_id'] = 1;
			  $data_cust_branch['sales_discount_account'] = 4510;
			  $data_cust_branch['receivables_account'] = 1200;
			  $data_cust_branch['payment_discount_account'] = 4500;
			  $data_cust_branch['default_ship_via'] = 1;
			  $data_cust_branch['inactive'] = 0;
			  $this->db->insert('cust_branch',$data_cust_branch);
			  $branch_code = $this->db->insert_id();
	  
			  /*Save Customers Data in Accounting Persons*/
			  $data_crm_persons = array();
			  $data_crm_persons['application'] = 2;
			  $data_crm_persons['pos_customer_id'] = $person_id;
			  $data_crm_persons['ref'] = $person_data['first_name']." ".$person_data['last_name'];
			  $data_crm_persons['name'] = $person_data['first_name'];
			  $data_crm_persons['name2'] = $person_data['last_name'];
			  $data_crm_persons['phone'] = $person_data['phone_number'];
			  $data_crm_persons['phone2'] = $person_data['phone_number'];
			  $data_crm_persons['email'] = $person_data['email'];
			  $data_crm_persons['inactive'] = 0;
			  $success = $this->db->insert('crm_persons',$data_crm_persons);
			  
			  /*Save Branch Data*/
			  $data_crm_contacts = array();
			  $data_crm_contacts['person_id'] = $person_id;
			  $data_crm_contacts['type'] = "cust_branch";
			  $data_crm_contacts['action'] = "general";
			  $data_crm_contacts['entity_id'] = $debtor_no;
			  $success = $this->db->insert('crm_contacts',$data_crm_contacts);
			  
			  /*Save Branch Data*/
			  $data_crm_contacts = array();
			  $data_crm_contacts['person_id'] = $person_id;
			  $data_crm_contacts['type'] = "cust_branch";
			  $data_crm_contacts['action'] = "general";
			  $data_crm_contacts['entity_id'] = $branch_code;
			  $success = $this->db->insert('crm_contacts',$data_crm_contacts);
			}
			else
			{
			  /*Update Customers Data in Pos*/
			  $person_id = $person_data['person_id'];
			  //$this->db->dbprefix = "opos_";
			  $this->db->where('person_id', $person_id);
			  $this->db->update('people',$person_data);
			  
			  /*Update Customers Data in Accounting Debtor*/
			  $this->db->dbprefix = "accounting_";
			  $data_debtors_master = array();
			  $data_debtors_master['application'] = 2;
			  $data_debtors_master['pos_customer_id'] = $person_id;
			  $data_debtors_master['name'] = $person_data['first_name']." ".$person_data['last_name'];
			  $data_debtors_master['debtor_ref'] = $person_data['first_name']." ".$person_data['last_name'];
			  $this->db->where('pos_customer_id', $person_id);
			  $this->db->update('debtors_master',$data_debtors_master);
			}
		}
		$this->db->trans_complete();
		return $this->db->trans_status();
	}	
}
?>