/*var wrapper = document.getElementById("signature-pad"),
    clearButton = wrapper.querySelector("[data-action=clear]"),
    saveButton = wrapper.querySelector("[data-action=save]"),
    canvas = wrapper.querySelector("canvas"),
    signaturePad;

// Adjust canvas coordinate space taking into account pixel ratio,
// to make it look crisp on mobile devices.
// This also causes canvas to be cleared.
function resizeCanvas() {
    // When zoomed out to less than 100%, for some very strange reason,
    // some browsers report devicePixelRatio as less than 1
    // and only part of the canvas is cleared then.
    var ratio =  Math.max(window.devicePixelRatio || 1, 1);
    canvas.width = canvas.offsetWidth * ratio;
    canvas.height = canvas.offsetHeight * ratio;
    canvas.getContext("2d").scale(ratio, ratio);
}

window.onresize = resizeCanvas;
resizeCanvas();

signaturePad = new SignaturePad(canvas);

clearButton.addEventListener("click", function (event) {
    signaturePad.clear();
});

saveButton.addEventListener("click", function (event) {
    if (signaturePad.isEmpty()) {
        alert("Please provide signature first.");
    } else {
        window.open(signaturePad.toDataURL());
    }
});*/
var canvas = document.querySelector("canvas");

//var signaturePad = new SignaturePad(canvas);
var signaturePad = new SignaturePad(canvas, {
    minWidth: 1,
    maxWidth: 2,
    penColor: "rgb(0, 0, 0)"
});

// Returns signature image as data URL (see https://mdn.io/todataurl for the list of possible paramters)
//signaturePad.toDataURL(); // save image as PNG
//signaturePad.toDataURL("image/jpeg"); // save image as JPEG

// Draws signature image from data URL
//signaturePad.fromDataURL("data:image/png;base64,iVBORw0K...");

// Clears the canvas
//signaturePad.clear();

// Returns true if canvas is empty, otherwise returns false
//signaturePad.isEmpty();

// Unbinds all event handlers
//signaturePad.off();

// Rebinds all event handlers
//signaturePad.on();

function resizeCanvas() {
    var ratio =  Math.max(window.devicePixelRatio || 1, 1);
    canvas.width = canvas.offsetWidth * ratio;
    canvas.height = canvas.offsetHeight * ratio;
    canvas.getContext("2d").scale(ratio, ratio);
    signaturePad.clear(); // otherwise isEmpty() might return incorrect value
}

window.addEventListener("resize", resizeCanvas);
resizeCanvas();

var clearButton = document.getElementById("clear_signature");
clearButton.addEventListener("click", function (event) {
    signaturePad.clear();
});