<?php
/*
Gets the html table to manage people.
*/
function get_people_manage_table($people,$controller)
{
	$CI =& get_instance();
	$table='<table class="tablesorter" id="sortable_table">';
	
	$headers = array('<input type="checkbox" id="select_all" />', 
	$CI->lang->line('common_last_name'),
	$CI->lang->line('common_first_name'),
	$CI->lang->line('common_email'),
	$CI->lang->line('common_phone_number'),
	'&nbsp');
	
	$table.='<thead><tr>';
	foreach($headers as $header)
	{
		$table.="<th>$header</th>";
	}
	$table.='</tr></thead><tbody>';
	$table.=get_people_manage_table_data_rows($people,$controller);
	$table.='</tbody></table>';
	return $table;
}

/*
Gets the html data rows for the people.
*/
function get_people_manage_table_data_rows($people,$controller)
{
	$CI =& get_instance();
	$table_data_rows='';
	
	foreach($people->result() as $person)
	{
		$table_data_rows.=get_person_data_row($person,$controller);
	}
	
	if($people->num_rows()==0)
	{
		$table_data_rows.="<tr><td colspan='6'><div class='warning_message' style='padding:7px;'>".$CI->lang->line('common_no_persons_to_display')."</div></tr></tr>";
	}
	
	return $table_data_rows;
}

function get_person_data_row($person,$controller)
{
	$CI =& get_instance();
	$controller_name=$CI->uri->segment(1);
	$width = $controller->get_form_width();

	$table_data_row='<tr>';
	$table_data_row.="<td width='5%'><input type='checkbox' id='person_$person->person_id' value='".$person->person_id."'/></td>";
	$table_data_row.='<td width="20%">'.character_limiter($person->last_name,13).'</td>';
	$table_data_row.='<td width="20%">'.character_limiter($person->first_name,13).'</td>';
	$table_data_row.='<td width="30%">'.mailto($person->email,character_limiter($person->email,22)).'</td>';
	$table_data_row.='<td width="20%">'.character_limiter($person->phone_number,13).'</td>';		
	$table_data_row.='<td width="5%">'.anchor($controller_name."/view/$person->person_id/width:$width", $CI->lang->line('common_edit'),array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_update'))).'</td>';		
	$table_data_row.='</tr>';
	
	return $table_data_row;
}

/*
Gets the html table to manage suppliers.
*/
function get_supplier_manage_table($suppliers,$controller)
{
	$CI =& get_instance();
	$table='<table class="tablesorter" id="sortable_table">';
	
	$headers = array('<input type="checkbox" id="select_all" />',
	$CI->lang->line('suppliers_company_name'),
	$CI->lang->line('common_last_name'),
	$CI->lang->line('common_first_name'),
	$CI->lang->line('common_email'),
	$CI->lang->line('common_phone_number'),
	'&nbsp');
	
	$table.='<thead><tr>';
	foreach($headers as $header)
	{
		$table.="<th>$header</th>";
	}
	$table.='</tr></thead><tbody>';
	$table.=get_supplier_manage_table_data_rows($suppliers,$controller);
	$table.='</tbody></table>';
	return $table;
}

/*
Gets the html data rows for the supplier.
*/
function get_supplier_manage_table_data_rows($suppliers,$controller)
{
	$CI =& get_instance();
	$table_data_rows='';
	
	foreach($suppliers->result() as $supplier)
	{
		$table_data_rows.=get_supplier_data_row($supplier,$controller);
	}
	
	if($suppliers->num_rows()==0)
	{
		$table_data_rows.="<tr><td colspan='7'><div class='warning_message' style='padding:7px;'>".$CI->lang->line('common_no_persons_to_display')."</div></tr></tr>";
	}
	
	return $table_data_rows;
}

function get_supplier_data_row($supplier,$controller)
{
	$CI =& get_instance();
	$controller_name=$CI->uri->segment(1);
	$width = $controller->get_form_width();

	$table_data_row='<tr>';
	$table_data_row.="<td width='5%'><input type='checkbox' id='person_$supplier->person_id' value='".$supplier->person_id."'/></td>";
	$table_data_row.='<td width="17%">'.character_limiter($supplier->company_name,13).'</td>';
	$table_data_row.='<td width="17%">'.character_limiter($supplier->last_name,13).'</td>';
	$table_data_row.='<td width="17%">'.character_limiter($supplier->first_name,13).'</td>';
	$table_data_row.='<td width="22%">'.mailto($supplier->email,character_limiter($supplier->email,22)).'</td>';
	$table_data_row.='<td width="17%">'.character_limiter($supplier->phone_number,13).'</td>';		
	$table_data_row.='<td width="5%">'.anchor($controller_name."/view/$supplier->person_id/width:$width", $CI->lang->line('common_edit'),array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_update'))).'</td>';		
	$table_data_row.='</tr>';
	
	return $table_data_row;
}

/*
Gets the html table to manage items.
*/
function get_items_manage_table($items,$controller)
{
	$CI =& get_instance();
	$table='<table class="tablesorter" id="sortable_table">';
	
	$headers = array('<input type="checkbox" id="select_all" />', 
	$CI->lang->line('items_item_number'),
	$CI->lang->line('items_name'),
	$CI->lang->line('items_category'),
	$CI->lang->line('items_cost_price'),
	
	//$CI->lang->line('items_unit_price'),
	$CI->lang->line('items_retail_price'),
	$CI->lang->line('items_tax_percents'),
	$CI->lang->line('items_quantity'),
	'&nbsp', 
	'View History'//Ramel Inventory Tracking
	);
	

	$table.='<thead><tr>';
	foreach($headers as $header)
	{
		$table.="<th>$header</th>";
	}
	$table.='</tr></thead><tbody>';
	$table.=get_items_manage_table_data_rows($items,$controller);
	$table.='</tbody></table>';
	return $table;
}


/*
Gets the html data rows for the items.
*/
function get_items_manage_table_data_rows($items,$controller)
{
	$CI =& get_instance();
	$table_data_rows='';
	if($items)
	{
	foreach($items->result() as $item)
	{
		$table_data_rows.=get_item_data_row($item,$controller);
	}
	
	if($items->num_rows()==0)
	{
		$table_data_rows.="<tr><td colspan='11'><div class='warning_message' style='padding:7px;'>".$CI->lang->line('items_no_items_to_display')."</div></tr></tr>";
	}
	}
	else
	{
		$table_data_rows.="<tr><td colspan='11'><div class='warning_message' style='padding:7px;'>".$CI->lang->line('items_no_items_to_display')."</div></tr></tr>";
	}
	
	return $table_data_rows;
}

function get_item_data_row($item,$controller)
{
	$CI =& get_instance();
	$item_tax_info=$CI->Item_taxes->get_info($item->item_id);
	$tax_percents = '';
	foreach($item_tax_info as $tax_info)
	{
		$tax_percents.=$tax_info['percent']. '%, ';
	}
	$tax_percents=substr($tax_percents, 0, -2);
	$controller_name=$CI->uri->segment(1);
	$width = $controller->get_form_width();

	$table_data_row='<tr>';
	$table_data_row.="<td width='3%'><input type='checkbox' id='item_$item->item_id' value='".$item->item_id."'/></td>";
	$table_data_row.='<td width="15%">'.$item->item_number.'</td>';
	$table_data_row.='<td width="20%">'.$item->name.'</td>';
	$table_data_row.='<td width="14%">'.$item->category.'</td>';
	$table_data_row.='<td width="14%">'.to_currency($item->cost_price).'</td>';
	$table_data_row.='<td width="14%">'.to_currency($item->unit_price).'</td>';
	$table_data_row.='<td width="14%">'.$tax_percents.'</td>';	
	$table_data_row.='<td width="14%">'.$item->quantity.'</td>';
	$table_data_row.='<td width="5%">'.anchor($controller_name."/view/$item->item_id/width:$width", $CI->lang->line('common_edit'),array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_update'))).'</td>';		
	
	//Ramel Inventory Tracking
	
	$table_data_row.='<td width="10%">'.anchor('', '-',array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_count')))./*'</td>';//inventory count	
	$table_data_row.='<td width="5%">'*/'&nbsp;&nbsp;&nbsp;&nbsp;'.anchor($controller_name."/count_details/$item->item_id/width:$width", $CI->lang->line('common_det'),array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_details_count'))).'</td>';//inventory details	
	
	$table_data_row.='</tr>';
	return $table_data_row;
}

/*
Gets the html table to manage giftcards.
*/
function get_giftcards_manage_table( $giftcards, $controller )
{
	$CI =& get_instance();
	
	$table='<table class="tablesorter" id="sortable_table">';
	
	$headers = array('<input type="checkbox" id="select_all" />', 
	$CI->lang->line('giftcards_giftcard_number'),
	$CI->lang->line('giftcards_card_value'),
	'&nbsp', 
	);
	
	$table.='<thead><tr>';
	foreach($headers as $header)
	{
		$table.="<th>$header</th>";
	}
	$table.='</tr></thead><tbody>';
	$table.=get_giftcards_manage_table_data_rows( $giftcards, $controller );
	$table.='</tbody></table>';
	return $table;
}

/*
Gets the html data rows for the giftcard.
*/
function get_giftcards_manage_table_data_rows( $giftcards, $controller )
{
	$CI =& get_instance();
	$table_data_rows='';
	
	foreach($giftcards->result() as $giftcard)
	{
		$table_data_rows.=get_giftcard_data_row( $giftcard, $controller );
	}
	
	if($giftcards->num_rows()==0)
	{
		$table_data_rows.="<tr><td colspan='11'><div class='warning_message' style='padding:7px;'>".$CI->lang->line('giftcards_no_giftcards_to_display')."</div></tr></tr>";
	}
	
	return $table_data_rows;
}

function get_giftcard_data_row($giftcard,$controller)
{
	$CI =& get_instance();
	$controller_name=$CI->uri->segment(1);
	$width = $controller->get_form_width();

	$table_data_row='<tr>';
	$table_data_row.="<td width='3%'><input type='checkbox' id='giftcard_$giftcard->giftcard_id' value='".$giftcard->giftcard_id."'/></td>";
	$table_data_row.='<td width="15%">'.$giftcard->giftcard_number.'</td>';
	$table_data_row.='<td width="20%">'.to_currency($giftcard->value).'</td>';
	$table_data_row.='<td width="5%">'.anchor($controller_name."/view/$giftcard->giftcard_id/width:$width", $CI->lang->line('common_edit'),array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_update'))).'</td>';		
	
	$table_data_row.='</tr>';
	return $table_data_row;
}
function get_gateway_data_row($gateways,$controller)
{
	$CI =& get_instance();
	$controller_name=$CI->uri->segment(1);
	  $table = $controller->get_form_width();

//	$table_data_row='<tr>';
//	$table_data_row.="<td width='5%'><input type='checkbox' id='person_$person->person_id' value='".$person->person_id."'/></td>";
//	$table_data_row.='<td width="20%">'.character_limiter($person->last_name,13).'</td>';
//	$table_data_row.='<td width="20%">'.character_limiter($person->first_name,13).'</td>';
//	$table_data_row.='<td width="30%">'.mailto($person->email,character_limiter($person->email,22)).'</td>';
//	$table_data_row.='<td width="20%">'.character_limiter($person->phone_number,13).'</td>';		
//	$table_data_row.='<td width="5%">'.anchor($controller_name."/view/$person->person_id/width:$width", $CI->lang->line('common_edit'),array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_update'))).'</td>';		
//	$table_data_row.='</tr>';
	
	return $table;
}

/*
Gets the html table to manage stores.
*/
function get_stores_manage_table( $stores, $controller )
{
	$CI =& get_instance();
	
	$table='<table class="tablesorter" id="sortable_table">';
	
	/*$headers = array('<input type="checkbox" id="select_all" />', 
	$CI->lang->line('giftcards_giftcard_number'),
	$CI->lang->line('giftcards_card_value'),
	$CI->lang->line('giftcards_card_value'),
	$CI->lang->line('giftcards_card_value'),
	'&nbsp', 
	);*/
	
	$headers = array('<input type="checkbox" id="select_all" />', 
	'ID',
	'Name',
	'Email',
	'Phone Number',
	'Address',
	'&nbsp', 
	);
	
	$table.='<thead><tr>';
	foreach($headers as $header)
	{
		$table.="<th class=\"header\" height=\"25\">$header</th>";
	}
	$table.='</tr></thead><tbody>';
	$table.=get_stores_manage_table_data_rows( $stores, $controller );
	$table.='</tbody></table>';
	return $table;
}


/*
Gets the html data rows for the stores.
*/
function get_stores_manage_table_data_rows($stores,$controller)
{
	$CI =& get_instance();
	$table_data_rows='';
	
	foreach($stores->result() as $store)
	{
		$table_data_rows.=get_store_data_row($store,$controller);
	}
	
	if($stores->num_rows()==0)
	{
		//$table_data_rows.="<tr><td colspan='6'><div class='warning_message' style='padding:7px;'>".$CI->lang->line('common_no_persons_to_display')."</div></tr></tr>";
		$table_data_rows.="<tr><td colspan='6'><div class='warning_message' style='padding:7px;'>No result found</div></tr></tr>";
	}
	
	return $table_data_rows;
}

function get_store_data_row($store,$controller)
{
	$CI =& get_instance();
	$controller_name=$CI->uri->segment(1);
	$width = "400";
	
    if($store->status=="0"){$status_text="Active";$status_value=1;}else{$status_text="Deactive";$status_value=0;}
	$table_data_row='<tr>';
	$table_data_row.="<td width='5%'><input type='checkbox' id='person_$store->id' value='".$store->id."'/></td>";
	$table_data_row.='<td width="5%">'.character_limiter($store->id,13).'</td>';
	$table_data_row.='<td width="20%">'.character_limiter($store->name,13).'</td>';
	$table_data_row.='<td width="30%">'.mailto($store->email,character_limiter($store->email,22)).'</td>';
	$table_data_row.='<td width="20%">'.character_limiter($store->phonenumber,13).'</td>';
	$table_data_row.='<td width="20%">'.character_limiter($store->address,13).'</td>';		
	$table_data_row.='<td width="5%">'.anchor($controller_name."/view/$store->id/width:$width", $CI->lang->line('common_edit'),array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_update'))).'&nbsp;&nbsp;|&nbsp;&nbsp;<a href="javascript:void(0);" style="cursor:pointer"  store_id="'.$store->id.'" status_value="'.$status_value.'" class="change_status">'.$status_text.'</a></td>';		
	$table_data_row.='</tr>';
	
	return $table_data_row;
}


/*
Gets the html table to manage items.
*/
function get_assign_items_manage_table($items,$controller,$source_store,$des_store_one,$des_store_two)
{
	$CI =& get_instance();
	
	$table='<table class="tablesorter" id="item_sortable_table">';
	
	$headers = array('<input type="checkbox" id="select_all" />', 
	$CI->lang->line('items_item_number'),
	$CI->lang->line('items_name'),
	$CI->lang->line('items_category'),
	//$CI->lang->line('items_cost_price'),
	
	//$CI->lang->line('items_unit_price'),
	//$CI->lang->line('items_retail_price'),
	//$CI->lang->line('items_tax_percents'),
	$CI->lang->line('items_quantity'),
	'Store 1 '.$CI->lang->line('items_quantity'),
	'Store 2 '.$CI->lang->line('items_quantity'),
	//'&nbsp', 
	//'View History'//Ramel Inventory Tracking
	);
	

	$table.='<thead><tr>';
	foreach($headers as $header)
	{
		$table.="<th>$header</th>";
	}
	$table.='</tr></thead><tbody>';
	$table.=get_assign_items_manage_table_data_rows($items,$controller,$source_store,$des_store_one,$des_store_two);
	$table.='</tbody></table>';
	return $table;
}


/*
Gets the html data rows for the items.
*/
function get_assign_items_manage_table_data_rows($items,$controller,$source_store,$des_store_one,$des_store_two)
{
	$CI =& get_instance();
	$table_data_rows='';
	if($source_store!="")
	{// exit;
		if($items)
		{
			foreach($items->result() as $item)
			{
				$table_data_rows.=get_assign_item_data_row($item,$controller,$source_store,$des_store_one,$des_store_two);
			}
			
			if($items->num_rows()==0)
			{
				$table_data_rows.="<tr ><td colspan='11'><div class='warning_message' style='padding:7px;'>".$CI->lang->line('items_no_items_to_display')."</div></tr></tr>";
			}
		}
		else
		{
				$table_data_rows.="<tr ><td colspan='11'><div class='warning_message' style='padding:7px;'>".$CI->lang->line('items_no_items_to_display')."</div></tr></tr>";
		}
	}
	else
	{
		$table_data_rows.="<tr ><td colspan='11'><div class='warning_message' style='padding:7px;'>".$CI->lang->line('items_no_items_to_display')."</div></tr></tr>";
	}
	return $table_data_rows;
}

function get_assign_item_data_row($item,$controller,$source_store,$des_store_one,$des_store_two)
{
	$CI =& get_instance();
	$item_tax_info=$CI->Item_taxes->get_info($item->item_id);
	$tax_percents = '';
	foreach($item_tax_info as $tax_info)
	{
		$tax_percents.=$tax_info['percent']. '%, ';
	}
	$tax_percents=substr($tax_percents, 0, -2);
	$controller_name=$CI->uri->segment(1);
	$width = $controller->get_form_width();
	
	if($des_store_one!="")
	{
		$des_store_one_Array = $CI->Item->get_Store_Item($des_store_one,$item->item_id);//print_r($des_store_one_Array);
		if(sizeof($des_store_one_Array)>0) $des_store_one_quantity = $des_store_one_Array[0]['quantity'];else $des_store_one_quantity = "0";
	}
	else
	{
		$des_store_one_quantity = "0";
	}
	
	if($des_store_two!="")
	{
		$des_store_two_Array = $CI->Item->get_Store_Item($des_store_two,$item->item_id);
		if(sizeof($des_store_two_Array)>0) $des_store_two_quantity = $des_store_two_Array[0]['quantity'];else $des_store_two_quantity = "0";
	}
	else
	{
		$des_store_two_quantity = "0";
	}
	//print_r($des_store_one_Array);
	
	$table_data_row='<tr onmouseover=this.className="over" onmouseout=this.className="">';
	$table_data_row.="<td width='3%'><input type='checkbox' id='item_$item->item_id' value='".$item->item_id."' class='checkbox'/></td>";
	$table_data_row.='<td width="15%">'.$item->item_number.'</td>';
	$table_data_row.='<td width="20%">'.$item->name.'</td>';
	$table_data_row.='<td width="14%">'.$item->category.'</td>';
	//$table_data_row.='<td width="14%">'.to_currency($item->cost_price).'</td>';
	//$table_data_row.='<td width="14%">'.to_currency($item->unit_price).'</td>';
	//$table_data_row.='<td width="14%">'.$tax_percents.'</td>';	
	$table_data_row.='<td width="10%" class="source_store_quantity" id="source_store_quantity'.$item->item_id.'">'.$item->quantity.'</td>';
	$table_data_row.='<td width="15%" align="center"><div id="span_quantity_store_one'.$item->item_id.'" style="width:40%;float:left">'.$des_store_one_quantity.'</div>&nbsp;&nbsp;&nbsp;'.form_input(array('name'=>'quantity_store_one'.$item->item_id,'id'=>'quantity_store_one'.$item->item_id,'value'=>"",'size'=>'5','item_id'=>$item->item_id,'class'=>'store_quantity','div'=>'span_quantity_store_one','style'=>'float:left','title'=>'Press enter to add quantity in existing quantity.','old_quantity'=>$des_store_one_quantity)).'</td>';
	$table_data_row.='<td width="15%" align="center"><div id="span_quantity_store_two'.$item->item_id.'" style="width:40%;float:left">'.$des_store_two_quantity.'</div>&nbsp;&nbsp;&nbsp;'.form_input(array('name'=>'quantity_store_two'.$item->item_id,'id'=>'quantity_store_two'.$item->item_id,'value'=>"",'size'=>'5','item_id'=>$item->item_id,'class'=>'store_quantity','div'=>'span_quantity_store_two','style'=>'float:left','title'=>'Press enter to add quantity in existing quantity.','old_quantity'=>$des_store_two_quantity)).'</td>';
	//$table_data_row.='<td width="5%">'.anchor($controller_name."/view/$item->item_id/width:$width", $CI->lang->line('common_edit'),array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_update'))).'</td>';		
	
	//Ramel Inventory Tracking
	
	//$table_data_row.='<td width="10%">'.anchor('', '-',array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_count')))./*'</td>';//inventory count	
	//$table_data_row.='<td width="5%">'*/'&nbsp;&nbsp;&nbsp;&nbsp;'.anchor($controller_name."/count_details/$item->item_id/width:$width", $CI->lang->line('common_det'),array('class'=>'thickbox','title'=>$CI->lang->line($controller_name.'_details_count'))).'</td>';//inventory details	
	
	$table_data_row.='</tr>';
	return $table_data_row;
}


?>