<?php include(ZBROOT."includes.inc.php");?>
<?php
/*Set Variables For Page Title and Meta Tags*/
$module_page_title = $applicationsModulesArray[$application_id][$module_id]['module_page_title'];
$title = (!empty($applicationsModulesArray[$application_id][$module_id]['module_title']))?$applicationsModulesArray[$application_id][$module_id]['module_title']:APPLICATION_NAME." :: ".$control_panel_title." - $application_title | $module_page_title";
$description = (!empty($applicationsModulesArray[$application_id][$module_id]['module_keywords']))?$applicationsModulesArray[$application_id][$module_id]['module_keywords']:APPLICATION_NAME." :: ".$control_panel_title." - $application_title | $module_page_title";
$keywords = (!empty($applicationsModulesArray[$application_id][$module_id]['module_description']))?$applicationsModulesArray[$application_id][$module_id]['module_description']:APPLICATION_NAME." :: ".$control_panel_title." - $application_title | $module_page_title";
?>
<!-- Header Start -->
<?php include(ZBROOT."header_internal.php");?>
<!-- Header End -->

<!-- Left Menu Start -->
<?php include(ZBROOT.'includes/left_menus.php'); ?>
<!-- Left Menu End -->

<?php
include(CLASSES .'Accounting.class.php');
$accountingClass = new Accounting();
?>

<!-- Sales Project Add/Edit/View Start -->  
<?php include(ZBROOT."accounting/sales_projects_form.php"); ?>
<!-- Sales Project Add/Edit/View End -->

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1>
      Sales <small>Projects</small>
    </h1>
    <ol class="breadcrumb">
      <?php /*?><li><i class="fa fa-dashboard"></i> <?=$control_panel_title?></li><?php */?>
      <li><a href="<?=ZBPATH?>dashboard"><i class="fa fa-dashboard"></i> Dashboard</a></li>
      <li><?=$application_title?></li>
      <li class="active">Sales</li>
    </ol>
  </section>
  <!-- Main content -->
  <section class="content">
    
    <div class="row">
      <div class="col-lg-12 text-right">
          <div class="form-group">
          	<button type="button" name="addedit_project" id="addedit_project" class="btn btn-default addedit_project" data-project_id>Add Project</button>
          </div>
      </div>
    </div>
    <div class="row" >  
      <div class="col-md-12">
      	<div class="box" id="sales_projects_results">
        	<?php include(ZBROOT."includes/page_loading.php");?>
        </div>
      </div>
    </div>      
  </section>
  <!-- /.content -->  
</div>
<!-- /.content-wrapper -->

<!-- JS Includes Start -->
<?php include(ZBROOT.'includes/footer_internal_includes.php'); ?> 
<!-- JS Includes Start -->

<script type="text/javascript">
$(function ()
{
	getSalesProjects(0);
	
	/*Submit Project Form*/
	$(document.body).on('click','#save_project',function(){
		$( "#save_project_form" ).submit();
	});
	
	/*Validate Project Form*/
	$("#save_project_form").validate({
	    errorElement: "div",
		submitHandler: function() 
		{ 
		    var validate = true;
			if(validate == true)
			{
				showResponseOverlay();
				$.ajax({
					type: "POST",
					data: $( "#save_project_form" ).serialize(),		
					url: "<?php echo RDIR."ajax/ajaxAccounting.php";?>",
					cache: false,
					success: function(response){//alert(response)
					  console.log(response);
					  var res = response.split("|");
					  getSalesProjects(0);
					  var res = response.split("|");
					  set_feedback(res[2],'success_message',false);
					  $("#addproject_modal").modal("hide");
					  hideResponseOverlay();
					}
				});
			}
		},
		//wrapper: "div",
		rules: 
		{
			name:{ 
				required: true,
			},
			customer: {
				required: true,
			},
			rate:{
				required: true,
				number: true,
			},
			description:{
				required: true,
			},
		},
		messages: 
		{
			name: {
			   required:"Title is required.",
			},
			customer: {
			   required:"Customer is required.",
			},
			rate: {
			   required:"Rate is required.",
			   number: "Rate is not valid. Only numeric and decimal values are allowed",
			},
			description: {
			   required:"Description is required.",
			},
		}
	});
	
	/*Change Status of Project*/
	$(document.body).on('change','.change_status',function()
	{	
		var action = "change_project_status";
		var project_id = $(this).data("rowid");
		var status = $(this).val();	
		$.fancybox.showLoading();
		$.ajax({
		  type: "POST",
		  data: "action="+action+"&project_id="+project_id+"&status="+status,		
		  url: "<?php echo RDIR."ajax/ajaxAccounting.php";?>",
		  cache: false,
		  success: function(response){//alert(response)
			  var res = response.split("|");
			  set_feedback(res[2],'success_message',false);
			  $.fancybox.hideLoading();
			  
		  }
		});//end of ajax	
	
	});
	
	/*Addedit Project*/
	$(document.body).on('click','.addedit_project',function()
	{
	   
	   var project_id = $(this).data("project_id");//alert(project_id);
	   $('#feedback_bar').css('opacity','0').hide();
	   $("#save_project_form").validate().resetForm(); 
	   $("#save_project_form").find(".form-group").find('span.glyphicon').remove();
	   $("#save_project_form").find(".form-group").removeClass("has-error").removeClass("has-success");
	   $("#name").val("").removeClass("valid").removeClass("invalid");
	   $("#rate").val("").removeClass("valid").removeClass("invalid");
	   $("#description").val("").removeClass("valid").removeClass("invalid");
	   
	   var action = "addedit_project";
	   $.ajax({
		  type: "POST",
		  data: "action="+action+"&project_id="+project_id,		
		  url: "<?php echo RDIR."ajax/ajaxAccounting.php";?>",
		  cache: false,
		  success: function(response){
			console.log(response);
			var getCustomerData = $.parseJSON(response);
			console.log(getCustomerData);
			var html_customers = '<option value="">Select Customer</option>';
			$.each(getCustomerData.customer, function (i, customer) {
				html_customers += '<option value="'+customer.person_id+'" >'+customer.first_name+'</option>';
			});
			
			if(project_id == "")
		    {
				$("#project_id").val("");
				$("#name").val("");
				$("#customer").html(html_customers);
				$("#rate").val("");
				$("#description").val("");
		    }
		    else
		    {
			  	$("#project_id").val(getCustomerData.projectinfo.id);
				$("#name").val(getCustomerData.projectinfo.name);
				$("#rate").val(getCustomerData.projectinfo.rate);
				$("#description").val(getCustomerData.projectinfo.description);
				$("#customer").html(html_customers);
				if(getCustomerData.projectinfo.customer_id)$("#customer").val(getCustomerData.projectinfo.customer_id);
		    }
			
			$("#addproject_modal").modal({keyboard: true});
		   }
	   });
	  
	})
	
	/*Paging Project*/
	$(document.body).on('click','.paging',function(){	
		var page = $(this).attr('id');//alert(page);
		getSalesProjects(page)	
	})
	
	/*Delete Project*/
	$(document.body).on('click','.delete_project',function(){	

		var project_id = $(this).data("project_id");
		var action="delete_sales_project";
		$.alerts.okButton="Ok"
		$.alerts.cancelButton="Cancel"
		jConfirm("Are you sure you want to delete this project?", 'Confirmation', function(r) {
		if(r == true){
			$.fancybox.showLoading();
			$.ajax({
			  type: "POST",
			  url: "<?php echo RDIR."ajax/ajaxAccounting.php";?>",
			  data: {action:action,project_id:project_id},
			  cache: false,
			  success: function(response){//alert(response);
			  	  console.log(response);
			      if(response!="" && response!=null)
				  {
					  var response = $.parseJSON(response);
					  if(response.status == 0)
					  {
						  set_feedback(response.message,'error_message',true);
					  }
					  else if(parseInt(response.status) > 0)
					  {
						  set_feedback(response.message,'success_message',false);
						  var table = $('#projects_list_table').DataTable();
					  	  var info = table.page.info();
					  	  getSalesProjects(info.page);
					  }
					  else
					  {
						  set_feedback(response,'error_message',true);
					  }			
				  }
				  $.fancybox.hideLoading();
			  }
			});//end of ajax		 
		   }
		}); //end of conferm box
		
	}); //end of delete	
	
})

/*Function to get Sales Invoices*/
function getSalesProjects(page)
{
	var action = "get_sales_projects";
	$.ajax({		
		type: "POST",
		url: "<?php echo RDIR."ajax/ajaxAccounting.php";?>",
		data: {action:action,page:page},
		cache: false,
		success: function(html) {
			console.log(html);
			var html = html.split("|");
			$("#sales_projects_results").html(html[1]);
		}
	})
}
 
</script>
       
<!-- Footer Start -->  
<?php include(ZBROOT."footer_internal.php"); ?>
<!-- Footer Start -->