<?php 
require_once(dirname(__FILE__) ."/ZimbraAPI/SplClassLoader.php");
$classLoader = new SplClassLoader('Zimbra', realpath(__DIR__.'/ZimbraAPI/src/')); // Point this to the src folder of the zcs-php repo
$classLoader->register();

class ZimbraAPI {

	protected $ZIMBRA_LOGIN = "";
	protected $ZIMBRA_PASS = "";
	protected $ZIMBRA_SERVER = "";
	protected $ZIMBRA_PORT = "";
	
	public function __construct()
	{
		$this->ZIMBRA_LOGIN = 'api@mail1.wrkmash.com';
		$this->ZIMBRA_PASS = 'j8usvTbxphfpHE2';
		$this->ZIMBRA_SERVER = 'mail.wrkmash.com';
		$this->ZIMBRA_PORT = '7071';
	}
	
	private function getErrorMessage($error)
    {
        switch ($error) {
            case 'account already exists':
                return "|1|Email account already exists|";
                break;
            case 'distribution list already exists':
                return "|2|Distribution list already exists|";
                break;
            case 'error while proxying request to target server':
				return "|3|Error while proxying request to target server|";
                break;
            case 'no such domain':
                return "|4|You have not set your domain|";
                break;
			case 'An unexpected error has occurred (account.DOMAIN_EXISTS)':
                return "|5|Domain already exists|";
                break;
			case 'An unexpected error has occurred (account.AUTH_FAILED)':
                return "|6|Authentication failed contact your system administrator|";
                break;		
            default:
                return sprintf("|7|".$error."|", $error);
        }
    }
	
	public function checkEmailDomain($domain)
	{
		
		$zimbra = new \Zimbra\ZCS\Admin($this->ZIMBRA_SERVER, $this->ZIMBRA_PORT);
		
		try {
			
			$zimbra->auth($this->ZIMBRA_LOGIN, $this->ZIMBRA_PASS);
			
			$cp_response = array();
			
			try {
								
				$emaildomain = $zimbra->getDomain($domain, $by = "name", $account);
				
				if(!empty($emaildomain))
				{
					$cp_response = $emaildomain;
				}
				
				/*echo "<pre>";
				print_r($cp_response);
				echo "</pre>";
				exit();*/
			} 
			catch (Exception $e) 
			{
				$error = $e->getMessage();
				$cp_error = $this->getErrorMessage($error);
			}
			/*echo "<pre>";
			print_r($result);
			echo "</pre>";
			exit();*/
		}
		catch (Exception $e) 
		{
			$error = $e->getMessage();
			$cp_error = $this->getErrorMessage($error);
		}
		
		$responseArray = array();
		$responseArray['CP_Error'] = $cp_error;
		$responseArray['CP_Response'] = $cp_response;
		return $responseArray;
	}
	
	public function createEmailDomain($domain)
	{
		
		$zimbra = new \Zimbra\ZCS\Admin($this->ZIMBRA_SERVER, $this->ZIMBRA_PORT);
		try {
			
			$zimbra->auth($this->ZIMBRA_LOGIN, $this->ZIMBRA_PASS);
		
			$cp_response = array();
			
			try {
								
				$newdomain = $zimbra->createDomain(array('name' => $domain));
				
				if(!empty($newdomain))
				{
					$cp_response = $newdomain;
				}
				
				/*echo "<pre>";
				print_r($cp_response);
				echo "</pre>";
				exit();*/
			} 
			catch (Exception $e) 
			{
				$error = $e->getMessage();
				$cp_error = $this->getErrorMessage($error);
			}
			/*echo "<pre>";
			print_r($result);
			echo "</pre>";
			exit();*/
		}
		catch (Exception $e) 
		{
			$error = $e->getMessage();
			$cp_error = $this->getErrorMessage($error);
		}	
			
		$responseArray = array();
		$responseArray['CP_Error'] = $cp_error;
		$responseArray['CP_Response'] = $cp_response;
		return $responseArray;
	}
	
	public function editEmailDomain($domain)
	{
		
		$zimbra = new \Zimbra\ZCS\Admin($this->ZIMBRA_SERVER, $this->ZIMBRA_PORT);
		try {
			
			$zimbra->auth($this->ZIMBRA_LOGIN, $this->ZIMBRA_PASS);
		
			$cp_response = array();
			
			try {
								
				$newdomain = $zimbra->modifyDomain(array('name' => $domain));
				
				if(!empty($newdomain))
				{
					$cp_response = $newdomain;
				}
				
				/*echo "<pre>";
				print_r($cp_response);
				echo "</pre>";
				exit();*/
			} 
			catch (Exception $e) 
			{
				$error = $e->getMessage();
				$cp_error = $this->getErrorMessage($error);
			}
			/*echo "<pre>";
			print_r($result);
			echo "</pre>";
			exit();*/
		
		}
		catch (Exception $e) 
		{
			$error = $e->getMessage();
			$cp_error = $this->getErrorMessage($error);
		}	
			
		$responseArray = array();
		$responseArray['CP_Error'] = $cp_error;
		$responseArray['CP_Response'] = $cp_response;
		return $responseArray;
	}
	
	public function checkEmailAccount($domain,$account)
	{
		
		$zimbra = new \Zimbra\ZCS\Admin($this->ZIMBRA_SERVER, $this->ZIMBRA_PORT);
		try {
			
			$zimbra->auth($this->ZIMBRA_LOGIN, $this->ZIMBRA_PASS);
		
			$cp_response = array();
			
			try {
								
				$emailaccount = $zimbra->getAccount($domain, $by = "name", $account);
				
				if(!empty($emailaccount))
				{
					$cp_response = $emailaccount;
				}
				
				/*echo "<pre>";
				print_r($cp_response);
				echo "</pre>";
				exit();*/
			} 
			catch (Exception $e) 
			{
				$error = $e->getMessage();
				$cp_error = $this->getErrorMessage($error);
			}
			/*echo "<pre>";
			print_r($result);
			echo "</pre>";
			exit();*/
			
		}
		catch (Exception $e) 
		{
			$error = $e->getMessage();
			$cp_error = $this->getErrorMessage($error);
		}	
			
		$responseArray = array();
		$responseArray['CP_Error'] = $cp_error;
		$responseArray['CP_Response'] = $cp_response;
		return $responseArray;
	}
	
	public function getAllEmailAccounts($domain,$query=null)
	{
		
		$zimbra = new \Zimbra\ZCS\Admin($this->ZIMBRA_SERVER, $this->ZIMBRA_PORT);
		try {
			
			$zimbra->auth($this->ZIMBRA_LOGIN, $this->ZIMBRA_PASS);
			/*$accounts = $zimbra->getAccounts(array(
				'domain' => 'wrkmate.com',
				'offset' => 0,
				'limit'  => 100
			),$sort = null, $query = null);*/
			
			$cp_response = array();
			
			try {
				$domainresult = $zimbra->getDomain($domain, $by = 'name', $attrs = array());
				if(!empty($domainresult))
				{
					
					try {
						$totalaccounts = $zimbra->count($domain, $query);
						if(!empty($totalaccounts))
						{
							try {
								
								$accounts = $zimbra->getAccounts(array(
									'domain' => $domain,
									'offset' => 0,
									'limit'  => $totalaccounts
								),$sort = null, $query);
								
								if(!empty($accounts))
								{
									$cp_response = $accounts;
								}
								
								/*echo "<pre>";
								print_r($cp_response);
								echo "</pre>";
								exit();*/
							} 
							catch (Exception $e) 
							{
								$error = $e->getMessage();
								$cp_error = $this->getErrorMessage($error);
							}
						}
						
					} 
					catch (Exception $e) 
					{
						$error = $e->getMessage();
						$cp_error = $this->getErrorMessage($error);
					}
				}
				
			} 
			catch (Exception $e) 
			{
				$error = $e->getMessage();
				$cp_error = $this->getErrorMessage($error);
			}
		
		}
		catch (Exception $e) 
		{
			$error = $e->getMessage();
			$cp_error = $this->getErrorMessage($error);
		}	 
		
		$responseArray = array();
		$responseArray['CP_Error'] = $cp_error;
		$responseArray['CP_Response'] = $cp_response;
		return $responseArray;

	}
	
	public function getEmailAccount($domain,$account)
	{
		
		$zimbra = new \Zimbra\ZCS\Admin($this->ZIMBRA_SERVER, $this->ZIMBRA_PORT);
		try {
			
			$zimbra->auth($this->ZIMBRA_LOGIN, $this->ZIMBRA_PASS);
			
			$cp_response = array();
			
			try {
								
				$emailaccount = $zimbra->getAccount($domain, $by = "name", $account);
				
				if(!empty($emailaccount))
				{
					$cp_response = $emailaccount;
				}
				
				/*echo "<pre>";
				print_r($cp_response);
				echo "</pre>";
				exit();*/
			} 
			catch (Exception $e) 
			{
				$error = $e->getMessage();
				$cp_error = $this->getErrorMessage($error);
			}
			/*echo "<pre>";
			print_r($result);
			echo "</pre>";
			exit();*/
		
		}
		catch (Exception $e) 
		{
			$error = $e->getMessage();
			$cp_error = $this->getErrorMessage($error);
		}	
			
		$responseArray = array();
		$responseArray['CP_Error'] = $cp_error;
		$responseArray['CP_Response'] = $cp_response;
		return $responseArray;
	}
	
	public function createEmailAccount($gn,$sn,$name,$password,$displayName,$domain)
	{
		
		
		$zimbra = new \Zimbra\ZCS\Admin($this->ZIMBRA_SERVER, $this->ZIMBRA_PORT);
		try {
			
			$zimbra->auth($this->ZIMBRA_LOGIN, $this->ZIMBRA_PASS);
		
			$is_domain = 0;
			$cp_response = array();
			
			try {
								
				$emaildomain = $zimbra->getDomain($domain, $by = "name", $account);
				
				if(!empty($emaildomain))
				{
					
					$is_domain = 1;
				}
				
				/*echo "<pre>";
				print_r($cp_response);
				echo "</pre>";
				exit();*/
			} 
			catch (Exception $e) 
			{
				$error = $e->getMessage();
				$error = explode("|",$error);
				if($error[1] == 4 )
				{
					try {
								
						$newdomain = $zimbra->createDomain(array('name' => $domain));
						
						if(!empty($newdomain))
						{
							$is_domain = 1;
						}
						
						/*echo "<pre>";
						print_r($cp_response);
						echo "</pre>";
						exit();*/
					} 
					catch (Exception $e) 
					{
						$error = $e->getMessage();
						$cp_error = $this->getErrorMessage($error);
					}
				}
				//$cp_error = $this->getErrorMessage($error);
			}
			
			if($is_domain == 1)
			{
			
				try {
					$newaccount = $zimbra->createAccount(array(
						'gn' => $gn,
						'sn'=> $sn,
						'name' => $name,
						'password' => $password,
						'displayName' => $displayName,
					));
					
					$cp_response = $newaccount;
				}
				catch (Exception $e) 
				{
					$error = $e->getMessage();
					$cp_error = $this->getErrorMessage($error);
				}
			
			}
			/*echo "<pre>";
			print_r($result);
			echo "</pre>";
			exit();*/
		}
		catch (Exception $e) 
		{
			$error = $e->getMessage();
			$cp_error = $this->getErrorMessage($error);
		}	
			
		$responseArray = array();
		$responseArray['CP_Error'] = $cp_error;
		$responseArray['CP_Response'] = $cp_response;
		return $responseArray;
		
	}
	
	public function editEmailAccount($id,$gn,$sn,$displayName,$domain)
	{
		
		
		$zimbra = new \Zimbra\ZCS\Admin($this->ZIMBRA_SERVER, $this->ZIMBRA_PORT);
		try {
			
			$zimbra->auth($this->ZIMBRA_LOGIN, $this->ZIMBRA_PASS);
		
			$is_domain = 0;
			$cp_response = array();
			
			try {
								
				$emaildomain = $zimbra->getDomain($domain, $by = "name", $account);
				
				if(!empty($emaildomain))
				{
					
					$is_domain = 1;
				}
				
				/*echo "<pre>";
				print_r($cp_response);
				echo "</pre>";
				exit();*/
			} 
			catch (Exception $e) 
			{
				$error = $e->getMessage();
				$error = explode("|",$error);
				if($error[1] == 4 )
				{
					try {
								
						$newdomain = $zimbra->createDomain(array('name' => $domain));
						
						if(!empty($newdomain))
						{
							$is_domain = 1;
						}
						
						/*echo "<pre>";
						print_r($cp_response);
						echo "</pre>";
						exit();*/
					} 
					catch (Exception $e) 
					{
						$error = $e->getMessage();
						$cp_error = $this->getErrorMessage($error);
					}
				}
				//$cp_error = $this->getErrorMessage($error);
			}
			
			if($is_domain == 1)
			{
			
				try {
					$editaccount = $zimbra->modifyAccount(array(
						'id' => $id,
						'gn' => $gn,
						'sn'=> $sn,
						'displayName' => $displayName,
					));
					
					$cp_response = $editaccount;
				}
				catch (Exception $e) 
				{
					$error = $e->getMessage();
					$cp_error = $this->getErrorMessage($error);
				}
			
			}
			/*echo "<pre>";
			print_r($cp_response);
			echo "</pre>";
			exit();*/
		}
		catch (Exception $e) 
		{
			$error = $e->getMessage();
			$cp_error = $this->getErrorMessage($error);
		}	
			
		$responseArray = array();
		$responseArray['CP_Error'] = $cp_error;
		$responseArray['CP_Response'] = $cp_response;
		return $responseArray;
		
	}
	
	public function changePasswordEmailAccount($id,$password)
	{
		
		
		$zimbra = new \Zimbra\ZCS\Admin($this->ZIMBRA_SERVER, $this->ZIMBRA_PORT);
		try {
			
			$zimbra->auth($this->ZIMBRA_LOGIN, $this->ZIMBRA_PASS);
		
			$cp_response = array();
			
			try {
				$setpassword = $zimbra->setPassword($id,$password);
				$cp_response = $setpassword;
			}
			catch (Exception $e) 
			{
				$error = $e->getMessage();
				$cp_error = $this->getErrorMessage($error);
			}
			/*echo "<pre>";
			print_r($result);
			echo "</pre>";
			exit();*/
		}
		catch (Exception $e) 
		{
			$error = $e->getMessage();
			$cp_error = $this->getErrorMessage($error);
		}	
			
		$responseArray = array();
		$responseArray['CP_Error'] = $cp_error;
		$responseArray['CP_Response'] = $cp_response;
		return $responseArray;
		
	}
	
	public function deleteEmailAccount($id)
	{
		
		
		$zimbra = new \Zimbra\ZCS\Admin($this->ZIMBRA_SERVER, $this->ZIMBRA_PORT);
		try {
			
			$zimbra->auth($this->ZIMBRA_LOGIN, $this->ZIMBRA_PASS);
		
			$cp_response = array();
			
			try {
				$deleteaccount = $zimbra->deleteAccount($id);
				$cp_response = $deleteaccount;
			}
			catch (Exception $e) 
			{
				$error = $e->getMessage();
				$cp_error = $this->getErrorMessage($error);
			}
			/*echo "<pre>";
			print_r($result);
			echo "</pre>";
			exit();*/
		}
		catch (Exception $e) 
		{
			$error = $e->getMessage();
			$cp_error = $this->getErrorMessage($error);
		}	
			
		$responseArray = array();
		$responseArray['CP_Error'] = $cp_error;
		$responseArray['CP_Response'] = $cp_response;
		return $responseArray;
		
	}
	
	
}
?> 