# Facebook SDK for PHP

The Facebook SDK for PHP is a library with powerful features that enable PHP developers to easily integrate Facebook login and make requests to the Graph API. It also plays well with the [Facebook SDK for JavaScript](https://developers.facebook.com/docs/javascript) to give the front-end user the best possible user experience. But it doesn't end there, the Facebook SDK for PHP makes it easy to upload photos and videos and send batch requests to the Graph API among other things. And SDK for PHP has many extensibility points giving PHP developers full control of how the SDK for PHP interacts with their specific hosting environment and web framework.

Whether you're developing a website with Facebook login, creating a Facebook Canvas app or Page tab, the Facebook SDK for PHP does all the heavy lifting for you making it as easy as possible to deeply integrate into the Facebook platform.

For installation & implementation instructions, look through the [Getting Started with the Facebook SDK for PHP](./getting_started.md) guide, and then check out some of the examples below.

---

## Examples

The following examples demonstrate how you would accomplish common tasks with the Facebook SDK for PHP.

- **Authentication & Signed Requests**
  - [Facebook Login (OAuth 2.0)](./examples/facebook_login.md)
  - [Obtaining an access token from the SDK for JavaScript](./examples/access_token_from_javascript.md)
  - [Obtaining an access token within a Facebook Canvas context](./examples/access_token_from_canvas.md)
  - [Obtaining an access token within a Facebook Page tab context](./examples/access_token_from_page_tab.md)
- **User profile**
  - [Retrieve a user's profile](./examples/retrieve_user_profile.md)
  - [Post a link to a user's feed](./examples/post_links.md)
- **File Uploads**
  - [Upload a photo to a user's profile](./examples/upload_photo.md)
  - [Upload a video to a user's profile](./examples/upload_video.md)
- **Batch Requests**
  - [Sending requests in a batch](./examples/batch_request.md)
  - [Uploading files in a batch](./examples/batch_upload.md)
- **Pagination**
  - [Basic pagination](./examples/pagination_basic.md)

## API Reference

For a full list of classes, see the API [reference page](./reference.md).
