<?php
// Include the autoloader provided in the SDK
require_once __DIR__ . '/vendor/autoload.php'; // change path as needed

// Include required libraries
use Facebook\Facebook;
use Facebook\Exceptions\FacebookApiException;
use Facebook\Exceptions\FacebookSDKException;
use Facebook\Exceptions\FacebookResponseException;

/*
 * Configuration and setup Facebook SDK
 */
$is_socialboard_facebook_error = 0;
$app_id = $socialboard_facebook_app_id; //Facebook App ID
$app_secret = $socialboard_facebook_app_secret; //Facebook App Secret
$socialboard_facebook_url = "https://facebook.com";
$socialboard_facebook_callback_module = getSession("app_module_name");
$socialboard_facebook_callback_url = ZBPATH."socialboard/$socialboard_facebook_callback_module/facebook/callback"; //Facebook Callback URL
$socialboard_facebook_permissions = array('email','user_birthday','user_posts','user_friends','user_photos','user_likes','user_age_range','user_events','user_gender','user_hometown','user_link','user_location','user_tagged_places','user_videos','user_location','user_location','publish_video');  //Optional permissions
//Group Permissions
/*groups_access_member_info,publish_to_groups,user_managed_groups*/
//Page Permissions
/*manage_pages,publish_pages,pages_show_list,pages_manage_cta,pages_manage_instant_articles,pages_messaging */

/*Check Facebook Object*/
$socialboard_facebook_object = json_decode(file_get_contents('https://graph.facebook.com/'.$app_id.'?fields=roles&access_token='.$app_id.'|'.$app_secret));
$socialboard_facebook_object_exists = false;
if ( isset( $socialboard_facebook_object ) and ! is_null( $socialboard_facebook_object ) ){$socialboard_facebook_object_exists = true;}

if($socialboard_facebook_object_exists)
{ 
	/*Create Facebook Object*/
	$fb = new Facebook(array(
		'app_id' => $app_id,
		'app_secret' => $app_secret,
		//'default_graph_version' => 'v2.12'
		'default_graph_version' => 'v3.1'
	));

	// Get redirect login helper 
	$helper = $fb->getRedirectLoginHelper();
	
	//if (isset($_GET['state'])) { $helper->getPersistentDataHandler()->set('state', $_GET['state']); }
	
	// Try to get access token
	try {
		/*if(isset($socialboard_facebook_access_token_session_value)){
			$socialboard_facebook_access_token = $socialboard_facebook_access_token_session_value;
		}else{
			$socialboard_facebook_access_token = $helper->getAccessToken();
		}*/
		if(!empty($socialboard_facebook_access_token_saved_value)){
			$socialboard_facebook_access_token = $socialboard_facebook_access_token_saved_value;
		}else{
			$socialboard_facebook_access_token = $helper->getAccessToken();
		}
		//$accessToken = $helper->getAccessToken();
		if(empty($socialboard_facebook_access_token))
		{
			// Get login url
			//$socialboard_facebook_login_url = $helper->getLoginUrl($socialboard_facebook_callback_url, $socialboard_facebook_permissionss);
				
			/*Throw Facebook exception if something gone wrong*/
			try {
				// Get login url
				$socialboard_facebook_login_url = $helper->getLoginUrl($socialboard_facebook_callback_url, $socialboard_facebook_permissions);
			} catch(Exception  $e) {
				$is_socialboard_facebook_error = 1;
				$socialboard_facebook_error = 'Facebook returned an error: ' . $e->getMessage();
			}
		}
	} catch(FacebookResponseException $e) {
		$is_socialboard_facebook_error = 1;
		$socialboard_facebook_error = 'Graph returned an error: ' . $e->getMessage();
		//exit;
	} catch(FacebookSDKException $e) {
		$is_socialboard_facebook_error = 1;
		$socialboard_facebook_error = 'Facebook SDK returned an error: ' . $e->getMessage();
		//exit;
	} catch(FacebookApiException $e){
		// Here : API call failed,
		// you don't have a valid access token
		// you have to send him to $facebook->getLoginUrl()
		$is_socialboard_facebook_error = 1;
		$socialboard_facebook_error = 'Facebook API returned an error: ' . $e->getMessage();
	}
}
else
{
	$is_socialboard_facebook_error = 1;
	//$socialboard_facebook_error = 'Facebook returned an error: Error in connecting with Facebook ';
	$socialboard_facebook_error = 'Please try again if you can not connect with Facebook <br>OR<br> '.$verbiage_contact_to_support;
}
?>