<?php
/*Includes Main Class*/
require_once(ROOT . 'classes' . DS . 'Main.class.php');
$sqlMainClass = new Main();

/*Get Image Thumb Resolution*/
function getImgthumbresoluttion($width,$height,$rw,$rh){
		$res = array();
		if($width>$rw && $width>$height)
				{
				//echo "cond1<br>";
				//echo $width."--".$height."<br>";
				$w = $rw;
				$h =  ($w/$width)*$height;
				//echo $w."--".$h."<br>";
				if($h>$rh)
					{
					
					$h=$rh;
					$w=$h/$height*$width;
					}
				//echo $w."--".$h."<br>";
				}
			elseif($width<$rw && $width>$height && $height>$rh)
				{
				//echo "cond2<br>";
				$w = $width;
				$h =  ($w/$width)*$height;
				if($h>$rh)
					{
					$h=$rh;
					$w=$h/$height*$width;
					}
				}
			elseif($height>$rh && $height>$width)
				{
				//echo "cond3<br>";
				$h = $rh;
				$w =  ($h/$height)*$width;
				if($w>$rw)
					{
					$w=$rw;
					$h=$w/$width*$height;
					}
				}
			elseif($height == $width)
				{
				//echo "cond4<br>";
				$h = $rh;
				$w =  $rh;
				if($w>$rw && $rw<$rh)
					{
					$w = $rw;
					$h = $rw;
					}
				elseif($h>$rh && $rh<=$rw)
					{
					$w = $rh;
					$h = $rh;
					}
				}
			else
				{
				//echo "cond5<br>";
				$h=$height;
				$w=$width;
				}
		$res[0] = round($w);
		$res[1] = round($h);
		return $res;
}

/*Function for Image Resize*/
function resizeImages($extension,$newWidth, $targetFile, $originalFile){
		
		 switch ($extension) {
				
			case 'jpeg':
			$img = imagecreatefromjpeg($originalFile);
			break;
					
			case 'jpg':
			$img = imagecreatefromjpeg($originalFile);
			break;		

			case 'png':
			$img = imagecreatefrompng($originalFile);
			break;

			case 'gif':
			$img = imagecreatefromgif($originalFile);
			break;
				
		 }
	
		 list($width, $height) = getimagesize($originalFile);
		 $newHeight = ($height / $width) * $newWidth;
		 $tmp = imagecreatetruecolor($newWidth, $newHeight);
		 imagecopyresampled($tmp, $img, 0, 0, 0, 0, $newWidth, $newHeight, $width, $height);
	
		 if (file_exists($targetFile)) {unlink($targetFile);}
		 
		 switch ($extension) {
				
			case 'jpeg':
			imagejpeg($tmp, "$targetFile");
			break;
					
			case 'jpg':
			imagejpeg($tmp, "$targetFile");
			break;		

			case 'png':
			imagepng($tmp, "$targetFile");
			break;

			case 'gif':
			imagegif($tmp, "$targetFile");
			break;
	
		 }
		 
	}

/*Get Random Prefixes*/
function randomPrefix($length){
	$random= "";
	
	srand((double)microtime()*1000000);
	//$data = "AbcDE123IJKLMN67QRSTUVWXYZ";
	//$data .= "aBCdefghijklmn123opq45rs67tuv89wxyz";
	//$data .= "0FGH45OP89";
	$data = "ABCDEFGHIJKLMNOPQRSTVUWXYZ";
	$data .= "1234567890";
	$data .= "abcdefghijklmnopqrstuvwxyz";
		
	for($i = 0; $i < $length; $i++)
	{
		$random .= substr($data, (rand()%(strlen($data))), 1);
	}
	
	return $random;
}

/*Get Limited Words*/
function limit_words($string, $word_limit){
	$words = explode(" ",$string);
	$limit_words = "";
	$limit_words .= implode(" ",array_splice($words,0,$word_limit));
	if(sizeof($words)>$word_limit)$limit_words .= "...";
	return $limit_words;
}

/*Get truncate text Words*/
function truncateText($string, $limit, $break=" ", $pad="..."){
  // return with no change if string is shorter than $limit
  if(strlen($string) <= $limit) return $string;

  $string = substr($string, 0, $limit);
  if(false !== ($breakpoint = strrpos($string, $break))) {
    $string = substr($string, 0, $breakpoint);
  }

  return $string . $pad;
}

/*Get Random Numeric Value*/
function generate_numeric_random($min = null, $max = null) {
  static $seeded;
  if (!$seeded) {
	mt_srand((double)microtime()*1000000);
	$seeded = true;
  }
  if (isset($min) && isset($max)) {
	if ($min >= $max) {
	  return $min;
	} else {
	  return mt_rand($min, $max);
	}
  } else {
	return mt_rand();
  }
}

/*Password Encryption and Validation*/
function pw_encrypt_password($plain) {
  $password = '';
  for ($i=0; $i<10; $i++) {
    $password .= generate_numeric_random();
  }
  $salt = substr(md5($password), 0, 2);
  $password = md5($salt . $plain) . ':' . $salt;
  return $password;
}
//echo pw_encrypt_password($plain);
function pw_validate_password($plain, $encrypted) {
  if (($plain) && ($encrypted)) {
// split apart the hash / salt
    $stack = explode(':', $encrypted);
	return $stack[0];
    if (sizeof($stack) != 2) return false;
    if (md5($stack[1] . $plain) == $stack[0]) {
      return true;
    }
  }
  return false;
}

//echo pw_validate_password("test","ee2514f9df24ba95eb934394d124d361:de");
function pw_create_random_value($length = 12) {
  $chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890';
  $chars_length = (strlen($chars) - 1);
  $string = $chars{rand(0, $chars_length)};
  for ($i = 1; $i < $length; $i = strlen($string)) {
	$r = $chars{rand(0, $chars_length)};
	if ($r != $string{$i - 1}) $string .=  $r;
  }
  return $string;
}

/*Generate Strong Password*/
function generateStrongPassword($length)
{
	$random= "";
	
	srand((double)microtime()*1000000);
	//$data = "AbcDE123IJKLMN67QRSTUVWXYZ";
	//$data .= "aBCdefghijklmn123opq45rs67tuv89wxyz";
	//$data .= "0FGH45OP89";
	$data = "ABCDEFGHIJKLMNOPQRSTVUWXYZ";
	$data .= "1234567890";
	$data .= "abcdefghijklmnopqrstuvwxyz";
	$data .= "!@#$%^&*()_-+={}[]|\/?<>`~";
		
	for($i = 0; $i < $length; $i++)
	{
		$random .= substr($data, (rand()%(strlen($data))), 1);
	}
	
	return $random;
}

/*Set Number Format */
function numberFormat($amount){
	return number_format((float)$amount,2,'.','');
}

/*Set Number Float*/
function numberFloat($amount,$digit){
	$amount_string = explode(".",number_format((float)$amount,5,'.',''));
	if($amount_string[1]>0){$digit = $digit;}else{$digit=0;}
	return number_format((float)$amount,$digit,'.','');
}

/*Set Number Format Display */
function numberFormatDsiplay($amount){
	return number_format((float)$amount,2,'.',',');
}

/*Set Number Float Display */
function numberFloatDsiplay($amount,$digit){
	$amount_string = explode(".",number_format((float)$amount,5,'.',''));
	if($amount_string[1]>0){$digit = $digit;}else{$digit=0;}
	return number_format((float)$amount,$digit,'.',',');
}

/*Set Number Format Display With Currency Symbol */
function numberWithCurrency($amount){
	$currency_symbol = '$ ';
	return $currency_symbol.number_format((float)$amount,2,'.',',');
}

/*Clean SQL Injections */
function cleanSQL($val){
	return mysql_real_escape_string($val);
}

/*Encode Url */
function urlEncodeVal($val){
	return urlencode($val);
}

/*Dencode Url */
function urlDecodeVal($val){
	return urldecode($val);
}

/*Generate Hour Drop Down*/
function hourDD($name,$id,$class,$css,$attributes) {
	$dd  = '';
	$dd .= '<select name="'.$name.'"id="'.$id.'" class="'.$class.'"  style="'.$css.'" '.$attributes.'>';
	$dd .= '<option value="0">Hour</option>';
	$time=1;
	for($i=1;$i<=24;$i++)
	{ 
		if($i<=12){$formate="am";}else{$formate="pm";}
		$dd .= '<option value="'.$i.'">'.$time.' '.$formate.'</option>';
		if($i==12){$time=1;}else{$time++;}
		
	}
	$dd .= '</select>';
	echo $dd;
}

/*Generate Hour Drop Down*/
function minuteDD($name,$id,$class,$css,$attributes) {
	$dd  = '';
	$dd .= '<select name="'.$name.'"id="'.$id.'" class="'.$class.'"  style="'.$css.'" '.$attributes.'>';
	$dd .= '<option value="0">Minutes</option>';
	for($i=1;$i<=60;$i++)
	{ 
		$dd .= '<option value="'.$i.'">'.$i.'</option>';
		
	}
	$dd .= '</select>';
	echo $dd;
}

/*Function For Current Date*/
function currentDate(){
	return date("Y-m-d");
}

/*Function For Current Time*/
function currentTime(){
	return date("H:i:s");
}

/*Function For Current Time Stamp*/
function TimeStamp(){
	return date("Y-m-d H:i:s");
}

/*Function For Formated Date Time*/
function formatedDateTime($format){
	return date($format);
}

/*Function For Formated Time Stamp*/
function formatedTimeStamp($format,$timestamp){
	return date($format,$timestamp);
}

/*Function For Generate Time Stamp*/
function generateTimeStamp($s,$i,$h,$m,$d,$y){
	return mktime($s,$i,$h,$m,$d,$y);
}

/*Function For Convert String to Time Stamp*/
function stringToTimeStamp($string){
	return strtotime($string);
}

/*Function For Change Date / Time*/
function changeDateTime($format,$date_string){
	//formatedTimeStamp("Y-m-d",stringToTimeStamp("YYYY-mm-dd"."+/-N day/month/year"))
	return formatedTimeStamp($format,stringToTimeStamp($date_string));
}

/*Function For GMT/UTC Date*/
function gmcurrentDate(){
	return gmdate("Y-m-d");
}

/*Function For GMT/UTC Time*/
function gmcurrentTime(){
	return gmdate("H:i:s");
}

/*Function For GMT/UTC Time Stamp*/
function gmTimeStamp(){
	return gmdate("Y-m-d H:i:s");
}

/*Function For Generate GMT/UTC Time Stamp*/
function gmGenerateTimeStamp($s,$i,$h,$m,$d,$y){
	return gmmktime($s,$i,$h,$m,$d,$y);
}

/*Function For GMT/UTC Formated Date Time*/
function gmFormatedDateTime($format){
	return gmdate($format);
}

/*Function For GMT/UTC Formated Time Stamp*/
function gmFormatedTimeStamp($format,$timestamp){
	return gmdate($format,$timestamp);
}

/*Function For Set Current Time Zone*/
function setTimeZone($value){
	if($value == "local"){
		date_default_timezone_set('UTC');
	}
	else if($value == "server"){
		date_default_timezone_set('America/Los_Angeles');
	}
	else{
		date_default_timezone_set($value);
	}
}

/*Function For Get Current Time Zone*/
function getTimeZone(){
	return date_default_timezone_get();
}

/*Function For Get Time Zone Lists*/
/**
 * Return an array of timezones
 * 
 * @return array
 */
function getTimeZoneLists(){
	$timezoneIdentifiers = DateTimeZone::listIdentifiers();
    $utcTime = new DateTime('now', new DateTimeZone('UTC'));
 
    $tempTimezones = array();
    foreach ($timezoneIdentifiers as $timezoneIdentifier) {
        $currentTimezone = new DateTimeZone($timezoneIdentifier);
 		$location = $currentTimezone->getLocation(); 
		$country_name = getValue("countries","country_name","WHERE country_code='".$location['country_code']."' ");
        $tempTimezones[] = array(
            'offset' => (int)$currentTimezone->getOffset($utcTime),
            'identifier' => $timezoneIdentifier,
			'location' => $location,
			'country_code' => $location['country_code'],
			'country_name' => $country_name,
			'latitude' => $location['latitude'],
			'longitude' => $location['longitude'],
			'comments' => $location['comments']
        );
    }
 
    // Sort the array by offset,identifier ascending
    usort($tempTimezones, function($a, $b) {
		return ($a['offset'] == $b['offset'])
			? strcmp($a['identifier'], $b['identifier'])
			: $a['offset'] - $b['offset'];
    });
 
	$timezoneList = array();
    foreach ($tempTimezones as $tz) {
		$sign = ($tz['offset'] > 0) ? '+' : '-';
		$offset = gmdate('H:i', abs($tz['offset']));
        $timezoneList[$tz['identifier']]['offset'] = $tz['offset'];
		$timezoneList[$tz['identifier']]['time'] = $sign . $offset;
		$timezoneList[$tz['identifier']]['name'] = $tz['identifier'];
		$timezoneList[$tz['identifier']]['label'] = str_replace("_"," ",$tz['identifier']);
		$timezoneList[$tz['identifier']]['location'] = $tz['location'];
		$timezoneList[$tz['identifier']]['country_code'] = $tz['country_code'];
		$timezoneList[$tz['identifier']]['country_name'] = $tz['country_name'];
		$timezoneList[$tz['identifier']]['latitude'] = $tz['latitude'];
		$timezoneList[$tz['identifier']]['longitude'] = $tz['longitude'];
		$timezoneList[$tz['identifier']]['comments'] = $tz['comments'];
		$timezoneList[$tz['identifier']]['utc_label'] = '(UTC ' . $sign . $offset . ') ' .str_replace("_"," ",$tz['identifier']);
		$timezoneList[$tz['identifier']]['gmt_label'] = '(GMT ' . $sign . $offset . ') ' .str_replace("_"," ",$tz['identifier']);
    }
 
    return $timezoneList;
}

function getTimeZoneGroupLists($timezones,$group_key="key"){
	//$timezones = getTimeZoneLists();//printArray($timezones_Array);
	$grouped_timezones = array();
	foreach ($timezones as $key=>$timezone) {
		if($group_key == "key")
		$exploded = explode('/', $key);
		else
		$exploded = explode('/', $timezone[$group_key]);
		if (count($exploded) > 1) {
			if (!isset($grouped_timezones[$exploded[0]])) {
				$grouped_timezones[$exploded[0]] = array();
			}
			$grouped_timezones[$exploded[0]][$key] = $timezone;
		} else {
			if (!isset($grouped_timezones['Misc'])) {
				$grouped_timezones['Misc'] = array();
			}
			$grouped_timezones['Misc'][$key] = $timezone;
		}
	}
	ksort($grouped_timezones);
	return $grouped_timezones;
}

/*Function For Get Time Diference*/
function timeDiffernce($start_time,$end_time){
   // convert to unix timestamps
   $start_time = strtotime($start_time);
   $end_time = strtotime($end_time);

   // perform subtraction to get the difference (in seconds) between times
   $timeDiffernce = ($end_time-$start_time);

   // return the difference
   return date("H:i:s",$timeDiffernce);
}

/*Function to find number of Days between two dates*/
function daysBetweenDates($to, $from) {
    /*return date_diff(
        date_create($from),  
        date_create($to)
    )->format('%a');*/
    $to = new DateTime($to); 
	$from = new DateTime($from); 
    $interval = $from->diff($to); 
    return $interval->format('%a'); 
}

/*Function to find number of Months between two dates*/
function monthsBetweenDates($to, $from) {
    $to = new DateTime($to." 00:00:00"); 
	$from = new DateTime($from." 00:00:00"); 
    $interval = $from->diff($to); 
    //return $interval->format('%m'); 
	return $interval->format('%y') * 12 + $interval->format('%m');
}

/*Function to find number of Years between two dates*/
function yearsBetweenDates($to, $from) {
    $to = new DateTime($to); 
	$from = new DateTime($from); 
    $interval = $from->diff($to); 
    return $interval->format('%y');
}

/*Function to Get Number of Days of a Month*/
function getNumberDaysOfMonth($month,$year)
{
	return cal_days_in_month(CAL_GREGORIAN,$month,$year);
}

/*Function to find number of Working Days between two dates*/
function workingDaysBetweenDates($to, $from)
{
    $workingDays = 0;
    $startTimestamp = strtotime($to);
    $endTimestamp = strtotime($from);
    for ($i = $startTimestamp; $i <= $endTimestamp; $i = $i + (60 * 60 * 24)) {
        if (date("N", $i) <= 5) $workingDays = $workingDays + 1;
    }
    return $workingDays;
}

/*Function to Get Date Format Ago*/
function formatDateAgo($value){
    $time = strtotime($value);
    $d = new DateTime($value);

    $weekDays = array('Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday');
    $monthsFull = array("January","February","March","April","May","June","July","August","September","October","November","December");
	$months = array("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec");
	//return strtotime('-30 minutes');
	//return 'Il y a ' . floor((strtotime('now') - $time)/60) . ' min';
    if ($time > strtotime('-2 minutes'))
    {
        return 'A few seconds ago';
    }
    elseif ($time > strtotime('-30 minutes'))
    {
        return ' ' . floor((strtotime('now') - $time)/60) . ' minutes ago';
    }
    elseif ($time > strtotime('today'))
    {
        return 'Today at '.$d->format('G:i');
    }
    elseif ($time > strtotime('yesterday'))
    {
        return 'Yesterday at ' . $d->format('G:i');
    }
    elseif ($time > strtotime('this week'))
    {
        //return $weekDays[$d->format('N') - 1] . ', ' . $d->format('G:i');
		return $weekDays[$d->format('N') - 1] . ' at ' . $d->format('G:i');
    }
    else
    {
        return $d->format('j') . ' ' . $months[$d->format('n') - 1];
    }
}

function formatDateAgoFull($value){
    $time = strtotime($value);
    $d = new DateTime($value);

    $weekDays = array('Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday');
    $monthsFull = array("January","February","March","April","May","June","July","August","September","October","November","December");
	$months = array("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec");
	//return strtotime('-30 minutes');
	//return 'Il y a ' . floor((strtotime('now') - $time)/60) . ' min';
    if ($time > strtotime('-2 minutes'))
    {
        return 'A few seconds ago';
    }
    elseif ($time > strtotime('-30 minutes'))
    {
        return ' ' . floor((strtotime('now') - $time)/60) . ' minutes ago';
    }
    elseif ($time > strtotime('today'))
    {
        return 'Today at '.$d->format('G:i');
    }
    elseif ($time > strtotime('yesterday'))
    {
        return 'Yesterday at ' . $d->format('G:i');
    }
    elseif ($time > strtotime('this week'))
    {
        //return $weekDays[$d->format('N') - 1] . ', ' . $d->format('G:i');
		return $weekDays[$d->format('N') - 1] . ' at ' . $d->format('G:i');
    }
    else
    {
        return $d->format('j') . ' ' . $months[$d->format('n') - 1] . ' ' . $d->format('G:i');
    }
}

/*Function to Create Array of Times with Minutes and Hours Interval*/
function getTimesWithInterval( $lower = 0, $upper = 86400, $step = 3600, $format = '' ) {
    $times = array();
    if ( empty( $format ) ) {
        $format = 'g:i a';
    }

    foreach ( range( $lower, $upper, $step ) as $increment ) {
        $increment = gmdate( 'H:i', $increment );
        list( $hour, $minutes ) = explode( ':', $increment );
        $date = new DateTime( $hour . ':' . $minutes );
        $times[(string) $increment] = $date->format( $format );
    }

    return $times;
}

/*Function to Create Array of Times with Minutes and Hours Interval : From and To*/
function getTimesWithIntervalStartToEnd($lower = 0, $upper = 86400, $step = 3600, $format = ''){
	if ( empty( $format ) ) {
        $format = 'g:i a';
    }
	
	$durationArray = array();
	foreach ( range( $lower, $upper, $step ) as $increment ) {
        
		$start_time = gmdate( 'H:i', $increment );
        list( $hour, $minutes ) = explode( ':', $start_time );
        $start_date = new DateTime( $hour . ':' . $minutes );
		
		$end_time = gmdate( 'H:i', ($increment+3600) );
		list( $hour, $minutes ) = explode( ':', $end_time );
        $end_date = new DateTime( $hour . ':' . $minutes );
		
        $durationArray[(string) $start_time."|".(string) $end_time] = $start_date->format( $format ) ." to ". $end_date->format( $format ) ;
    }
	
	return $durationArray;
}

/*Function to get PHP Variable*/
function getVariable($name, $default = '', $method = 'POST') {
  switch($method){
      case 'POST' : return isset($_POST[$name]) ? $_POST[$name] : $default;
        break;
      case 'GET' : return isset($_GET[$name]) ? $_GET[$name] : $default;
        break;
      case 'COOKIE' : return isset($_COOKIE[$name]) ? $_COOKIE[$name] : $default;
	  	break;
	  case 'SERVER' : return isset($_SERVER[$name]) ? $_SERVER[$name] : $default;
	  	break;
	  case 'SESSION' : return isset($_SESSION[$name]) ? $_SESSION[$name] : $default;
	  	break;			
      default : return $default;
  }
}

/*Function to Encode Array to JSON*/
function jsonEncode($array)
{
	return json_encode($array);
}

/*Function to Decode JSON to Array*/
function jsonDecode($json,$option=false)
{
	return json_decode($json,$option);
}

/*Function to Convert Std Object to Array*/
function convertStdObjtoArray($std_obj)
{
	return json_decode(json_encode($std_obj),TRUE);
}

/*Function to Serialize an Array*/
function serializeArray($array)
{
	return serialize($array);
}

/*Function to Unserialize data to Array*/
function unserializeArray($data)
{
	return unserialize($data);
} 

/*Check Array Exists*/
function isArrayExists($array)
{
	return is_array($array);
}

/*Check Array is Multidimensional*/
function isArrayMultidimensional($array)
{
	if(isArrayExists($array))
	{
		return count($array) !== count($array, COUNT_RECURSIVE);
	}
	return false;
}

/*Check Array Key Exists*/
function isArrayKeyExists($array,$key)
{
	// check if it's even an array
	if (!isArrayExists($array)) return false;
  
	// key exists
	if (array_key_exists($key, $array)) return true;
  
	// key isn't in this array, go deeper
	foreach($array as $index => $value)
	{
		// return true if it's found
		if (isArrayKeyExists($value, $key)) return true;
	}
  
	return false;
}

/*Get Array Value By Key*/
function getArrayValueByKey($array=array(),$key=NULL,$index=NULL)
{
	if(isArrayMultidimensional($array))
	{
		if($index != NULL)
		return array_column($array, $key);
		else
		return array_column($array, $key,$index);
	}
	else
	{
		return $array[$key];
	}
	return false;
}

/*Get Array Value Index*/
function getArrayValueIndex($array=array(),$key=NULL,$value=NULL)
{
	if(isArrayMultidimensional($array))
	{
		return array_search($value, array_column($array, $key));
	}
	else
	{
		return in_array($value, $result);
	}
	return false;
}

/*Function For Sending Email*/
function ZentroveEmail($emaildataArray,$newTemplate=true) {
	/**
	* This example shows sending a message using PHP's mail() function.
	*/
	
	$email_message_html = $emaildataArray["email_message_html"];
	if($newTemplate && strpos($email_message_html, 'new_email_template_available') == false)
	{
		$company_logo = "";
		if(array_key_exists('company_logo', $emaildataArray))
			$company_logo = $emaildataArray['company_logo'];

		$email_message_html = emailTemplate('<tr><td>'.$email_message_html.'</td></tr>',$company_logo);
	}

	$is_smtp = $emaildataArray["is_smtp"];
	$from_email = $emaildataArray["from_email"];
	$from_name = $emaildataArray["from_name"];
	$replyto_email = $emaildataArray["replyto_email"];
	$replyto_name = $emaildataArray["replyto_name"];
	$to_email = $emaildataArray["to_email"];
	$to_name = $emaildataArray["to_name"];
	$cc_email = $emaildataArray["cc_email"];
	$cc_name = $emaildataArray["cc_name"];
	$bcc_email = $emaildataArray["bcc_email"];
	$bcc_name = $emaildataArray["bcc_name"];
	$email_subject = $emaildataArray["email_subject"];
	/*$email_message_html = $emaildataArray["email_message_html"];*/
	$email_alt_body = $emaildataArray["email_alt_body"];
	$email_attachment = $emaildataArray["email_attachment"];
	
	require_once(ROOT."lib/PHPMailer/PHPMailerAutoload.php");
	
	//Create a new PHPMailer instance
	$mail = new PHPMailer(true);
	
	try {
	
		if($is_smtp)
		{
			require_once(ROOT."lib/PHPMailer/class.smtp.php");
			$mail->IsSMTP();                                      // set mailer to use SMTP
			//$mail->SMTPDebug  = 2; 
			$mail->SMTPAuth = true;     // turn on SMTP authentication
			$mail->SMTPSecure = SMTP_SECURE;  
			$mail->Port       = SMTP_PORT;    
			$mail->Host = SMTP_HOST;  // specify main and backup server
			$mail->Username = SMTP_USERNAME;  // SMTP username
			$mail->Password = SMTP_PASSWORD; // SMTP password
			$mail->SMTPKeepAlive = true;
		}
		
		$mail->CharSet = 'utf-8';
		//Set who the message is to be sent from
		$mail->setFrom($from_email, $from_name);
		//Set an alternative reply-to address
		if(!empty($replyto_email))$mail->addReplyTo($replyto_email, $replyto_name);
		//Set who the message is to be sent to
		$mail->addAddress($to_email, $to_name);
		//Set CC who the message is to be sent to
		if(!empty($cc_email)){$mail->AddCC($cc_email, $cc_name);}
		//Set BCC who the message is to be sent to
		if(!empty($bcc_email)){$mail->AddBCC($bcc_email, $bcc_name);}
		//Set the subject line
		$mail->Subject = $email_subject;
		//Read an HTML message body from an external file, convert referenced images to embedded,
		//convert HTML into a basic plain-text alternative body
		//$mail->msgHTML(file_get_contents('email_test1.php'), dirname(__FILE__));
		$mail->WordWrap = 78; // set word wrap to the RFC2822 limit
		//$mail->msgHTML($email_message_html, dirname(__FILE__), true);
		$mail->msgHTML($email_message_html);
		$mail->IsHTML(true); // send as HTML
		//Replace the plain text body with one created manually
		//$mail->AltBody = 'This is a plain-text message body';
		if(!empty($email_alt_body))$mail->AltBody = $email_alt_body;
		//Attach an image file
		if(!empty($email_attachment))$mail->addAttachment($email_attachment);
		//send the message, check for errors
		if (!$mail->send()) {
			return "|0|Mailer Error: " . $mail->ErrorInfo."|";
		} else {
			return "|1|Message sent!"."|";
		}
		$mail->ClearAddresses();
	} catch (phpmailerException $e) {
		//echo $e->errorMessage();
		return "|0|Mailer Error: " . $mail->ErrorInfo."|";
	}	
}

/*Function For Sending Full Feature Email */
function ZentroveFFEmail($emaildataArray){
	/*
	* A web form that both generates and uses PHPMailer code.
	* revised, updated and corrected 27/02/2013
	* by matt.sturdy@gmail.com
	*/
	require ROOT.'lib/PHPMailer/PHPMailerAutoload.php';
	$CFG['smtp_debug'] = 2; //0 == off, 1 for client output, 2 for client and server
	$CFG['smtp_debugoutput'] = 'html';
	$CFG['smtp_server'] = 'localhost';
	$CFG['smtp_port'] = '25';
	$CFG['smtp_authenticate'] = false;
	$CFG['smtp_username'] = 'name@example.com';
	$CFG['smtp_password'] = 'yourpassword';
	$CFG['smtp_secure'] = 'None';
	$from_name = (isset($_POST['From_Name'])) ? $_POST['From_Name'] : '';
	$from_email = (isset($_POST['From_Email'])) ? $_POST['From_Email'] : '';
	$to_name = (isset($_POST['To_Name'])) ? $_POST['To_Name'] : '';
	$to_email = (isset($_POST['To_Email'])) ? $_POST['To_Email'] : '';
	$cc_email = (isset($_POST['cc_Email'])) ? $_POST['cc_Email'] : '';
	$bcc_email = (isset($_POST['bcc_Email'])) ? $_POST['bcc_Email'] : '';
	$subject = (isset($_POST['Subject'])) ? $_POST['Subject'] : '';
	$message = (isset($_POST['Message'])) ? $_POST['Message'] : '';
	$test_type = (isset($_POST['test_type'])) ? $_POST['test_type'] : 'smtp';
	$smtp_debug = (isset($_POST['smtp_debug'])) ? $_POST['smtp_debug'] : $CFG['smtp_debug'];
	$smtp_server = (isset($_POST['smtp_server'])) ? $_POST['smtp_server'] : $CFG['smtp_server'];
	$smtp_port = (isset($_POST['smtp_port'])) ? $_POST['smtp_port'] : $CFG['smtp_port'];
	$smtp_secure = strtolower((isset($_POST['smtp_secure'])) ? $_POST['smtp_secure'] : $CFG['smtp_secure']);
	$smtp_authenticate = (isset($_POST['smtp_authenticate'])) ?
	$_POST['smtp_authenticate'] : $CFG['smtp_authenticate'];
	$authenticate_password = (isset($_POST['authenticate_password'])) ?
	$_POST['authenticate_password'] : $CFG['smtp_password'];
	$authenticate_username = (isset($_POST['authenticate_username'])) ?
	$_POST['authenticate_username'] : $CFG['smtp_username'];
	// storing all status output from the script to be shown to the user later
	$results_messages = array();
	// $example_code represents the "final code" that we're using, and will
	// be shown to the user at the end.
	$example_code = "\nrequire_once '../PHPMailerAutoload.php';";
	$example_code .= "\n\n\$results_messages = array();";
	$mail = new PHPMailer(true); //PHPMailer instance with exceptions enabled
	$mail->CharSet = 'utf-8';
	$mail->Debugoutput = $CFG['smtp_debugoutput'];
	$example_code .= "\n\n\$mail = new PHPMailer(true);";
	$example_code .= "\n\$mail->CharSet = 'utf-8';";
	class phpmailerAppException extends phpmailerException
	{
	}
	$example_code .= "\n\nclass phpmailerAppException extends phpmailerException {}";
	$example_code .= "\n\ntry {";
	try {
	if (isset($_POST["submit"]) && $_POST['submit'] == "Submit") {
	$to = $_POST['To_Email'];
	if (!PHPMailer::validateAddress($to)) {
	throw new phpmailerAppException("Email address " . $to . " is invalid -- aborting!");
	}
	$example_code .= "\n\$to = '{$_POST['To_Email']}';";
	$example_code .= "\nif(!PHPMailer::validateAddress(\$to)) {";
	$example_code .= "\n throw new phpmailerAppException(\"Email address \" . " .
	"\$to . \" is invalid -- aborting!\");";
	$example_code .= "\n}";
	switch ($_POST['test_type']) {
	case 'smtp':
	$mail->isSMTP(); // telling the class to use SMTP
	$mail->SMTPDebug = (integer)$_POST['smtp_debug'];
	$mail->Host = $_POST['smtp_server']; // SMTP server
	$mail->Port = (integer)$_POST['smtp_port']; // set the SMTP port
	if ($_POST['smtp_secure']) {
	$mail->SMTPSecure = strtolower($_POST['smtp_secure']);
	}
	$mail->SMTPAuth = array_key_exists('smtp_authenticate', $_POST); // enable SMTP authentication?
	if (array_key_exists('smtp_authenticate', $_POST)) {
	$mail->Username = $_POST['authenticate_username']; // SMTP account username
	$mail->Password = $_POST['authenticate_password']; // SMTP account password
	}
	$example_code .= "\n\$mail->isSMTP();";
	$example_code .= "\n\$mail->SMTPDebug = " . $_POST['smtp_debug'] . ";";
	$example_code .= "\n\$mail->Host = \"" . $_POST['smtp_server'] . "\";";
	$example_code .= "\n\$mail->Port = \"" . $_POST['smtp_port'] . "\";";
	$example_code .= "\n\$mail->SMTPSecure = \"" . strtolower($_POST['smtp_secure']) . "\";";
	$example_code .= "\n\$mail->SMTPAuth = " . (array_key_exists(
	'smtp_authenticate',
	$_POST
	) ? 'true' : 'false') . ";";
	if (array_key_exists('smtp_authenticate', $_POST)) {
	$example_code .= "\n\$mail->Username = \"" . $_POST['authenticate_username'] . "\";";
	$example_code .= "\n\$mail->Password = \"" . $_POST['authenticate_password'] . "\";";
	}
	break;
	case 'mail':
	$mail->isMail(); // telling the class to use PHP's mail()
	$example_code .= "\n\$mail->isMail();";
	break;
	case 'sendmail':
	$mail->isSendmail(); // telling the class to use Sendmail
	$example_code .= "\n\$mail->isSendmail();";
	break;
	case 'qmail':
	$mail->isQmail(); // telling the class to use Qmail
	$example_code .= "\n\$mail->isQmail();";
	break;
	default:
	throw new phpmailerAppException('Invalid test_type provided');
	}
	try {
	if ($_POST['From_Name'] != '') {
	$mail->addReplyTo($_POST['From_Email'], $_POST['From_Name']);
	$mail->From = $_POST['From_Email'];
	$mail->FromName = $_POST['From_Name'];
	$example_code .= "\n\$mail->addReplyTo(\"" .
	$_POST['From_Email'] . "\", \"" . $_POST['From_Name'] . "\");";
	$example_code .= "\n\$mail->From = \"" . $_POST['From_Email'] . "\";";
	$example_code .= "\n\$mail->FromName = \"" . $_POST['From_Name'] . "\";";
	} else {
	$mail->addReplyTo($_POST['From_Email']);
	$mail->From = $_POST['From_Email'];
	$mail->FromName = $_POST['From_Email'];
	$example_code .= "\n\$mail->addReplyTo(\"" . $_POST['From_Email'] . "\");";
	$example_code .= "\n\$mail->From = \"" . $_POST['From_Email'] . "\";";
	$example_code .= "\n\$mail->FromName = \"" . $_POST['From_Email'] . "\";";
	}
	if ($_POST['To_Name'] != '') {
	$mail->addAddress($to, $_POST['To_Name']);
	$example_code .= "\n\$mail->addAddress(\"$to\", \"" . $_POST['To_Name'] . "\");";
	} else {
	$mail->addAddress($to);
	$example_code .= "\n\$mail->addAddress(\"$to\");";
	}
	if ($_POST['bcc_Email'] != '') {
	$indiBCC = explode(" ", $_POST['bcc_Email']);
	foreach ($indiBCC as $key => $value) {
	$mail->addBCC($value);
	$example_code .= "\n\$mail->addBCC(\"$value\");";
	}
	}
	if ($_POST['cc_Email'] != '') {
	$indiCC = explode(" ", $_POST['cc_Email']);
	foreach ($indiCC as $key => $value) {
	$mail->addCC($value);
	$example_code .= "\n\$mail->addCC(\"$value\");";
	}
	}
	} catch (phpmailerException $e) { //Catch all kinds of bad addressing
	throw new phpmailerAppException($e->getMessage());
	}
	$mail->Subject = $_POST['Subject'] . ' (PHPMailer test using ' . strtoupper($_POST['test_type']) . ')';
	$example_code .= "\n\$mail->Subject = \"" . $_POST['Subject'] .
	'(PHPMailer test using ' . strtoupper($_POST['test_type']) . ')";';
	if ($_POST['Message'] == '') {
	$body = file_get_contents('contents.html');
	} else {
	$body = $_POST['Message'];
	}
	$example_code .= "\n\$body = <<<'EOT'\n" . htmlentities($body) . "\nEOT;";
	$mail->WordWrap = 78; // set word wrap to the RFC2822 limit
	$mail->msgHTML($body, dirname(__FILE__), true); //Create message bodies and embed images
	$example_code .= "\n\$mail->WordWrap = 78;";
	$example_code .= "\n\$mail->msgHTML(\$body, dirname(__FILE__), true); //Create message bodies and embed images";
	$mail->addAttachment('image.jpg', 'image.jpg'); // optional name
	//$mail->addAttachment('images/phpmailer.png', 'phpmailer.png'); // optional name
	$example_code .= "\n\$mail->addAttachment('images/phpmailer_mini.png'," .
	"'phpmailer_mini.png'); // optional name";
	$example_code .= "\n\$mail->addAttachment('images/phpmailer.png', 'phpmailer.png'); // optional name";
	$example_code .= "\n\ntry {";
	$example_code .= "\n \$mail->send();";
	$example_code .= "\n \$results_messages[] = \"Message has been sent using " .
	strtoupper($_POST['test_type']) . "\";";
	$example_code .= "\n}";
	$example_code .= "\ncatch (phpmailerException \$e) {";
	$example_code .= "\n throw new phpmailerAppException('Unable to send to: ' . \$to. ': '.\$e->getMessage());";
	$example_code .= "\n}";
	try {
	$mail->send();
	$results_messages[] = "Message has been sent using " . strtoupper($_POST["test_type"]);
	} catch (phpmailerException $e) {
	throw new phpmailerAppException("Unable to send to: " . $to . ': ' . $e->getMessage());
	}
	}
	} catch (phpmailerAppException $e) {
	$results_messages[] = $e->errorMessage();
	}
	$example_code .= "\n}";
	$example_code .= "\ncatch (phpmailerAppException \$e) {";
	$example_code .= "\n \$results_messages[] = \$e->errorMessage();";
	$example_code .= "\n}";
	$example_code .= "\n\nif (count(\$results_messages) > 0) {";
	$example_code .= "\n echo \"<h2>Run results</h2>\\n\";";
	$example_code .= "\n echo \"<ul>\\n\";";
	$example_code .= "\nforeach (\$results_messages as \$result) {";
	$example_code .= "\n echo \"<li>\$result</li>\\n\";";
	$example_code .= "\n}";
	$example_code .= "\necho \"</ul>\\n\";";
	$example_code .= "\n}";
}

/*Function to Test Email*/
function ZentroveTestEmail() {
	/**
	* This example shows sending a message using PHP's mail() function.
	*/
	require ROOT.'lib/PHPMailer/PHPMailerAutoload.php';
	//Create a new PHPMailer instance
	$mail = new PHPMailer;
	//Set who the message is to be sent from
	$mail->setFrom('admin@wrkmash.com', 'Admin');
	//Set an alternative reply-to address
	$mail->addReplyTo('support@wrkmash.com', 'Support');
	//Set who the message is to be sent to
	$mail->addAddress('waseem.ansari@wrkmash.com', 'Test User');
	//Set CC who the message is to be sent to
	$mail->AddCC('waseeansari@gmail.com', 'CC');
	//Set BCC who the message is to be sent to
	$mail->AddBCC('waseem.85@hotmail.com', 'BCC');
	//Set the subject line
	$mail->Subject = 'Testing Email';
	//Read an HTML message body from an external file, convert referenced images to embedded,
	//convert HTML into a basic plain-text alternative body
	//$mail->msgHTML(file_get_contents('email_test1.php'), dirname(__FILE__));
	$mail->msgHTML("Email sent for testing.");
	//Replace the plain text body with one created manually
	$mail->AltBody = 'This is a plain-text message body';
	//Attach an image file
	//$mail->addAttachment(ROOT.'lib/Session.php');
	//send the message, check for errors
	if (!$mail->send()) {
		echo "Mailer Error: " . $mail->ErrorInfo;
	} else {
		echo "Message sent!"."|";
	}
}

/*Function to send Error Report to Support*/
function notifyToCPSupport($is_save,$is_send) 
{
	
}

/*********************/
/*Database Functions */
/*********************/

/*Function Get Column Value*/
function getValue($table,$column,$condition){
	//$sqlClass = new Main();
	global $sqlMainClass;
	$table = TBLPREFIX.$table;
	//return "SELECT ".$fields." FROM ".$tbl_modules. " ".$join_user_access." ".$condition." ".$limits;	   
	$array = $sqlMainClass->getRow($column,$table, $condition);
	return $array[$column];
}

/*Function to save activity data*/
function saveActivityLog($application,$activity,$user_id){
	global $sqlMainClass;
	$sqlMainClass->usedatabase(CUSTOMERDB);
	$table = TBLPREFIX_USERMANAGEMENT."users_activitylog";
	$data = array();
	$data['uid'] = $user_id;
	$data['application'] = $application;
	$data['activity'] = $activity;
	$sqlMainClass->addData($data,$table);
	//$sqlMainClass->close_db_conection();
}

/*Function to save time data*/
function saveTimeLog($user_id,$timelog_id,$column){
	global $sqlMainClass;
	$sqlMainClass->usedatabase(CUSTOMERDB);
	$table = TBLPREFIX_USERMANAGEMENT."users_timelog";
	$data = array();
	$data['uid'] = $user_id;
	$data[$column] = date('Y-m-d')." ".date('H:i:s');
	$sqlMainClass->updateData($timelog_id,$data,$table,"id");
	//$sqlMainClass->close_db_conection();
}

/*Function Get AUTO INCREMENT ID*/
function getAUTOINCREMENTID($table,$db) {
	$sql = ("SELECT `AUTO_INCREMENT` FROM  INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = '$db' AND  TABLE_NAME = '$table'");
	$query = mysql_query($sql) or die(mysql_error()); 
	
	if (!$query) { 
			return "Could not successfully run query ($sql) from DB: " . mysql_error()." method getNextID"; 
			exit; 
		} 
	$row = mysql_fetch_array($query);
	return $nextId = $row['AUTO_INCREMENT'];
}

/*Function Get MAX ID*/
function getTableMaxID($table,$column) {
	//$sql = ("SELECT MAX(`$column`)+1 AS `$column` FROM `".$table."` ORDER BY `$column` DESC");
	$sql = ("SELECT COALESCE(MAX(CONVERT(`$column`, SIGNED INTEGER)),0)+1 AS `$column` FROM `".$table."` ORDER BY `$column` DESC");
	$query = mysql_query($sql) or die(mysql_error()); 
	
	if (!$query) { 
			return "Could not successfully run query ($sql) from DB: " . mysql_error()." method getMaxID"; 
			exit; 
		} 
		
	$obj = mysql_fetch_object($query);
	return $obj->$column;
}

/*Function to Count Table Number of Rows*/
function countTableRows($table,$column,$where) {
	$sql = ("SELECT COUNT(`$column`) AS `$column` FROM `".$table."` ".$where." ORDER BY `$column` DESC");
	$query = mysql_query($sql) or die(mysql_error()); 
	
	if (!$query) { 
		return "Could not successfully run query ($sql) from DB: " . mysql_error()." method countTableRows"; 
		exit; 
	} 
		
	$obj = mysql_fetch_object($query);
	return $obj->$column;
}

/*Function to Check Table From Database*/
function checkTableFromDB($table,$obj){
	$countrows = $obj->dbcountrows("SHOW TABLES LIKE '".$table."' ");
	if($countrows>0) 
    return 1;
	else 
	return 0;
}

/*Function to get Loged In Customer Data*/
function getLogedInCustomerData($account_name) {
	global $sqlMainClass;
	$tbl_customers= TBLPREFIX."customers";
	return $customer = $sqlMainClass->getRow("*",$tbl_customers," WHERE account_name='$account_name' ");
	/*$sqlMainClass->usedatabase(CUSTOMERDB_PREFIX.$account_name);
	$customer_user = $sqlMainClass->getRow("*",TBLPREFIX_USERMANAGEMENT."users", " WHERE username = '".$account_name."' ");
	$customer['customer_employee'] = $customer_user;
	return $customer;*/		
} 

/*Function to get Loged In Customer User Data*/
function getLogedInCustomerUserData($SESSION_CUSTOMER) {
	global $sqlMainClass;
	$account_name = $SESSION_CUSTOMER['account_name'];
	$username = $SESSION_CUSTOMER['customer_employee']['username'];
	$sqlMainClass->usedatabase(CUSTOMERDB_PREFIX.$account_name);
	$customer_user = $sqlMainClass->getRow("*",TBLPREFIX_USERMANAGEMENT."users", " WHERE username = '".$username."' ");
	if($customer_user['type']!=0)
	{$customer_usersgroups = $sqlMainClass->getRow("*",TBLPREFIX_USERMANAGEMENT."usergroups", " WHERE group_id = '".$customer_user['type']."' ");$customer_usersdesination = $customer_usersgroups['title'];}
	else
	{$customer_usersdesination = "Administrator";}
	$sqlMainClass->usedatabase(DB);
	$customer_user['designation'] = $customer_usersdesination;
	return $customer_user;		
} 

/*Function to get Countries*/
function getCountries(){
	//$sqlMClass = new Main();
	global $sqlMainClass;
	$fields = "*";
	mysql_query("SET NAMES 'utf8'");
	$countries = $sqlMainClass->getRows($fields,TBLPREFIX."countries", "ORDER BY country_name");
	return $countries;
}

/*Function to get States*/
function getStates(){
	//$sqlMClass = new Main();
	global $sqlMainClass;
	$fields = "*";
	mysql_query("SET NAMES 'utf8'");
	$states = $sqlMainClass->getRows($fields,TBLPREFIX."states", "ORDER BY state_name");
	return $states;
}

/*Function to get States*/
function getCities(){
	//$sqlMClass = new Main();
	global $sqlMainClass;
	$fields = "*";
	mysql_query("SET NAMES 'utf8'");
	$cities = $sqlMainClass->getRows($fields,TBLPREFIX."cities", "ORDER BY city_name");
	return $cities;
}

/*Function to get Currencies*/
function getCurrencies(){
	//$sqlMClass = new Main();
	global $sqlMainClass;
	$fields = "*";
	mysql_query("SET NAMES 'utf8'");
	$currencies = $sqlMainClass->getRows($fields,TBLPREFIX."currencies", "ORDER BY currency_country_name");
	return $currencies;
}

/*Function to get Control Panel Translations*/
function getControlPanelTranslations(){
	//$sqlMClass = new Main();
	global $sqlMainClass;
	isset($_SESSION['customer']['language']) ? $language = $_SESSION['customer']['language'] : $language = "en";
	$fields = "translation_id,page_id,translation_text,translation_".$language;
	return $translations_controlpanel = $sqlMainClass->getRows($fields,TBLPREFIX."translations_controlpanel", " ORDER BY translation_id ");
	/*$ControlPanelTranslationsArray = array();
	foreach($translations_controlpanel as $key=>$eachTranslation)
	{
		//$BackofficeTranslationsArray[$eachTranslationBackoffice['page_id']][$eachTranslationBackoffice['translation_id']] = $eachTranslationBackoffice;
		//$BackofficeTranslationsArray[$eachTranslation['page_id']][$eachTranslation['translation_id']] = $eachTranslation["translation_".$language];
		if($eachTranslation["translation_".$language]!="")
		{$translation_text = $eachTranslation["translation_".$language];}else{$translation_text = $eachTranslation["translation_text"];}
		$ControlPanelTranslationsArray[$eachTranslation['page_id']][$eachTranslation['translation_id']] = $translation_text;
	}
	return $ControlPanelTranslationsArray;*/
}

/*Function to get Admin Panel Translations*/
function getBackofficeTranslations(){
	//$sqlMClass = new Main();
	global $sqlMainClass;
	isset($_SESSION['customer']['language']) ? $language = $_SESSION['customer']['language'] : $language = "en";
	$fields = "translation_id,page_id,translation_text,translation_".$language;
	$translations_backoffice = $sqlMainClass->getRows($fields,TBLPREFIX."translations_backoffice", " ORDER BY translation_id ");
	$BackofficeTranslationsArray = array();
	foreach($translations_backoffice as $key=>$eachTranslation)
	{
		//$BackofficeTranslationsArray[$eachTranslationBackoffice['page_id']][$eachTranslationBackoffice['translation_id']] = $eachTranslationBackoffice;
		//$BackofficeTranslationsArray[$eachTranslation['page_id']][$eachTranslation['translation_id']] = $eachTranslation["translation_".$language];
		if($eachTranslation["translation_".$language]!="")
		{$translation_text = $eachTranslation["translation_".$language];}else{$translation_text = $eachTranslation["translation_text"];}
		$BackofficeTranslationsArray[$eachTranslation['page_id']][$eachTranslation['translation_id']] = $translation_text;
	}
	return $BackofficeTranslationsArray;
}

/*Function to get Applications Data*/
function applicationsData($condition="",$orderby="",$limits=""){
	global $sqlMainClass;
	$fields = "*";
	$applications = $sqlMainClass->getRows($fields,TBLPREFIX."applications", "  ".$condition." ".$orderby." ".$limits);	
	return $applications;
}

/*Function to check Application*/
function checkApplication($app_id){
	global $sqlMainClass;
	$tbl_applications = TBLPREFIX."applications";
	return $check_application = $sqlMainClass->getRow("*",$tbl_applications, " WHERE app_id = '$app_id' ");
}

/*Function to get Applications Data*/
function customerApplicationsData($condition="",$orderby="",$limits=""){
	global $sqlMainClass;
	$tbl_applications = TBLPREFIX."applications";
	$tbl_customers_applications = TBLPREFIX."customers_applications";
	$fields = "$tbl_applications.app_id,
			   $tbl_applications.app_title,
			   $tbl_applications.app_image,
			   $tbl_applications.app_icon,
			   $tbl_applications.app_hover_icon,
			   $tbl_applications.app_leftmenu_icon,
			   $tbl_applications.app_leftmenu_hovericon,
			   $tbl_applications.app_topmenu_icon,
			   $tbl_applications.app_topmenu_hovericon,
			   $tbl_applications.app_name,
			   $tbl_applications.app_link,
			   $tbl_applications.app_cp_link,
			   $tbl_applications.app_cost,
			   $tbl_applications.app_description,
			   $tbl_applications.app_frontend_title,
			   $tbl_applications.app_font_icon,
			   $tbl_applications.is_frontend_app,
			   $tbl_applications.is_appsetup,
			   $tbl_applications.is_cms,
			   $tbl_applications.is_link,
			   $tbl_applications.is_payable,
			   $tbl_applications.is_delete,
			   $tbl_applications.status,
			   $tbl_applications.ts,
			   $tbl_customers_applications.customer_app_id,
			   $tbl_customers_applications.customer_id,
			   $tbl_customers_applications.customer_app_manage,
			   $tbl_customers_applications.customer_app_status
			   ";
		   
	$join_applications = " LEFT JOIN $tbl_applications ON $tbl_applications.app_id = $tbl_customers_applications.app_id ";
	//$join_applications = " RIGHT JOIN $tbl_applications ON $tbl_applications.app_id = $tbl_customers_applications.app_id ";
	//return "SELECT ".$fields." FROM ".$tbl_customers_applications. " ".$join_applications." ".$condition." ".$limits;	   
	$customer_applications = $sqlMainClass->getRows($fields,$tbl_customers_applications, " ".$join_applications." ".$condition." ".$orderby." ".$limits);
	return $customer_applications;
}

/*Function to check Applications*/
function checkCustomerApplications($condition="",$orderby="",$limits=""){
	global $sqlMainClass;
	$tbl_customers_applications = TBLPREFIX."customers_applications";
	$fields = "*";
	return $check_customer_applications = $sqlMainClass->getRows($fields,$tbl_customers_applications, $condition." ".$orderby." ".$limits);
}

/*Function to check Single Application*/
function checkCustomerApplication($condition="",$orderby="",$limits=""){
	global $sqlMainClass;
	$tbl_applications = TBLPREFIX."applications";
	$tbl_customers_applications = TBLPREFIX."customers_applications";
	$fields = "$tbl_applications.app_id,
			   $tbl_applications.app_title,
			   $tbl_applications.app_image,
			   $tbl_applications.app_icon,
			   $tbl_applications.app_hover_icon,
			   $tbl_applications.app_leftmenu_icon,
			   $tbl_applications.app_leftmenu_hovericon,
			   $tbl_applications.app_topmenu_icon,
			   $tbl_applications.app_topmenu_hovericon,
			   $tbl_applications.app_name,
			   $tbl_applications.app_link,
			   $tbl_applications.app_cp_link,
			   $tbl_applications.app_cost,
			   $tbl_applications.app_description,
			   $tbl_applications.app_frontend_title,
			   $tbl_applications.app_font_icon,
			   $tbl_applications.is_frontend_app,
			   $tbl_applications.is_appsetup,
			   $tbl_applications.is_cms,
			   $tbl_applications.is_link,
			   $tbl_applications.is_payable,
			   $tbl_applications.is_delete,
			   $tbl_applications.status,
			   $tbl_applications.ts,
			   $tbl_customers_applications.customer_app_id,
			   $tbl_customers_applications.customer_id,
			   $tbl_customers_applications.customer_app_manage,
			   $tbl_customers_applications.customer_app_status
			   ";
		   
	$join_applications = " LEFT JOIN $tbl_applications ON $tbl_applications.app_id = $tbl_customers_applications.app_id ";
	//$join_applications = " RIGHT JOIN $tbl_applications ON $tbl_applications.app_id = $tbl_customers_applications.app_id ";
	//return "SELECT ".$fields." FROM ".$tbl_customers_applications. " ".$join_applications." ".$condition." ".$limits;	   
	$customer_application = $sqlMainClass->getRow($fields,$tbl_customers_applications, " ".$join_applications." ".$condition." ".$orderby." ".$limits);
	return $customer_application;
}

/*Function to get Applications Data For Setup*/
function customerApplicationsDataSetup($condition="",$orderby="",$limits=""){
	global $sqlMainClass;
	$tbl_applications = TBLPREFIX."applications";
	$tbl_customers_applications = TBLPREFIX."customers_applications";
	$fields = "$tbl_applications.app_id,
			   $tbl_applications.app_title,
			   $tbl_applications.app_image,
			   $tbl_applications.app_icon,
			   $tbl_applications.app_hover_icon,
			   $tbl_applications.app_leftmenu_icon,
			   $tbl_applications.app_leftmenu_hovericon,
			   $tbl_applications.app_topmenu_icon,
			   $tbl_applications.app_topmenu_hovericon,
			   $tbl_applications.app_name,
			   $tbl_applications.app_link,
			   $tbl_applications.app_cp_link,
			   $tbl_applications.app_cost,
			   $tbl_applications.app_description,
			   $tbl_applications.app_frontend_title,
			   $tbl_applications.app_font_icon,
			   $tbl_applications.is_frontend_app,
			   $tbl_applications.is_appsetup,
			   $tbl_applications.is_cms,
			   $tbl_applications.is_link,
			   $tbl_applications.is_payable,
			   $tbl_applications.is_delete,
			   $tbl_applications.status,
			   $tbl_applications.ts,
			   $tbl_customers_applications.customer_app_id,
			   $tbl_customers_applications.customer_id,
			   $tbl_customers_applications.customer_app_manage,
			   $tbl_customers_applications.customer_app_status
			   ";
		   
	$join_applications = " RIGHT JOIN $tbl_applications ON $tbl_applications.app_id = $tbl_customers_applications.app_id ";
	//return "SELECT ".$fields." FROM ".$tbl_customers_applications. " ".$join_applications." ".$condition." ".$limits;	   
	$customer_applications = $sqlMainClass->getRows($fields,$tbl_customers_applications, " ".$join_applications." ".$condition." ".$orderby." ".$limits);
	return $customer_applications;
}

/*Function to get Customer Applications Modules*/	
function customerAppModulesData($condition="",$orderby="",$limits=""){
	global $sqlMainClass;
	$tbl_applications_modules = TBLPREFIX."applications_modules";
	$fields = "*";
	$applications_modules = $sqlMainClass->getRows($fields,$tbl_applications_modules,  " ".$condition." ".$orderby." ".$limits);
	return $applications_modules;
}

/*Function to get Customer Applications Modules Sections*/	
function customerAppModulesSectionsData($condition="",$orderby="",$limits=""){
	global $sqlMainClass;
	$tbl_applications_modules_sections = TBLPREFIX."applications_modules_sections";
	$fields = "*";
	$applications_modules_sections = $sqlMainClass->getRows($fields,$tbl_applications_modules_sections,  " ".$condition." ".$orderby." ".$limits);
	return $applications_modules_sections;
}

/*Function Get Setting Data*/
function getSettingsData(){
	//$sqlClass = new Main();
	global $sqlMainClass;
	$settings = $sqlMainClass->getRows("*", TBLPREFIX."settings","");
	$settingsArray = array();
	foreach($settings as $key=>$value)
	{
		$settingsArray[$value['key']] = $value['value'];
	}
	return $settingsArray;
}

/*Save Application Settings Data*/
function saveApplicationSetting($sqlClass,$table,$vlaue,$key,$column){
	$check_column = $sqlClass->getRow("*",$table,"WHERE `$column`='$key' ");
	if(is_array($check_column))
	{
	    $sqlClass->updateRow($table," value='$vlaue' "," WHERE `$column`='$key' ");
	}
	else 
	{
		$data = array();
		$data["`$column`"] = $key;
		$data["value"] = $vlaue;
		$sqlClass->addData($data,$table);
	} 
}

/*Function to get Sitebuilder Themes Data*/
function getSitebuilderTemplates($condition="",$orderby="",$limits=""){
	//$sqlMClass = new Main();
	global $sqlMainClass;
	$fields = "*";
	$sitebuilder_templates = $sqlMainClass->getRows($fields,TBLPREFIX."sitebuilder_templates",  " ".$condition." ".$orderby." ".$limits);
	return $sitebuilder_templates;
}

/*Function to get E-Commerce Themes Data*/
function getEcommerceTemplates($condition="",$orderby="",$limits=""){
	//$sqlMClass = new Main();
	global $sqlMainClass;
	$fields = "*";
	$ecommerce_templates = $sqlMainClass->getRows($fields,TBLPREFIX."ecommerce_templates",  " ".$condition." ".$orderby." ".$limits);
	return $ecommerce_templates;
}

/*Function to check Customer Account Verification*/	
function checkAccountVerification($account_verification_code){
	if(!empty($account_verification_code))
	{
		global $sqlMainClass;
		$tbl_customers = TBLPREFIX."customers";
		$fields = "*";
		$account_information = $sqlMainClass->getRow($fields,$tbl_customers,  " WHERE account_code = '$account_verification_code' ");
		if(md5($account_information['account_name']) == $account_verification_code)
		{return $account_information;}
		else
		{return 0;}
	}{return 0;}
}

/*Function to get Dashboard Report Settings*/
function getAllDashboardReportSettings($where="",$orderby="",$limit=""){
	global $sqlMainClass;
	$fields =  " * ";
	$dasboard_reports =  $sqlMainClass->getRows($fields,TBLPREFIX."applications_reports",  "  ".$where." ".$orderby." ".$limit);	
	return $dasboard_reports;
}

/*Function to get All Reports Data*/
function getAllReports($where="",$orderby="") {
	global $sqlMainClass;
	$tbl_applications = TBLPREFIX."applications";
	$tbl_applications_reports = TBLPREFIX."applications_reports";	
	$fields = "$tbl_applications_reports.app_id,
			   $tbl_applications_reports.report_id,
			   $tbl_applications_reports.report_title,
			   $tbl_applications_reports.report_name,
			   $tbl_applications_reports.report_filename,
			   $tbl_applications_reports.report_description,
			   $tbl_applications_reports.type,
			   $tbl_applications_reports.is_delete,
			   $tbl_applications_reports.status,
			   $tbl_applications_reports.is_dashboard,
			   $tbl_applications_reports.display_order,
			   $tbl_applications.app_id as appid,
			   $tbl_applications.app_title";
	   
	$join_applications = " left JOIN $tbl_applications ON $tbl_applications.app_id = $tbl_applications_reports.app_id  ";
	//return "SELECT ".$fields." FROM ".$tbl_customers_applications. " ".$join_applications." ".$condition." ".$limits;	   
	$all_reports = $sqlMainClass->getRows($fields,$tbl_applications_reports, " ".$join_applications." ".$where." " .$orderby);
	return $all_reports;	

}

/*Function to get Help Section Data*/
function getHelpSectionsData($where="",$orderby="") {
	global $sqlMainClass;
	$tbl_helpsection_contents = TBLPREFIX."helpsection_contents";
	$fields = "*";
	   
	$all_helpsection_contents = $sqlMainClass->getRows($fields,$tbl_helpsection_contents, " ".$where." ".$orderby);
	return $all_helpsection_contents;	

}

/*Function to get Applications Settings Data*/
function getApplicationsSettingsData($customer_db="") {
	global $sqlMainClass;

	if($customer_db == "")
		$sqlMainClass->usedatabase(CUSTOMERDB);
	else if($customer_db != "")
		$sqlMainClass->usedatabase($customer_db);
	/*OPOS Settings Array*/
	$oposSetting = $sqlMainClass->getRows("*",TBLPREFIX_OPOS."app_config", " ");
	$opos_settingArray = array();
	foreach($oposSetting as $key => $value)
	{
	  $opos_settingArray[$value['key']] = $value['value'];
	}
	
	/*Accounting Settings Array*/
	$accountingSetting = $sqlMainClass->getRows("*",TBLPREFIX_ACCOUNTING."sys_prefs", " ");
	$accounting_settingArray = array();
	foreach($accountingSetting as $key => $value)
	{
	  $accounting_settingArray[$value['name']] = $value['value'];
	}
	
	/*Ecommerce Settings Array*/
	$ecommerceSetting = $sqlMainClass->getRows("*",TBLPREFIX_ECOMMERCE."general_settings", " ");
	$ecommerce_settingArray = array();
	foreach($ecommerceSetting as $key => $value)
	{
	  $ecommerce_settingArray[$value['key']] = $value['value'];
	}
	
	/*Sitebuilder Settings Array*/
	$sitebuilderSetting = $sqlMainClass->getRows("*",TBLPREFIX_SITEBUILDER."general_settings", " ");
	$sitebuilder_settingArray = array();
	foreach($sitebuilderSetting as $key => $value)
	{
	  $sitebuilder_settingArray[$value['key']] = $value['value'];
	}
	
	return array(
					POINTOFSALE => $opos_settingArray,
					ACCOUNTING => $accounting_settingArray,
					ECOMMERCE => $ecommerce_settingArray,
					SITEBUILDER => $sitebuilder_settingArray
			    );
	
	//$sqlMainClass->usedatabase(DB);
	//$sqlMainClass->close_db_conection();	

}

/*Function to get Payment Gateways Data*/
function getPaymentGateways($where="",$orderby="") {
	global $sqlMainClass;
	$tbl_payment_gateways = TBLPREFIX."payment_gateways";
	$fields = "*";
		
	$all_payment_gateways = $sqlMainClass->getRows($fields,$tbl_payment_gateways , " ".$where." ".$orderby);
	return $all_payment_gateways; 
}

/*Function to get Payment Devices Data*/
function getPaymentDevices($fields = "*",$where="",$orderby="") {
	global $sqlMainClass;
	$tbl_payment_devices = TBLPREFIX."payment_devices";
	$get_payment_devices = $sqlMainClass->getRows($fields,$tbl_payment_devices , " ".$where." ".$orderby);
	return $get_payment_devices; 
}

/*Function to get Packages Data*/
function getPackages($where="",$orderby="") {
	/*global $sqlMainClass;
	$tbl_packages = TBLPREFIX."packages";
	$tbl_packages_applications = TBLPREFIX."packages_applications";
		
	$packages = $sqlMainClass->getRows("*",$tbl_packages , " ".$where." ".$orderby);
	foreach($packages as $key => $value)
	{
	  $packages_applications = $sqlMainClass->getRows("*",$tbl_packages_applications , " WHERE pkg_id = '".$value['pkg_id']."' ".$orderby);
	  $packages[$key]['applications'] = $packages_applications;
	}
	return $packages;*/
	global $sqlMainClass;
	$packages = $sqlMainClass->getRows("*",TBLPREFIX."packages" , " ".$where." ".$orderby);
	return $packages; 
}

/*Function to get Package Applications Data*/
function getPackageApplications($package_id="") {
	global $sqlMainClass;
	$packages_applications = $sqlMainClass->getRows("*",TBLPREFIX."packages_applications" , " WHERE pkg_id = '".$package_id."' ");
	return $packages_applications; 
}

/*Function to get Customers Packages Data*/
function getCustomersPackages($where="",$orderby="") {
	global $sqlMainClass;
	$tbl_packages = TBLPREFIX."packages";
	$all_customers_packages = $sqlMainClass->getRows("*",$tbl_packages , " ".$where." ".$orderby);
	return $all_customers_packages; 
}

/*Function to get All Packages and Applications Data*/
function getAllPackagesApplications($where="",$orderby="") {
	global $sqlMainClass;
	$tbl_packages = TBLPREFIX."packages";
	$tbl_packages_applications = TBLPREFIX."packages_applications";
	$packages = $sqlMainClass->getRows("*",$tbl_packages , " ".$where." ".$orderby);
	foreach($packages as $key => $value)
	{
	  $packages_applications = $sqlMainClass->getRows("*",$tbl_packages_applications , " WHERE pkg_id = '".$value['pkg_id']."' ".$orderby);
	  $packages[$key]['applications'] = $packages_applications;
	}
	return $packages;
}

/*Function to check Package Application Data*/
function checkPackageApplication($condition="") {
	global $sqlMainClass;
	$check_package_application = $sqlMainClass->getRow("*",TBLPREFIX."packages_applications" , $condition);
	return $check_package_application;
}

/*Function to Check Customer Payment Status*/
function checkCustomerPaymentStatus($customer_data) {
	//printArray($customer_data);
	global $settingsData;
	$customer_payment_status = array();
	$current_date = cleanSQL(currentDate());
	$account_name = cleanSQL($customer_data['account_name']);
	$account_is_payable = cleanSQL($customer_data['is_payable']);
	$account_create_date = date_create($customer_data['ts']);
	$account_create_date = date_format($account_create_date,"Y-m-d");
	$payment_plan = cleanSQL($customer_data['payment_plan']);
	$payment_status = cleanSQL($customer_data['payment_status']);
	$payment_start_date = cleanSQL($customer_data['payment_start_date']);
	$payment_paid_date = cleanSQL($customer_data['payment_paid_date']);
	$payment_due_date = cleanSQL($customer_data['payment_due_date']);
	$payment_trial_duration = cleanSQL($customer_data['payment_trial_duration']);
	// $payment_free_trial_warning_days = $settingsData['customer_payment_free_trial_warning_days'];
	$customer_data_payment_trial_warning_days = cleanSQL($customer_data['payment_trial_warning_days']);
	if($customer_data_payment_trial_warning_days == 0)
		$payment_free_trial_warning_days = $settingsData['customer_payment_free_trial_warning_days'];
	else
		$payment_free_trial_warning_days = $customer_data_payment_trial_warning_days;

	
	if($account_is_payable == 1 && $payment_plan != 9)
	{
		if($payment_status == 0)
		{
			//if(daysBetweenDates($current_date, $account_create_date) > 30)
			//if(daysBetweenDates($current_date, $account_create_date) >= 35)
			if(daysBetweenDates($current_date, $account_create_date) >= ($payment_trial_duration+$payment_free_trial_warning_days))
			{
				$check_customer_payment = 0;
			}
			else
			{
				$check_customer_payment = 1;
			}
			$check_customer_payment_plan = 0;
			$check_customer_payment_status = 0;
			$check_customer_payment_overdue_days = daysBetweenDates($current_date, $account_create_date);
			$check_customer_payment_trial_duration = $payment_trial_duration;
			$check_customer_payment_free_trial_warning_days = ($payment_trial_duration+$payment_free_trial_warning_days);
		}
		else 
		{
			/*if(daysBetweenDates($current_date, $payment_paid_date) > daysBetweenDates($payment_due_date, $payment_paid_date))
			{
				$check_customer_payment = 0;
			}
			else
			{
				$check_customer_payment = 1;
			}*/
						
			if($payment_status == 1)
			{
				if(daysBetweenDates($current_date, $payment_paid_date) > daysBetweenDates($payment_due_date, $payment_paid_date))
				{
					$check_customer_payment = 0;
				}
				else
				{
					$check_customer_payment = 1;
				}	
			}
			else
			{
				$check_customer_payment = 0;
			}
			
			//$check_customer_payment_status = 1;
			$check_customer_payment_plan = $payment_plan;
			$check_customer_payment_status = $payment_status;
			$check_customer_payment_overdue_days = daysBetweenDates($current_date, $payment_paid_date);
			$check_customer_payment_trial_duration = 0;
			$check_customer_payment_free_trial_warning_days = 0;
		}
	}
	else
	{
		$check_customer_payment = 1;
		$check_customer_payment_plan = 0;
		$check_customer_payment_status = 1;
		$check_customer_payment_overdue_days = 0;
		$check_customer_payment_trial_duration = 0;
		$check_customer_payment_free_trial_warning_days = 0;
	}
	
	$customer_payment_status['check_customer_payment'] = $check_customer_payment;
	$customer_payment_status['check_customer_payment_plan'] = $check_customer_payment_plan;
	$customer_payment_status['check_customer_payment_status'] = $check_customer_payment_status;
	$customer_payment_status['check_customer_payment_overdue_days'] = $check_customer_payment_overdue_days;
	$customer_payment_status['check_customer_payment_trial_duration'] = $check_customer_payment_trial_duration;
	$customer_payment_status['check_customer_payment_free_trial_warning_days'] = $check_customer_payment_free_trial_warning_days;
	
	return $customer_payment_status;
}

/*Function to get Socialboard Campaigns Data*/
function getSocialboardCampaigns($where="",$orderby="") {
	global $sqlMainClass;
	$tbl_campaigns = TBLPREFIX_SOCIALBOARD."campaigns";
	$all_campaigns = $sqlMainClass->getRows("*",$tbl_campaigns , " ".$where." ".$orderby);
	return $all_campaigns; 
}

/*Function to Get Operating System*/
function getOS() { 
    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    $os_platform    =   "Unknown OS Platform";
    $os_array       =   array(
                            '/windows nt 6.3/i'     =>  'Windows 8.1',
                            '/windows nt 6.2/i'     =>  'Windows 8',
                            '/windows nt 6.1/i'     =>  'Windows 7',
                            '/windows nt 6.0/i'     =>  'Windows Vista',
                            '/windows nt 5.2/i'     =>  'Windows Server 2003/XP x64',
                            '/windows nt 5.1/i'     =>  'Windows XP',
                            '/windows xp/i'         =>  'Windows XP',
                            '/windows nt 5.0/i'     =>  'Windows 2000',
                            '/windows me/i'         =>  'Windows ME',
                            '/win98/i'              =>  'Windows 98',
                            '/win95/i'              =>  'Windows 95',
                            '/win16/i'              =>  'Windows 3.11',
                            '/macintosh|mac os x/i' =>  'Mac OS X',
                            '/mac_powerpc/i'        =>  'Mac OS 9',
                            '/linux/i'              =>  'Linux',
                            '/ubuntu/i'             =>  'Ubuntu',
                            '/iphone/i'             =>  'iPhone',
                            '/ipod/i'               =>  'iPod',
                            '/ipad/i'               =>  'iPad',
                            '/android/i'            =>  'Android',
                            '/blackberry/i'         =>  'BlackBerry',
                            '/webos/i'              =>  'Mobile'
                        );

    foreach ($os_array as $regex => $value) { 

        if (preg_match($regex, $user_agent)) {
            $os_platform    =   $value;
        }

    }   
    return $os_platform;
}

/*Function to Get Brower Details*/
function getBrowser() {

    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    $browser        =   "Unknown Browser";
    $browser_array  =   array(
                            '/msie/i'       =>  'Internet Explorer',
                            '/firefox/i'    =>  'Firefox',
                            '/safari/i'     =>  'Safari',
                            '/chrome/i'     =>  'Chrome',
                            '/opera/i'      =>  'Opera',
                            '/netscape/i'   =>  'Netscape',
                            '/maxthon/i'    =>  'Maxthon',
                            '/konqueror/i'  =>  'Konqueror',
                            '/mobile/i'     =>  'Handheld Browser'
                        );

    foreach ($browser_array as $regex => $value) { 

        if (preg_match($regex, $user_agent)) {
            $browser    =   $value;
        }

    }
    return $browser;
}

/*Function to get IP Address*/
function get_ip_address() {
    if (isset($_SERVER)) {
      if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
      } elseif (isset($_SERVER['HTTP_CLIENT_IP'])) {
        $ip = $_SERVER['HTTP_CLIENT_IP'];
      } else {
        $ip = $_SERVER['REMOTE_ADDR'];
      }
    } else {
      if (getenv('HTTP_X_FORWARDED_FOR')) {
        $ip = getenv('HTTP_X_FORWARDED_FOR');
      } elseif (getenv('HTTP_CLIENT_IP')) {
        $ip = getenv('HTTP_CLIENT_IP');
      } else {
        $ip = getenv('REMOTE_ADDR');
      }
    }
    return $ip;
  }
//echo get_ip_address();

/*Function to get Days Name*/
function getDaysName(){
	$daysName = array();
	$daysName[1] = "Monday";
	$daysName[2] = "Tuesday";
	$daysName[3] = "Wednesday";
	$daysName[4] = "Thursday";
	$daysName[5] = "Friday";
	$daysName[6] = "Saturday";
	$daysName[7] = "Sunday";
	return $daysName;
}

/*Function to get Days Name*/
function getMonthsName(){
	$monthsName = array();
	$monthsName[1] = "January";
	$monthsName[2] = "February";
	$monthsName[3] = "March";
	$monthsName[4] = "April";
	$monthsName[5] = "May";
	$monthsName[6] = "June";
	$monthsName[7] = "July";
	$monthsName[8] = "August";
	$monthsName[9] = "September";
	$monthsName[10] = "October";
	$monthsName[11] = "November";
	$monthsName[12] = "December";
	return $monthsName;
}

/*Remove Multiple Slashes*/
function drop_multiple_slashes($str){
	if(strpos($str,'//')!==false)
	{
	   return drop_multiple_slashes(str_replace('//','/',$str));
	}
	
	if(strpos($str,'\\')!==false)
	{
	   return drop_multiple_slashes(str_replace('\\','',$str));
	}
	
	return $str;
}

/*Change New Line to br*/
function new_line_html($str){
    //return preg_replace('/\v+|\\\[rn]/','<br/>',$str);
	$str = preg_replace('/\v+|\\\[rn]/','<br/>',$str);
	return preg_replace("#(<br\s*/?>\s*){2,}#","<br/>",$str);
}

function new_line_textarea($str){
  	//return preg_replace('/\v+|\\\[rn]/',PHP_EOL,$str);
	$str = preg_replace('/\v+|\\\[rn]/',PHP_EOL,$str);
	return preg_replace("#(".PHP_EOL."\s*){2,}#",PHP_EOL,$str);
} 

/*Change br to new line*/
function br_to_newline_replace( $str ) {
    $output = str_replace( "<br>", "\n", $str );
    $output = str_replace( "<br/>", "\n", $output );
    $output = str_replace( "<br />", "\n", $output );
    $output = str_replace( "<BR>", "\n", $output );
    $output = str_replace( "<BR/>", "\n", $output );
    $output = str_replace( "<BR />", "\n", $output );
    return $output;
}

function newline_to_br_preg_replace( $str ) {
	$str = preg_replace('/\v+|\\\[rn]/','<br/>',$str);
	return preg_replace("#(<br\s*/?>\s*){2,}#","<br/>",$str);
}

function br_to_newline_preg_replace( $str ) {
 	$str = preg_replace("/<br(\s+)?\/?>/i", "\r\n", $str);
	return preg_replace("#(\r\n\s*){2,}#","\r\n",$str);
}

/*Find and change text or character in string*/
function strReplace($search,$replace,$string){
	return str_replace($search,$replace,$string);
}

/*Converts the first character of a string to upercase*/
function uppercaseFirst($string)
{
	return ucfirst($string);
}

/*Converts the first character of a string to lowercase*/
function lowercaseFirst($string)
{
	return lcfirst($string);
}

/*Converts the first character of each word in a string to uppercase*/
function uppercaseWords($string)
{
	return ucwords($string);
}

/*Parse Request URI*/
function parseRequestUri($request_uri)
{
	$request_uri_query_string = end(explode("?",$request_uri));
	$request_uri_query_string_array = explode("&",$request_uri_query_string);
	$request_uri_query_string_final_array = array();
	foreach($request_uri_query_string_array as $request_uri_query_string)
	{
		$request_uri_query_string_unparsed = explode("=",$request_uri_query_string);
		$request_uri_query_string_final_array[$request_uri_query_string_unparsed[0]] = $request_uri_query_string_unparsed[1];
	}
	//printArray($request_uri_query_string_final_array);
	return $request_uri_query_string_final_array;
}

//////////////////////////
/******Curl Functions****/
//////////////////////////

/*Function to Check Curl*/
function cpCheckCurl(){
	if(is_callable('curl_init')){
	   return 1;
	}
	else
	{
	   return 0;
	}
}

/*Function to Get Data through Curl*/
function cpGetCurl($url){
    $ch = curl_init(); 
	 
    curl_setopt($ch,CURLOPT_URL,$url);
    curl_setopt($ch,CURLOPT_BINARYTRANSFER, true);
	curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
	//curl_setopt($ch,CURLOPT_HEADER, false);
	 
    $output=curl_exec($ch);
	
    curl_close($ch);
    return $output;
}
//echo cpGetCurl("http://google.com");

/*Function to POST Data through Curl*/
function cpPostCurl($url,$params){
    $postData = '';
    //create name value pairs seperated by &
    foreach($params as $k => $v) 
    { 
      $postData .= $k . '='.$v.'&'; 
    }
    $postData = rtrim($postData, '&');
 
    $ch = curl_init();  
 
    curl_setopt($ch,CURLOPT_URL,$url);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
    curl_setopt($ch,CURLOPT_HEADER, false); 
    curl_setopt($ch,CURLOPT_POST, count($postData));
    curl_setopt($ch,CURLOPT_POSTFIELDS, $postData);    
 
    $output=curl_exec($ch);
 
    curl_close($ch);
    return $output;
}
/*$params = array(
   "name" => "My Name",
   "age" => "25",
   "location" => "Pakistan"
);
 
echo httpPost("http://google.com/examples/php/curl-examples/post.php",$params);*/

/*Function to Get Curl Error*/
function cpCheckCurlErros($url){
    $ch = curl_init();  
 
    curl_setopt($ch,CURLOPT_URL,$url);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
 
    $output=curl_exec($ch);
 
    if($output === false)
    {
        echo "Error Number:".curl_errno($ch)."<br>";
        echo "Error String:".curl_error($ch);
    }
    curl_close($ch);
    return $output;
}

/*Function to Copy Image from Url*/
function copyImageFromUrl($sourceImage,$targetImage){
	$image_file = fopen($targetImage, "wb");
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $sourceImage);
	curl_setopt($ch, CURLOPT_HEADER, 0);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 0);
	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 50); //timeout
	curl_setopt($ch, CURLOPT_TIMEOUT, 50); //timeout
	curl_setopt($ch, CURLOPT_FILE, $image_file);
	curl_exec($ch);
	curl_close($ch);
	fclose($image_file);
}

/* Load Content Form Url*/
function load_url_content($url,$id) { 
	$html = file_get_contents($url);
	$dom = new DOMDocument;
    libxml_use_internal_errors(true);
    $dom->loadHTML($html);
    $node = $dom->getElementById($id);
    if ($node) {
        return $dom->saveXML($node);
    }
    return FALSE;
}

/* Load Sitebuilder Concrete5 Login Form */
function get_sitebuilder_loginformdata($url,$id) { 
	$html = file_get_contents($url);
	$dom = new DOMDocument;
    libxml_use_internal_errors(true);
    $dom->loadHTML($html);
    $node = $dom->getElementById($id);
    if ($node) {
        return $dom->saveXML($node);
    }
    return FALSE;
}

/*
This method is used for wordpress sitebuilder admin login form
*/
function get_web_page( $url )
{
    $user_agent='Mozilla/5.0 (Windows NT 6.1; rv:8.0) Gecko/20100101 Firefox/8.0';

    $options = array(

        CURLOPT_CUSTOMREQUEST  =>"GET",        //set request type post or get
        CURLOPT_POST           =>false,        //set to GET
        CURLOPT_USERAGENT      => $user_agent, //set user agent
        CURLOPT_COOKIEFILE     =>"cookie.txt", //set cookie file
        CURLOPT_COOKIEJAR      =>"cookie.txt", //set cookie jar
        CURLOPT_RETURNTRANSFER => true,     // return web page
        CURLOPT_HEADER         => false,    // don't return headers
        CURLOPT_FOLLOWLOCATION => true,     // follow redirects
        CURLOPT_ENCODING       => "",       // handle all encodings
        CURLOPT_AUTOREFERER    => true,     // set referer on redirect
        CURLOPT_CONNECTTIMEOUT => 120,      // timeout on connect
        CURLOPT_TIMEOUT        => 120,      // timeout on response
        CURLOPT_MAXREDIRS      => 10,       // stop after 10 redirects
    );

    $ch      = curl_init( $url );
    curl_setopt_array( $ch, $options );
    $content = curl_exec( $ch );
    $err     = curl_errno( $ch );
    $errmsg  = curl_error( $ch );
    $header  = curl_getinfo( $ch );
    curl_close( $ch );

    $header['errno']   = $err;
    $header['errmsg']  = $errmsg;
    $header['content'] = $content;
    return $content;
}

//Function to Get Remote Data See Updates and explanation at: https://github.com/tazotodua/useful-php-scripts/
function get_remote_data($url, $post_paramtrs=false){
    $c = curl_init();
    curl_setopt($c, CURLOPT_URL, $url);
    curl_setopt($c, CURLOPT_RETURNTRANSFER, 1);
    if($post_paramtrs)
    {
        curl_setopt($c, CURLOPT_POST,TRUE);
        curl_setopt($c, CURLOPT_POSTFIELDS, "var1=bla&".$post_paramtrs );
    }
    curl_setopt($c, CURLOPT_SSL_VERIFYHOST,false);
    curl_setopt($c, CURLOPT_SSL_VERIFYPEER,false);
    curl_setopt($c, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows NT 6.1; rv:33.0) Gecko/20100101 Firefox/33.0");
    curl_setopt($c, CURLOPT_COOKIE, 'CookieName1=Value;');
    curl_setopt($c, CURLOPT_MAXREDIRS, 10);
    $follow_allowed= ( ini_get('open_basedir') || ini_get('safe_mode')) ? false:true;
    if ($follow_allowed)
    {
        curl_setopt($c, CURLOPT_FOLLOWLOCATION, 1);
    }
    curl_setopt($c, CURLOPT_CONNECTTIMEOUT, 9);
    curl_setopt($c, CURLOPT_REFERER, $url);
    curl_setopt($c, CURLOPT_TIMEOUT, 60);
    curl_setopt($c, CURLOPT_AUTOREFERER, true);
    curl_setopt($c, CURLOPT_ENCODING, 'gzip,deflate');
    $data=curl_exec($c);
    $status=curl_getinfo($c);
    curl_close($c);
    preg_match('/(http(|s)):\/\/(.*?)\/(.*\/|)/si',  $status['url'],$link); $data=preg_replace('/(src|href|action)=(\'|\")((?!(http|https|javascript:|\/\/|\/)).*?)(\'|\")/si','$1=$2'.$link[0].'$3$4$5', $data);   $data=preg_replace('/(src|href|action)=(\'|\")((?!(http|https|javascript:|\/\/)).*?)(\'|\")/si','$1=$2'.$link[1].'://'.$link[3].'$3$4$5', $data);
    if($status['http_code']==200)
    {
        return $data;
    }
    elseif($status['http_code']==301 || $status['http_code']==302)
    {
        if (!$follow_allowed)
        {
            if (!empty($status['redirect_url']))
            {
                $redirURL=$status['redirect_url'];
            }
            else
            {
                preg_match('/href\=\"(.*?)\"/si',$data,$m);
                if (!empty($m[1]))
                {
                    $redirURL=$m[1];
                }
            }
            if(!empty($redirURL))
            {
                return  call_user_func( __FUNCTION__, $redirURL, $post_paramtrs);
            }
        }
    }
    return "ERRORCODE22 with $url!!<br/>Last status codes<b/>:".json_encode($status)."<br/><br/>Last data got<br/>:$data";
}

/*Function to Make Hash Password*/
function makePasswordHash($password){	
	require (ROOT . 'lib' . DS . 'phpass' . DS . 'PasswordHash.php');
	$PasswordHash = new PasswordHash(12, false);
	return $password = $PasswordHash->HashPassword($password);
}

/*Function to Check Stored Hash Password*/
function checkPasswordHash($password,$stored_hash){
	require (ROOT . 'lib' . DS . 'phpass' . DS . 'PasswordHash.php');
	$PasswordHash = new PasswordHash(12, false);
	return $PasswordHash->CheckPassword($password,$stored_hash);
}

/*Set Order of Array*/
function aasort (&$array, $key) {
    $sorter=array();
    $ret=array();
    reset($array);
    foreach ($array as $ii => $va) {
        $sorter[$ii]=$va[$key];
    }
    asort($sorter);
    foreach ($sorter as $ii => $va) {
        $ret[$ii]=$array[$ii];
    }
    $array=$ret;
}

/*Function to Convert Number to Words*/
function numberToWords ($number){
	$words = array ('zero',
			'one',
			'two',
			'three',
			'four',
			'five',
			'six',
			'seven',
			'eight',
			'nine',
			'ten',
			'eleven',
			'twelve',
			'thirteen',
			'fourteen',
			'fifteen',
			'sixteen',
			'seventeen',
			'eighteen',
			'nineteen',
			'twenty',
			30=> 'thirty',
			40 => 'fourty',
			50 => 'fifty',
			60 => 'sixty',
			70 => 'seventy',
			80 => 'eighty',
			90 => 'ninety',
			100 => 'hundred',
			1000=> 'thousand');

	if (is_numeric ($number))
	{
		$number = (int) round($number);
		if ($number < 0)
		{
			$number = -$number;
			$number_in_words = 'minus ';
		}
		if ($number > 1000)
		{
			$number_in_words = $number_in_words . numberToWords(floor($number/1000)) . " " . $words[1000];
			$hundreds = $number % 1000;
			$tens = $hundreds % 100;
			if ($hundreds > 100)
			{
				$number_in_words = $number_in_words . ", " . numberToWords ($hundreds);
			}
			elseif ($tens)
			{
				$number_in_words = $number_in_words . " and " . numberToWords ($tens);
			}
		}
		elseif ($number > 100)
		{
			$number_in_words = $number_in_words . numberToWords(floor ($number / 100)) . " " . $words[100];
			$tens = $number % 100;
			if ($tens)
			{
				$number_in_words = $number_in_words . " and " . numberToWords ($tens);
			}
		}
		elseif ($number > 20)
		{
			$number_in_words = $number_in_words . " " . $words[10 * floor ($number/10)];
			$units = $number % 10;
			if ($units)
			{
				$number_in_words = $number_in_words . numberToWords ($units);
			}
		}
		else
		{
			$number_in_words = $number_in_words . " " . $words[$number];
		}
		return $number_in_words;
	}
	return false;
}

/** 
*  Function:   convert_number 
*
*  Description: 
*  Converts a given integer (in range [0..1T-1], inclusive) into 
*  alphabetical format ("one", "two", etc.)
*
*  @int
*
*  @return string
*
*/ 
function convert_number($number) { 
    if (($number < 0) || ($number > 999999999)) 
    { 
    throw new Exception("Number is out of range");
    } 

    $Gn = floor($number / 1000000);  /* Millions (giga) */ 
    $number -= $Gn * 1000000; 
    $kn = floor($number / 1000);     /* Thousands (kilo) */ 
    $number -= $kn * 1000; 
    $Hn = floor($number / 100);      /* Hundreds (hecto) */ 
    $number -= $Hn * 100; 
    $Dn = floor($number / 10);       /* Tens (deca) */ 
    $n = $number % 10;               /* Ones */ 

    $res = ""; 

    if ($Gn) 
    { 
        $res .= convert_number($Gn) . " Million"; 
    } 

    if ($kn) 
    { 
        $res .= (empty($res) ? "" : " ") . 
            convert_number($kn) . " Thousand"; 
    } 

    if ($Hn) 
    { 
        $res .= (empty($res) ? "" : " ") . 
            convert_number($Hn) . " Hundred"; 
    } 

    $ones = array("", "One", "Two", "Three", "Four", "Five", "Six", 
        "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", 
        "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eightteen", 
        "Nineteen"); 
    $tens = array("", "", "Twenty", "Thirty", "Fourty", "Fifty", "Sixty", 
        "Seventy", "Eigthy", "Ninety"); 

    if ($Dn || $n) 
    { 
        if (!empty($res)) 
        { 
            $res .= " and "; 
        } 

        if ($Dn < 2) 
        { 
            $res .= $ones[$Dn * 10 + $n]; 
        } 
        else 
        { 
            $res .= $tens[$Dn]; 

            if ($n) 
            { 
                $res .= "-" . $ones[$n]; 
            } 
        } 
    } 

    if (empty($res)) 
    { 
        $res = "zero"; 
    } 

    return $res; 
} 

/*Function for Print Array*/
function printArray($array){
	echo "<pre>";
	print_r($array);
	echo "</pre>";
}
/*Function for Email Template Array*/
function emailTemplate($body,$company_logo="")
{
	$body = str_replace("controlpanel.", "", $body);
	if($company_logo == "")
	{
		$company_logo = 'data:image/png;base64,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';
	}
	else
	{
		$file_ext = explode(".", $company_logo)[1];
		$company_logo = 'data:image/'.$file_ext.';base64,'.base64_encode(file_get_contents_curl($company_logo));
	}
    $updatedUrl = str_replace("controlpanel.", "", DOMAIN);
	$email_message_html = '<table style="width:100%;"><tbody><tr><td><div style="background: #f1f1f1;border-radius: 4px;padding: 20px;" class="new_email_template_available">
							<table width="100%" border="0" cellpadding="0" cellspacing="0" style="text-align:center;margin:auto;background: #fff; padding: 30px;">
							<tbody>
								<tr>
									<td>
										<img src="'.$company_logo.'" width="250" alt="new_logo.png">
										</td>
									</tr>
								</tbody>
							</table>
							<table width="100%" border="0" cellpadding="0" cellspacing="0" style="margin:auto;border: 1pt solid #e2e2e2;border-left: 0;border-right: 0;padding:30px;margin-top: 0;background: #fff;">
								<tbody>
								'.$body.'
								</tbody>
							</table>
							<table width="100%" border="0" cellpadding="0" cellspacing="0" style="text-align:center;margin:auto;border: 1pt solid #e2e2e2;border-left: 0;border-bottom: 0;background: #fff;border-right: 0;border-top:none;padding:20px;">
								<tbody>
									<tr>
										<td>
											<p style="font-family:Open Sans, sans-serif;color:#656565;margin:0;">
												<a rel="nofollow" style="text-decoration:none;font-size:14px;color:#656973;" href="'.$updatedUrl.'">Powered by 
													<span style="color:#4da6f3;">'.APPLICATION_NAME.'</span>
												</a>
											</p>
										</td>
									</tr>
								</tbody>
							</table>
						</div></td></tr></tbody></table>';
	return $email_message_html;
}

function file_get_contents_curl($url) {
	$ch = curl_init();
	curl_setopt ($ch, CURLOPT_URL, $url);
	curl_setopt ($ch, CURLOPT_CONNECTTIMEOUT, 5);
	curl_setopt ($ch, CURLOPT_RETURNTRANSFER, true);
	$contents = curl_exec($ch);
	if (curl_errno($ch)) {
	  echo curl_error($ch);
	  echo "\n<br />";
	  $contents = '';
	} else {
	  curl_close($ch);
	}

	return $contents;
}

/*Function to Check Customer Database is exist or not*/
function isCustomerDBexist($db_name){
	$temp_connect = mysql_connect(DBHOST, DBUSER, DBPASSWORD) or die(mysql_error());
	$fetch_all_dbs = mysql_query('SHOW DATABASES',$temp_connect);
	$all_dbs = array();
	while($db = mysql_fetch_array($fetch_all_dbs))
	{
		array_push($all_dbs, $db['Database']);
	}

	$db_name = CUSTOMERDB_PREFIX.$db_name;
	if(in_array($db_name, $all_dbs))
		return 1;
	else
		return 0;
}

/*Function to all Databases name*/
function getAllDBs()
{
	$temp_connect = mysql_connect(DBHOST, DBUSER, DBPASSWORD) or die(mysql_error());
	$fetch_all_dbs = mysql_query('SHOW DATABASES',$temp_connect);
	$all_dbs = array();
	while($db = mysql_fetch_array($fetch_all_dbs))
	{
		array_push($all_dbs, $db['Database']);
	}

	return $all_dbs;
}

function updateDomainInWPSitebuilder($conn,$user_url)
{
	$user_url = str_replace("controlpanel.", "", $user_url);
	$sql_users = "UPDATE `wp_users` SET 
						`user_url`='$user_url';";

	$user_url = str_replace("controlpanel.wrkmash", "wrkmash", $user_url);

	if (mysql_query($sql_users,$conn))
	  {
	 //echo "QUEYR EXECUTED";
	  }
	else
	  {
	  echo "Error in query: " . mysql_error();
	  }    
	  
	  $sql_wp_home = "UPDATE `wp_options` SET `option_value` = '$user_url' WHERE `wp_options`.`option_name` = 'home'";
	  if (mysql_query($sql_wp_home,$conn))
	  {
	 // //echo "QUEYR EXECUTED";
	  }
	else
	  {
	  echo "Error in query: " . mysql_error();
	  }    

	  $sql_wp_siteurl = "UPDATE `wp_options` SET `option_value` = '$user_url' WHERE `wp_options`.`option_name` = 'siteurl'";
	  if (mysql_query($sql_wp_siteurl,$conn))
	  {
	 // //echo "QUEYR EXECUTED";
	  }
	else
	  {
	  echo "Error in query: " . mysql_error();
	  }    
}

function getWPSitebuilderDomain($account_name)
{
	if($account_name != null)
	{
		$sqlClass = new Main();
		$sqlClass->usedatabase(CUSTOMERDB_PREFIX.$account_name);
		$is_table = checkTableFromDB('wp_options',$sqlClass);
		if($is_table)
		{
			$array = $sqlClass->getRow('option_value','wp_options', ' where option_name = "siteurl" ');
				
			$return_url = "";
			if(isset($_REQUEST['return_url']))
			{
				$return_url_data = $sqlClass->getRow('meta_value','wp_postmeta', ' where meta_key = "astra-main-page-id" ');//$sqlClass->getRow('option_value','wp_options', ' where option_name = "astra_sites_settings" ');

				if(empty($return_url_data))
				{
					$return_url = "starter_template";
				}
			}

			return $array['option_value']."|".$return_url;
		}
		else
			return "";		
	}
	else
		return "";
}

function checkSiteIsOnline($domain) {
   $curlInit = curl_init($domain);
   curl_setopt($curlInit,CURLOPT_CONNECTTIMEOUT,10);
   curl_setopt($curlInit,CURLOPT_HEADER,true);
   curl_setopt($curlInit,CURLOPT_NOBODY,true);
   curl_setopt($curlInit,CURLOPT_RETURNTRANSFER,true);

   //get answer
   $response = curl_exec($curlInit);

   curl_close($curlInit);
   if ($response) return true;
   return false;
}

function runWPSitebuilderCurl($account_name,$action,$post)
{
	// printArray($post);
	// exit;
	$sitebuilder_url = str_replace("controlpanel.wrkmash", "wrkmash", SITEBUILDERDOMAIN);
	$url = $sitebuilder_url.'?account_name='.$account_name.'&wp_sitebuilder_direct_action='.$action;
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL,$url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post));
	$response = curl_exec($ch);
	$result = json_decode($response,true);
	curl_close($ch); // Close the connection	
	return $result;
}
function CheckDisposableEmail($email)
{
	$domain = substr(strrchr($email, "@"), 1);
	$dispose_domain = array();
	/*
	* fetching disposable emails from text file to array.
	*/
	$handle = fopen("dispose_email_servers.txt", "r");
	//print_r($handle);exit();
	while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
	$dispose_domain[$data[0]] = $data[0];
	}
	fclose($handle);

	if (in_array($domain, $dispose_domain)) {
			//echo "Email is Disposable";
			return "|0|Please use a valid email address. Disposable addresses are not allowed."."|";
			exit();
			} /*
			* checking , if domain exist or not in DNS.
			*/ /*elseif (!in_array($domain, $dispose_domain) && !fopen("http://$domain", 'r')) {
			echo "|1|Email is Disposable|";
			exit();
			}*/
			/*
			* Checking the domains of all possible disposable emails providers.
			*/ elseif (preg_match("/(ThrowAwayMail|DeadAddress|10MinuteMail|20MinuteMail|AirMail|Dispostable|Email Sensei|EmailThe|FilzMail|Guerrillamail|IncognitoEmail|Koszmail|Mailcatch|Mailinator|Mailnesia|MintEmail|MyTrashMail|NoClickEmail|
			SpamSpot|Spamavert|Spamfree24|TempEmail|Thrashmail.ws|Yopmail|EasyTrashMail|Jetable|MailExpire|MeltMail|Spambox|empomail|33Mail|
			E4ward|GishPuppy|InboxAlias|MailNull|Spamex|Spamgourmet|BloodyVikings|SpamControl|MailCatch|Tempomail|EmailSensei|Yopmail|
			Trasmail|Guerrillamail|Yopmail|boximail|ghacks|Maildrop|MintEmail|fixmail|gelitik.in|ag.us.to|mobi.web.id
			|fansworldwide.de|privymail.de|gishpuppy|spamevader|uroid|tempmail|soodo|deadaddress|trbvm)/i", $domain)) {
			return "|0|This is disposible email address ,use valid email address"."|";
			exit();
			}
			else{
				return "|1|This is valid email address"."|";
				exit();
			}
}
?>