<?php

class imageprocessing

	{

	

	public function do_resize($srcimg="",$destimg="",$width,$height,$imw,$imh,$ext)

		{

			
			$image_info = getimagesize($srcimg);

			$allocatedmemory = (ini_get("memory_limit")*1024*1024);

			$image_width = $image_info[0]; 

			$image_height = $image_info[1]; 

			$image_bits = $image_info['bits']; 

			$image_channels = $image_info['channels']; 

			$memory_needed = round(($image_width * $image_height * $image_bits * $image_channels / 8 + Pow(2, 16)) * 1.8);

			if($allocatedmemory<=$memory_needed+5000)

				{

				return false;

				}

			

			if($ext == "jpg") 

				{

				$src = imagecreatefromjpeg($srcimg);

				if(!$src)

					{

					return false;

					}				

				} 

			else if($ext == "gif") 

				{

				$src = imagecreatefromgif ($srcimg);

					if(!$src)

					{

					return false;

					}

				} 

			else if($ext == "png") 

				{

				$src = imagecreatefrompng ($srcimg);

					if(!$src)

					{

					return false;

					}

				}

			

			$new_img = imagecreatetruecolor($imw,$imh);

				if(!$new_img)

					{

					return false;

					}

			

			if(!imagecopyresampled($new_img, $src, 0, 0, 0, 0, $imw, $imh, $width, $height))

				{

				return false;

				}

			

			if($ext == "jpg" || $ext == "jpeg") 

				{

				if(!imagejpeg($new_img, $destimg, 100))

					{

					return false;

					}

				} 

			else if($ext == "gif") 

				{

				 if(!imagegif ($new_img, $destimg, 100))

				 	{

					return false;

					}

				} 

			else if($ext == "png") 

				{

				 if(!imagepng ($new_img, $destimg, 9))

				 	{

					return false;

					}

				}//Resized uploaded image

		

		imagedestroy($src);

		return true;

		}

	public function do_crop($srcimg="",$destimg="",$rw,$rh,$ext,$left,$top,$size="m")

		{

			if($ext == "jpg") 

				{

				$src = imagecreatefromjpeg($srcimg);

				if(!$src)

					{

					return false;

					}

				} 

			else if($ext == "gif") 

				{

				$src = imagecreatefromgif ($srcimg);

				if(!$src)

					{

					return false;

					}

				} 

			else if($ext == "png") 

				{

				$src = imagecreatefrompng ($srcimg);

				if(!$src)

					{

					return false;

					}

				}

			

			

			//initiallizing new image for croping

			if($size=="m")

			$dst  = imagecreatetruecolor(160, 110);

			else

			$dst  = imagecreatetruecolor(90, 90);

			if(!$dst)

				{

				return false;

				}		

			//croping area

			

			//creating croped image

			if(!imagecopy($dst,$src, 0, 0, $left, $top, $rw, $rh))

				{

				return false;

				}

			//save croped image

			if($ext == "jpg" || $ext == "jpeg") 

				{

				if(!imagejpeg($dst, $destimg, 100))

					{

					return false;

					}

				} 

			else if($ext == "gif") 

				{

				if(!imagegif ($dst, $destimg, 100))

					{

					return false;

					}

				} 

			else if($ext == "png") 

				{

				if(!imagepng ($dst, $destimg, 9))

					{

					return false;

					}

				}

			

		//deleting resized image from image processing

		imagedestroy($src);

		return true;

		}

		
	//used for banner images

	public function getImgresoluttion($width,$height,$rw)
		{
		$res = array();
		$ratio = $height/$width;
	
		if($width>$rw)
			{
			$w = $rw;
						
			$h = $w*$ratio; 
			
			}
		else
			{
			$w = $width;
			$h = $height;
			}
		$res[0] = $w;
		$res[1] = $h;
		return $res;
		}

		

	public function getImgthumbresoluttion($width,$height,$rw,$rh)

		{
		$res = array();
		if($width>$rw && $width>$height)
				{
				$w = $rw;
				$h =  ($w/$width)*$height;
				if($h>$rh)
					{
					$h=$rh;
					$w=$h/$height*$width;
					}
				}
			elseif($width<$rw && $width>$height && $height>$rh)
				{
				$w = $width;
				$h =  ($w/$width)*$height;
				if($h>$rh)
					{
					$h=$rh;
					$w=$h/$height*$width;
					}
				}

			elseif($height>$rh && $height>$width)
				{
				$h = $rh;
				$w =  ($h/$height)*$width;
				}

			elseif($height == $width)
				{
				$h = $rh;
				$w =  $rh;
				}

			else
				{
				$h=$height;
				$w=$width;
				}
		$res[0] = $w;
		$res[1] = $h;
		return $res;

		}

	

	

	}

?>

