$(document).ready(function(){
  // check for auto domain registration
  checkAutoDomainRegistration(function(){  
    quickSettings.initialize();
    // functions in header_internal_includes.php file
    companyInfoFunctions("#account_settings_form");
    domainSettingsFunctions("#change_domain_form");
  })
})

// Json object
var quickSettings = {
  initialize:function()
  {
    quickSettings.events();
    if($("#quick_settings_container").length > 0)
    {
      var quickSettingsStatus = $("#quick_settings_container").attr("status");
      if(quickSettingsStatus == "")
      {
        quickSettings.loadQuickSettings();
      }
      else if(quickSettingsStatus != "completed")
      {
        quickSettings.addButtonForQuickSettingsModal();
      } 
    }
  },
  loadQuickSettings:function()
  {
    var url = $("#quick_settings_container").attr("url");
    if($("#quick_settings_container").html() == "")
    {
      $.fancybox.showLoading();
      $("#quick_settings_container").load(url+"quicksettings",function()
      {
        $.fancybox.hideLoading();
        getLoggedInUserProfileData($("#open_profile_modal").data("url"),1);
        var quickSettingsStatus = $("#quick_settings_container").attr("status");
        quickSettings.showQuickSetiingsModal();    
        // functions in header_internal_includes.php file
        companyInfoFunctions("#account_settings_form_quick_settings");   
        domainSettingsFunctions("#change_domain_form_quick_settings");
        editProfileFormValidate("_quick_settings");
			  // fixing flash effect for accordion
		$("#dashboardreportform .box-header").click(function(){
			$(this).siblings(".panel-collapse.collapse.in").slideToggle();
			return false;
		});
      })      
    }
    else
    {      
        quickSettings.showQuickSetiingsModal();    
    }
  },
  showQuickSetiingsModal : function()
  {
    $('.show-animation-popup').hide();
    quickSettings.addPopupAnimation();
    $("#quick-settings-modal").modal("show");      
  },
  addButtonForQuickSettingsModal : function()
  {
    $(".show_quick_settings_modal").remove();
    var html = '<div class="show_quick_settings_modal left-menu-bottom-messege">'
                +'<button class="hide_quick_settings_modal_button" type="button" aria-hidden="true">x</button>'
                +'<span>Your account setup is waiting to be completed.</span>'
              +'</div>';
    $("body").append(html);        
  },
  /* Function for add animation on popup */
  addPopupAnimation : function()
  {
      $('body').removeClass('cd-about').addClass('page-is-changing');
      setTimeout(function(){
          $('body').removeClass('page-is-changing');
          $('body').addClass('cd-about');
      },1500);
      $('.animation-main-container').addClass('cd-main-content cd-about');
      setTimeout(function(){
          $('.form-setup-modal').fadeIn();
      },1880);    
  },
  updateQuickSettingsStatus : function(status)
  {
    if($("#quick_settings_container").length > 0)
    {
      var action = "updateQuickSettingsStatus";
      var ajaxurl = $("#quick_settings_container").attr("baseurl");
      $.ajax({        
          type: "POST",
          url: ajaxurl,
          data: 'action='+action+'&status='+status, 
          cache: false,
          success: function(response) 
          {
            response = response.trim();
            $("#quick_settings_container").attr("status",response);
            if(response == "completed")
            {
              $(".show_quick_settings_modal").remove();
              $("#quick-settings-modal").modal("hide");
            }
            else if(status == "dashboard_settings")
            {
              quickSettings.addButtonForQuickSettingsModal();
              $("#quick-settings-modal").modal("hide");
            }
          }
      });      
    }
  },
  showHideNextPreviousButtons:function()
  {
    setTimeout(function(){      
      var activeForm = $('.pearl.current').attr("count");
      if(activeForm == 1)
      {
        $('#quick-settings-modal .previous-step').addClass("hide");   
        $('#quick-settings-modal .next-step').removeClass("hide");   
      }
      else if(activeForm == 4)
      {
        $('#quick-settings-modal .next-step').addClass("hide");   
        $('#quick-settings-modal .previous-step').removeClass("hide");   
      }
      else
      {
        $('#quick-settings-modal .next-step').removeClass("hide");   
        $('#quick-settings-modal .previous-step').removeClass("hide");         
      }

      if(activeForm == 3)
      {
        $(".saveQuickSetupBottom").addClass("hide")
      }
      else
      {
        $(".saveQuickSetupBottom").removeClass("hide")
      }
    },500)
  },
  saveDashboardQuickSettings:function()
  {
    var validate=true;
    var action="addReportsToDashboard";
    
    var count=1;
    var all_selected_reports = "";
    $(".show_dashboardreports_quicksettings:checked").each(function() {

          if(count<=5)
          {
              count++;
              all_selected_reports += $(this).data('report_id')+",";
              validate=true;
          }
          else
          {
              jAlert("Dashboard can display a maximum of 5 reports.", 'Warning');
              validate=false;
          }
    });
    
    if(validate==true){
        //$.fancybox.showLoading();
        quickSettings.loader("show","quick_settings");
        $.ajax({
            type: "POST",
            data:"action="+action+"&all_selected_reports="+all_selected_reports,      
            url: $("#quick_settings_container").attr("baseurl"),
            cache: false,
            success: function(response){

                  //alert(all_selected_reports);
                  var res = response.split("|");
                  
                  if(res[1] == 1)
                  {
                      quickSettings.updateQuickSettingsStatus("dashboard_settings");
                      set_feedback(res[2],'success_message',false);
                  }
                  else
                  {
                      set_feedback(response,'error_message',true);
                  }
                  //$.fancybox.hideLoading();
                  //$.fancybox.close();
                  quickSettings.loader("hide","quick_settings");
            }

        });
    }
  },
  events : function()
  {
      $(document).off('click', '.hide_quick_settings_modal_button').on('click', '.hide_quick_settings_modal_button', function(e){
          e.stopPropagation();
          jConfirm("Are you sure, you want to hide this notification?", 'Confirmation', function(r) {
            if(r == true){
              quickSettings.updateQuickSettingsStatus("completed");
              $(".show_quick_settings_modal").remove();
            }
          })
      })  

      $(document).off('click', '#quick-settings-modal .next-step').on('click', '#quick-settings-modal .next-step', function(){
          var $currentPearl = $('.pearl.current');
          $('.pearl.current').removeClass('current').addClass('done');
          $currentPearl.next().addClass('current');
          var $current = $('.form-panel-steps-container.active');
          // var eq = $current.attr("eq");
          $('.form-panel-steps-container').removeClass('active');

          // eq = parseInt(eq) + 1;
          $current.next().addClass('active');
          // $('.form-panel-steps-container:eq(eq)').removeClass('active');

          /* code for add animation on next button*/
          $('body').removeClass('cd-about');
          $('.animation-main-container').removeClass('cd-main-content cd-about');
          $('.form-setup-modal').hide();
          quickSettings.showHideNextPreviousButtons();
          quickSettings.addPopupAnimation();
      });

      $(document).off('click', '#quick-settings-modal .previous-step').on('click', '#quick-settings-modal .previous-step', function(){
          var $currentPearl = $('.pearl.current');
          $('.pearl.current').removeClass('current');
          $currentPearl.prev().addClass('current').removeClass("done");
          var $current = $('.form-panel-steps-container.active');
          $('.form-panel-steps-container').removeClass('active');
          $current.prev().addClass('active');

          /* code for add animation on next button*/
          $('body').removeClass('cd-about');
          $('.animation-main-container').removeClass('cd-main-content cd-about');
          $('.form-setup-modal').hide();
          quickSettings.showHideNextPreviousButtons();
          quickSettings.addPopupAnimation();
      });

      $(document).off('click', '.show-animation-popup').on('click', '.show-animation-popup', function(){
          $('.show-animation-popup').hide();
          quickSettings.addPopupAnimation();
      });

      $(document).off('click', '.data-toggle-button').on('click', '.data-toggle-button', function(){
          if ($(this).parent('.box-primary').hasClass('collapsed-box')) 
          {   
              $(this).parent('.box-primary').removeClass('collapsed-box');
              $(this).parent('.box-primary').find('.box-body').toggle();
          }
          else
          {
              $(this).parent('.box-primary').addClass('collapsed-box');
              $(this).parent('.box-primary').find('.box-body').toggle();
          }
      });

      $(document).off('click', '.form-setup-modal-close').on('click', '.form-setup-modal-close', function(){
          $("#quick-settings-modal").modal("hide");
          quickSettings.addButtonForQuickSettingsModal();
          quickSettings.updateQuickSettingsStatus("");
      });

      // show modal via button
      $(document).off('click', '.show_quick_settings_modal').on('click', '.show_quick_settings_modal', function(){
          quickSettings.loadQuickSettings();
      });

      $(document).off('click', '.saveQuickSetup').on('click', '.saveQuickSetup', function(){
        var formId = $('.form-panel-steps-container.active').attr("id");
        if(formId == "dashboardreportform")
        {
            quickSettings.saveDashboardQuickSettings();
        }
        else if(formId == "change_domain_form_quick_settings")
        {
            // function in header_internal_includes.php file
            saveDomainSettings("#change_domain_form_quick_settings");
        }
        else
        {
            $("#"+formId).submit();
        }
      });
	  
      $(document.body).off('change','.show_dashboardreports_quicksettings').on('change','.show_dashboardreports_quicksettings',function()
      {   
          var count = $(".show_dashboardreports_quicksettings:checked").length;
          if(!$(this).is(':checked'))
          {
              if(count<=5)
              {
                  set_feedback('','success_message',false);
              }
          }
          else
          {
              if(count<=5)
              {
                  set_feedback('','success_message',false);
              }
              else
              {
                  $(this).trigger("click");
                  jAlert("Dashboard can display a maximum of 5 reports.", 'Warning');
              }            
          }
          
      });
  },
  loader:function(action,formId)
  {
    if(formId.includes("quick_setting"))
    {
      if(action =="show")
      {
        showAjaxResponseOverlay("");
      }
      else
      {
        hideAjaxResponseOverlay("");      
      }      
    }
    else
    {
      if(action =="show")
      {
        showResponseOverlay()
      }
      else
      {
        hideResponseOverlay();
      }
    }
  }
}

