<?php
require_once ("secure_area.php");
require_once (APPPATH."libraries/ofc-library/open-flash-chart.php");
class Reports extends Secure_area 
{	
	function __construct()
	{
		parent::__construct('reports');
		$this->load->helper('report');		
	}
	
	//Initial report listing screen
	function index()
	{
		$data=array();
	
		if ( $t1=$this->Appconfig->get('freports') ){
			$data['frep']= $t1;
			}
			$this->load->view("reports/listing",$data);	
	}
	
	function _get_common_report_data()
	{
		$data = array();
		$data['report_date_range_simple'] = get_simple_date_ranges();
		$data['months'] = get_months();
		$data['days'] = get_days();
		$data['years'] = get_years();
		$data['selected_month']=date('n');
		$data['selected_day']=date('d');
		$data['selected_year']=date('Y');	
	
		return $data;
	}
	
	//Input for reports that require only a date range and an export to excel. (see routes.php to see that all summary reports route here)
	function date_input_excel_export()
	{
		$data = $this->_get_common_report_data();
		$this->load->view("reports/date_input_excel_export",$data);	
	}
	
	//Summary sales report
	function summary_sales($start_date, $end_date, $export_excel=0)
	{
		$this->load->model('reports/Summary_sales');
		$model = $this->Summary_sales;
		$tabular_data = array();
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $tabular_data[] = array($row['sale_date'], to_currency($row['subtotal']), to_currency($row['total']), to_currency($row['tax']),to_currency($row['profit']));
		  }
		}
		$data = array(
			"title" => $this->lang->line('reports_sales_summary_report'),
			"subtitle" => date('m/d/Y', strtotime($start_date)) .'-'.date('m/d/Y', strtotime($end_date)),
			"headers" => $model->getDataColumns(),
			"data" => $tabular_data,
			"summary_data" => $model->getSummaryData(array('start_date'=>$start_date, 'end_date'=>$end_date)),
			"export_excel" => $export_excel
		);

		$this->load->view("reports/tabular",$data);
	}
	
	//Summary categories report
	function summary_categories($start_date, $end_date, $export_excel=0)
	{
		$this->load->model('reports/Summary_categories');
		$model = $this->Summary_categories;
		$tabular_data = array();
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $tabular_data[] = array($row['category'], to_currency($row['subtotal']), to_currency($row['total']), to_currency($row['tax']),to_currency($row['profit']));
		  }
		}
		$data = array(
			"title" => $this->lang->line('reports_categories_summary_report'),
			"subtitle" => date('m/d/Y', strtotime($start_date)) .'-'.date('m/d/Y', strtotime($end_date)),
			"headers" => $model->getDataColumns(),
			"data" => $tabular_data,
			"summary_data" => $model->getSummaryData(array('start_date'=>$start_date, 'end_date'=>$end_date)),
			"export_excel" => $export_excel
		);

		$this->load->view("reports/tabular",$data);
	}
	//Summary clocking report Added By admin@wrkmash.com
	function summary_clockings($start_date, $end_date, $export_excel=0)
	{
		$this->load->model('reports/Summary_clockinout');
		$model = $this->Summary_clockinout;
		$tabular_data = array();
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		
		//print_r($report_data);
		foreach($report_data as $row)
		{
			 $dt = (strtotime($row['logout'])- strtotime($row['login']));
			$tabular_data[] = array($row['username'],output_db_datetime($row['login']),output_db_datetime($row['logout']),TS2time($dt));
		}

		$data = array(
			"title" => "Clock In-Clock Out ",
			"subtitle" => date('m/d/Y', strtotime($start_date)) .'-'.date('m/d/Y', strtotime($end_date)),
			"headers" => $model->getDataColumns(),
			"data" => $tabular_data,
			//"summary_data" => $model->getSummaryData(array('start_date'=>$start_date, 'end_date'=>$end_date)),
			"export_excel" => $export_excel
		);

		$this->load->view("reports/tabular_clk",$data);
	}
	//Summary customers report
	function summary_customers($start_date, $end_date, $export_excel=0)
	{
		$this->load->model('reports/Summary_customers');
		$model = $this->Summary_customers;
		$tabular_data = array();
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $tabular_data[] = array($row['customer'], to_currency($row['subtotal']), to_currency($row['total']), to_currency($row['tax']),to_currency($row['profit']));
		  }
		}
		$data = array(
			"title" => $this->lang->line('reports_customers_summary_report'),
			"subtitle" => date('m/d/Y', strtotime($start_date)) .'-'.date('m/d/Y', strtotime($end_date)),
			"headers" => $model->getDataColumns(),
			"data" => $tabular_data,
			"summary_data" => $model->getSummaryData(array('start_date'=>$start_date, 'end_date'=>$end_date)),
			"export_excel" => $export_excel
		);

		$this->load->view("reports/tabular",$data);
	}
	//====================Added By admin@wrkmash.com =================//
	
		function specific_sael_input()
	{
		$data = $this->_get_common_report_data();
		$data['specific_input_name'] = $this->lang->line('reports_employee');
		
		$employees = array();
		$employees[0] = "All Employees";
		foreach($this->Employee->get_all()->result() as $employee)
		{
			$employees[$employee->person_id] = $employee->first_name .' '.$employee->last_name;
		}
		$data['specific_input_data'] = $employees;
		$this->load->view("reports/specific_input",$data);	
	}


function summary_SAEL($start_date, $end_date, $employee_id, $export_excel=0)
	{
		$this->load->model('reports/Summary_sael');
		$model = $this->Summary_sael;
		
		//$this->load->model('reports/Specific_employee');
		//$model = $this->Specific_employee;
		$tabular_data = array();
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date,'employee_id' =>$employee_id));
		if(!empty($report_data))
		{
		/*print_r($report_data);*/
//		$tabular_data[] =$report_data;
		  foreach($report_data as $row)
		  {//COUNT(sale_id), SUM(totalSV),SUM(profit),first_name'
			$tabular_data[] = array( $row['COUNT(sale_id)'],$row['first_name'],$row['SUM(totalSV)'],$row['SUM(profit)']);
		  }
		}
		
		$data = array(
			"title" => "Summary Sales Person ",
			"subtitle" => date('m/d/Y', strtotime($start_date)) .'-'.date('m/d/Y', strtotime($end_date)),
			"headers" => $model->getDataColumns(),
			"data" => $tabular_data,
			
			//"summary_data" => $model->getSummaryData(array('start_date'=>$start_date, 'end_date'=>$end_date)),
			"export_excel" => $export_excel
		);

	$this->load->view("reports/tabular_SP",$data);
		
	}
	//=============================//
	
	
	
	
	//Summary suppliers report
	function summary_suppliers($start_date, $end_date, $export_excel=0)
	{
		$this->load->model('reports/Summary_suppliers');
		$model = $this->Summary_suppliers;
		$tabular_data = array();
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $tabular_data[] = array($row['supplier'], to_currency($row['subtotal']), to_currency($row['total']), to_currency($row['tax']),to_currency($row['profit']));
		  }
		}
		$data = array(
			"title" => $this->lang->line('reports_suppliers_summary_report'),
			"subtitle" => date('m/d/Y', strtotime($start_date)) .'-'.date('m/d/Y', strtotime($end_date)),
			"headers" => $model->getDataColumns(),
			"data" => $tabular_data,
			"summary_data" => $model->getSummaryData(array('start_date'=>$start_date, 'end_date'=>$end_date)),
			"export_excel" => $export_excel
		);

		$this->load->view("reports/tabular",$data);
	}
	
	//Summary items report
	function summary_items($start_date, $end_date, $export_excel=0)
	{
		$this->load->model('reports/Summary_items');
		$model = $this->Summary_items;
		$tabular_data = array();
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $tabular_data[] = array(character_limiter($row['name'], 16), $row['quantity_purchased'], to_currency($row['subtotal']), to_currency($row['total']), to_currency($row['tax']),to_currency($row['profit']));
		  }
		}
		$data = array(
			"title" => $this->lang->line('reports_items_summary_report'),
			"subtitle" => date('m/d/Y', strtotime($start_date)) .'-'.date('m/d/Y', strtotime($end_date)),
			"headers" => $model->getDataColumns(),
			"data" => $tabular_data,
			"summary_data" => $model->getSummaryData(array('start_date'=>$start_date, 'end_date'=>$end_date)),
			"export_excel" => $export_excel
		);
		
		$this->load->view("reports/tabular",$data);
	}
	
	//Summary employees report
	function summary_employees($start_date, $end_date, $export_excel=0)
	{
		$this->load->model('reports/Summary_employees');
		$model = $this->Summary_employees;
		$tabular_data = array();
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $tabular_data[] = array($row['employee'], to_currency($row['subtotal']), to_currency($row['total']), to_currency($row['tax']),to_currency($row['profit']));
		  }
		}
		$data = array(
			"title" => $this->lang->line('reports_employees_summary_report'),
			"subtitle" => date('m/d/Y', strtotime($start_date)) .'-'.date('m/d/Y', strtotime($end_date)),
			"headers" => $model->getDataColumns(),
			"data" => $tabular_data,
			"summary_data" => $model->getSummaryData(array('start_date'=>$start_date, 'end_date'=>$end_date)),
			"export_excel" => $export_excel
		);

		$this->load->view("reports/tabular",$data);
	}
	
	//Summary taxes report
	function summary_taxes($start_date, $end_date, $export_excel=0)
	{
		$this->load->model('reports/Summary_taxes');
		$model = $this->Summary_taxes;
		$tabular_data = array();
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $tabular_data[] = array($row['percent'], to_currency($row['subtotal']), to_currency($row['total']), to_currency($row['tax']));
		  }
		}
		$data = array(
			"title" => $this->lang->line('reports_taxes_summary_report'),
			"subtitle" => date('m/d/Y', strtotime($start_date)) .'-'.date('m/d/Y', strtotime($end_date)),
			"headers" => $model->getDataColumns(),
			"data" => $tabular_data,
			"summary_data" => $model->getSummaryData(array('start_date'=>$start_date, 'end_date'=>$end_date)),
			"export_excel" => $export_excel
		);

		$this->load->view("reports/tabular",$data);
	}
	
	//Summary discounts report
	function summary_discounts($start_date, $end_date, $export_excel=0)
	{
		$this->load->model('reports/Summary_discounts');
		$model = $this->Summary_discounts;
		$tabular_data = array();
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $tabular_data[] = array($row['discount_percent'],$row['count']);
		  }
		}
		$data = array(
			"title" => $this->lang->line('reports_discounts_summary_report'),
			"subtitle" => date('m/d/Y', strtotime($start_date)) .'-'.date('m/d/Y', strtotime($end_date)),
			"headers" => $model->getDataColumns(),
			"data" => $tabular_data,
			"summary_data" => $model->getSummaryData(array('start_date'=>$start_date, 'end_date'=>$end_date)),
			"export_excel" => $export_excel
		);

		$this->load->view("reports/tabular",$data);
	}
	
	function summary_payments($start_date, $end_date, $export_excel=0)
	{
		$this->load->model('reports/Summary_payments');
		$model = $this->Summary_payments;
		$tabular_data = array();
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $tabular_data[] = array($row['payment_type'],to_currency($row['payment_amount']));
		  }
		}
		$data = array(
			"title" => $this->lang->line('reports_payments_summary_report'),
			"subtitle" => date('m/d/Y', strtotime($start_date)) .'-'.date('m/d/Y', strtotime($end_date)),
			"headers" => $model->getDataColumns(),
			"data" => $tabular_data,
			"summary_data" => $model->getSummaryData(array('start_date'=>$start_date, 'end_date'=>$end_date)),
			"export_excel" => $export_excel
		);

		$this->load->view("reports/tabular",$data);
	}
	
	//Input for reports that require only a date range. (see routes.php to see that all graphical summary reports route here)
	function date_input()
	{
		$data = $this->_get_common_report_data();
		$this->load->view("reports/date_input",$data);	
	}
	
	//Graphical summary sales report
	function graphical_summary_sales($start_date, $end_date)
	{
		$this->load->model('reports/Summary_sales');
		$model = $this->Summary_sales;
		
		
		
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		
		$graph_data = array();
		if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $graph_data[date('m/d/Y', strtotime($row['sale_date']))]= $row['total'];
		  }
		}
		//print_r($graph_data);
		
		

		$data = array(
			"title" => $this->lang->line('reports_sales_summary_report'),
			"data_file" => site_url("reports/graphical_summary_sales_graph/$start_date/$end_date"),
			"subtitle" => date('m/d/Y', strtotime($start_date)) .'-'.date('m/d/Y', strtotime($end_date)),
			"summary_data" => $model->getSummaryData(array('start_date'=>$start_date, 'end_date'=>$end_date)),
			"graph_data" => $graph_data,
			"chartType" => 'line'
		);
		
		$this->load->view("reports/graphical",$data);


	}
	
	//The actual graph data
	function graphical_summary_sales_graph($start_date, $end_date)
	{
		$this->load->model('reports/Summary_sales');
		$model = $this->Summary_sales;
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		
		$graph_data = array();
		if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $graph_data[date('m/d/Y', strtotime($row['sale_date']))]= $row['total'];
		  }
		}
		print_r($graph_data);

		$data = array(
			"title" => $this->lang->line('reports_sales_summary_report'),
			"yaxis_label"=>$this->lang->line('reports_revenue'),
			"xaxis_label"=>$this->lang->line('reports_date'),
			"data" => $graph_data
		);
		
	//	$this->load->view("reports/graphical",$data);

		$this->load->view("reports/graphs/line",$data);

	}
	
	//Graphical summary items report
	function graphical_summary_items($start_date, $end_date)
	{
		$this->load->model('reports/Summary_items');
		$model = $this->Summary_items;
		
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		
		$graph_data = array();
		if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $graph_data[$row['name']] = $row['total'];
		  }
		}
		$data = array(
			"title" => $this->lang->line('reports_items_summary_report'),
			"data_file" => site_url("reports/graphical_summary_items_graph/$start_date/$end_date"),
			"subtitle" => date('m/d/Y', strtotime($start_date)) .'-'.date('m/d/Y', strtotime($end_date)),
			"summary_data" => $model->getSummaryData(array('start_date'=>$start_date, 'end_date'=>$end_date)),
			"graph_data" => $graph_data,
			"chartType" => 'line'
		);

		$this->load->view("reports/graphical",$data);
	}
	
	//The actual graph data
	function graphical_summary_items_graph($start_date, $end_date)
	{
		$this->load->model('reports/Summary_items');
		$model = $this->Summary_items;
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		
		$graph_data = array();
		if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $graph_data[$row['name']] = $row['total'];
		  }
		}
		$data = array(
			"title" => $this->lang->line('reports_items_summary_report'),
			"xaxis_label"=>$this->lang->line('reports_revenue'),
			"yaxis_label"=>$this->lang->line('reports_items'),
			"data" => $graph_data
		);

		$this->load->view("reports/graphs/hbar",$data);
	}
	
	//Graphical summary customers report
	function graphical_summary_categories($start_date, $end_date)
	{
		$this->load->model('reports/Summary_categories');
		$model = $this->Summary_categories;
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		$graph_data = array();
		if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $graph_data[$row['category']] = $row['total'];
		  }
		}
		$data = array(
			"title" => $this->lang->line('reports_categories_summary_report'),
			"data_file" => site_url("reports/graphical_summary_categories_graph/$start_date/$end_date"),
			"subtitle" => date('m/d/Y', strtotime($start_date)) .'-'.date('m/d/Y', strtotime($end_date)),
			"summary_data" => $model->getSummaryData(array('start_date'=>$start_date, 'end_date'=>$end_date)),
			"graph_data" =>  $graph_data,
			"chartType" => 'pie'
		);

		$this->load->view("reports/graphical",$data);
	}
	
	//The actual graph data
	function graphical_summary_categories_graph($start_date, $end_date)
	{
		$this->load->model('reports/Summary_categories');
		$model = $this->Summary_categories;
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		
		$graph_data = array();
		if(!empty($report_data))
		{
			foreach($report_data as $row)
			{
				$graph_data[$row['category']] = $row['total'];
			}
		}
		$data = array(
			"title" => $this->lang->line('reports_categories_summary_report'),
			"data" => $graph_data
		);

		$this->load->view("reports/graphs/pie",$data);
	}
	
	function graphical_summary_suppliers($start_date, $end_date)
	{
		$this->load->model('reports/Summary_suppliers');
		$model = $this->Summary_suppliers;
		
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		
		$graph_data = array();
		if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $graph_data[$row['supplier']] = $row['total'];
		  }
		}
		$data = array(
			"title" => $this->lang->line('reports_suppliers_summary_report'),
			"data_file" => site_url("reports/graphical_summary_suppliers_graph/$start_date/$end_date"),
			"subtitle" => date('m/d/Y', strtotime($start_date)) .'-'.date('m/d/Y', strtotime($end_date)),
			"summary_data" => $model->getSummaryData(array('start_date'=>$start_date, 'end_date'=>$end_date)),
			"graph_data" => $graph_data,
			"chartType" => 'pie'
		);

		$this->load->view("reports/graphical",$data);
	}
	
	//The actual graph data
	function graphical_summary_suppliers_graph($start_date, $end_date)
	{
		$this->load->model('reports/Summary_suppliers');
		$model = $this->Summary_suppliers;
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		
		$graph_data = array();
	    if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $graph_data[$row['supplier']] = $row['total'];
		  }
		}
		$data = array(
			"title" => $this->lang->line('reports_suppliers_summary_report'),
			"data" => $graph_data
		);

		$this->load->view("reports/graphs/pie",$data);
	}
	
	function graphical_summary_employees($start_date, $end_date)
	{
		$this->load->model('reports/Summary_employees');
		$model = $this->Summary_employees;
		
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		
		$graph_data = array();
		if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $graph_data[$row['employee']] = $row['total'];
		  }
		}

		$data = array(
			"title" => $this->lang->line('reports_employees_summary_report'),
			"data_file" => site_url("reports/graphical_summary_employees_graph/$start_date/$end_date"),
			"subtitle" => date('m/d/Y', strtotime($start_date)) .'-'.date('m/d/Y', strtotime($end_date)),
			"summary_data" => $model->getSummaryData(array('start_date'=>$start_date, 'end_date'=>$end_date)),
			"graph_data" => $graph_data,
			"chartType" => 'pie'
			
		);

		$this->load->view("reports/graphical",$data);
	}
	
	//The actual graph data
	function graphical_summary_employees_graph($start_date, $end_date)
	{
		$this->load->model('reports/Summary_employees');
		$model = $this->Summary_employees;
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		
		$graph_data = array();
		if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $graph_data[$row['employee']] = $row['total'];
		  }
		}
		$data = array(
			"title" => $this->lang->line('reports_employees_summary_report'),
			"data" => $graph_data
		);

		$this->load->view("reports/graphs/pie",$data);
	}
	
	function graphical_summary_taxes($start_date, $end_date)
	{
		$this->load->model('reports/Summary_taxes');
		$model = $this->Summary_taxes;
		
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		$graph_data = array();
		if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $graph_data[$row['percent']] = $row['total'];
		  }
		}

		$data = array(
			"title" => $this->lang->line('reports_taxes_summary_report'),
			"data_file" => site_url("reports/graphical_summary_taxes_graph/$start_date/$end_date"),
			"subtitle" => date('m/d/Y', strtotime($start_date)) .'-'.date('m/d/Y', strtotime($end_date)),
			"summary_data" => $model->getSummaryData(array('start_date'=>$start_date, 'end_date'=>$end_date)),
			"graph_data" => $graph_data,
			"chartType" => 'pie'
		);

		$this->load->view("reports/graphical",$data);
	}
	
	//The actual graph data
	function graphical_summary_taxes_graph($start_date, $end_date)
	{
		$this->load->model('reports/Summary_taxes');
		$model = $this->Summary_taxes;
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		
		$graph_data = array();
		if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $graph_data[$row['percent']] = $row['total'];
		  }
		}
		$data = array(
			"title" => $this->lang->line('reports_taxes_summary_report'),
			"data" => $graph_data
		);

		$this->load->view("reports/graphs/pie",$data);
	}
	
	//Graphical summary customers report
	function graphical_summary_customers($start_date, $end_date)
	{
		$this->load->model('reports/Summary_customers');
		$model = $this->Summary_customers;
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		$graph_data = array();
		if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $graph_data[$row['customer']] = $row['total'];
		  }
		}

		$data = array(
			"title" => $this->lang->line('reports_customers_summary_report'),
			"data_file" => site_url("reports/graphical_summary_customers_graph/$start_date/$end_date"),
			"subtitle" => date('m/d/Y', strtotime($start_date)) .'-'.date('m/d/Y', strtotime($end_date)),
			"summary_data" => $model->getSummaryData(array('start_date'=>$start_date, 'end_date'=>$end_date)),
			"graph_data" => $graph_data,
			"chartType" => 'line'
		);

		$this->load->view("reports/graphical",$data);
	}
	
	//The actual graph data
	function graphical_summary_customers_graph($start_date, $end_date)
	{
		$this->load->model('reports/Summary_customers');
		$model = $this->Summary_customers;
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		
		$graph_data = array();
		if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $graph_data[$row['customer']] = $row['total'];
		  }
		}
		$data = array(
			"title" => $this->lang->line('reports_customers_summary_report'),
			"xaxis_label"=>$this->lang->line('reports_revenue'),
			"yaxis_label"=>$this->lang->line('reports_customers'),
			"data" => $graph_data
		);

		$this->load->view("reports/graphs/hbar",$data);
	}
	
	//Graphical summary discounts report
	function graphical_summary_discounts($start_date, $end_date)
	{
		$this->load->model('reports/Summary_discounts');
		$model = $this->Summary_discounts;
		
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		$graph_data = array();
		if(!empty($report_data))
		{
		
		  foreach($report_data as $row)
		  {
			  $graph_data[$row['discount_percent']] = $row['count'];
		  }
		 }
		$data = array(
			"title" => $this->lang->line('reports_discounts_summary_report'),
			"data_file" => site_url("reports/graphical_summary_discounts_graph/$start_date/$end_date"),
			"subtitle" => date('m/d/Y', strtotime($start_date)) .'-'.date('m/d/Y', strtotime($end_date)),
			"summary_data" => $model->getSummaryData(array('start_date'=>$start_date, 'end_date'=>$end_date)),
			"graph_data" => $graph_data,
			"chartType" => 'column'
		);

		$this->load->view("reports/graphical",$data);
	}
	
	//The actual graph data
	function graphical_summary_discounts_graph($start_date, $end_date)
	{
		$this->load->model('reports/Summary_discounts');
		$model = $this->Summary_discounts;
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		
		$graph_data = array();
		if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $graph_data[$row['discount_percent']] = $row['count'];
		  }
		}
		$data = array(
			"title" => $this->lang->line('reports_discounts_summary_report'),
			"yaxis_label"=>$this->lang->line('reports_count'),
			"xaxis_label"=>$this->lang->line('reports_discount_percent'),
			"data" => $graph_data
		);

		$this->load->view("reports/graphs/bar",$data);
	}
	
	function graphical_summary_payments($start_date, $end_date)
	{
		$this->load->model('reports/Summary_payments');
		$model = $this->Summary_payments;
		
			
			$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		
		$graph_data = array();
		if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $graph_data[$row['payment_type']] = $row['payment_amount'];
		  }
		}

		$data = array(
			"title" => $this->lang->line('reports_payments_summary_report'),
			"data_file" => site_url("reports/graphical_summary_payments_graph/$start_date/$end_date"),
			"subtitle" => date('m/d/Y', strtotime($start_date)) .'-'.date('m/d/Y', strtotime($end_date)),
			"summary_data" => $model->getSummaryData(array('start_date'=>$start_date, 'end_date'=>$end_date)),
			"graph_data" => $graph_data,
			"chartType" => 'pie'
		);

		$this->load->view("reports/graphical",$data);
	}
	
	//The actual graph data
	function graphical_summary_payments_graph($start_date, $end_date)
	{
		$this->load->model('reports/Summary_payments');
		$model = $this->Summary_payments;
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		
		$graph_data = array();
		if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $graph_data[$row['payment_type']] = $row['payment_amount'];
		  }
		}
		$data = array(
			"title" => $this->lang->line('reports_payments_summary_report'),
			"yaxis_label"=>$this->lang->line('reports_revenue'),
			"xaxis_label"=>$this->lang->line('reports_payment_type'),
			"data" => $graph_data
		);

		$this->load->view("reports/graphs/pie",$data);
	}
	function specific_customer_input()
	{
		$data = $this->_get_common_report_data();
		$data['specific_input_name'] = $this->lang->line('reports_customer');
		
		$customers = array();
		foreach($this->Customer->get_all()->result() as $customer)
		{
			$customers[$customer->person_id] = $customer->first_name .' '.$customer->last_name;
		}
		$data['specific_input_data'] = $customers;
		$this->load->view("reports/specific_input",$data);	
	}

	function specific_customer($start_date, $end_date, $customer_id, $export_excel=0)
	{
		$this->load->model('reports/Specific_customer');
		$model = $this->Specific_customer;
		
		$headers = $model->getDataColumns();
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date, 'customer_id' =>$customer_id));
		
		$summary_data = array();
		$details_data = array();
		if(!empty($report_data['summary']))
		{
		  foreach($report_data['summary'] as $key=>$row)
		  {
			  $summary_data[] = array(anchor('sales/edit/'.$row['sale_id'], 'POS '.$row['sale_id'], array('target' => '_blank')), $row['sale_date'], $row['items_purchased'], $row['employee_name'], to_currency($row['subtotal']), to_currency($row['total']), to_currency($row['tax']),to_currency($row['profit']), $row['payment_type'], $row['comment']);
			  
			  foreach($report_data['details'][$key] as $drow)
			  {
				  $details_data[$key][] = array($drow['name'], $drow['category'], $drow['serialnumber'], $drow['description'], $drow['quantity_purchased'], to_currency($drow['subtotal']), to_currency($drow['total']), to_currency($drow['tax']),to_currency($drow['profit']), $drow['discount_percent'].'%');
			  }
		  }
		}
		$customer_info = $this->Customer->get_info($customer_id);
		$data = array(
			"title" => $customer_info->first_name .' '. $customer_info->last_name.' '.$this->lang->line('reports_report'),
			"subtitle" => date('m/d/Y', strtotime($start_date)) .'-'.date('m/d/Y', strtotime($end_date)),
			"headers" => $model->getDataColumns(),
			"summary_data" => $summary_data,
			"details_data" => $details_data,
			"overall_summary_data" => $model->getSummaryData(array('start_date'=>$start_date, 'end_date'=>$end_date,'customer_id' =>$customer_id)),
			"export_excel" => $export_excel
		);

		$this->load->view("reports/tabular_details",$data);
	}
	
	function specific_employee_input()
	{
		$data = $this->_get_common_report_data();
		$data['specific_input_name'] = $this->lang->line('reports_employee');
		
		$employees = array();
		if(!empty($report_data))
		{
		  foreach($this->Employee->get_all()->result() as $employee)
		  {
			  $employees[$employee->person_id] = $employee->first_name .' '.$employee->last_name;
		  }
		}
		$data['specific_input_data'] = $employees;
		$this->load->view("reports/specific_input",$data);	
	}

	function specific_employee($start_date, $end_date, $employee_id, $export_excel=0)
	{
		$this->load->model('reports/Specific_employee');
		$model = $this->Specific_employee;
		
		$headers = $model->getDataColumns();
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date, 'employee_id' =>$employee_id));
		
		$summary_data = array();
		$details_data = array();
		if(!empty($report_data['summary']))
		{
		  foreach($report_data['summary'] as $key=>$row)
		  {
			  $summary_data[] = array(anchor('sales/edit/'.$row['sale_id'], 'POS '.$row['sale_id'], array('target' => '_blank')), $row['sale_date'], $row['items_purchased'], $row['customer_name'], to_currency($row['subtotal']), to_currency($row['total']), to_currency($row['tax']),to_currency($row['profit']), $row['payment_type'], $row['comment']);
			  
			  foreach($report_data['details'][$key] as $drow)
			  {
				  $details_data[$key][] = array($drow['name'], $drow['category'], $drow['serialnumber'], $drow['description'], $drow['quantity_purchased'], to_currency($drow['subtotal']), to_currency($drow['total']), to_currency($drow['tax']),to_currency($drow['profit']), $drow['discount_percent'].'%');
			  }
		  }
		}
		$employee_info = $this->Employee->get_info($employee_id);
		$data = array(
			"title" => $employee_info->first_name .' '. $employee_info->last_name.' '.$this->lang->line('reports_report'),
			"subtitle" => date('m/d/Y', strtotime($start_date)) .'-'.date('m/d/Y', strtotime($end_date)),
			"headers" => $model->getDataColumns(),
			"summary_data" => $summary_data,
			"details_data" => $details_data,
			"overall_summary_data" => $model->getSummaryData(array('start_date'=>$start_date, 'end_date'=>$end_date,'employee_id' =>$employee_id)),
			"export_excel" => $export_excel
		);

		$this->load->view("reports/tabular_details",$data);
	}
	
	function detailed_sales($start_date, $end_date, $export_excel=0)
	{
		$this->load->model('reports/Detailed_sales');
		$model = $this->Detailed_sales;
		
		$headers = $model->getDataColumns();
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		
		$summary_data = array();
		$details_data = array();
		if(!empty($report_data['summary']))
		{
		  foreach($report_data['summary'] as $key=>$row)
		  {
			  $summary_data[] = array(anchor('sales/edit/'.$row['sale_id'], 'POS '.$row['sale_id'], array('target' => '_blank')), $row['sale_date'], $row['items_purchased'], $row['employee_name'], $row['customer_name'], to_currency($row['subtotal']), to_currency($row['total']), to_currency($row['tax']),to_currency($row['profit']), $row['payment_type'], $row['comment']);
			  
			  foreach($report_data['details'][$key] as $drow)
			  {
				  $details_data[$key][] = array($drow['name'], $drow['category'], $drow['serialnumber'], $drow['description'], $drow['quantity_purchased'], to_currency($drow['subtotal']), to_currency($drow['total']), to_currency($drow['tax']),to_currency($drow['profit']), $drow['discount_percent'].'%');
			  }
		   }
	     }

		$data = array(
			"title" =>$this->lang->line('reports_detailed_sales_report'),
			"subtitle" => date('m/d/Y', strtotime($start_date)) .'-'.date('m/d/Y', strtotime($end_date)),
			"headers" => $model->getDataColumns(),
			"summary_data" => $summary_data,
			"details_data" => $details_data,
			"overall_summary_data" => $model->getSummaryData(array('start_date'=>$start_date, 'end_date'=>$end_date)),
			"export_excel" => $export_excel
		);

		$this->load->view("reports/tabular_details",$data);
	}
	
	function detailed_receivings($start_date, $end_date, $export_excel=0)
	{
		$this->load->model('reports/Detailed_receivings');
		$model = $this->Detailed_receivings;
		
		$headers = $model->getDataColumns();
		$report_data = $model->getData(array('start_date'=>$start_date, 'end_date'=>$end_date));
		
		$summary_data = array();
		$details_data = array();
		if(!empty($report_data['summary']))
		{
		  foreach($report_data['summary'] as $key=>$row)
		  {
			  $summary_data[] = array(anchor('receivings/receipt/'.$row['receiving_id'], 'RECV '.$row['receiving_id'], array('target' => '_blank')), $row['receiving_date'], $row['items_purchased'], $row['employee_name'], $row['supplier_name'], to_currency($row['total']), $row['payment_type'], $row['comment']);
			  
			  foreach($report_data['details'][$key] as $drow)
			  {
				  $details_data[$key][] = array($drow['name'], $drow['category'], $drow['quantity_purchased'], to_currency($drow['total']), $drow['discount_percent'].'%');
			  }
		  }
		}

		$data = array(
			"title" =>$this->lang->line('reports_detailed_receivings_report'),
			"subtitle" => date('m/d/Y', strtotime($start_date)) .'-'.date('m/d/Y', strtotime($end_date)),
			"headers" => $model->getDataColumns(),
			"summary_data" => $summary_data,
			"details_data" => $details_data,
			"overall_summary_data" => $model->getSummaryData(array('start_date'=>$start_date, 'end_date'=>$end_date)),
			"export_excel" => $export_excel
		);

		$this->load->view("reports/tabular_details",$data);
	}
			
	function excel_export()
	{
		$this->load->view("reports/excel_export",array());		
	}
	
	function inventory_low($export_excel=0)
	{
		$this->load->model('reports/Inventory_low');
		$model = $this->Inventory_low;
		$tabular_data = array();
		$report_data = $model->getData(array());
		if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $tabular_data[] = array($row['name'], $row['item_number'], $row['description'], $row['quantity'], $row['reorder_level']);
		  }
		}
		$data = array(
			"title" => $this->lang->line('reports_low_inventory_report'),
			"subtitle" => '',
			"headers" => $model->getDataColumns(),
			"data" => $tabular_data,
			"summary_data" => $model->getSummaryData(array()),
			"export_excel" => $export_excel
		);

		$this->load->view("reports/tabular",$data);	
	}
	
	function inventory_summary($export_excel=0)
	{
		$this->load->model('reports/Inventory_summary');
		$model = $this->Inventory_summary;
		$tabular_data = array();
		$report_data = $model->getData(array());
		if(!empty($report_data))
		{
		  foreach($report_data as $row)
		  {
			  $tabular_data[] = array($row['name'], $row['item_number'], $row['description'], $row['quantity'], $row['reorder_level']);
		  }
		}
		$data = array(
			"title" => $this->lang->line('reports_inventory_summary_report'),
			"subtitle" => '',
			"headers" => $model->getDataColumns(),
			"data" => $tabular_data,
			"summary_data" => $model->getSummaryData(array()),
			"export_excel" => $export_excel
		);

		$this->load->view("reports/tabular",$data);	
	}
	
	function cogs_report_input()
	{
		$data = $this->_get_common_report_data();
		//$data['specific_input_name'] = $this->lang->line('reports_employee');
		
		/*$employees = array();
		foreach($this->Employee->get_all()->result() as $employee)
		{
			$employees[$employee->person_id] = $employee->first_name .' '.$employee->last_name;
		}*/
		//$data['specific_input_data'] = $employees;
		$this->load->view("reports/cogs_report",$data);	
	}
	
	function cogs_report($start_date, $end_date, $export_excel=0)
	{
		
		//Cost of existing inventory at the beginning of the report period
		$sql_xcost = mysql_query("SELECT SUM(cost_price) as xcost FROM phppos_inventory as ppiv,phppos_items as ppit WHERE ppit.item_id = ppiv.trans_items AND DATE(trans_date) = '$start_date'");
		$result_xcost = mysql_fetch_assoc($sql_xcost);
		$xcost = $result_xcost['xcost'];
		
		//Cost of inventory purchased during the report period
		$sql_ycost = mysql_query("SELECT SUM(item_cost_price) as ycost FROM phppos_inventory as ppiv,phppos_receivings_items as pprit WHERE pprit.item_id = ppiv.trans_items AND (DATE(trans_date) >= '$start_date' AND DATE(trans_date) <= '$end_date')");
		$result_ycost = mysql_fetch_assoc($sql_ycost);
		$ycost = $result_ycost['ycost'];
		
		//Cost of inventory on hand at the end of the report period
		$sql_zcost = mysql_query("SELECT SUM(cost_price) as zcost FROM phppos_inventory as ppiv,phppos_items as ppit WHERE ppit.item_id = ppiv.trans_items AND DATE(trans_date) = '$end_date' AND quantity>0");
		$result_zcost = mysql_fetch_assoc($sql_zcost);
		$zcost = $result_zcost['zcost'];
		
		$data = array(
			"title" => 'COGS Report',
			"subtitle" => date('m/d/Y', strtotime($start_date)) .'-'.date('m/d/Y', strtotime($end_date)),
			"xcost" => $xcost,
			"ycost" => $ycost,
			"zcost" => $zcost,
			"export_excel" => $export_excel
		);
		
		$this->load->view("reports/cogs_report_detail.php",$data);	
	}
	
}
?>