<?php
if(!empty($get_sales_projects))
{
?>
<script type="text/javascript">
  $(function () {
	//alert("Test");
	//$("#example1").dataTable();
	var table = $('#projects_list_table').DataTable({
	  "bPaginate": <?=$pagination?>,
	  "bLengthChange": true,
	  "pageLength": <?=$limit?>,
	  'displayStart': <?=$displayStart?>,
	  "bFilter": true,
	  "bSort": true,
	  "bInfo": true,
	  "bAutoWidth": false,
	  "order": [[0, "asc"]],
	  "aoColumnDefs" : [ {'bSortable' : false,'aTargets' : [ 3,4 ]} ]
	});
	
	$('.footable').footable({
	  calculateWidthOverride: function() {
		return { width: $(window).width() };
	  }
	});
	
	$( "#projects_list_table" ).wrap( "<div class='table-responsive'></div>" );
	
  });
</script>
<?php
}
?>

<div class="box-header">
  <h3 class="box-title">List of Projects</h3>
</div>
<!-- /.box-header -->
<div class="box-body">
	<input type="hidden" name="curpage" id="curpage" value="<?=$curpage?>">
    <table id="projects_list_table" class="table table-bordered table-striped table-hover footable responsive">
        <thead>
            <tr>
               <th class="valign-center text-left" style="width:15%;">Name</th>
               <th class="valign-center text-left" style="width:55%;" >Description</th>
               <th class="valign-center text-center" style="width:10%;">Rate</th>
               <th class="valign-center text-center" style="width:10%;">Status</th>
               <th class="valign-center text-center" style="width:10%">Action</th>
            </tr>
        </thead>     
        <tbody>
		  <?php
          if(!empty($get_sales_projects))
          { 
              foreach($get_sales_projects as $key=>$eachProject)
			  {
				$project_id = $eachProject['id'];
				$project_name = drop_multiple_slashes($eachProject['name']);
			    $project_name = str_replace("|","&#124;",$project_name); 
				$project_description = drop_multiple_slashes($eachProject['description']);
			    $project_description = str_replace("|","&#124;",$project_description); 
				$project_rate = drop_multiple_slashes($eachProject['rate']);
			    $project_rate = str_replace("|","&#124;",$project_rate); 
			    $project_status = $eachProject['status'];
		        ?>
                <tr style="height:35px;" data-project_id="<?=$project_id?>">
                  <td class="valign-center text-left"><?php echo $project_name?></td>
                  <td class="valign-center text-left"><?php echo $project_description?></td>
                  <td class="valign-center text-center"><?php echo numberWithCurrency($project_rate)?></td>
                  <td class="valign-center text-center">
				  	<select id="change_status<?=$eachProject['id']?>"  class="form-control change_status input-sm" data-rowid="<?=$eachProject['id']?>">
				    	<option value="1" <?php if (($project_status == 1)){echo 'selected="selected"'; }?>><?php echo "Active";?></option>
						<option value="0" <?php if (($project_status == 0)){echo 'selected="selected"'; }?>><?php echo "Inactive";?></option>
					</select>
				  </td>
                  <td class="valign-center text-center">
                    <button type="button" class="btn btn-icon addedit_project" data-toggle="tooltip" title="Edit Project" data-project_id="<?=$project_id?>"><span class="glyphicon glyphicon-edit"></span></button>
                    <button type="button" style="cursor:pointer;" class="btn btn-icon delete_project" data-toggle="tooltip" title="Delete Project" data-project_id="<?=$project_id?>"><span class="glyphicon glyphicon-remove"></span></button>
                  </td>
                </tr>
                <?php
              } 
          }
          else
          {
              echo '<tr><td colspan="5" class="text-center valign-center"><br /><br />No records found.<br /><br /></td></tr>';
          }
          ?>
        </tbody>
        <tfoot>
            <tr>
               <td class="valign-center text-left font-bold">Name</td>
               <td class="valign-center text-left font-bold">Description</td>
               <td class="valign-center text-center font-bold">Rate</td>
               <td class="valign-center text-center font-bold">Status</td>
               <td class="valign-center text-center font-bold">Action</td>
            </tr>
        </tfoot>
	</table>
</div>