<?php
class  CPCustomers extends Main{
	
private $conn;
	
public function  __construct($CUSTOMERDB="")
	 {
		 $this->conn = $this->connect(DBHOST, DBUSER, DBPASSWORD);
		 if(!empty($CUSTOMERDB))
		 {
			$this->usedatabase($CUSTOMERDB);
		 }
		 else
		 {
			$this->usedatabase(CUSTOMERDB);
		 }
	 }

/*Function To Get Customers*/
public function getCustomers($condition="",$orderby="",$limits="")
	{
		$tbl_customers =TBLPREFIX_OPOS."customers";
	    $tbl_people = TBLPREFIX_OPOS."people";
		$fields = "$tbl_customers.person_id,
				   $tbl_customers.accounting_customer_id,
				   $tbl_customers.plateform,
				   $tbl_customers.account_number,
				   $tbl_customers.taxable,
				   $tbl_customers.deleted,
				   $tbl_people.person_id,
				   $tbl_people.person_id,
				   $tbl_people.first_name,
				   $tbl_people.last_name,
				   $tbl_people.phone_number,
				   $tbl_people.email,
				   $tbl_people.address_1,
				   $tbl_people.address_2,
				   $tbl_people.city,
				   $tbl_people.state,
				   $tbl_people.zip,
				   $tbl_people.country,
				   $tbl_people.comments,
				   $tbl_people.curjid,
				   $tbl_people.login,
				   $tbl_people.m_name
				   ";
		$join_customers = " LEFT JOIN $tbl_people ON $tbl_customers.person_id = $tbl_people.person_id ";
		$customers = $this->getRows($fields,$tbl_customers, " ".$join_customers." ".$condition." ".$orderby." ".$limits);
		return $customers;
	}
				   
/*Function To Get Customer*/	
public function getCustomer($condition="")
	{
		$tbl_customers =TBLPREFIX_OPOS."customers";
	    $tbl_people = TBLPREFIX_OPOS."people";
		$fields = "$tbl_customers.person_id,
				   $tbl_customers.plateform,
				   $tbl_customers.account_number,
				   $tbl_customers.taxable,
				   $tbl_customers.deleted,
				   $tbl_people.person_id,
				   $tbl_people.first_name,
				   $tbl_people.last_name,
				   $tbl_people.phone_number,
				   $tbl_people.email,
				   $tbl_people.address_1,
				   $tbl_people.address_2,
				   $tbl_people.city,
				   $tbl_people.state,
				   $tbl_people.zip,
				   $tbl_people.country,
				   $tbl_people.comments,
				   $tbl_people.curjid,
				   $tbl_people.login,
				   $tbl_people.m_name
				   ";
		$join_customers = " LEFT JOIN $tbl_customers ON $tbl_customers.person_id = $tbl_people.person_id ";
		$customer = $this->getRow($fields,$tbl_people, " ".$join_customers." ".$condition);
		return $customer;
	}

/*Function To Add Customer*/	
public function addCustomerData($person_id,$customersdata)
	{
		$data = array();
		$table = TBLPREFIX_OPOS."customers";
     	$data['person_id']  = $person_id;
		$data['plateform']  = $customersdata['plateform'];
		$data['account_number'] = $customersdata['account_number'];
	    $data['taxable'] = $customersdata['taxable'];
	    return $this->addData($data,$table);
	}
	
/*Function To Update Customer*/	
public function updateCustomerData($customersdata)
	{
		$table = TBLPREFIX_OPOS."customers";
        $person_id =  $customersdata['person_id'];
		$data['plateform']  = $customersdata['plateform'];
		$data['account_number'] = $customersdata['account_number'];
	    $data['taxable'] = $customersdata['taxable'];
	    return $this->updateData($person_id,$data,$table,"person_id");
	}
	
/*Function To Add Customer in Accounting*/	
public function addAccountingCustomer($accounting_data)
	{
		global $currency_code ;
		$customer_id =  $accounting_data['person_id'];
		/*Save Customers Data in Accounting Debtor*/
		$data_debtors_master = array();
		$table_debtors_master = TBLPREFIX_ACCOUNTING."debtors_master";
		$data_debtors_master['application'] = 2;
		$data_debtors_master['pos_customer_id'] = $customer_id;
		$data_debtors_master['name'] = $accounting_data['first_name']." ".$accounting_data['last_name'];
	    //$data_debtors_master['debtor_ref'] = $accounting_data['first_name']."_".$crm_person_id;
		$data_debtors_master['debtor_ref'] = $accounting_data['first_name']." ".$accounting_data['last_name'];
		//$data_debtors_master['address'] = $accounting_data['address_1'];
		$data_debtors_master['address'] = ($accounting_data['address_1']."\n".$accounting_data['address_2']);
		//$data_debtors_master['curr_code']  = "USD";
		$data_debtors_master['curr_code'] = $currency_code;
		$data_debtors_master['sales_type'] = 1;
		//$data_debtors_master['dimension_id']  = 1;
		$data_debtors_master['dimension_id'] = 0;
		$data_debtors_master['credit_status'] = 1;
		$data_debtors_master['payment_terms'] = 4;
		$data_debtors_master['notes'] = $accounting_data['comments'];
		$data_debtors_master['inactive'] = 0;
		$debtor_no = $this->addData($data_debtors_master,$table_debtors_master);
		
		/*Update Accounting Customer Id in POS Customer Table*/
		$this->updateRow(TBLPREFIX_OPOS."customers"," accounting_customer_id='$debtor_no' "," WHERE person_id='$customer_id' ");
		
		/*Save Customers Data in Accounting Customer Branch*/
		$data_cust_branch = array();
		$table_cust_branch = TBLPREFIX_ACCOUNTING."cust_branch";
		$data_cust_branch['application'] = 2;
		$data_cust_branch['pos_customer_id'] = $customer_id;
		$data_cust_branch['debtor_no'] = $debtor_no;
		$data_cust_branch['br_name'] = $accounting_data['first_name']." ".$accounting_data['last_name'];
	    $data_cust_branch['branch_ref'] = $accounting_data['first_name']." ".$accounting_data['last_name'];
		$data_cust_branch['br_address'] = ($accounting_data['address_1']."\n".$accounting_data['address_2']);
		$data_cust_branch['area'] = 1;
		$data_cust_branch['salesman'] = 1;
		$data_cust_branch['contact_name'] = "Main Branch";
		$data_cust_branch['default_location'] = "DEF";
		$data_cust_branch['tax_group_id'] = 1;
		$data_cust_branch['sales_discount_account'] = 4510;
		$data_cust_branch['receivables_account'] = 1200;
		$data_cust_branch['payment_discount_account'] = 4500;
		$data_cust_branch['default_ship_via'] = 1;
		$data_cust_branch['br_post_address'] = ($accounting_data['address_1']."\n".$accounting_data['address_2']);
		$data_cust_branch['notes'] = $accounting_data['comments'];
		$data_cust_branch['inactive'] = 0;
		$branch_code = $this->addData($data_cust_branch,$table_cust_branch);
		//$this->updateRow($table_cust_branch," debtor_no='$branch_code' "," WHERE branch_code='$branch_code' ");
		
		/*Save Customers Data in Accounting Persons*/
		$data_crm_persons = array();
		$table_crm_persons = TBLPREFIX_ACCOUNTING."crm_persons";
		$data_crm_persons['application'] = 2;
		$data_crm_persons['pos_customer_id'] = $customer_id;
		$data_crm_persons['ref'] = $accounting_data['first_name']." ".$accounting_data['last_name'];
	    $data_crm_persons['name'] = $accounting_data['first_name'];
		$data_crm_persons['name2'] = $accounting_data['last_name'];
		$data_crm_persons['address'] = ($accounting_data['address_1']."\n".$accounting_data['address_2']);
		$data_crm_persons['phone'] = $accounting_data['phone_number'];
		$data_crm_persons['phone2'] = $accounting_data['phone_number'];
		$data_crm_persons['email'] = $accounting_data['email'];
		$data_crm_persons['notes'] = $accounting_data['comments'];
		$data_crm_persons['inactive'] = 0;
		$person_id = $this->addData($data_crm_persons,$table_crm_persons);
		
		/*Save Customers Data in Accounting Contact*/
		$table_crm_contacts = TBLPREFIX_ACCOUNTING."crm_contacts";
		/*Save Customer Data*/
		$data_crm_contacts = array();
		$data_crm_contacts['person_id'] = $person_id;
		$data_crm_contacts['type'] = "customer";
		$data_crm_contacts['action'] = "general";
		$data_crm_contacts['entity_id'] = $debtor_no;
		$this->addData($data_crm_contacts,$table_crm_contacts);
		
		/*Save Branch Data*/
		$data_crm_contacts = array();
		$data_crm_contacts['person_id'] = $person_id;
		$data_crm_contacts['type'] = "cust_branch";
		$data_crm_contacts['action'] = "general";
		$data_crm_contacts['entity_id'] = $branch_code;
		$this->addData($data_crm_contacts,$table_crm_contacts);
		
	}
	
/*Function To Update Customer in Accounting*/	
public function updateAccountingCustomer($accounting_data)
	{
        global $currency_code ;
		$customer_id =  $accounting_data['person_id'];
		
		/*Save Customers Data in Accounting Persons*/
		$data_crm_persons = array();
		$table_crm_persons = TBLPREFIX_ACCOUNTING."crm_persons";
		$data_crm_persons['ref'] = $accounting_data['first_name']." ".$accounting_data['last_name'];
	    $data_crm_persons['name'] = $accounting_data['first_name'];
		$data_crm_persons['name2'] = $accounting_data['last_name'];
		$data_crm_persons['address'] = ($accounting_data['address_1']."\n".$accounting_data['address_2']);
		$data_crm_persons['phone'] = $accounting_data['phone_number'];
		$data_crm_persons['phone2'] = $accounting_data['phone_number'];
		$data_crm_persons['email'] = $accounting_data['email'];
		$data_crm_persons['notes'] = $accounting_data['comments'];
		$this->updateData($customer_id,$data_crm_persons,$table_crm_persons,"pos_customer_id");
		
		/*Save Customers Data in Accounting Debtor*/
		$data_debtors_master = array();
		$table_debtors_master = TBLPREFIX_ACCOUNTING."debtors_master";
		$data_debtors_master['name'] = $accounting_data['first_name']." ".$accounting_data['last_name'];
	    $data_debtors_master['debtor_ref'] = $accounting_data['first_name']." ".$accounting_data['last_name'];
		$data_debtors_master['address'] = ($accounting_data['address_1']."\n".$accounting_data['address_2']);
		$data_debtors_master['notes'] = $accounting_data['comments'];
		$this->updateData($customer_id,$data_debtors_master,$table_debtors_master,"pos_customer_id");
		
		/*Save Customers Data in Accounting Customer Branch*/
		/*$data_cust_branch = array();
		$table_cust_branch = TBLPREFIX_ACCOUNTING."cust_branch";
		$data_cust_branch['br_name'] = $accounting_data['first_name']." ".$accounting_data['last_name'];
	    $data_cust_branch['branch_ref'] = $accounting_data['first_name']." ".$accounting_data['last_name'];
		$data_cust_branch['br_address'] = ($accounting_data['address_1']."\n".$accounting_data['address_2']);
		$this->updateData($customer_id,$data_cust_branch,$table_cust_branch,"pos_customer_id");*/
	}
	
/*Function To Update Customer in C5*/	
public function updateC5Customer($c5_data)
	{
		global $countriesArray;
		global $statesBNArray;
		$person_id =  $c5_data['person_id'];
		$checkCustomer = $this->getRow("*",TBLPREFIX_OPOS."customers"," WHERE person_id='$person_id' ");
		if(!empty($checkCustomer['c5_uID']))
		{		
			/*Save Customers Data in C5*/
			$data_c5_customers = array();
			$table_c5_customers = "UserSearchIndexAttributes";
			$data_c5_customers['ak_billing_first_name'] = $c5_data['first_name'];
			$data_c5_customers['ak_billing_last_name'] = $c5_data['last_name'];
			$data_c5_customers['ak_billing_address_address1'] = $c5_data['address_1'];
			$data_c5_customers['ak_billing_address_address2'] = $c5_data['address_2'];
			$data_c5_customers['ak_billing_address_city'] = $c5_data['city'];
			$data_c5_customers['ak_billing_address_state_province'] = $statesBNArray[$c5_data['state']]['state_code'];
			$data_c5_customers['ak_billing_address_country'] = $countriesArray[$c5_data['country']]['country_code'];
			$data_c5_customers['ak_billing_address_postal_code'] = $c5_data['zip'];
			$data_c5_customers['ak_billing_phone'] = $c5_data['phone_number'];
			$this->updateData($checkCustomer['c5_uID'],$data_c5_customers,$table_c5_customers,"uID");
		}
	}
	
/*Function To Delete Customer from C5*/
public function deleteC5Customer($person_id)
{
	$checkCustomer = $this->getRow("*",TBLPREFIX_OPOS."customers"," WHERE person_id='$person_id' ");
	if(!empty($checkCustomer) && !empty($checkCustomer['c5_uID']))
	{
		$this->removeRow("UserSearchIndexAttributes", " WHERE uID='".$checkCustomer['c5_uID']."' ");
		$this->removeRow("Users", " WHERE uID='".$checkCustomer['c5_uID']."' ");
	}
}
	
public function close()
	{
		$this->close_db($this->conn);
	}
	
}
?>