<?php
// Include the autoloader provided in the SDK
require_once __DIR__ . '/vendor/autoload.php'; // change path as needed

// Include required libraries
use MetzWeb\Instagram\Instagram;

/*
 * Configuration and setup Instagram SDK
 */
$is_socialboard_instagram_error = 0;
$client_id = $socialboard_instagram_client_id; //Instagram Client ID
$client_secret = $socialboard_instagram_client_secret; //Instagram Client Secret
$socialboard_instagram_url = "https://instagram.com";
$socialboard_instagram_callback_module = getSession("app_module_name");
$socialboard_instagram_callback_url = ZBPATH."socialboard/$socialboard_instagram_callback_module/instagram/callback"; //Instagram Callback URL
$socialboard_instagram_scopes = array('basic','relationships','likes','comments');  //Optional scopes
//$socialboard_instagram_scopes = array('basic','public_content','relationships','likes','comments');  //Optional scopes
$socialboard_instagram_credentials = array('apiKey'=>$client_id,'apiSecret'=>$client_secret,'apiCallback'=>$socialboard_instagram_callback_url);  //Optional scopes

/*Check Instagram Object*/
$socialboard_instagram_object = new Instagram($socialboard_instagram_credentials);//printArray($socialboard_instagram_object);
$socialboard_instagram_object_exists = false;
if ( isset( $socialboard_instagram_object ) and ! is_null( $socialboard_instagram_object ) ){$socialboard_instagram_object_exists = true;}

if($socialboard_instagram_object_exists)
{ 
	/*Create Instagram Object*/
	$instagram = $socialboard_instagram_object;//printArray($instagram);
	
	// Try to get access token
	try {
		if(!empty($socialboard_instagram_access_token_saved_value)){
			$socialboard_instagram_access_token = $socialboard_instagram_access_token_saved_value;//printArray($socialboard_instagram_access_token);
		}else{
			if(!empty($socialboard_instagram_callback_code))
			{
				/*Get Instagram access token*/
				try {
					$socialboard_instagram_results = $instagram->getOAuthToken($socialboard_instagram_callback_code);
					$socialboard_instagram_results = convertStdObjtoArray($socialboard_instagram_results);//printArray($socialboard_instagram_results);
					if(array_key_exists('code', $socialboard_instagram_results) )
					{
						$code = $socialboard_instagram_results['code'];
						$error_reason = $socialboard_instagram_results['error_reason'];
						$error_description = $socialboard_instagram_results['error_message'];
						$is_socialboard_instagram_error = 1;
					    $socialboard_instagram_error = 'Instagram returned an error: ' . $error_description;
					}
					else
					{
						$socialboard_instagram_access_token = $socialboard_instagram_results['access_token'];
						$socialboard_instagram_user_id = $socialboard_instagram_results['user']['id'];
					}
				} catch(Exception  $e) {
					$is_socialboard_instagram_error = 1;
					$socialboard_instagram_error = 'Instagram returned an error: ' . $e->getMessage();
				}
			}
		}
		
		if(empty($socialboard_instagram_access_token))
		{
			try {
				$socialboard_instagram_login_url = $instagram->getLoginUrl($socialboard_instagram_scopes);
			} catch(Exception  $e) {
				$is_socialboard_instagram_error = 1;
				$socialboard_instagram_error = 'Instagram returned an error: ' . $e->getMessage();
			}
		}
		else
		{
			$instagram->setAccessToken($socialboard_instagram_access_token);
			$socialboard_instagram_access_token = $instagram->getAccessToken();
			/*$instagram_user_profile = $instagram->getUser();
			$instagram_user_profile = convertStdObjtoArray($instagram_user_profile);
			printArray($instagram_user_profile);*/
		}
	} catch(Exception  $e) {
		$is_socialboard_instagram_error = 1;
		$socialboard_instagram_error = 'Instagram returned an error: ' . $e->getMessage();
	} 
}
else
{
	$is_socialboard_instagram_error = 1;
	//$socialboard_instagram_error = 'Instagram returned an error: Error in connecting with Instagram ';
	$socialboard_instagram_error = 'Please try again if you can not connect with Instagram <br>OR<br> '.$verbiage_contact_to_support;
}
?>