<?php //session_start();
/*********************************************\
 * Class: 	PHP Paging Class
 * Author:	Waseem Ansari
 * Created:	20-05-2010
 * Version:	1.0
\*********************************************/
class Paging
{ 
   	
	/////////////////////////////////////////////////
  	// Method to get the Start point of the Data 
  	/////////////////////////////////////////////////
	function findStart($limit) 
    { 
     	if ((!isset($_REQUEST['page'])) || ($_REQUEST['page'] == "1")) 
      	{ 
       		$start = 0; 
       		$_REQUEST['page'] = 1; 
      	} 
     	else 
      	{ 
       		$start = ($_REQUEST['page']-1) * $limit; 
      	} 

     	return $start; 
    } 
    
	/////////////////////////////////////////////////
  	// Method to get the Number of Pages of the Data 
  	/////////////////////////////////////////////////
   	function findPages($count, $limit) 
    { 
     	$pages = (($count % $limit) == 0) ? $count / $limit : floor($count / $limit) + 1; 

     	return $pages; 
    } 
   
   /////////////////////////////////////////////////
   // Method to get Page Lists of the Data 
   /////////////////////////////////////////////////
   function pageList($curpage, $pages) 
   { 
     	$page_list  = ""; 

		 /*if (($curpage != 1) && ($curpage)) 
		  { 
		   $page_list .= "  <a href=\"".$_SERVER['PHP_SELF']."?id=".$id."&page=1\" title=\"First Page\" class=\"forgot\"><</a> "; 
		  } */

     	if (($curpage-1) > 0) 
      	{ 
         $page_list .= "  <a href=\"".$_SERVER['PHP_SELF']."?page=".($curpage-1)."\" title=\"Previous Page\" class=\"paging\">Previous</a> "; 
      	} 

     	for ($i=1; $i<=$pages; $i++) 
      	{ 
       		if ($i == $curpage) 
        	{ 
         		$page_list .= "<a title=\"Page ".$i."\" class=\"paging-active\">".$i."</a>";  
        	} 
       		else 
        	{ 
         		$page_list .= "<a href=\"".$_SERVER['PHP_SELF']."?page=".$i."\" title=\"Page ".$i."\" class=\"paging\">".$i."</a>"; 
        	} 
       		//$page_list .= "|"; 
      	} 

     	if (($curpage+1) <= $pages) 
      	{ 
       		$page_list .= "  <a href=\"".$_SERVER['PHP_SELF']."?page=".($curpage+1)."\" title=\"Next Page\" class=\"paging\">Next</a> "; 
      	} 

		/* if (($curpage != $pages) && ($pages != 0)) 
		  { 
		   $page_list .= "  <a href=\"".$_SERVER['PHP_SELF']."?id=".$id."&page=".$pages."\" title=\"Last Page\" class=\"forgot\">></a> "; 
		  } */
     	$page_list .= "</td>\n"; 

     	return $page_list; 
    } 
	
	/////////////////////////////////////////////////
   // Method to get Limited Page Lists of the Data 
   /////////////////////////////////////////////////
	public function limitedPageList($totalpages,$currentpage,$pageRange,$querystring) 
	{//return "pagelimit".$pagelimit."currentpage".$currentpage."pageRange".$pageRange;
						
		if($pageRange==1){$page_list=" <span class='pagination_text'> <strong> Pages: </strong><span class='pagination_selected'>1</span>  </span>";}
		else{
		$range = $pageRange;
						
		$page_list.=" <span class='pagination_text'> <strong> Pages: </strong>  </span>";
		if ($currentpage > 1)
		{  
			$page_list.= " <a href='{$_SERVER['PHP_SELF']}?page=1$querystring' class='pagination_links'>First </a> <font class='table_links'>|</font> ";
		   	$prevpage = $currentpage - 1;
			$page_list.="<a href='{$_SERVER['PHP_SELF']}?page=$prevpage$querystring' class='pagination_links'> << </a> ";
		}
		for ($x = ($currentpage - $range); $x < (($currentpage + $range) + 1); $x++)
		{   
			if (($x > 0) && ($x <= $totalpages))
			{   
				if($x == $currentpage && $currentpage==1)
				{
					$page_list.="<b><span class='pagination_selected'>$x</span></b>";
				}
				else if ($x == $currentpage)
				{ 
					$page_list.="<b><font class='pagination_links'>|</font><span class='pagination_selected'>$x</span></b>";
				}
				else
				{
				 	$page_list.="<font class='pagination_links'>|</font><a href='{$_SERVER['PHP_SELF']}?page=$x$querystring' class='pagination_links'>$x</a>";      
				} 
			 }
		 }
		if ($currentpage != $totalpages)
		{  
			$nextpage = $currentpage + 1;   
		  	$page_list.="<font class='pagination_links'>|</font><a href='{$_SERVER['PHP_SELF']}?page=$nextpage$querystring' class='pagination_links'> >> </a> ";   
		  	$page_list.= "<font class='pagination_links'>|</font><a href='{$_SERVER['PHP_SELF']}?page=$totalpages$querystring' class='pagination_links'>&nbsp;Last</a> ";
		} 
	
 		}/////////////////End of Main If
		return $page_list; 
	}
   /////////////////////////////////////////////////
   // Method to get Page Lists of the Data 
   /////////////////////////////////////////////////
   function AjaxpageList($curpage, $pages) 
   { 
     	$page_list  = ""; 

		 /*if (($curpage != 1) && ($curpage)) 
		  { 
		   $page_list .= "  <a href=\"".$_SERVER['PHP_SELF']."?id=".$id."&page=1\" title=\"First Page\" class=\"forgot\"><</a> "; 
		  } */

     	if (($curpage-1) > 0) 
      	{ 
         $page_list .= "  <a id=\"".($curpage-1)."\" title=\"Previous Page\" class=\"paging\">Previous</a> "; 
      	} 

     	for ($i=1; $i<=$pages; $i++) 
      	{ 
       		if ($i == $curpage) 
        	{ 
         		$page_list .= "<a id=\"".$i."\" class=\"paging-active\">".$i."</a>"; 
        	} 
       		else 
        	{ 
         		$page_list .= "<a id=\"".$i."\" title=\"Page ".$i."\" class=\"paging\">".$i."</a>"; 
        	} 
       		//$page_list .= "|"; 
      	} 

     	if (($curpage+1) <= $pages) 
      	{ 
       		$page_list .= "  <a id=\"".($curpage+1)."\" title=\"Next Page\" class=\"paging\">Next</a> "; 
      	} 

		/* if (($curpage != $pages) && ($pages != 0)) 
		  { 
		   $page_list .= "  <a href=\"".$_SERVER['PHP_SELF']."?id=".$id."&page=".$pages."\" title=\"Last Page\" class=\"forgot\">></a> "; 
		  } */
     	//$page_list .= "\n"; 

     	return $page_list; 
    } 
   
   
   function AjaxpageLimitedList($curpage, $pages) 
   { 
     	$page_list  = ""; 

		 /*if (($curpage != 1) && ($curpage)) 
		  { 
		   $page_list .= "  <a href=\"".$_SERVER['PHP_SELF']."?id=".$id."&page=1\" title=\"First Page\" class=\"forgot\"><</a> "; 
		  } */

     	if (($curpage-1) > 0) 
      	{ 
         $page_list .= "  <a id=\"".($curpage-1)."\" title=\"Previous Page\" class=\"paging\"> << </a> "; 
      	} 

     	//for ($i=1; $i<=$pages; $i++) 
      	/*for ($i = $curpage; $i < ($curpage + 10); $i++)
		{ 
       		if ($i == $curpage) 
        	{ 
         		$page_list .= "<a id=\"".$i."\" class=\"paging-active\">".$i."</a>"; 
        	} 
       		else 
        	{ 
         		$page_list .= "<a id=\"".$i."\" title=\"Page ".$i."\" class=\"paging\">".$i."</a>"; 
        	} 
       		//$page_list .= "|"; 
      	} */
		$dif = $pages - $curpage;
		$secondlast = $pages - 1;
		$adjacents = 2;
		if ($pages <= 1 + ($adjacents * 2))
		{
			for ($i = 1; $i <=$pages; $i++)
			{ 
				if ($i == $curpage) 
				{ 
					$page_list .= "<a id=\"".$i."\" class=\"paging-active\">".$i."</a>"; 
				} 
				else 
				{ 
					$page_list .= "<a id=\"".$i."\" title=\"Page ".$i."\" class=\"paging\">".$i."</a>"; 
				} 
				//$page_list .= "|"; 
			} 
		
		}
			
		elseif($pages > 1 + ($adjacents * 2))	//enough pages to hide some
		{
			//close to beginning; only hide later pages
			
			if($curpage < 1 + ($adjacents * 2))		
			{
				for ($i = 1; $i < 2 + ($adjacents * 2); $i++)
				{
					if ($i == $curpage)
						$page_list .= "<a id=\"".$i."\" class=\"paging-active\">".$i."</a>";
					else
						$page_list .= "<a id=\"".$i."\" title=\"Page ".$i."\" class=\"paging\">".$i."</a>";		
			
				}
				$page_list .= "<a class=\"paging_more\">...</a>";
				$page_list .= "<a id=\"".$secondlast."\" title=\"Page ".$secondlast."\" class=\"paging\">".$secondlast."</a>";
				$page_list .= "<a id=\"".$pages."\" title=\"Page ".$pages."\" class=\"paging\">".$pages."</a>";
						
			}
			//in middle; hide some front and some back
			elseif($pages - ($adjacents * 2) > $curpage && $curpage > ($adjacents * 2))
			{
				
				
				$page_list .= "<a id=\"1\" title=\"Page 1\" class=\"paging\">1</a>";
				$page_list .= "<a id=\"2\" title=\"Page 2\" class=\"paging\">2</a>";
				$page_list .= "<a class=\"paging_more\">...</a>";
				for ($i = $curpage - $adjacents; $i <= $curpage + $adjacents; $i++)
				{
					if ($i == $curpage)
						$page_list .= "<a id=\"".$i."\" class=\"paging-active\">".$i."</a>";
					else
						$page_list .= "<a id=\"".$i."\" title=\"Page ".$i."\" class=\"paging\">".$i."</a>";	
			
				}
				$page_list .= "<a class=\"paging_more\">...</a>";
				$page_list .= "<a id=\"".$secondlast."\" title=\"Page ".$secondlast."\" class=\"paging\">".$secondlast."</a>";
				$page_list .= "<a id=\"".$pages."\" title=\"Page ".$pages."\" class=\"paging\">".$pages."</a>";
						
			}
			//close to end; only hide early pages
			else
			{
				
				$page_list .= "<a id=\"1\" title=\"Page 1\" class=\"paging\">1</a>";
				$page_list .= "<a id=\"2\" title=\"Page 2\" class=\"paging\">2</a>";
				$page_list .= "<a class=\"paging_more\">...</a>";
				for ($i = $pages - (0 + ($adjacents * 2)); $i <= $pages; $i++)
				{
					if ($i == $curpage)
						$page_list .= "<a id=\"".$i."\" class=\"paging-active\">".$i."</a>";
					else
						$page_list .= "<a id=\"".$i."\" title=\"Page ".$i."\" class=\"paging\">".$i."</a>";	

			
				}
			}
		}

     	if (($curpage+1) <= $pages) 
      	{ 
       		$page_list .= "  <a id=\"".($curpage+1)."\" title=\"Next Page\" class=\"paging\"> >> </a> "; 
      	} 

		/* if (($curpage != $pages) && ($pages != 0)) 
		  { 
		   $page_list .= "  <a href=\"".$_SERVER['PHP_SELF']."?id=".$id."&page=".$pages."\" title=\"Last Page\" class=\"forgot\">></a> "; 
		  } */
     	//$page_list .= "\n"; 

     	return $page_list; 
    }
   /////////////////////////////////////////////////
   // Method to get Only Next Previous of Page Lists of the Data 
   /////////////////////////////////////////////////
   function nextPrev($curpage, $pages) 
   { 
     	$next_prev  = ""; 

     	if (($curpage-1) <= 0) 
      	{ 
      	 	$next_prev .= "Previous"; 
      	} 
     	else 
      	{ 
       		$next_prev .= "<a href=\"".$_SERVER['PHP_SELF']."?id=".$id."&page=".($curpage-1)."\" class=\"active-arti\">Previous</a>"; 
      	} 

     	$next_prev .= " | "; 

     	if (($curpage+1) > $pages) 
      	{ 
       		$next_prev .= "Next"; 
      	} 
     	else 
      	{ 
      		 $next_prev .= "<a href=\"".$_SERVER['PHP_SELF']."?id=".$id."&page=".($curpage+1)."\" class=\"active-arti\">Next</a>"; 
      	} 

     	return $next_prev; 
    } 
} 
?> 