$(function () {

  'use strict';

  /* ChartJS
   * -------
   * Here we will create a few charts using ChartJS
   */
  
  //-----------------------
  //- MONTHLY SALES CHART -
  //-----------------------
  generateMonthlyRecapReport(salesChartData);

  //---------------------------
  //- END MONTHLY SALES CHART -
  //---------------------------
  
  //$("#select_duration").live('change',function()
  $(document.body).on('change','#select_duration',function()
  {
	  //alert();
	  var select_duration = $("#select_duration").val();
	  if(select_duration==6)
	  {
		  $(".duration_by_date_div").css('display','block');
	  }
	  else
	  {
		  $(".duration_by_date_div").css('display','none');
		  $("#selectDataForm").submit();
	  }
	  
  });
  
  //$("#search_sale_by_date").live('click',function()
  $(document.body).on('click','#search_sale_by_date',function()
  {
	  $("#selectDataForm").submit();		
  });
  
  $("#report_from_date").datepicker({
	  format: 'dd-mm-yyyy',
	  autoclose: true,
  }).on('changeDate', function (selected) {
	  var startDate = new Date(selected.date.valueOf());
	  $('#report_to_date').datepicker('setStartDate', startDate);
  }).on('clearDate', function (selected) {
	  $('#report_to_date').datepicker('setStartDate', null);
  });
  
  $("#report_to_date").datepicker({
	  format: 'dd-mm-yyyy',
	  autoclose: true,
  }).on('changeDate', function (selected) {
	  var endDate = new Date(selected.date.valueOf());
	  $('#report_from_date').datepicker('setEndDate', endDate);
  }).on('clearDate', function (selected) {
	  $('#report_from_date').datepicker('setEndDate', null);
  });
  
  $(document.body).on('change','.search_monthlyrecap_report',function()
  {
	  //alert();
	  var select_duration = $("#select_duration").val();
	  if(select_duration==6)
	  {
		  $(".duration_by_date_div").css('display','block');
	  }
	  else
	  {
		  $(".duration_by_date_div").css('display','none');
		  $("#selectDataForm").submit();
	  }
  });
  
  $('.main-row').each(function(){
	  var $row = $(this);
	  var $details_row = $(this).data("details_row");
	  //var $rowmore = $row.next('.drill-down-row');
	  var $rowmore = $('.'+$details_row);
	  //alert($rowmore);
	  if($rowmore.length>0){
		  $row.data('cached-row', $rowmore);
	  }
  });

}); 

/*Function to Generate Monthly Recap Report*/
function generateMonthlyRecapReport(salesChartData)
{
  
  // Get context with jQuery - using jQuery's .get() method.
  var salesChartCanvas = $("#salesChart").get(0).getContext("2d");
  // This will get the first returned node in the jQuery collection.
  var salesChart = new Chart(salesChartCanvas);

  var salesChartData12 = {
    labels: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
    datasets: [
      {
        label: "Point of Sale",
        fillColor: "rgb(210, 214, 222)",
        strokeColor: "rgb(210, 214, 222)",
        pointColor: "rgb(210, 214, 222)",
        pointStrokeColor: "#c1c7d1",
        pointHighlightFill: "#fff",
        pointHighlightStroke: "rgb(220,220,220)",
        data: [65, 59, 80, 81, 56, 55, 40, 65, 59, 80, 81, 56, 55]
      },
      {
        label: "E-Commerce",
        fillColor: "rgba(60,141,188,0.9)",
        strokeColor: "rgba(60,141,188,0.8)",
        pointColor: "#3b8bba",
        pointStrokeColor: "rgba(60,141,188,1)",
        pointHighlightFill: "#fff",
        pointHighlightStroke: "rgba(60,141,188,1)",
        data: [65, 59, 80, 81, 56, 55, 40, 65, 59, 80, 81, 56, 55]
      }
    ]
  };

  var salesChartOptions = {
    //Boolean - If we should show the scale at all
    showScale: true,
    //Boolean - Whether grid lines are shown across the chart
    scaleShowGridLines: false,
    //String - Colour of the grid lines
    scaleGridLineColor: "rgba(0,0,0,.05)",
    //Number - Width of the grid lines
    scaleGridLineWidth: 1,
    //Boolean - Whether to show horizontal lines (except X axis)
    scaleShowHorizontalLines: true,
    //Boolean - Whether to show vertical lines (except Y axis)
    scaleShowVerticalLines: true,
    //Boolean - Whether the line is curved between points
    bezierCurve: true,
    //Number - Tension of the bezier curve between points
    bezierCurveTension: 0.3,
    //Boolean - Whether to show a dot for each point
    pointDot: false,
    //Number - Radius of each point dot in pixels
    pointDotRadius: 4,
    //Number - Pixel width of point dot stroke
    pointDotStrokeWidth: 1,
    //Number - amount extra to add to the radius to cater for hit detection outside the drawn point
    pointHitDetectionRadius: 20,
    //Boolean - Whether to show a stroke for datasets
    datasetStroke: true,
    //Number - Pixel width of dataset stroke
    datasetStrokeWidth: 2,
    //Boolean - Whether to fill the dataset with a color
    datasetFill: true,
    //String - A legend template
    legendTemplate: "<ul class=\"<%=name.toLowerCase()%>-legend\"><% for (var i=0; i<datasets.length; i++){%><li><span style=\"background-color:<%=datasets[i].lineColor%>\"></span><%=datasets[i].label%></li><%}%></ul>",
    //Boolean - whether to maintain the starting aspect ratio or not when responsive, if set to false, will take up entire container
    maintainAspectRatio: true,
    //Boolean - whether to make the chart responsive to window resizing
    responsive: true
  };

  //Create the line chart
  salesChart.Line(salesChartData, salesChartOptions);
}