<?php include("pos_main.php");?>
<?php
$table_sales = TBLPREFIX_OPOS."sales";
$table_items = TBLPREFIX_OPOS."items";
$table_people = TBLPREFIX_OPOS."people";
$table_sales_items = TBLPREFIX_OPOS."sales_items";
$table_sales_payments = TBLPREFIX_OPOS."sales_payments";
$table_sales_items_taxes = TBLPREFIX_OPOS."sales_items_taxes";

/*Method For Get Sale Data*/
if(isset($_REQUEST['action']) && $_REQUEST['action']=="get_sale_detail")
{
	
	$results = array();
	
	$sale_id = cleanSQL($_REQUEST['sale_id']);
	
	/*Get Sale Data*/
	$sale_data = $sqlPOSWebServicesClass->getRow("*",$table_sales," WHERE sale_id = '$sale_id' ");
	
	if(!empty($sale_data))
	{
		$sale_time = date('m/d/Y h:i:s a', strtotime($sale_data['sale_time']));
		$sale_datetime =  explode(' ',$sale_time);
		$sale_date = $sale_datetime[0];
		$sale_time = explode(":",$sale_datetime[1]);
		$sale_time = $sale_time[0].":".$sale_time[1]." ".$sale_datetime[2];
		
		/*Get Sale Employee Data*/
		$employee_id = cleanSQL($sale_data['employee_id']);
		$sale_person = $sqlPOSWebServicesClass->getRow("*",$table_people," WHERE person_id = '$employee_id' ");
		
		/*Get Sale From Data*/
		$sale_company_data = $sqlPOSWebServicesClass->getRows("*",TBLPREFIX_OPOS."app_config", " ");
		$sale_company_dataArray = array();
		foreach($sale_company_data as $key => $value)
		{
		  $sale_company_dataArray[$value['key']] = $value['value'];
		}
		
		$sale_from = array(
					"name" => drop_multiple_slashes($sale_company_dataArray['company']),
					"address" => drop_multiple_slashes($sale_company_dataArray['address']),
					"phone" => drop_multiple_slashes($sale_company_dataArray['phone']),
					"email" => drop_multiple_slashes($sale_company_dataArray['email'])
				);
		
		/*Get Sale To Data*/
		$customer_id = cleanSQL($sale_data['customer_id']);
		$sale_to = $sqlPOSWebServicesClass->getRow("*",$table_people," WHERE person_id = '$customer_id' ");
		
		/*Get Sale Items Data*/
		$sale_items_data = $sqlPOSWebServicesClass->getRows("*",$table_sales_items," WHERE sale_id = '$sale_id' ");
		$sale_sub_total = 0;
		$sale_tax_total = 0;
		$sale_items = array();
		$sale_items_taxes = array();
		foreach($sale_items_data as $key => $sale_item_data)
		{
		  $item_id = $sale_item_data['item_id'];
		  $item_unit_price = $sale_item_data['item_unit_price'];
		  $quantity_purchased = $sale_item_data['quantity_purchased'];
		  $discount_percent = $sale_item_data['discount_percent'];
		  $discount_amount = $sale_item_data['discount_amount'];
		  $item_data = $sqlPOSWebServicesClass->getRow("*",$table_items," WHERE item_id = '$item_id' ");
		  $sale_items[$key]['line'] = $key;
		  $sale_items[$key]['item_id'] = $item_data['item_id'];
		  $sale_items[$key]['name'] = drop_multiple_slashes($item_data['name']);
		  $sale_items[$key]['quantity'] = $quantity_purchased;
		  $sale_items[$key]['serialnumber'] = $sale_item_data['serialnumber'];
		  $sale_items[$key]['description'] = drop_multiple_slashes($sale_item_data['description']);
		  $sale_items[$key]['price'] = $item_unit_price;
		  $sale_items[$key]['discount_percent'] = $discount_percent;
		  $sale_items[$key]['discount_amount'] = $discount_amount;
		  $item_total = ($item_unit_price*$quantity_purchased-($item_unit_price*$quantity_purchased*$discount_percent/100)-$discount_amount);
		  $sale_items[$key]['item_total'] = $item_total;
		  $sale_sub_total+=$item_total;
		  
		  /*Get Sale Items Taxes Data*/
		  $sale_items_taxes_data = $sqlPOSWebServicesClass->getRows("*",$table_sales_items_taxes," WHERE sale_id = '$sale_id' AND item_id = '$item_id' ");
		  foreach($sale_items_taxes_data as $key_taxes => $sale_items_taxe_data)
		  {
			$sale_items_taxes[$key_taxes]['name'] = $sale_items_taxe_data['name'];
			$sale_items_taxes[$key_taxes]['value'] = $sale_items_taxe_data['percent'];
			$tax_amount = $item_total * ($sale_items_taxe_data['percent']/100);
			$sale_items_taxes[$key_taxes]['amount'] = numberFormat($tax_amount);
			$sale_tax_total+=$tax_amount;
		  }
		}
		
		/*Get Sale Payments Data*/
		$sale_payments_data = $sqlPOSWebServicesClass->getRow("*",$table_sales_payments," WHERE sale_id = '$sale_id' ");
		$sale_payments = array(
							"payment_type" => $sale_payments_data['payment_type'],
							"payment_amount" => $sale_payments_data['payment_amount'],
						 );
		
		$status = 1;
		$message = "Success";
		$sale_total = ($sale_sub_total+$sale_tax_total);
		$data = array(
					"sale_id" => $sale_data['sale_id'],
					"sale_time" => $sale_time,
					"sale_date" => $sale_date,
					"sale_person" => $sale_person,
					"sale_from" => $sale_from,
					"sale_to" => $sale_to,
					"sale_items" => $sale_items,
					"sale_items_taxes" => $sale_items_taxes,
					"sale_sub_total" => numberFormat($sale_sub_total),
					"sale_total" => numberFormat($sale_total),
					"sale_payments" => $sale_payments,
					"sale_change_due" => numberFormat($sale_payments_data['payment_amount']-$sale_total),
					"sale_print_return_policy" => $sale_company_dataArray['print_return_policy'],
					"sale_return_policy" => $sale_company_dataArray['return_policy'],
					"sale_signature" => $sale_data['signature'],
					"sale_barcode" => drop_multiple_slashes(ZBPATH."pointofsale/application/barcodimages/".$account_name."/sales/barcode_POS ".$sale_id.".jpg?".time())
				);
	}
	else
	{
		$status = 0;
		$message = "No data found";
		$data = "";
	}
	
	$results['status'] = $status;
	$results['message'] = $message;
	$results['data'] = $data;
	format_output($format,$results);
	exit();
	
}
/*
https://wrkmash.com/zcp/webservice/pointofsale/pos_sales.php?action=get_sale_detail&account_name=<ACCOUNT_NAME:VARCHAR>&format=<FORMAT:json/xml>&sale_id=<SALE_ID:INT>
*/
?>	