<?php include(dirname(dirname(dirname(__FILE__)))."/source/includes.inc.php");?>
<?php
$sqlClass = new Main();

require_once(ROOT . 'classes' . DS . 'TimeTracker.class.php');

/*Function for Response Output*/
if ( ! function_exists('format_output'))
{
	function format_output($format,$results)
	{
		if($format == "xml")
		{
			header('Content-type: text/xml');
			echo '<response>';
				echo '<status>'.$results['status'].'</status>';
				echo '<message>'.$results['message'].'</message>';
				if(is_array($results['data']))
				{
					echo '<data>';
					foreach($results['data'] as $index => $data) {
						echo '<'.$index.'>';
						if(is_array($data)) {
							foreach($data as $key => $value) {
								echo '<'.$key.'>';
								if(is_array($value)) {
									foreach($value as $tag => $val) {
										echo '<'.$tag.'>'.htmlentities($val).'</'.$tag.'>';
									}
								}
								else
								{
									echo htmlentities($value);
								}
								echo '</'.$key.'>';
							}
						}
						else
						{
							echo htmlentities($data);
						}
						echo '</'.$index.'>';
					}
					echo '</data>';
				}
			echo '</response>';
		}
		else
		{
			header('Content-type: application/json');
			$results = array("response"=>$results);
			//echo json_encode($results,JSON_FORCE_OBJECT);
			if(isset($_REQUEST['plateform']) && $_REQUEST['plateform'] == "ios")
			{
				echo json_encode($results);
			}
			else
			{
				echo json_encode($results,JSON_FORCE_OBJECT);
			}
		}
	}
}

/*Function to Generate Authorize Token*/
if ( ! function_exists('generate_authorize_token'))
{
	function generate_authorize_token($length,$lowercase=false)
	{
		$letters = 'abcefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
		$found_token = false;
		while ($found_token == false) {
			$str = str_repeat($letters, 10);
			$authorize_token = substr(str_shuffle($str), 0, $length);
			if ($lowercase) {
				$authorize_token = strtolower($authorize_token);
			}
			$cnt = countTableRows(TBLPREFIX_USERMANAGEMENT."users_tracking","wt_token",$where=" WHERE `wt_token`='$authorize_token' ");
			if ($cnt < 1) {
				$found_token = true;
			}
		}
		return $authorize_token;
	}
}
?>